/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit;

import crazypants.enderio.EnderIO;
import crazypants.enderio.conduit.gas.GasUtil;
import crazypants.enderio.conduit.me.MEUtil;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;

public enum ConduitDisplayMode {
    ALL,
    POWER,
    REDSTONE,
    FLUID,
    ITEM,
    GAS,
    ME;


    public static ConduitDisplayMode next(ConduitDisplayMode mode) {
        ConduitDisplayMode res;
        int index = mode.ordinal() + 1;
        if (index >= ConduitDisplayMode.values().length) {
            index = 0;
        }
        if ((res = ConduitDisplayMode.values()[index]) == GAS && !GasUtil.isGasConduitEnabled()) {
            return ConduitDisplayMode.next(res);
        }
        if (res == ME && !MEUtil.isMEEnabled()) {
            return ConduitDisplayMode.next(res);
        }
        return res;
    }

    public static ConduitDisplayMode previous(ConduitDisplayMode mode) {
        ConduitDisplayMode res;
        int index = mode.ordinal() - 1;
        if (index < 0) {
            index = ConduitDisplayMode.values().length - 1;
        }
        if ((res = ConduitDisplayMode.values()[index]) == GAS && !GasUtil.isGasConduitEnabled()) {
            return ConduitDisplayMode.previous(res);
        }
        if (res == ME && !MEUtil.isMEEnabled()) {
            return ConduitDisplayMode.previous(res);
        }
        return res;
    }

    public static ConduitDisplayMode getDisplayMode(ItemStack equipped) {
        if (equipped == null || equipped.func_77973_b() != EnderIO.itemYetaWench) {
            return ALL;
        }
        int index = equipped.func_77960_j();
        index = MathHelper.func_76125_a((int)index, (int)0, (int)(ConduitDisplayMode.values().length - 1));
        return ConduitDisplayMode.values()[index];
    }

    public static void setDisplayMode(ItemStack equipped, ConduitDisplayMode mode) {
        if (mode == null || equipped == null) {
            return;
        }
        equipped.func_77964_b(mode.ordinal());
    }

    public ConduitDisplayMode next() {
        return ConduitDisplayMode.next(this);
    }

    public ConduitDisplayMode previous() {
        return ConduitDisplayMode.previous(this);
    }
}

