/*
 * Decompiled with CFR 0.152.
 */
package thermalfoundation.util;

import cofh.core.CoFHProps;
import cofh.core.util.oredict.OreDictionaryArbiter;
import cofh.lib.inventory.ComparableItemStackSafe;
import cofh.lib.util.ItemWrapper;
import cofh.lib.util.helpers.ItemHelper;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Scanner;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.oredict.OreDictionary;
import thermalfoundation.ThermalFoundation;

public class LexiconManager {
    private static LexiconManager instance = new LexiconManager();
    private static HashSet<String> listNames = new HashSet();
    private static HashSet<ItemWrapper> listOres = new HashSet();
    public static boolean isWhitelist = true;
    public static boolean logEntries = false;
    public static boolean writeDefaultFile = true;
    static File theList;

    public static void preInit() {
        String string = "Set to true for a whitelist, FALSE for a blacklist";
        isWhitelist = ThermalFoundation.config.get("general", "Lexicon.WhiteList", isWhitelist, string);
        string = "This will generate a default list file depending on your list setting. This will ONLY generate if no list file already exists.";
        writeDefaultFile = ThermalFoundation.config.get("general", "Lexicon.GenerateDefaultList", writeDefaultFile, string);
        string = "This will echo all entries to the log.";
        logEntries = ThermalFoundation.config.get("general", "Lexicon.LogEntries", logEntries, string);
    }

    public static void generateList() {
        theList = isWhitelist ? new File(CoFHProps.configDir, "/cofh/Lexicon-Whitelist.cfg") : new File(CoFHProps.configDir, "/cofh/Lexicon-Blacklist.cfg");
        boolean bl = false;
        BufferedWriter bufferedWriter = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (writeDefaultFile && !theList.exists()) {
            try {
                bl = true;
                theList.createNewFile();
                bufferedWriter = new BufferedWriter(new FileWriter(theList));
            }
            catch (Throwable throwable) {
                ThermalFoundation.log.warn("There is an error in the " + theList.getName() + " file!");
                throwable.printStackTrace();
            }
        }
        if (bl) {
            int n;
            String[] stringArray = OreDictionary.getOreNames();
            for (n = 0; n < stringArray.length; ++n) {
                if (isWhitelist && ComparableItemStackSafe.safeOreType((String)stringArray[n])) {
                    listNames.add(stringArray[n]);
                    arrayList.add(stringArray[n]);
                    continue;
                }
                if (isWhitelist || ComparableItemStackSafe.safeOreType((String)stringArray[n])) continue;
                listNames.add(stringArray[n]);
                arrayList.add(stringArray[n]);
            }
            Collections.sort(arrayList);
            if (isWhitelist) {
                ThermalFoundation.log.info("[Whitelist] Generating Default Whitelist.");
            } else {
                ThermalFoundation.log.info("[Blacklist] Generating Default Blacklist.");
            }
            try {
                for (n = 0; n < arrayList.size(); ++n) {
                    bufferedWriter.write((String)arrayList.get(n) + "\n");
                }
                bufferedWriter.close();
                arrayList.clear();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public static void addAllListedOres() {
        try {
            if (!theList.exists()) {
                return;
            }
            if (isWhitelist) {
                ThermalFoundation.log.info("[Whitelist] Reading established Whitelist from file.");
            } else {
                ThermalFoundation.log.info("[Blacklist] Reading established Blacklist from file.");
            }
            Scanner scanner = new Scanner(theList);
            String[] stringArray = null;
            String[] stringArray2 = null;
            while (scanner.hasNext()) {
                stringArray = scanner.next().split("\\n");
                stringArray2 = stringArray[0].split(":");
                if (stringArray2.length != 1) continue;
                listNames.add(stringArray[0]);
                if (!logEntries) continue;
                if (isWhitelist) {
                    ThermalFoundation.log.info("[Whitelist] The Forge Lexicon will allow conversions for ALL items of type '" + stringArray[0] + "'.");
                    continue;
                }
                ThermalFoundation.log.info("[Blacklist] The Forge Lexicon will disable conversions for ALL items of type '" + stringArray[0] + "'.");
            }
            scanner.close();
        }
        catch (Throwable throwable) {
            ThermalFoundation.log.warn("There is an error in the " + theList.getName() + " file!");
            throwable.printStackTrace();
        }
    }

    public static boolean validOre(ItemStack itemStack) {
        return ItemHelper.hasOreName((ItemStack)itemStack) ? isWhitelist == (listOres.contains(new ItemWrapper(itemStack)) || listNames.contains(OreDictionaryArbiter.getOreName((ItemStack)itemStack))) : false;
    }

    public static ItemStack getPreferredStack(EntityPlayer entityPlayer, ItemStack itemStack) {
        ItemStack itemStack2;
        String string;
        NBTTagCompound nBTTagCompound;
        NBTTagCompound nBTTagCompound2 = entityPlayer.getEntityData();
        if (nBTTagCompound2.func_74764_b("Lexicon") && (nBTTagCompound = nBTTagCompound2.func_74775_l("Lexicon")).func_74764_b(string = OreDictionaryArbiter.getOreName((ItemStack)itemStack)) && ItemHelper.isOreNameEqual((ItemStack)(itemStack2 = ItemStack.func_77949_a((NBTTagCompound)nBTTagCompound.func_74775_l(string))), (String)string)) {
            return ItemHelper.cloneStack((ItemStack)itemStack2, (int)itemStack.field_77994_a);
        }
        return ItemHelper.cloneStack((ItemStack)((ItemStack)OreDictionaryArbiter.getOres((ItemStack)itemStack).get(0)), (int)itemStack.field_77994_a);
    }

    public static void setPreferredStack(EntityPlayer entityPlayer, ItemStack itemStack) {
        NBTTagCompound nBTTagCompound = entityPlayer.getEntityData();
        NBTTagCompound nBTTagCompound2 = nBTTagCompound.func_74775_l("Lexicon");
        String string = OreDictionaryArbiter.getOreName((ItemStack)itemStack);
        nBTTagCompound2.func_74782_a(string, (NBTBase)itemStack.func_77955_b(new NBTTagCompound()));
        nBTTagCompound.func_74782_a("Lexicon", (NBTBase)nBTTagCompound2);
    }
}

