/*
 * Decompiled with CFR 0.152.
 */
package com.mark719.magicalcrops.blocks.crops;

import com.mark719.magicalcrops.ConfigHandler;
import com.mark719.magicalcrops.MagicalCrops;
import com.mark719.magicalcrops.blocks.crops.BlockMagicalCrops;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;

public class BlockGrowthCrop
extends BlockMagicalCrops {
    @SideOnly(value=Side.CLIENT)
    private IIcon[] iconArray;

    public BlockGrowthCrop(int par1) {
        this.func_149715_a(1.0f);
        this.func_149675_a(true);
        this.func_149663_c("CropGrowth");
    }

    @Override
    public int func_149645_b() {
        return 1;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int par1, int par2) {
        if (par2 < 7) {
            if (par2 == 6) {
                par2 = 5;
            }
            return this.iconArray[par2 >> 1];
        }
        return this.iconArray[3];
    }

    @Override
    protected Item func_149866_i() {
        return null;
    }

    @Override
    protected Item func_149865_P() {
        return MagicalCrops.SeedsGrowth;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister p_149651_1_) {
        this.iconArray = new IIcon[4];
        for (int i = 0; i < this.iconArray.length; ++i) {
            this.iconArray[i] = p_149651_1_.func_94245_a("magicalcrops:CropAir_" + i);
        }
    }

    @Override
    public Item func_149650_a(int p_149650_1_, Random p_149650_2_, int p_149650_3_) {
        return p_149650_1_ == 7 ? this.func_149865_P() : this.func_149866_i();
    }

    @Override
    public int func_149745_a(Random p_149745_1_) {
        return 1;
    }

    @Override
    public boolean func_149851_a(World p_149851_1_, int p_149851_2_, int p_149851_3_, int p_149851_4_, boolean p_149851_5_) {
        return p_149851_1_.func_72805_g(p_149851_2_, p_149851_3_, p_149851_4_) != 7;
    }

    @Override
    public boolean func_149852_a(World p_149852_1_, Random p_149852_2_, int p_149852_3_, int p_149852_4_, int p_149852_5_) {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Item func_149694_d(World p_149694_1_, int p_149694_2_, int p_149694_3_, int p_149694_4_) {
        return this.func_149866_i();
    }

    @Override
    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        int i;
        ArrayList<ItemStack> ret = super.getDrops(world, x, y, z, metadata, fortune);
        if (metadata >= 7) {
            for (i = 0; i < 1 + fortune; ++i) {
                if (world.field_73012_v.nextInt(7) > metadata) continue;
                ret.add(new ItemStack(this.func_149866_i(), 1, 0));
            }
        }
        if (metadata >= 7 && ConfigHandler.seeddrops > 0) {
            for (i = 0; i < 1 + fortune; ++i) {
                if (world.field_73012_v.nextInt(100) > Math.max(ConfigHandler.seeddrops, ConfigHandler.seeddropchance)) continue;
                ret.add(new ItemStack(this.func_149866_i(), 1, 0));
            }
        }
        return ret;
    }

    @Override
    public void func_149674_a(World world, int x, int y, int z, Random par5Random) {
        this.growCropsNearby(world, x, y, z);
    }

    private int secondsBetweenGrowthTicks() {
        return 60;
    }

    private int tileRange() {
        return 4;
    }

    private int fullPotencyRange() {
        return 0;
    }

    public void growCropsNearby(World world, int xO, int yO, int zO) {
        int meta = world.func_72805_g(xO, yO, zO);
        if (meta >= 7) {
            for (int xD = -this.tileRange(); xD <= this.tileRange(); ++xD) {
                for (int yD = -1; yD <= this.tileRange(); ++yD) {
                    for (int zD = -this.tileRange(); zD <= this.tileRange(); ++zD) {
                        int x = xO + xD;
                        int y = yO + yD;
                        int z = zO + zD;
                        double distance = Math.sqrt(Math.pow(x - xO, 2.0) + Math.pow(y - yO, 2.0) + Math.pow(z - zO, 2.0));
                        distance -= (double)this.fullPotencyRange();
                        distance = Math.min(1.0, distance);
                        double distanceCoefficient = 1.0 - distance / (double)this.tileRange();
                        Block block = world.func_147439_a(x, y, z);
                        if (!(block instanceof IPlantable) && !(block instanceof IGrowable) || block instanceof BlockGrowthCrop) continue;
                        world.func_147464_a(x, y, z, block, (int)(distanceCoefficient * (double)this.secondsBetweenGrowthTicks() * 20.0));
                        block.func_149674_a(world, x, y, z, world.field_73012_v);
                    }
                }
            }
            world.func_147464_a(xO, yO, zO, world.func_147439_a(xO, yO, zO), this.secondsBetweenGrowthTicks() * 20);
        }
    }
}

