/*
 * Decompiled with CFR 0.152.
 */
package sync.common.packet;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import ichun.common.core.network.AbstractPacket;
import ichun.common.core.network.PacketHandler;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import sync.api.SyncStartEvent;
import sync.common.Sync;
import sync.common.packet.PacketPlayerDeath;
import sync.common.packet.PacketZoomCamera;
import sync.common.shell.ShellHandler;
import sync.common.tileentity.TileEntityDualVertical;
import sync.common.tileentity.TileEntityShellConstructor;
import sync.common.tileentity.TileEntityShellStorage;

public class PacketSyncRequest
extends AbstractPacket {
    public int xCoord;
    public int yCoord;
    public int zCoord;
    public int dimID;
    public int shellPosX;
    public int shellPosY;
    public int shellPosZ;
    public int shellDimID;

    public PacketSyncRequest() {
    }

    public PacketSyncRequest(int xCoord, int yCoord, int zCoord, int dimID, int shellPosX, int shellPosY, int shellPosZ, int shellDimID) {
        this.xCoord = xCoord;
        this.yCoord = yCoord;
        this.zCoord = zCoord;
        this.dimID = dimID;
        this.shellPosX = shellPosX;
        this.shellPosY = shellPosY;
        this.shellPosZ = shellPosZ;
        this.shellDimID = shellDimID;
    }

    public void writeTo(ByteBuf buffer, Side side) {
        buffer.writeInt(this.xCoord);
        buffer.writeInt(this.yCoord);
        buffer.writeInt(this.zCoord);
        buffer.writeInt(this.dimID);
        buffer.writeInt(this.shellPosX);
        buffer.writeInt(this.shellPosY);
        buffer.writeInt(this.shellPosZ);
        buffer.writeInt(this.shellDimID);
    }

    public void readFrom(ByteBuf buffer, Side side) {
        this.xCoord = buffer.readInt();
        this.yCoord = buffer.readInt();
        this.zCoord = buffer.readInt();
        this.dimID = buffer.readInt();
        this.shellPosX = buffer.readInt();
        this.shellPosY = buffer.readInt();
        this.shellPosZ = buffer.readInt();
        this.shellDimID = buffer.readInt();
    }

    public void execute(Side side, EntityPlayer player) {
        boolean valid = false;
        WorldServer worldOri = DimensionManager.getWorld((int)this.dimID);
        WorldServer world = DimensionManager.getWorld((int)this.shellDimID);
        if (worldOri != null && world != null) {
            TileEntity oriTe = worldOri.func_147438_o(this.xCoord, this.yCoord, this.zCoord);
            TileEntity te = world.func_147438_o(this.shellPosX, this.shellPosY, this.shellPosZ);
            if (oriTe instanceof TileEntityDualVertical && te instanceof TileEntityDualVertical) {
                TileEntityDualVertical originShell = (TileEntityDualVertical)oriTe;
                TileEntityDualVertical targetShell = (TileEntityDualVertical)te;
                if (originShell.getPlayerName().equalsIgnoreCase(player.func_70005_c_()) && targetShell.getPlayerName().equalsIgnoreCase(player.func_70005_c_())) {
                    TileEntityShellStorage ss;
                    if (targetShell instanceof TileEntityShellConstructor) {
                        TileEntityShellConstructor sc = (TileEntityShellConstructor)targetShell;
                        if (sc.constructionProgress < (float)Sync.config.getSessionInt("shellConstructionPowerRequirement")) {
                            ShellHandler.updatePlayerOfShells(player, null, true);
                            return;
                        }
                    }
                    if (targetShell instanceof TileEntityShellStorage) {
                        ss = (TileEntityShellStorage)targetShell;
                        if (!ss.syncing) {
                            ShellHandler.updatePlayerOfShells(player, null, true);
                            return;
                        }
                    }
                    if (originShell instanceof TileEntityShellStorage) {
                        ss = (TileEntityShellStorage)originShell;
                        ss.setPlayerName(player.func_70005_c_());
                        ss.occupied = true;
                        ss.occupationTime = 40;
                        ss.syncing = true;
                        player.func_70066_B();
                        NBTTagCompound tag = new NBTTagCompound();
                        player.func_70109_d(tag);
                        tag.func_74768_a("sync_playerGameMode", ((EntityPlayerMP)player).field_71134_c.func_73081_b().func_77148_a());
                        ss.setPlayerNBT(tag);
                        worldOri.func_147471_g(ss.field_145851_c, ss.field_145848_d, ss.field_145849_e);
                        worldOri.func_147471_g(ss.field_145851_c, ss.field_145848_d + 1, ss.field_145849_e);
                    }
                    PacketHandler.sendToPlayer(Sync.channels, (AbstractPacket)new PacketZoomCamera(this.xCoord, this.yCoord, this.zCoord, this.dimID, originShell.face, false, false), (EntityPlayer)player);
                    targetShell.resyncPlayer = 120;
                    originShell.canSavePlayer = -1;
                    targetShell.resyncOrigin = originShell;
                    ShellHandler.syncInProgress.put(player.func_70005_c_(), targetShell);
                    MinecraftForge.EVENT_BUS.post((Event)new SyncStartEvent(player, originShell.getPlayerNBT(), targetShell.getPlayerNBT(), targetShell.field_145851_c, targetShell.field_145848_d, targetShell.field_145849_e));
                    PacketHandler.sendToAll(Sync.channels, (AbstractPacket)new PacketPlayerDeath(player.func_70005_c_(), false));
                    valid = true;
                }
            }
        }
        if (!valid) {
            ShellHandler.updatePlayerOfShells(player, null, true);
        }
    }
}

