/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.util.crafting;

import gnu.trove.map.hash.THashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import thermalexpansion.ThermalExpansion;

public class PrecipitatorManager {
    private static Map<Fluid, RecipePrecipitator> recipeMap = new THashMap();
    private static boolean allowOverwrite = false;

    public static RecipePrecipitator getRecipe(Fluid fluid) {
        return fluid == null ? null : recipeMap.get(fluid);
    }

    public static RecipePrecipitator getRecipe(FluidStack fluidStack) {
        return PrecipitatorManager.getRecipe(fluidStack.getFluid());
    }

    public static boolean recipeExists(Fluid fluid) {
        return PrecipitatorManager.getRecipe(fluid) != null;
    }

    public static boolean recipeExists(FluidStack fluidStack) {
        return PrecipitatorManager.recipeExists(fluidStack.getFluid());
    }

    public static RecipePrecipitator[] getRecipeList() {
        return recipeMap.values().toArray(new RecipePrecipitator[0]);
    }

    public static void addDefaultRecipes() {
    }

    public static void loadRecipes() {
    }

    public static void refreshRecipes() {
    }

    static {
        allowOverwrite = ThermalExpansion.config.get("tweak.crafting", "Precipitator.AllowRecipeOverwrite", false);
    }

    public static class RecipePrecipitator {
        final FluidStack[] fluid;
        final ItemStack[] outputs;
        final int[] energy;

        RecipePrecipitator(FluidStack[] fluidStackArray, ItemStack[] itemStackArray, int[] nArray) {
            this.fluid = fluidStackArray;
            this.outputs = itemStackArray;
            this.energy = nArray;
        }

        public FluidStack[] getInputs() {
            return this.fluid;
        }

        public ItemStack[] getOutputs() {
            return this.outputs;
        }

        public int[] getEnergy() {
            return this.energy;
        }
    }
}

