/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.util.crafting;

import cofh.core.util.oredict.OreDictionaryArbiter;
import cofh.lib.inventory.ComparableItemStackSafe;
import cofh.lib.util.helpers.ItemHelper;
import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import thermalexpansion.ThermalExpansion;
import thermalexpansion.core.TEProps;
import thermalfoundation.fluid.TFFluids;
import thermalfoundation.item.TFItems;

public class CrucibleManager {
    private static Map<ComparableItemStackSafe, RecipeCrucible> recipeMap = new THashMap();
    private static ComparableItemStackSafe query = new ComparableItemStackSafe(new ItemStack(Blocks.field_150348_b));
    private static boolean allowOverwrite = false;

    public static RecipeCrucible getRecipe(ItemStack itemStack) {
        return itemStack == null ? null : recipeMap.get(query.set(itemStack));
    }

    public static boolean recipeExists(ItemStack itemStack) {
        return CrucibleManager.getRecipe(itemStack) != null;
    }

    public static RecipeCrucible[] getRecipeList() {
        return recipeMap.values().toArray(new RecipeCrucible[0]);
    }

    public static void addDefaultRecipes() {
        boolean bl = ThermalExpansion.config.get("tweak.crafting", "Crucible.Netherrack", true);
        boolean bl2 = ThermalExpansion.config.get("tweak.crafting", "Crucible.BlazeRod", true);
        int n = ThermalExpansion.config.get("tweak.crafting", "Crucible.Netherrack.Energy", TEProps.lavaRF * 6 / 10);
        int n2 = ThermalExpansion.config.get("tweak.crafting", "Crucible.BlazeRod.Energy", TEProps.lavaRF / 10);
        if (bl) {
            if (n >= TEProps.lavaRF / 10 && n <= TEProps.lavaRF) {
                CrucibleManager.addTERecipe(n, new ItemStack(Blocks.field_150424_aL), new FluidStack(FluidRegistry.LAVA, 1000));
            } else {
                CrucibleManager.addTERecipe(TEProps.lavaRF * 6 / 10, new ItemStack(Blocks.field_150424_aL), new FluidStack(FluidRegistry.LAVA, 1000));
                ThermalExpansion.log.info("'Crucible.Netherrack.Energy' config value is out of acceptable range. Using default.");
                ThermalExpansion.config.set("tweak.crafting", "Crucible.Netherrack.Energy", TEProps.lavaRF * 6 / 10);
            }
        }
        if (bl2) {
            if (n2 >= TEProps.lavaRF / 20 && n2 <= TEProps.lavaRF) {
                CrucibleManager.addTERecipe(n2, new ItemStack(Items.field_151072_bj), new FluidStack(FluidRegistry.LAVA, 250));
            } else {
                CrucibleManager.addTERecipe(TEProps.lavaRF / 10, new ItemStack(Items.field_151072_bj), new FluidStack(FluidRegistry.LAVA, 250));
                ThermalExpansion.log.info("'Crucible.BlazeRod.Energy' config value is out of acceptable range. Using default.");
                ThermalExpansion.config.set("tweak.crafting", "Crucible.BlazeRod.Energy", TEProps.lavaRF / 10);
            }
        }
        int n3 = TEProps.lavaRF * 8 / 5;
        CrucibleManager.addTERecipe(n3, new ItemStack(Blocks.field_150347_e), new FluidStack(FluidRegistry.LAVA, 1000));
        CrucibleManager.addTERecipe(n3, new ItemStack(Blocks.field_150348_b), new FluidStack(FluidRegistry.LAVA, 1000));
        CrucibleManager.addTERecipe(n3, new ItemStack(Blocks.field_150343_Z), new FluidStack(FluidRegistry.LAVA, 1000));
        CrucibleManager.addTERecipe(200, new ItemStack(Items.field_151126_ay), new FluidStack(FluidRegistry.WATER, 125));
        CrucibleManager.addTERecipe(800, new ItemStack(Blocks.field_150433_aE), new FluidStack(FluidRegistry.WATER, 500));
        CrucibleManager.addTERecipe(1600, new ItemStack(Blocks.field_150432_aD), new FluidStack(FluidRegistry.WATER, 1000));
        CrucibleManager.addTERecipe(8000, new ItemStack(Items.field_151137_ax), new FluidStack(TFFluids.fluidRedstone, 100));
        CrucibleManager.addTERecipe(72000, new ItemStack(Blocks.field_150451_bX), new FluidStack(TFFluids.fluidRedstone, 900));
        CrucibleManager.addTERecipe(20000, new ItemStack(Items.field_151114_aO), new FluidStack(TFFluids.fluidGlowstone, 250));
        CrucibleManager.addTERecipe(80000, new ItemStack(Blocks.field_150426_aN), new FluidStack(TFFluids.fluidGlowstone, 1000));
        CrucibleManager.addTERecipe(20000, new ItemStack(Items.field_151079_bi), new FluidStack(TFFluids.fluidEnder, 250));
        CrucibleManager.addTERecipe(8000, TFItems.dustPyrotheum, new FluidStack(TFFluids.fluidPyrotheum, 100));
        CrucibleManager.addTERecipe(8000, TFItems.dustCryotheum, new FluidStack(TFFluids.fluidCryotheum, 100));
        CrucibleManager.addTERecipe(8000, TFItems.dustCoal, new FluidStack(TFFluids.fluidCoal, 100));
    }

    public static void loadRecipes() {
    }

    public static void refreshRecipes() {
        THashMap tHashMap = new THashMap(recipeMap.size());
        for (Map.Entry<ComparableItemStackSafe, RecipeCrucible> entry : recipeMap.entrySet()) {
            RecipeCrucible recipeCrucible = entry.getValue();
            tHashMap.put(new ComparableItemStackSafe(recipeCrucible.input), recipeCrucible);
        }
        recipeMap.clear();
        recipeMap = tHashMap;
    }

    public static boolean addTERecipe(int n, ItemStack itemStack, FluidStack fluidStack) {
        if (itemStack == null || fluidStack == null || fluidStack.amount <= 0 || n <= 0) {
            return false;
        }
        RecipeCrucible recipeCrucible = new RecipeCrucible(itemStack, fluidStack, n);
        recipeMap.put(new ComparableItemStackSafe(itemStack), recipeCrucible);
        return true;
    }

    public static boolean addRecipe(int n, ItemStack itemStack, FluidStack fluidStack, boolean bl) {
        if (itemStack == null || fluidStack == null || fluidStack.amount <= 0 || n <= 0 || !(allowOverwrite & bl) && CrucibleManager.recipeExists(itemStack)) {
            return false;
        }
        RecipeCrucible recipeCrucible = new RecipeCrucible(itemStack, fluidStack, n);
        recipeMap.put(new ComparableItemStackSafe(itemStack), recipeCrucible);
        return true;
    }

    public static void addOreDictionaryRecipe(int n, String string, int n2, FluidStack fluidStack) {
        ArrayList arrayList = OreDictionaryArbiter.getOres((String)string);
        for (int i = 0; i < arrayList.size(); ++i) {
            CrucibleManager.addTERecipe(n, ItemHelper.cloneStack((ItemStack)((ItemStack)arrayList.get(i)), (int)n2), fluidStack);
        }
    }

    public static boolean addRecipe(int n, ItemStack itemStack, FluidStack fluidStack) {
        return CrucibleManager.addRecipe(n, itemStack, fluidStack, false);
    }

    static {
        allowOverwrite = ThermalExpansion.config.get("tweak.crafting", "Crucible.AllowRecipeOverwrite", false);
    }

    public static class RecipeCrucible {
        final ItemStack input;
        final FluidStack output;
        final int energy;

        RecipeCrucible(ItemStack itemStack, FluidStack fluidStack, int n) {
            this.input = itemStack;
            this.output = fluidStack;
            this.energy = n;
        }

        public ItemStack getInput() {
            return this.input.func_77946_l();
        }

        public FluidStack getOutput() {
            return this.output.copy();
        }

        public int getEnergy() {
            return this.energy;
        }
    }
}

