/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.util;

import cofh.core.CoFHProps;
import cofh.core.util.ConfigHandler;
import java.io.File;
import java.util.Locale;
import java.util.Set;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fluids.FluidRegistry;
import thermalexpansion.block.dynamo.TileDynamoCompression;
import thermalexpansion.block.dynamo.TileDynamoMagmatic;
import thermalexpansion.block.dynamo.TileDynamoReactant;
import thermalexpansion.core.TEProps;

public class FuelHandler {
    public static ConfigHandler configFuels = new ConfigHandler("1.7.10R4.0.0B8");

    private FuelHandler() {
    }

    public static boolean registerMagmaticFuel(String string, int n) {
        if (!FluidRegistry.isFluidRegistered((String)string)) {
            return false;
        }
        return TileDynamoMagmatic.registerFuel(FluidRegistry.getFluid((String)string), n);
    }

    public static boolean registerCompressionFuel(String string, int n) {
        if (!FluidRegistry.isFluidRegistered((String)string)) {
            return false;
        }
        return TileDynamoCompression.registerFuel(FluidRegistry.getFluid((String)string), n);
    }

    public static boolean registerReactantFuel(String string, int n) {
        if (!FluidRegistry.isFluidRegistered((String)string)) {
            return false;
        }
        return TileDynamoReactant.registerFuel(FluidRegistry.getFluid((String)string), n);
    }

    public static boolean registerCoolant(String string, int n) {
        if (!FluidRegistry.isFluidRegistered((String)string)) {
            return false;
        }
        return TileDynamoCompression.registerCoolant(FluidRegistry.getFluid((String)string), n);
    }

    public static void parseFuels() {
        String string = "fuels.magmatic";
        FuelHandler.registerMagmaticFuel("lava", configFuels.get(string, "lava", TEProps.lavaRF * 9 / 10));
        FuelHandler.registerMagmaticFuel("pyrotheum", configFuels.get(string, "pyrotheum", 2000000));
        Set set = configFuels.getCategoryKeys(string);
        for (String string2 : set) {
            FuelHandler.registerMagmaticFuel(string2.toLowerCase(Locale.ENGLISH), configFuels.get(string, string2, TEProps.lavaRF * 9 / 10));
        }
        string = "fuels.compression";
        FuelHandler.registerCompressionFuel("coal", configFuels.get(string, "coal", 1000000));
        FuelHandler.registerCompressionFuel("biofuel", configFuels.get(string, "biofuel", 500000));
        FuelHandler.registerCompressionFuel("bioethanol", configFuels.get(string, "bioethanol", 500000));
        FuelHandler.registerCompressionFuel("fuel", configFuels.get(string, "fuel", 1500000));
        FuelHandler.registerCompressionFuel("oil", configFuels.get(string, "oil", 150000));
        set = configFuels.getCategoryKeys(string);
        for (String string2 : set) {
            FuelHandler.registerCompressionFuel(string2.toLowerCase(Locale.ENGLISH), configFuels.get(string, string2, 500000));
        }
        string = "fuels.reactant";
        FuelHandler.registerReactantFuel("redstone", configFuels.get(string, "redstone", 600000));
        FuelHandler.registerReactantFuel("glowstone", configFuels.get(string, "glowstone", 750000));
        FuelHandler.registerReactantFuel("mobessence", configFuels.get(string, "mobessence", 500000));
        FuelHandler.registerReactantFuel("sewage", configFuels.get(string, "sewage", 12000));
        FuelHandler.registerReactantFuel("sludge", configFuels.get(string, "sludge", 12000));
        FuelHandler.registerReactantFuel("seedoil", configFuels.get(string, "seedoil", 250000));
        FuelHandler.registerReactantFuel("biomass", configFuels.get(string, "biomass", 450000));
        FuelHandler.registerReactantFuel("creosote", configFuels.get(string, "creosote", 200000));
        set = configFuels.getCategoryKeys(string);
        for (String string2 : set) {
            FuelHandler.registerReactantFuel(string2.toLowerCase(Locale.ENGLISH), configFuels.get(string, string2, 200000));
        }
        string = "coolants";
        FuelHandler.registerCoolant("water", configFuels.get(string, "water", 400000));
        FuelHandler.registerCoolant("cryotheum", configFuels.get(string, "cryotheum", 4000000));
        FuelHandler.registerCoolant("ice", configFuels.get(string, "ice", 2000000));
        set = configFuels.getCategoryKeys(string);
        for (String string2 : set) {
            FuelHandler.registerCoolant(string2.toLowerCase(Locale.ENGLISH), configFuels.get(string, string2, 400000));
        }
        configFuels.cleanUp(true, false);
    }

    static {
        configFuels.setConfiguration(new Configuration(new File(CoFHProps.configDir, "cofh/ThermalExpansion-Fuels.cfg")));
    }
}

