/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.plugins.nei.handlers;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.GuiCraftingRecipe;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.GuiUsageRecipe;
import codechicken.nei.recipe.TemplateRecipeHandler;
import cofh.lib.render.RenderHelper;
import cofh.lib.util.helpers.ItemHelper;
import cofh.lib.util.helpers.StringHelper;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;
import org.lwjgl.opengl.GL11;

public abstract class RecipeHandlerBase
extends TemplateRecipeHandler {
    Class<? extends GuiContainer> containerClass;
    String recipeName;
    static final String TEXTURE = "thermalexpansion:textures/gui/NEIHandler.png";
    int[] trCoords = new int[4];
    int maxEnergy = 24000;
    int scaleEnergy = 42;
    int maxFluid = 10000;
    int scaleFluid = 60;
    int[] energyAmount = new int[2];
    int[] fluidAmount = new int[2];
    int[] lastCycle = new int[2];
    int[] arecipe = new int[]{-1, -1};

    public void loadTransferRects() {
        this.initialize();
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(this.trCoords[0], this.trCoords[1], this.trCoords[2], this.trCoords[3]), this.getOverlayIdentifier(), new Object[0]));
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return this.containerClass;
    }

    public String getRecipeName() {
        return StringHelper.localize((String)("tile.thermalexpansion.machine." + this.recipeName + ".name"));
    }

    public String getGuiTexture() {
        return TEXTURE;
    }

    public String getOverlayIdentifier() {
        return "thermalexpansion." + this.recipeName;
    }

    public abstract void initialize();

    public void drawBackground(int n) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)0, (int)0, (int)5, (int)11, (int)166, (int)65);
        this.drawBackgroundExtras(n);
    }

    public void drawBackgroundExtras(int n) {
    }

    public boolean keyTyped(GuiRecipe guiRecipe, char c, int n, int n2) {
        if (n == NEIClientConfig.getKeyBinding((String)"gui.recipe") ? this.transferFluidTank(guiRecipe, n2, false) : n == NEIClientConfig.getKeyBinding((String)"gui.usage") && this.transferFluidTank(guiRecipe, n2, true)) {
            return true;
        }
        return super.keyTyped(guiRecipe, c, n, n2);
    }

    public boolean mouseClicked(GuiRecipe guiRecipe, int n, int n2) {
        if (n == 0 ? this.transferFluidTank(guiRecipe, n2, false) : n == 1 && this.transferFluidTank(guiRecipe, n2, true)) {
            return true;
        }
        return super.mouseClicked(guiRecipe, n, n2);
    }

    protected boolean transferFluidTank(GuiRecipe guiRecipe, int n, boolean bl) {
        int n2 = 153;
        int n3 = 169;
        int n4 = 19;
        int n5 = 79;
        int n6 = 65;
        Point point = GuiDraw.getMousePosition();
        FluidStack fluidStack = null;
        if (point.x >= n2 + guiRecipe.field_147003_i && point.x < n3 + guiRecipe.field_147003_i && point.y >= n4 + guiRecipe.field_147009_r && point.y < n5 + guiRecipe.field_147009_r && this.arecipe[0] == n) {
            fluidStack = ((NEIRecipeBase)((Object)this.arecipes.get((int)n))).fluid;
        } else if (point.x >= n2 + guiRecipe.field_147003_i && point.x < n3 + guiRecipe.field_147003_i && point.y >= n4 + guiRecipe.field_147009_r + n6 && point.y < n5 + guiRecipe.field_147009_r + n6 && this.arecipe[1] == n) {
            fluidStack = ((NEIRecipeBase)((Object)this.arecipes.get((int)n))).fluid;
        }
        return fluidStack != null && fluidStack.amount > 0 && (bl ? GuiUsageRecipe.openRecipeGui((String)"liquid", (Object[])new Object[]{fluidStack}) : GuiCraftingRecipe.openRecipeGui((String)"liquid", (Object[])new Object[]{fluidStack}));
    }

    private void resetCounters() {
        this.arecipe[0] = -1;
        this.arecipe[1] = -1;
        this.energyAmount[0] = 0;
        this.energyAmount[1] = 0;
        this.fluidAmount[0] = 0;
        this.fluidAmount[1] = 0;
        this.lastCycle[0] = 0;
        this.lastCycle[1] = 0;
    }

    public void drawEnergy(int n) {
        int n2 = 0;
        if (this.arecipe[0] == -1) {
            this.arecipe[0] = n;
        } else if (this.arecipe[1] == -1 && this.arecipe[0] != n) {
            this.arecipe[1] = n;
        }
        if (this.arecipe[0] != n && this.arecipe[1] != n) {
            this.resetCounters();
            this.drawEnergy(n);
            return;
        }
        if (this.arecipe[1] == n) {
            n2 = 1;
        }
        GuiDraw.drawTexturedModalRect((int)4, (int)2, (int)0, (int)96, (int)16, (int)this.scaleEnergy);
        int n3 = this.getScaledEnergy(this.energyAmount[n2]);
        GuiDraw.drawTexturedModalRect((int)4, (int)(2 + n3), (int)16, (int)(96 + n3), (int)16, (int)(this.scaleEnergy - n3));
        if (this.cycleticks % 20 == 0 && this.cycleticks != this.lastCycle[n2]) {
            if (this.energyAmount[n2] == this.maxEnergy) {
                this.energyAmount[n2] = 0;
            }
            int n4 = n2;
            this.energyAmount[n4] = this.energyAmount[n4] + ((NEIRecipeBase)((Object)this.arecipes.get((int)n))).energy;
            if (this.energyAmount[n2] > this.maxEnergy) {
                this.energyAmount[n2] = this.maxEnergy;
            }
            this.lastCycle[n2] = this.cycleticks;
        }
    }

    public void drawFluid(int n, boolean bl) {
        int n2 = 0;
        if (this.arecipe[0] == -1) {
            this.arecipe[0] = n;
        } else if (this.arecipe[1] == -1 && this.arecipe[0] != n) {
            this.arecipe[1] = n;
        }
        if (this.arecipe[0] != n && this.arecipe[1] != n) {
            this.resetCounters();
            this.drawFluid(n, bl);
            return;
        }
        if (this.arecipe[1] == n) {
            n2 = 1;
        }
        GuiDraw.drawTexturedModalRect((int)147, (int)2, (int)32, (int)96, (int)18, (int)(this.scaleFluid + 2));
        int n3 = this.getScaledFluid(this.fluidAmount[n2]);
        if (bl) {
            this.drawFluidRect(148, 3 + this.scaleFluid - n3, ((NEIRecipeBase)((Object)this.arecipes.get((int)n))).fluid, 16, n3);
        } else {
            this.drawFluidRect(148, 3 + n3, ((NEIRecipeBase)((Object)this.arecipes.get((int)n))).fluid, 16, this.scaleFluid - n3);
        }
        if (this.cycleticks % 20 == 0 && this.cycleticks != this.lastCycle[n2]) {
            if (this.fluidAmount[n2] == this.maxFluid) {
                this.fluidAmount[n2] = 0;
            }
            int n4 = n2;
            this.fluidAmount[n4] = this.fluidAmount[n4] + ((NEIRecipeBase)((Object)this.arecipes.get((int)n))).fluid.amount;
            if (this.fluidAmount[n2] > this.maxFluid) {
                this.fluidAmount[n2] = this.maxFluid;
            }
        }
        GuiDraw.drawTexturedModalRect((int)148, (int)2, (int)80, (int)96, (int)18, (int)(this.scaleFluid + 2));
    }

    public int getScaledEnergy(int n) {
        return n * this.scaleEnergy / this.maxEnergy;
    }

    public int getScaledFluid(int n) {
        return n * this.scaleFluid / this.maxFluid;
    }

    protected void drawFluidRect(int n, int n2, FluidStack fluidStack, int n3, int n4) {
        if (n4 > this.scaleFluid) {
            n4 = this.scaleFluid;
        }
        int n5 = 0;
        int n6 = 0;
        RenderHelper.setBlockTextureSheet();
        RenderHelper.setColor3ub((int)fluidStack.getFluid().getColor(fluidStack));
        for (int i = 0; i < n3; i += 16) {
            for (int j = 0; j < n4; j += 16) {
                n6 = Math.min(n3 - i, 16);
                n5 = Math.min(n4 - j, 16);
                RecipeHandlerBase.drawScaledTexturedModelRectFromIcon(n + i, n2 + j, fluidStack.getFluid().getIcon(), n6, n5);
            }
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
    }

    public static void drawScaledTexturedModelRectFromIcon(int n, int n2, IIcon iIcon, int n3, int n4) {
        if (iIcon == null) {
            return;
        }
        double d = iIcon.func_94209_e();
        double d2 = iIcon.func_94212_f();
        double d3 = iIcon.func_94206_g();
        double d4 = iIcon.func_94210_h();
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)(n + 0), (double)(n2 + n4), (double)GuiDraw.gui.getZLevel(), d, d3 + (d4 - d3) * (double)n4 / 16.0);
        tessellator.func_78374_a((double)(n + n3), (double)(n2 + n4), (double)GuiDraw.gui.getZLevel(), d + (d2 - d) * (double)n3 / 16.0, d3 + (d4 - d3) * (double)n4 / 16.0);
        tessellator.func_78374_a((double)(n + n3), (double)(n2 + 0), (double)GuiDraw.gui.getZLevel(), d + (d2 - d) * (double)n3 / 16.0, d3);
        tessellator.func_78374_a((double)(n + 0), (double)(n2 + 0), (double)GuiDraw.gui.getZLevel(), d, d3);
        tessellator.func_78381_a();
    }

    abstract class NEIRecipeBase
    extends TemplateRecipeHandler.CachedRecipe {
        PositionedStack input;
        PositionedStack secondaryInput;
        PositionedStack output;
        PositionedStack secondaryOutput;
        String inputOreName;
        ArrayList<ItemStack> inputList;
        String secondaryInputOreName;
        ArrayList<ItemStack> secondaryList;
        int inputOrePosition;
        int secondaryOrePosition;
        FluidStack fluid;
        int secondaryOutputChance;
        int energy;

        NEIRecipeBase() {
            super((TemplateRecipeHandler)RecipeHandlerBase.this);
            this.input = null;
            this.secondaryInput = null;
            this.output = null;
            this.secondaryOutput = null;
            this.inputOreName = "Unknown";
            this.inputList = null;
            this.secondaryInputOreName = "Unknown";
            this.secondaryList = null;
            this.inputOrePosition = 0;
            this.secondaryOrePosition = 0;
            this.fluid = null;
            this.secondaryOutputChance = 0;
            this.energy = 0;
        }

        protected void setOres() {
            if (this.input != null) {
                this.inputOreName = ItemHelper.getOreName((ItemStack)this.input.item);
                if (!this.inputOreName.equals("Unknown")) {
                    this.inputList = OreDictionary.getOres((String)this.inputOreName);
                }
            }
            if (this.secondaryInput != null) {
                this.secondaryInputOreName = ItemHelper.getOreName((ItemStack)this.secondaryInput.item);
                if (!this.secondaryInputOreName.equals("Unknown")) {
                    this.secondaryList = OreDictionary.getOres((String)this.secondaryInputOreName);
                }
            }
        }

        protected void incrementPrimary() {
            if (!this.inputOreName.equals("Unknown")) {
                ++this.inputOrePosition;
                this.inputOrePosition %= this.inputList.size();
                int n = this.input.item.field_77994_a;
                this.input.item = this.inputList.get(this.inputOrePosition);
                this.input.item.field_77994_a = n;
                if (this.inputList.get(this.inputOrePosition).func_77960_j() != Short.MAX_VALUE) {
                    this.input.item.func_77964_b(this.inputList.get(this.inputOrePosition).func_77960_j());
                }
            }
        }

        protected void incrementSecondary() {
            if (!this.secondaryInputOreName.equals("Unknown")) {
                ++this.secondaryOrePosition;
                this.secondaryOrePosition %= this.secondaryList.size();
                int n = this.secondaryInput.item.field_77994_a;
                this.secondaryInput.item = this.secondaryList.get(this.secondaryOrePosition);
                this.secondaryInput.item.field_77994_a = n;
                if (this.secondaryList.get(this.secondaryOrePosition).func_77960_j() != Short.MAX_VALUE) {
                    this.secondaryInput.item.func_77964_b(this.secondaryList.get(this.secondaryOrePosition).func_77960_j());
                }
            }
        }

        public PositionedStack getIngredient() {
            if (RecipeHandlerBase.this.cycleticks % 20 == 0) {
                this.incrementPrimary();
            }
            return this.input;
        }

        public PositionedStack getResult() {
            return this.output;
        }

        public ArrayList<PositionedStack> getOtherStacks() {
            ArrayList<PositionedStack> arrayList = new ArrayList<PositionedStack>();
            if (this.secondaryOutput != null) {
                arrayList.add(this.secondaryOutput);
            }
            if (this.secondaryInput != null) {
                if (RecipeHandlerBase.this.cycleticks % 20 == 0) {
                    this.incrementSecondary();
                }
                arrayList.add(this.secondaryInput);
            }
            return arrayList;
        }
    }
}

