/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.gui.client;

import cofh.api.tileentity.ISecurable;
import cofh.core.CoFHProps;
import cofh.core.gui.GuiBaseAdv;
import cofh.core.gui.element.TabInfo;
import cofh.core.gui.element.TabSecurity;
import cofh.lib.gui.GuiBase;
import cofh.lib.gui.element.TabBase;
import cofh.lib.util.helpers.MathHelper;
import cofh.lib.util.helpers.SecurityHelper;
import cofh.lib.util.helpers.StringHelper;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import thermalexpansion.gui.container.ContainerSatchel;
import thermalexpansion.item.ItemSatchel;

public class GuiSatchel
extends GuiBaseAdv {
    boolean enchanted;
    boolean secure;
    String playerName;
    int storageIndex;
    String myInfo = "";

    public GuiSatchel(InventoryPlayer inventoryPlayer, ContainerSatchel containerSatchel) {
        super((Container)containerSatchel);
        this.playerName = inventoryPlayer.field_70458_d.func_70005_c_();
        this.storageIndex = ItemSatchel.getStorageIndex(containerSatchel.getContainerStack());
        this.enchanted = ItemSatchel.isEnchanted(containerSatchel.getContainerStack());
        this.secure = SecurityHelper.isSecure((ItemStack)containerSatchel.getContainerStack());
        ((GuiBase)this).texture = CoFHProps.TEXTURE_STORAGE[this.storageIndex];
        ((GuiBase)this).name = containerSatchel.getInventoryName();
        ((GuiScreen)this).field_146291_p = false;
        ((GuiContainer)this).field_146999_f = 14 + 18 * MathHelper.clampI((int)(this.storageIndex + 1), (int)9, (int)13);
        ((GuiContainer)this).field_147000_g = 112 + 18 * MathHelper.clampI((int)this.storageIndex, (int)2, (int)8);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        if (this.storageIndex == ItemSatchel.Types.CREATIVE.ordinal()) {
            this.myInfo = StringHelper.localize((String)"tab.thermalexpansion.satchel.creative");
        } else {
            this.myInfo = StringHelper.localize((String)"tab.thermalexpansion.satchel.0") + "\n\n" + StringHelper.localize((String)"tab.thermalexpansion.satchel.1");
            if (!this.enchanted) {
                this.myInfo = this.myInfo + "\n\n" + StringHelper.localize((String)"tab.thermalexpansion.storage.enchant");
            }
        }
        this.addTab((TabBase)new TabInfo((GuiBase)this, this.myInfo));
        if (ItemSatchel.enableSecurity && this.secure) {
            this.addTab((TabBase)new TabSecurity((GuiBase)this, (ISecurable)((GuiContainer)this).field_147002_h, this.playerName));
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (this.secure && !((ISecurable)((GuiContainer)this).field_147002_h).canPlayerAccess(this.playerName)) {
            ((GuiScreen)this).field_146297_k.field_71439_g.func_71053_j();
        }
    }
}

