/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block.plate;

import cofh.core.render.IconRegistry;
import cofh.lib.util.helpers.ItemHelper;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.ShapedOreRecipe;
import thermalexpansion.ThermalExpansion;
import thermalexpansion.block.BlockTEBase;
import thermalexpansion.block.plate.TilePlateBase;
import thermalexpansion.block.plate.TilePlateImpulse;
import thermalexpansion.block.plate.TilePlateSignal;
import thermalexpansion.block.plate.TilePlateTranslocate;
import thermalexpansion.core.TEProps;
import thermalexpansion.util.crafting.TransposerManager;
import thermalfoundation.fluid.TFFluids;

public class BlockPlate
extends BlockTEBase {
    public static final Material material = new PlateMaterial(MapColor.field_151668_h);
    public static final String[] NAMES = new String[]{"frame", "signal", "impulse", "translocate"};
    public static boolean[] enable = new boolean[Types.values().length];
    public static ItemStack plateFrame;
    public static ItemStack signalPlate;
    public static ItemStack impulsePlate;
    public static ItemStack translocatePlate;

    public BlockPlate() {
        super(material);
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.0625f, 1.0f);
        this.func_149711_c(15.0f);
        this.func_149752_b(25.0f);
        this.func_149663_c("thermalexpansion.plate");
    }

    public TileEntity func_149915_a(World world, int n) {
        if (n >= Types.values().length) {
            return null;
        }
        switch (Types.values()[n]) {
            case FRAME: {
                return new TilePlateBase();
            }
            case SIGNAL: {
                return new TilePlateSignal();
            }
            case IMPULSE: {
                return new TilePlateImpulse();
            }
            case TRANSLOCATE: {
                return new TilePlateTranslocate();
            }
        }
        return null;
    }

    public boolean rotateBlock(World world, int n, int n2, int n3, ForgeDirection forgeDirection) {
        TilePlateBase tilePlateBase;
        boolean bl = false;
        if (!world.field_72995_K && (tilePlateBase = (TilePlateBase)world.func_147438_o(n, n2, n3)) != null) {
            tilePlateBase.rotated();
            int n4 = forgeDirection.ordinal();
            if (n4 >> 1 == tilePlateBase.alignment >> 1) {
                tilePlateBase.direction = (byte)((tilePlateBase.direction + 1) % 6);
                bl = true;
            }
        }
        if (bl) {
            world.func_147471_g(n, n2, n3);
        }
        return bl;
    }

    public void func_149666_a(Item item, CreativeTabs creativeTabs, List list) {
        for (int i = 0; i < Types.values().length; ++i) {
            if (!enable[i]) continue;
            list.add(new ItemStack(item, 1, i));
        }
    }

    public void func_149724_b(World world, int n, int n2, int n3, Entity entity) {
    }

    public void func_149670_a(World world, int n, int n2, int n3, Entity entity) {
        TilePlateBase tilePlateBase = (TilePlateBase)world.func_147438_o(n, n2, n3);
        if (tilePlateBase == null) {
            return;
        }
        AxisAlignedBB axisAlignedBB = entity.func_70046_E();
        if (axisAlignedBB == null) {
            axisAlignedBB = entity.field_70121_D;
        }
        if (!axisAlignedBB.func_72326_a(this.getCollisionBlockBounds(tilePlateBase, n, n2, n3))) {
            return;
        }
        tilePlateBase.onEntityCollidedWithBlock(entity);
    }

    public AxisAlignedBB getCollisionBlockBounds(TilePlateBase tilePlateBase, int n, int n2, int n3) {
        float f = 0.0625f;
        float f2 = 0.9375f;
        AxisAlignedBB axisAlignedBB = null;
        switch (tilePlateBase.alignment) {
            case 0: {
                axisAlignedBB = AxisAlignedBB.func_72330_a((double)f, (double)0.0, (double)f, (double)f2, (double)0.125, (double)f2).func_72317_d((double)n, (double)n2, (double)n3);
                break;
            }
            case 1: {
                axisAlignedBB = AxisAlignedBB.func_72330_a((double)f, (double)0.875, (double)f, (double)f2, (double)1.0, (double)f2).func_72317_d((double)n, (double)n2, (double)n3);
                break;
            }
            case 2: {
                axisAlignedBB = AxisAlignedBB.func_72330_a((double)f, (double)f, (double)0.0, (double)f2, (double)f2, (double)0.125).func_72317_d((double)n, (double)n2, (double)n3);
                break;
            }
            case 3: {
                axisAlignedBB = AxisAlignedBB.func_72330_a((double)f, (double)f, (double)0.875, (double)f2, (double)f2, (double)1.0).func_72317_d((double)n, (double)n2, (double)n3);
                break;
            }
            case 4: {
                axisAlignedBB = AxisAlignedBB.func_72330_a((double)0.0, (double)f, (double)f, (double)0.125, (double)f2, (double)f2).func_72317_d((double)n, (double)n2, (double)n3);
                break;
            }
            case 5: {
                axisAlignedBB = AxisAlignedBB.func_72330_a((double)0.875, (double)f, (double)f, (double)1.0, (double)f2, (double)f2).func_72317_d((double)n, (double)n2, (double)n3);
                break;
            }
        }
        return axisAlignedBB;
    }

    public void func_149719_a(IBlockAccess iBlockAccess, int n, int n2, int n3) {
        TilePlateBase tilePlateBase = (TilePlateBase)iBlockAccess.func_147438_o(n, n2, n3);
        if (tilePlateBase != null) {
            switch (tilePlateBase.alignment) {
                case 0: {
                    this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.0625f, 1.0f);
                    return;
                }
                case 1: {
                    this.func_149676_a(0.0f, 0.9375f, 0.0f, 1.0f, 1.0f, 1.0f);
                    return;
                }
                case 2: {
                    this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0625f);
                    return;
                }
                case 3: {
                    this.func_149676_a(0.0f, 0.0f, 0.9375f, 1.0f, 1.0f, 1.0f);
                    return;
                }
                case 4: {
                    this.func_149676_a(0.0f, 0.0f, 0.0f, 0.0625f, 1.0f, 1.0f);
                    return;
                }
                case 5: {
                    this.func_149676_a(0.9375f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                    return;
                }
            }
        }
    }

    public int func_149645_b() {
        return TEProps.renderIdPlate;
    }

    public MovingObjectPosition func_149731_a(World world, int n, int n2, int n3, Vec3 vec3, Vec3 vec32) {
        this.func_149719_a((IBlockAccess)world, n, n2, n3);
        return super.func_149731_a(world, n, n2, n3, vec3, vec32);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iIconRegister) {
        IconRegistry.addIcon((String)"PlateBottom", (String)"thermalexpansion:plate/Plate_Bottom", (IIconRegister)iIconRegister);
        IconRegistry.addIcon((String)"PlateTop0", (String)"thermalexpansion:plate/Plate_Top_Down", (IIconRegister)iIconRegister);
        IconRegistry.addIcon((String)"PlateTop1", (String)"thermalexpansion:plate/Plate_Top_Up", (IIconRegister)iIconRegister);
        IconRegistry.addIcon((String)"PlateTop2", (String)"thermalexpansion:plate/Plate_Top_North", (IIconRegister)iIconRegister);
        IconRegistry.addIcon((String)"PlateTop3", (String)"thermalexpansion:plate/Plate_Top_South", (IIconRegister)iIconRegister);
        IconRegistry.addIcon((String)"PlateTop4", (String)"thermalexpansion:plate/Plate_Top_West", (IIconRegister)iIconRegister);
        IconRegistry.addIcon((String)"PlateTop5", (String)"thermalexpansion:plate/Plate_Top_East", (IIconRegister)iIconRegister);
    }

    public boolean initialize() {
        TilePlateBase.initialize();
        TilePlateSignal.initialize();
        TilePlateImpulse.initialize();
        TilePlateTranslocate.initialize();
        plateFrame = new ItemStack((Block)this, 1, Types.FRAME.ordinal());
        signalPlate = new ItemStack((Block)this, 1, Types.SIGNAL.ordinal());
        impulsePlate = new ItemStack((Block)this, 1, Types.IMPULSE.ordinal());
        translocatePlate = new ItemStack((Block)this, 1, Types.TRANSLOCATE.ordinal());
        GameRegistry.registerCustomItemStack((String)"plateFrame", (ItemStack)plateFrame);
        GameRegistry.registerCustomItemStack((String)"plateSignal", (ItemStack)signalPlate);
        GameRegistry.registerCustomItemStack((String)"plateImpulse", (ItemStack)impulsePlate);
        GameRegistry.registerCustomItemStack((String)"plateTranslocate", (ItemStack)translocatePlate);
        return true;
    }

    public boolean postInit() {
        ItemHelper.addRecipe((IRecipe)new ShapedOreRecipe(plateFrame, new Object[]{"SGS", "I I", "SIS", Character.valueOf('S'), "ingotSignalum", Character.valueOf('G'), "blockGlassHardened", Character.valueOf('I'), "ingotInvar"}));
        if (enable[Types.SIGNAL.ordinal()]) {
            TransposerManager.addTEFillRecipe(2000, plateFrame, signalPlate, new FluidStack(TFFluids.fluidRedstone, 1000), true);
        }
        if (enable[Types.IMPULSE.ordinal()]) {
            TransposerManager.addTEFillRecipe(2000, plateFrame, impulsePlate, new FluidStack(TFFluids.fluidGlowstone, 1000), true);
        }
        if (enable[Types.TRANSLOCATE.ordinal()]) {
            TransposerManager.addTEFillRecipe(2000, plateFrame, translocatePlate, new FluidStack(TFFluids.fluidEnder, 1000), true);
        }
        return true;
    }

    static {
        String string = "block.feature";
        BlockPlate.enable[Types.FRAME.ordinal()] = true;
        BlockPlate.enable[Types.SIGNAL.ordinal()] = ThermalExpansion.config.get(string, "Plate.Signal", true);
        BlockPlate.enable[Types.IMPULSE.ordinal()] = ThermalExpansion.config.get(string, "Plate.Impulse", true);
        BlockPlate.enable[Types.TRANSLOCATE.ordinal()] = ThermalExpansion.config.get(string, "Plate.Translocate", true);
    }

    public static enum Types {
        FRAME,
        SIGNAL,
        IMPULSE,
        TRANSLOCATE;

    }

    private static class PlateMaterial
    extends Material {
        public PlateMaterial(MapColor mapColor) {
            super(mapColor);
            this.func_76221_f();
        }

        public boolean func_76220_a() {
            return false;
        }
    }
}

