/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block.machine;

import cofh.CoFHCore;
import cofh.core.network.PacketCoFHBase;
import cofh.core.render.IconRegistry;
import cofh.core.util.CoreUtils;
import cofh.core.util.fluid.FluidTankAdv;
import cofh.lib.render.RenderHelper;
import cofh.lib.util.helpers.FluidHelper;
import cofh.lib.util.helpers.ItemHelper;
import cofh.lib.util.helpers.MathHelper;
import cofh.lib.util.helpers.ServerHelper;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.IFluidHandler;
import thermalexpansion.ThermalExpansion;
import thermalexpansion.block.TileTEBase;
import thermalexpansion.block.machine.BlockMachine;
import thermalexpansion.block.machine.TileMachineBase;
import thermalexpansion.core.TEProps;
import thermalexpansion.gui.client.machine.GuiTransposer;
import thermalexpansion.gui.container.machine.ContainerTransposer;
import thermalexpansion.util.crafting.TransposerManager;

public class TileTransposer
extends TileMachineBase
implements IFluidHandler {
    static final int TYPE = BlockMachine.Types.TRANSPOSER.ordinal();
    int outputTracker;
    int outputTrackerFluid;
    FluidStack outputBuffer;
    FluidStack renderFluid = new FluidStack(FluidRegistry.WATER, 0);
    FluidTankAdv tank = new FluidTankAdv(10000);
    IFluidContainerItem containerItem = null;
    public boolean reverseFlag;
    public boolean reverse;

    public static void initialize() {
        TileMachineBase.defaultSideConfig[TileTransposer.TYPE] = new TileTEBase.SideConfig();
        TileMachineBase.defaultSideConfig[TileTransposer.TYPE].numGroup = 5;
        TileMachineBase.defaultSideConfig[TileTransposer.TYPE].slotGroups = new int[][]{new int[0], {0}, {1}, new int[0], {1}};
        TileMachineBase.defaultSideConfig[TileTransposer.TYPE].allowInsertion = new boolean[]{false, true, false, false, false};
        TileMachineBase.defaultSideConfig[TileTransposer.TYPE].allowExtraction = new boolean[]{false, true, true, false, true};
        TileMachineBase.defaultSideConfig[TileTransposer.TYPE].sideTex = new int[]{0, 1, 2, 3, 4};
        TileMachineBase.defaultSideConfig[TileTransposer.TYPE].defaultSides = new byte[]{3, 1, 2, 2, 2, 2};
        int n = MathHelper.clampI((int)ThermalExpansion.config.get("block.tweak", "Machine.Transposer.BasePower", 40), (int)10, (int)500);
        ThermalExpansion.config.set("block.tweak", "Machine.Transposer.BasePower", n);
        TileMachineBase.defaultEnergyConfig[TileTransposer.TYPE] = new TileTEBase.EnergyConfig();
        TileMachineBase.defaultEnergyConfig[TYPE].setParamsPower(n);
        TileMachineBase.sounds[TileTransposer.TYPE] = CoreUtils.getSoundName((String)"ThermalExpansion", (String)"blockMachineTransposer");
        TileMachineBase.enableSound[TileTransposer.TYPE] = CoFHCore.configClient.get("sound", "Machine.Transposer", true);
        GameRegistry.registerTileEntity(TileTransposer.class, (String)"thermalexpansion.Transposer");
    }

    public TileTransposer() {
        this.inventory = new ItemStack[3];
    }

    public int getType() {
        return TYPE;
    }

    @Override
    public void func_145845_h() {
        if (ServerHelper.isClientWorld((World)((TileEntity)this).field_145850_b)) {
            if (this.inventory[0] == null) {
                this.processRem = 0;
            }
            return;
        }
        if (this.containerItem == null && FluidHelper.isFluidContainerItem((ItemStack)this.inventory[0])) {
            this.updateContainerItem();
        }
        if (this.reverse) {
            this.transferFluid();
        }
        if (this.containerItem != null) {
            boolean bl = this.isActive;
            this.processContainerItem();
            this.updateIfChanged(bl);
            this.chargeEnergy();
        } else {
            super.func_145845_h();
        }
    }

    @Override
    protected boolean canStart() {
        if (this.inventory[0] == null) {
            return false;
        }
        if (!this.reverse) {
            if (this.tank.getFluidAmount() <= 0) {
                return false;
            }
            TransposerManager.RecipeTransposer recipeTransposer = TransposerManager.getFillRecipe(this.inventory[0], this.tank.getFluid());
            if (recipeTransposer == null || this.tank.getFluidAmount() < recipeTransposer.getFluid().amount || this.energyStorage.getEnergyStored() < recipeTransposer.getEnergy()) {
                return false;
            }
            if (this.inventory[0].field_77994_a < recipeTransposer.getInput().field_77994_a) {
                return false;
            }
            if (this.inventory[1] == null) {
                return true;
            }
            ItemStack itemStack = recipeTransposer.getOutput();
            if (!this.inventory[1].func_77969_a(itemStack)) {
                return false;
            }
            int n = this.inventory[1].field_77994_a + itemStack.field_77994_a;
            return n <= itemStack.func_77976_d();
        }
        TransposerManager.RecipeTransposer recipeTransposer = TransposerManager.getExtractionRecipe(this.inventory[0]);
        if (recipeTransposer == null || this.energyStorage.getEnergyStored() < recipeTransposer.getEnergy()) {
            return false;
        }
        if (this.inventory[0].field_77994_a < recipeTransposer.getInput().field_77994_a) {
            return false;
        }
        if (this.tank.fill(recipeTransposer.getFluid(), false) != recipeTransposer.getFluid().amount) {
            return false;
        }
        if (this.inventory[1] == null) {
            return true;
        }
        ItemStack itemStack = recipeTransposer.getOutput();
        if (itemStack == null) {
            return true;
        }
        if (!this.inventory[1].func_77969_a(itemStack)) {
            return false;
        }
        return this.inventory[1].field_77994_a + itemStack.field_77994_a <= itemStack.func_77976_d();
    }

    @Override
    protected boolean hasValidInput() {
        if (this.containerItem != null) {
            return true;
        }
        TransposerManager.RecipeTransposer recipeTransposer = !this.reverse ? TransposerManager.getFillRecipe(this.inventory[0], this.tank.getFluid()) : TransposerManager.getExtractionRecipe(this.inventory[0]);
        if (recipeTransposer == null) {
            return false;
        }
        return recipeTransposer.getInput().field_77994_a <= this.inventory[0].field_77994_a;
    }

    @Override
    protected void processStart() {
        int n = this.renderFluid.fluidID;
        if (!this.reverse) {
            this.processMax = TransposerManager.getFillRecipe(this.inventory[0], this.tank.getFluid()).getEnergy();
            this.renderFluid = this.tank.getFluid().copy();
        } else {
            this.processMax = TransposerManager.getExtractionRecipe(this.inventory[0]).getEnergy();
            this.renderFluid = TransposerManager.getExtractionRecipe(this.inventory[0]).getFluid();
        }
        this.renderFluid.amount = 0;
        this.processRem = this.processMax;
        if (n != this.renderFluid.fluidID) {
            this.sendFluidPacket();
        }
    }

    @Override
    protected void processFinish() {
        if (!this.reverse) {
            TransposerManager.RecipeTransposer recipeTransposer = TransposerManager.getFillRecipe(this.inventory[0], this.tank.getFluid());
            ItemStack itemStack = recipeTransposer.getOutput();
            if (this.inventory[1] == null) {
                this.inventory[1] = itemStack;
            } else {
                this.inventory[1].field_77994_a += itemStack.field_77994_a;
            }
            --this.inventory[0].field_77994_a;
            if (this.inventory[0].field_77994_a <= 0) {
                this.inventory[0] = null;
            }
            this.tank.drain(recipeTransposer.getFluid().amount, true);
        } else {
            TransposerManager.RecipeTransposer recipeTransposer = TransposerManager.getExtractionRecipe(this.inventory[0]);
            ItemStack itemStack = recipeTransposer.getOutput();
            int n = recipeTransposer.getChance();
            if (n >= 100 || ((TileEntity)this).field_145850_b.field_73012_v.nextInt(this.secondaryChance) < n) {
                if (this.inventory[1] == null) {
                    this.inventory[1] = itemStack;
                } else {
                    this.inventory[1].field_77994_a += itemStack.field_77994_a;
                }
            }
            --this.inventory[0].field_77994_a;
            if (this.inventory[0].field_77994_a <= 0) {
                this.inventory[0] = null;
            }
            this.tank.fill(recipeTransposer.getFluid(), true);
        }
        this.reverse = this.reverseFlag;
    }

    protected void transferFluid() {
        if (!this.augmentAutoTransfer) {
            return;
        }
        if (this.tank.getFluidAmount() <= 0) {
            return;
        }
        this.outputBuffer = new FluidStack(this.tank.getFluid(), Math.min(this.tank.getFluidAmount(), 500));
        for (int i = this.outputTrackerFluid + 1; i <= this.outputTrackerFluid + 6; ++i) {
            int n;
            int n2 = i % 6;
            if (this.sideCache[n2] != 3 && this.sideCache[n2] != 4 || (n = FluidHelper.insertFluidIntoAdjacentFluidHandler((TileEntity)this, (int)n2, (FluidStack)this.outputBuffer, (boolean)true)) <= 0) continue;
            this.tank.drain(n, true);
            this.outputTrackerFluid = n2;
            break;
        }
    }

    @Override
    protected void transferProducts() {
        if (!this.augmentAutoTransfer) {
            return;
        }
        if (this.inventory[1] == null) {
            if (this.containerItem != null) {
                this.inventory[1] = ItemHelper.cloneStack((ItemStack)this.inventory[0], (int)1);
                this.inventory[0] = ItemHelper.consumeItem((ItemStack)this.inventory[0]);
                this.containerItem = null;
            } else {
                return;
            }
        }
        for (int i = this.outputTracker + 1; i <= this.outputTracker + 6; ++i) {
            int n = i % 6;
            if (this.sideCache[n] != 2 && this.sideCache[n] != 4 || !this.transferItem(1, 4, n)) continue;
            this.outputTracker = n;
            break;
        }
    }

    protected void processContainerItem() {
        if (this.isActive) {
            int n = Math.min(this.energyStorage.getEnergyStored(), this.calcEnergy() * this.energyMod);
            if (!this.reverse) {
                this.updateContainerFill(n * this.processMod);
            } else {
                this.updateContainerEmpty(n * this.processMod);
            }
            if (!this.redstoneControlOrDisable()) {
                this.isActive = false;
                this.wasActive = true;
                this.tracker.markTime(((TileEntity)this).field_145850_b);
            } else if (this.containerItem == null) {
                if (FluidHelper.isFluidContainerItem((ItemStack)this.inventory[0])) {
                    this.updateContainerItem();
                    this.isActive = true;
                } else {
                    this.isActive = false;
                    this.wasActive = true;
                    this.tracker.markTime(((TileEntity)this).field_145850_b);
                }
            }
        } else if (this.redstoneControlOrDisable()) {
            if (this.timeCheck()) {
                this.transferProducts();
            }
            if (this.containerItem == null && FluidHelper.isFluidContainerItem((ItemStack)this.inventory[0])) {
                this.updateContainerItem();
            }
            if (this.containerItem != null) {
                this.isActive = true;
            }
        }
    }

    protected void updateContainerItem() {
        FluidStack fluidStack = FluidHelper.getFluidStackFromContainerItem((ItemStack)this.inventory[0]);
        int n = this.renderFluid.fluidID;
        if (!this.reverse) {
            if (fluidStack == null || FluidHelper.isFluidEqual((FluidStack)fluidStack, (FluidStack)this.tank.getFluid())) {
                this.containerItem = (IFluidContainerItem)this.inventory[0].func_77973_b();
                this.renderFluid = this.tank.getFluid() == null ? null : this.tank.getFluid().copy();
            }
        } else if (fluidStack != null && this.tank.getFluid() == null || FluidHelper.isFluidEqual((FluidStack)fluidStack, (FluidStack)this.tank.getFluid())) {
            this.containerItem = (IFluidContainerItem)this.inventory[0].func_77973_b();
            this.renderFluid = fluidStack;
        }
        if (this.renderFluid == null) {
            this.renderFluid = new FluidStack(FluidRegistry.WATER, 0);
        } else {
            this.renderFluid.amount = 0;
        }
        if (this.containerItem != null) {
            this.processMax = 192;
            this.processRem = 1;
            if (n != this.renderFluid.fluidID) {
                this.sendFluidPacket();
            }
        }
    }

    protected void updateContainerFill(int n) {
        int n2;
        if (n <= 0) {
            return;
        }
        int n3 = Math.min(this.tank.getFluidAmount(), n);
        int n4 = n2 = this.tank.getFluid() == null ? 0 : this.containerItem.fill(this.inventory[0], new FluidStack(this.tank.getFluid(), n3), true);
        if (n2 == 0) {
            this.processRem = 0;
            this.reverse = this.reverseFlag;
            this.transferProducts();
            if (!this.redstoneControlOrDisable()) {
                this.isActive = false;
                this.wasActive = true;
                this.tracker.markTime(((TileEntity)this).field_145850_b);
            }
        } else {
            this.tank.drain(n2, true);
            this.energyStorage.modifyEnergyStored(-n3);
        }
    }

    protected void updateContainerEmpty(int n) {
        if (n <= 0) {
            return;
        }
        FluidStack fluidStack = null;
        int n2 = Math.min(this.tank.getSpace(), n);
        if (n2 > 0) {
            fluidStack = this.containerItem.drain(this.inventory[0], n2, true);
        }
        if (fluidStack == null) {
            this.processRem = 0;
            this.reverse = this.reverseFlag;
            this.transferProducts();
            if (!this.redstoneControlOrDisable()) {
                this.isActive = false;
                this.wasActive = true;
                this.tracker.markTime(((TileEntity)this).field_145850_b);
            }
        } else {
            this.tank.fill(fluidStack, true);
            this.energyStorage.modifyEnergyStored(-fluidStack.amount);
        }
    }

    @Override
    public boolean isItemValid(ItemStack itemStack, int n, int n2) {
        return n == 0 ? FluidHelper.isFluidContainerItem((ItemStack)itemStack) || TransposerManager.isItemValid(itemStack) : true;
    }

    public Object getGuiClient(InventoryPlayer inventoryPlayer) {
        return new GuiTransposer(inventoryPlayer, (TileEntity)this);
    }

    public Object getGuiServer(InventoryPlayer inventoryPlayer) {
        return new ContainerTransposer(inventoryPlayer, (TileEntity)this);
    }

    @Override
    public FluidTankAdv getTank() {
        return this.tank;
    }

    @Override
    public FluidStack getTankFluid() {
        return this.tank.getFluid();
    }

    @Override
    public void func_145839_a(NBTTagCompound nBTTagCompound) {
        super.func_145839_a(nBTTagCompound);
        this.outputTracker = nBTTagCompound.func_74762_e("Tracker1");
        this.outputTrackerFluid = nBTTagCompound.func_74762_e("Tracker2");
        this.reverseFlag = this.reverse = nBTTagCompound.func_74767_n("Rev");
        this.tank.readFromNBT(nBTTagCompound);
        if (this.tank.getFluid() != null) {
            this.renderFluid = this.tank.getFluid();
        } else if (TransposerManager.getExtractionRecipe(this.inventory[0]) != null) {
            this.renderFluid = TransposerManager.getExtractionRecipe(this.inventory[0]).getFluid();
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nBTTagCompound) {
        super.func_145841_b(nBTTagCompound);
        nBTTagCompound.func_74768_a("Tracker1", this.outputTracker);
        nBTTagCompound.func_74768_a("Tracker2", this.outputTrackerFluid);
        nBTTagCompound.func_74757_a("Rev", this.reverse);
        this.tank.writeToNBT(nBTTagCompound);
    }

    @Override
    public PacketCoFHBase getPacket() {
        PacketCoFHBase packetCoFHBase = super.getPacket();
        packetCoFHBase.addFluidStack(this.renderFluid);
        return packetCoFHBase;
    }

    @Override
    public PacketCoFHBase getGuiPacket() {
        PacketCoFHBase packetCoFHBase = super.getGuiPacket();
        packetCoFHBase.addBool(this.reverse);
        packetCoFHBase.addBool(this.reverseFlag);
        if (this.tank.getFluid() == null) {
            packetCoFHBase.addFluidStack(this.renderFluid);
        } else {
            packetCoFHBase.addFluidStack(this.tank.getFluid());
        }
        return packetCoFHBase;
    }

    @Override
    public PacketCoFHBase getFluidPacket() {
        PacketCoFHBase packetCoFHBase = super.getFluidPacket();
        packetCoFHBase.addFluidStack(this.renderFluid);
        return packetCoFHBase;
    }

    @Override
    public PacketCoFHBase getModePacket() {
        PacketCoFHBase packetCoFHBase = super.getModePacket();
        packetCoFHBase.addBool(this.reverseFlag);
        return packetCoFHBase;
    }

    @Override
    protected void handleGuiPacket(PacketCoFHBase packetCoFHBase) {
        super.handleGuiPacket(packetCoFHBase);
        this.reverse = packetCoFHBase.getBool();
        this.reverseFlag = packetCoFHBase.getBool();
        this.tank.setFluid(packetCoFHBase.getFluidStack());
    }

    @Override
    protected void handleFluidPacket(PacketCoFHBase packetCoFHBase) {
        super.handleFluidPacket(packetCoFHBase);
        this.renderFluid = packetCoFHBase.getFluidStack();
        ((TileEntity)this).field_145850_b.func_147471_g(((TileEntity)this).field_145851_c, ((TileEntity)this).field_145848_d, ((TileEntity)this).field_145849_e);
    }

    @Override
    protected void handleModePacket(PacketCoFHBase packetCoFHBase) {
        super.handleModePacket(packetCoFHBase);
        this.reverseFlag = packetCoFHBase.getBool();
        if (!this.isActive) {
            this.reverse = this.reverseFlag;
        }
        this.callNeighborTileChange();
    }

    public void setMode(boolean bl) {
        boolean bl2 = this.reverseFlag;
        this.reverseFlag = bl;
        this.sendModePacket();
        this.reverseFlag = bl2;
    }

    @Override
    public void handleTilePacket(PacketCoFHBase packetCoFHBase, boolean bl) {
        super.handleTilePacket(packetCoFHBase, bl);
        if (!bl) {
            this.renderFluid = packetCoFHBase.getFluidStack();
        } else {
            packetCoFHBase.getFluidStack();
        }
    }

    @Override
    public ItemStack func_70298_a(int n, int n2) {
        ItemStack itemStack = super.func_70298_a(n, n2);
        if (ServerHelper.isServerWorld((World)((TileEntity)this).field_145850_b) && n <= this.getMaxInputSlot() && this.isActive && (this.inventory[n] == null || !this.hasValidInput())) {
            this.isActive = false;
            this.wasActive = true;
            this.tracker.markTime(((TileEntity)this).field_145850_b);
            this.processRem = 0;
            this.containerItem = null;
            this.reverse = this.reverseFlag;
        }
        return itemStack;
    }

    @Override
    public void func_70299_a(int n, ItemStack itemStack) {
        if (ServerHelper.isServerWorld((World)((TileEntity)this).field_145850_b) && n <= this.getMaxInputSlot()) {
            if (!(!this.isActive || this.inventory[n] == null || itemStack != null && itemStack.func_77969_a(this.inventory[n]) && this.hasValidInput())) {
                this.isActive = false;
                this.wasActive = true;
                this.tracker.markTime(((TileEntity)this).field_145850_b);
                this.processRem = 0;
            }
            this.containerItem = null;
            this.reverse = this.reverseFlag;
        }
        this.inventory[n] = itemStack;
        if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
            itemStack.field_77994_a = this.func_70297_j_();
        }
    }

    @Override
    public void func_70296_d() {
        if (this.isActive && !this.hasValidInput()) {
            this.isActive = false;
            this.wasActive = true;
            this.tracker.markTime(((TileEntity)this).field_145850_b);
            this.processRem = 0;
            this.containerItem = null;
            this.reverse = this.reverseFlag;
        }
        super.func_70296_d();
    }

    public int fill(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        if (this.reverse || forgeDirection == ForgeDirection.UNKNOWN || this.sideCache[forgeDirection.ordinal()] != 1) {
            return 0;
        }
        return this.tank.fill(fluidStack, bl);
    }

    public FluidStack drain(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        if (!this.reverse || forgeDirection == ForgeDirection.UNKNOWN || this.sideCache[forgeDirection.ordinal()] != 3) {
            return null;
        }
        return this.tank.drain(fluidStack, bl);
    }

    public FluidStack drain(ForgeDirection forgeDirection, int n, boolean bl) {
        if (!this.reverse || forgeDirection == ForgeDirection.UNKNOWN || this.sideCache[forgeDirection.ordinal()] != 3) {
            return null;
        }
        return this.tank.drain(n, bl);
    }

    public boolean canFill(ForgeDirection forgeDirection, Fluid fluid) {
        if (forgeDirection == ForgeDirection.UNKNOWN) {
            return false;
        }
        return !this.reverse && this.sideCache[forgeDirection.ordinal()] == 1;
    }

    public boolean canDrain(ForgeDirection forgeDirection, Fluid fluid) {
        if (forgeDirection == ForgeDirection.UNKNOWN) {
            return false;
        }
        return this.reverse && this.sideCache[forgeDirection.ordinal()] == 3;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection forgeDirection) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }

    @Override
    public IIcon getTexture(int n, int n2) {
        if (n2 == 0) {
            if (n == 0) {
                return IconRegistry.getIcon((String)"MachineBottom");
            }
            if (n == 1) {
                return IconRegistry.getIcon((String)"MachineTop");
            }
            return n != this.facing ? IconRegistry.getIcon((String)"MachineSide") : (this.isActive ? RenderHelper.getFluidTexture((FluidStack)this.renderFluid) : IconRegistry.getIcon((String)"MachineFace", (int)this.getType()));
        }
        return n != this.facing ? IconRegistry.getIcon((String)TEProps.textureSelection, (int)this.sideConfig.sideTex[this.sideCache[n]]) : (this.isActive ? IconRegistry.getIcon((String)"MachineActive", (int)this.getType()) : IconRegistry.getIcon((String)"MachineFace", (int)this.getType()));
    }
}

