/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block.dynamo;

import cofh.core.network.PacketCoFHBase;
import cofh.core.util.fluid.FluidTankAdv;
import cofh.lib.util.helpers.ItemHelper;
import cofh.lib.util.helpers.MathHelper;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import thermalexpansion.ThermalExpansion;
import thermalexpansion.block.TileTEBase;
import thermalexpansion.block.dynamo.BlockDynamo;
import thermalexpansion.block.dynamo.TileDynamoBase;
import thermalexpansion.core.TEProps;
import thermalexpansion.gui.client.dynamo.GuiDynamoSteam;
import thermalexpansion.gui.container.dynamo.ContainerDynamoSteam;
import thermalexpansion.util.FuelHandler;
import thermalfoundation.fluid.TFFluids;

public class TileDynamoSteam
extends TileDynamoBase
implements IFluidHandler {
    static final int TYPE = BlockDynamo.Types.STEAM.ordinal();
    static final int STEAM_MIN = 2000;
    static int coalRF = 48000;
    static int charcoalRF = 32000;
    static int woodRF = 4500;
    static int blockCoalRF = coalRF * 10;
    static int otherRF = woodRF / 3;
    static ItemStack coal = new ItemStack(Items.field_151044_h, 1, 0);
    static ItemStack charcoal = new ItemStack(Items.field_151044_h, 1, 1);
    static ItemStack blockCoal = new ItemStack(Blocks.field_150402_ci);
    FluidTankAdv steamTank = new FluidTankAdv(4000);
    FluidTankAdv waterTank = new FluidTankAdv(4000);
    int currentFuelRF = TileDynamoSteam.getEnergyValue(coal);
    int steamAmount;
    FluidStack steam;

    public static void initialize() {
        int n = MathHelper.clampI((int)ThermalExpansion.config.get("block.tweak", "Dynamo.Steam.BasePower", 80), (int)10, (int)160);
        ThermalExpansion.config.set("block.tweak", "Dynamo.Steam.BasePower", n);
        n /= 10;
        TileDynamoBase.defaultEnergyConfig[TileDynamoSteam.TYPE] = new TileTEBase.EnergyConfig();
        TileDynamoBase.defaultEnergyConfig[TYPE].setParamsDefault(n *= 10);
        GameRegistry.registerTileEntity(TileDynamoSteam.class, (String)"thermalexpansion.DynamoSteam");
    }

    public static int getEnergyValue(ItemStack itemStack) {
        if (itemStack == null) {
            return 0;
        }
        if (itemStack.func_77969_a(coal)) {
            return coalRF;
        }
        if (itemStack.func_77969_a(charcoal)) {
            return charcoalRF;
        }
        if (itemStack.func_77969_a(blockCoal)) {
            return blockCoalRF;
        }
        Item item = itemStack.func_77973_b();
        if (itemStack.func_77973_b() instanceof ItemBlock && ((ItemBlock)item).field_150939_a.func_149688_o() == Material.field_151575_d) {
            return woodRF;
        }
        if (item == Items.field_151055_y || item instanceof ItemBlock && ((ItemBlock)item).field_150939_a == Blocks.field_150345_g) {
            return otherRF;
        }
        return GameRegistry.getFuelValue((ItemStack)itemStack) * 10 * 3 / 2;
    }

    public TileDynamoSteam() {
        this.steamAmount = TileDynamoBase.defaultEnergyConfig[TileDynamoSteam.TYPE].maxPower / 2;
        this.steam = new FluidStack(FluidRegistry.getFluid((String)"steam"), this.steamAmount);
        this.inventory = new ItemStack[1];
    }

    public int getType() {
        return TYPE;
    }

    @Override
    protected boolean canGenerate() {
        if (this.steamTank.getFluidAmount() > 2000) {
            return true;
        }
        if (this.waterTank.getFluidAmount() < this.config.maxPower) {
            return false;
        }
        if (this.fuelRF > 0) {
            return true;
        }
        return TileDynamoSteam.getEnergyValue(this.inventory[0]) > 0;
    }

    @Override
    public void attenuate() {
        if (this.timeCheck()) {
            this.fuelRF -= 10;
            if (this.fuelRF < 0) {
                this.fuelRF = 0;
            }
            this.steamTank.drain(this.config.minPower, true);
        }
    }

    @Override
    public void generate() {
        if (this.steamTank.getFluidAmount() < 2000 + this.steamAmount * this.energyMod) {
            int n;
            if (this.fuelRF <= 0 && this.inventory[0] != null) {
                n = TileDynamoSteam.getEnergyValue(this.inventory[0]) * this.fuelMod / 1000;
                this.fuelRF += n;
                this.currentFuelRF = n;
                this.inventory[0] = ItemHelper.consumeItem((ItemStack)this.inventory[0]);
            }
            if (this.fuelRF > 0) {
                n = this.steamTank.fill(this.steam, true);
                this.fuelRF -= n << 1;
                if (this.timeCheck()) {
                    this.waterTank.drain(n, true);
                }
            }
            if (this.steamTank.getFluidAmount() > 2000) {
                n = Math.min(this.steamTank.getFluidAmount() - 2000 << 1, this.calcEnergy());
                this.energyStorage.modifyEnergyStored(n *= this.energyMod);
                this.steamTank.drain(n >> 1, true);
            }
            return;
        }
        int n = this.calcEnergy() * this.energyMod;
        this.energyStorage.modifyEnergyStored(n);
        this.steamTank.drain(n >> 1, true);
        if (this.fuelRF > 0) {
            n = this.steamTank.fill(this.steam, true);
            this.fuelRF -= n << 1;
            if (this.timeCheck()) {
                this.waterTank.drain(n, true);
            }
        }
    }

    @Override
    public IIcon getActiveIcon() {
        return TFFluids.fluidSteam.getIcon();
    }

    public Object getGuiClient(InventoryPlayer inventoryPlayer) {
        return new GuiDynamoSteam(inventoryPlayer, (TileEntity)this);
    }

    public Object getGuiServer(InventoryPlayer inventoryPlayer) {
        return new ContainerDynamoSteam(inventoryPlayer, (TileEntity)this);
    }

    @Override
    public int getScaledDuration(int n) {
        if (this.currentFuelRF <= 0) {
            this.currentFuelRF = coalRF;
        }
        return this.fuelRF * n / this.currentFuelRF;
    }

    @Override
    public FluidTankAdv getTank(int n) {
        if (n == 0) {
            return this.steamTank;
        }
        return this.waterTank;
    }

    @Override
    public void func_145839_a(NBTTagCompound nBTTagCompound) {
        super.func_145839_a(nBTTagCompound);
        this.currentFuelRF = nBTTagCompound.func_74762_e("FuelMax");
        this.steamTank.readFromNBT(nBTTagCompound.func_74775_l("SteamTank"));
        this.waterTank.readFromNBT(nBTTagCompound.func_74775_l("WaterTank"));
        if (this.currentFuelRF <= 0) {
            this.currentFuelRF = coalRF;
        }
        this.steam.amount = this.steamAmount * this.energyMod;
    }

    @Override
    public void func_145841_b(NBTTagCompound nBTTagCompound) {
        super.func_145841_b(nBTTagCompound);
        nBTTagCompound.func_74768_a("FuelMax", this.currentFuelRF);
        nBTTagCompound.func_74782_a("SteamTank", (NBTBase)this.steamTank.writeToNBT(new NBTTagCompound()));
        nBTTagCompound.func_74782_a("WaterTank", (NBTBase)this.waterTank.writeToNBT(new NBTTagCompound()));
    }

    @Override
    public PacketCoFHBase getGuiPacket() {
        PacketCoFHBase packetCoFHBase = super.getGuiPacket();
        packetCoFHBase.addInt(this.currentFuelRF);
        packetCoFHBase.addFluidStack(this.steamTank.getFluid());
        packetCoFHBase.addFluidStack(this.waterTank.getFluid());
        return packetCoFHBase;
    }

    @Override
    protected void handleGuiPacket(PacketCoFHBase packetCoFHBase) {
        super.handleGuiPacket(packetCoFHBase);
        this.currentFuelRF = packetCoFHBase.getInt();
        this.steamTank.setFluid(packetCoFHBase.getFluidStack());
        this.waterTank.setFluid(packetCoFHBase.getFluidStack());
    }

    @Override
    protected void onInstalled() {
        super.onInstalled();
        this.steam.amount = this.steamAmount * this.energyMod;
    }

    @Override
    protected void resetAugments() {
        super.resetAugments();
        this.steam.amount = this.steamAmount;
    }

    @Override
    public int getInfoEnergyPerTick() {
        return this.steamTank.getFluidAmount() >= 2000 ? this.calcEnergy() * this.energyMod : 0;
    }

    public int fill(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        if (fluidStack == null || forgeDirection.ordinal() == this.facing && !this.augmentCoilDuct) {
            return 0;
        }
        if (fluidStack.getFluid() == this.steam.getFluid()) {
            return this.steamTank.fill(fluidStack, bl);
        }
        if (fluidStack.getFluid() == FluidRegistry.WATER) {
            return this.waterTank.fill(fluidStack, bl);
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        if (fluidStack == null || !this.augmentCoilDuct) {
            return null;
        }
        if (fluidStack.getFluid() == this.steam.getFluid()) {
            return this.steamTank.drain(fluidStack.amount, bl);
        }
        if (fluidStack.getFluid() == FluidRegistry.WATER) {
            return this.waterTank.drain(fluidStack.amount, bl);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection forgeDirection, int n, boolean bl) {
        if (!this.augmentCoilDuct) {
            return null;
        }
        return this.waterTank.drain(n, bl);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection forgeDirection) {
        return new FluidTankInfo[]{this.steamTank.getInfo(), this.waterTank.getInfo()};
    }

    @Override
    public int[] func_94128_d(int n) {
        return n != this.facing || this.augmentCoilDuct ? TileDynamoBase.SLOTS : TEProps.EMPTY_INVENTORY;
    }

    static {
        String string = "fuels.steam";
        coalRF = FuelHandler.configFuels.get(string, "coal", coalRF);
        charcoalRF = FuelHandler.configFuels.get(string, "charcoal", charcoalRF);
        woodRF = FuelHandler.configFuels.get(string, "wood", woodRF);
        blockCoalRF = coalRF * 10;
        otherRF = woodRF / 3;
    }
}

