/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block.device;

import cofh.core.entity.CoFHFakePlayer;
import cofh.core.network.PacketCoFHBase;
import cofh.core.render.IconRegistry;
import cofh.lib.util.helpers.BlockHelper;
import cofh.lib.util.helpers.MathHelper;
import cofh.lib.util.helpers.ServerHelper;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;
import thermalexpansion.ThermalExpansion;
import thermalexpansion.block.TileAugmentable;
import thermalexpansion.block.TileTEBase;
import thermalexpansion.block.device.BlockDevice;
import thermalexpansion.core.TEProps;
import thermalexpansion.gui.client.device.GuiActivator;
import thermalexpansion.gui.container.device.ContainerActivator;

public class TileActivator
extends TileAugmentable {
    static final int TYPE = BlockDevice.Types.ACTIVATOR.ordinal();
    static TileTEBase.SideConfig defaultSideConfig = new TileTEBase.SideConfig();
    public static boolean enableSecurity = true;
    public boolean leftClick = false;
    public byte tickSlot = 0;
    public boolean actsSneaking = false;
    public byte angle = 1;
    CoFHFakePlayer myFakePlayer;
    boolean needsWorld = true;
    int slotTracker = 0;

    public static void initialize() {
        defaultSideConfig = new TileTEBase.SideConfig();
        TileActivator.defaultSideConfig.numGroup = 3;
        TileActivator.defaultSideConfig.slotGroups = new int[][]{new int[0], {0, 1, 2, 3, 4, 5, 6, 7, 8}, {0, 1, 2, 3, 4, 5, 6, 7, 8}};
        TileActivator.defaultSideConfig.allowInsertion = new boolean[]{false, true, false};
        TileActivator.defaultSideConfig.allowExtraction = new boolean[]{false, false, true};
        TileActivator.defaultSideConfig.sideTex = new int[]{0, 1, 4};
        TileActivator.defaultSideConfig.defaultSides = new byte[]{1, 1, 1, 1, 1, 1};
        GameRegistry.registerTileEntity(TileActivator.class, (String)"thermalexpansion.Activator");
        TileActivator.configure();
    }

    public static void configure() {
        String string = "Enable this to allow for Activators to be securable. (Default: true)";
        enableSecurity = ThermalExpansion.config.get("security", "Device.Activator.Securable", enableSecurity, string);
    }

    public TileActivator() {
        this.sideConfig = defaultSideConfig;
        this.inventory = new ItemStack[9];
    }

    @Override
    public void setDefaultSides() {
        this.sideCache = this.getDefaultSides();
        this.sideCache[this.facing] = 0;
        this.sideCache[this.facing ^ 1] = 2;
    }

    public String getName() {
        return "tile.thermalexpansion.device." + BlockDevice.NAMES[this.getType()] + ".name";
    }

    public int getType() {
        return TYPE;
    }

    @Override
    public boolean enableSecurity() {
        return enableSecurity;
    }

    @Override
    public boolean sendRedstoneUpdates() {
        return true;
    }

    @Override
    public void onRedstoneUpdate() {
        if (!this.redstoneControlOrDisable() && !this.needsWorld && this.myFakePlayer.field_71074_e != null) {
            this.myFakePlayer.func_71034_by();
        } else {
            int[] nArray = BlockHelper.getAdjacentCoordinatesForSide((int)((TileEntity)this).field_145851_c, (int)((TileEntity)this).field_145848_d, (int)((TileEntity)this).field_145849_e, (int)this.facing);
            Block block = ((TileEntity)this).field_145850_b.func_147439_a(nArray[0], nArray[1], nArray[2]);
            if (block != null && block.isAir((IBlockAccess)((TileEntity)this).field_145850_b, nArray[0], nArray[1], nArray[2])) {
                this.doDeploy();
            }
        }
    }

    public void func_145845_h() {
        if (ServerHelper.isServerWorld((World)((TileEntity)this).field_145850_b)) {
            if (((TileEntity)this).field_145850_b.func_82737_E() % 16L == 0L && this.redstoneControlOrDisable()) {
                this.doDeploy();
            } else if (!this.needsWorld) {
                if (this.leftClick && this.myFakePlayer.field_71134_c.field_73094_o > -1) {
                    int n = this.getNextStackIndex();
                    this.myFakePlayer.field_71134_c.func_73075_a();
                    if (this.myFakePlayer.field_71134_c.field_73094_o >= 9) {
                        this.simLeftClick((EntityPlayer)this.myFakePlayer, this.func_70301_a(n), this.facing);
                    }
                } else if (!this.leftClick && this.myFakePlayer.field_71074_e != null) {
                    this.myFakePlayer.tickItemInUse(this.func_70301_a(this.getNextStackIndex()));
                }
            }
        }
    }

    public void doDeploy() {
        int n = this.getNextStackIndex();
        ItemStack itemStack = this.func_70301_a(n);
        this.updateFakePlayer(n);
        if (this.leftClick) {
            this.simLeftClick((EntityPlayer)this.myFakePlayer, itemStack, this.facing);
        } else {
            int[] nArray = BlockHelper.getAdjacentCoordinatesForSide((int)((TileEntity)this).field_145851_c, (int)((TileEntity)this).field_145848_d, (int)((TileEntity)this).field_145849_e, (int)this.facing);
            this.simRightClick((EntityPlayer)this.myFakePlayer, itemStack, nArray[0], nArray[1], nArray[2], 1);
        }
        if (itemStack != null && itemStack.field_77994_a <= 0) {
            this.func_70299_a(n, null);
        }
        this.checkItemsUpdated();
    }

    public void checkItemsUpdated() {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            this.func_70299_a(i, this.myFakePlayer.field_71071_by.field_70462_a[i]);
            if (this.inventory[i] == null || this.inventory[i].field_77994_a > 0) continue;
            this.inventory[i] = null;
        }
    }

    public int getNextStackIndex() {
        if (!this.needsWorld) {
            if (this.leftClick && this.myFakePlayer.field_71134_c.field_73094_o > -1 || this.myFakePlayer.field_71074_e != null) {
                return this.slotTracker;
            }
            if (this.tickSlot == 0) {
                return this.incrementTracker();
            }
            if (this.tickSlot == 1) {
                return this.getRandomStackIndex();
            }
            return 0;
        }
        return 0;
    }

    public int getRandomStackIndex() {
        int n = -1;
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (this.func_70301_a(i) == null || MathHelper.RANDOM.nextInt(2) != 0) continue;
            n = i;
        }
        return n == -1 ? this.incrementTracker() : n;
    }

    public int incrementTracker() {
        int n;
        ++this.slotTracker;
        this.slotTracker %= this.func_70302_i_();
        for (n = this.slotTracker; n < this.func_70302_i_(); ++n) {
            if (this.inventory[n] == null) continue;
            this.slotTracker = n;
            return this.slotTracker;
        }
        for (n = 0; n < this.slotTracker; ++n) {
            if (this.inventory[n] == null) continue;
            this.slotTracker = n;
            return this.slotTracker;
        }
        this.slotTracker = 0;
        return this.slotTracker;
    }

    public void updateFakePlayer(int n) {
        float f;
        if (this.needsWorld) {
            this.myFakePlayer = new CoFHFakePlayer((WorldServer)((TileEntity)this).field_145850_b);
            this.needsWorld = false;
        }
        this.myFakePlayer.field_71071_by.field_70462_a = new ItemStack[36];
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            this.myFakePlayer.field_71071_by.field_70462_a[i] = this.func_70301_a(i);
        }
        double d = (double)((TileEntity)this).field_145851_c + 0.5;
        double d2 = (double)((TileEntity)this).field_145848_d - 1.1;
        double d3 = (double)((TileEntity)this).field_145849_e + 0.5;
        float f2 = this.angle == 0 ? 45.0f : (this.angle == 1 ? 0.0f : -45.0f);
        switch (this.facing) {
            case 0: {
                f2 = this.angle == 0 ? -90.0f : (this.angle == 1 ? 0.0f : 90.0f);
                f = 0.0f;
                d2 -= 0.51;
                break;
            }
            case 1: {
                f2 = this.angle == 0 ? 90.0f : (this.angle == 1 ? 0.0f : -90.0f);
                f = 0.0f;
                d2 += 1.51;
                break;
            }
            case 2: {
                f = 180.0f;
                d3 -= 0.51;
                d2 += 0.5;
                break;
            }
            case 3: {
                f = 0.0f;
                d3 += 0.51;
                d2 += 0.5;
                break;
            }
            case 4: {
                f = 90.0f;
                d -= 0.51;
                d2 += 0.5;
                break;
            }
            default: {
                f = -90.0f;
                d += 0.51;
                d2 += 0.5;
            }
        }
        this.myFakePlayer.func_70080_a(d, d2, d3, f, f2);
        this.myFakePlayer.isSneaking = this.actsSneaking;
        this.myFakePlayer.field_70129_M = -1.1f;
        this.myFakePlayer.setItemInHand(n);
        this.myFakePlayer.func_70071_h_();
    }

    public boolean simLeftClick(EntityPlayer entityPlayer, ItemStack itemStack, int n) {
        int[] nArray = BlockHelper.getAdjacentCoordinatesForSide((int)((TileEntity)this).field_145851_c, (int)((TileEntity)this).field_145848_d, (int)((TileEntity)this).field_145849_e, (int)this.facing);
        Block block = ((TileEntity)this).field_145850_b.func_147439_a(nArray[0], nArray[1], nArray[2]);
        if (block != Blocks.field_150350_a) {
            if (this.myFakePlayer.field_71134_c.field_73094_o == -1) {
                this.myFakePlayer.field_71134_c.func_73074_a(nArray[0], nArray[1], nArray[2], this.facing ^ 1);
            } else if (this.myFakePlayer.field_71134_c.field_73094_o >= 9) {
                this.myFakePlayer.field_71134_c.func_73082_a(nArray[0], nArray[1], nArray[2]);
                this.myFakePlayer.field_71134_c.field_73094_o = -1;
                if (itemStack != null) {
                    itemStack.func_77973_b().func_150894_a(itemStack, ((TileEntity)this).field_145850_b, block, nArray[0], nArray[1], nArray[2], (EntityLivingBase)this.myFakePlayer);
                }
            }
        } else {
            this.myFakePlayer.field_71134_c.field_73094_o = -1;
            List list = ((TileEntity)this).field_145850_b.func_72872_a(Entity.class, BlockHelper.getAdjacentAABBForSide((int)((TileEntity)this).field_145851_c, (int)((TileEntity)this).field_145848_d, (int)((TileEntity)this).field_145849_e, (int)this.facing));
            if (list.size() == 0) {
                return false;
            }
            entityPlayer.func_71059_n((Entity)list.get(list.size() > 1 ? MathHelper.RANDOM.nextInt(list.size() - 1) : 0));
        }
        return true;
    }

    public void simRightClick(EntityPlayer entityPlayer, ItemStack itemStack, int n, int n2, int n3, int n4) {
        if (entityPlayer.field_71074_e == null && !this.simRightClick2(entityPlayer, itemStack, n, n2, n3, n4) && itemStack != null) {
            List list = ((TileEntity)this).field_145850_b.func_72872_a(Entity.class, BlockHelper.getAdjacentAABBForSide((int)((TileEntity)this).field_145851_c, (int)((TileEntity)this).field_145848_d, (int)((TileEntity)this).field_145849_e, (int)this.facing));
            if (list.size() > 0 && entityPlayer.func_70998_m((Entity)list.get(list.size() > 1 ? MathHelper.RANDOM.nextInt(list.size() - 1) : 0))) {
                return;
            }
            ItemStack itemStack2 = itemStack.func_77957_a(((TileEntity)this).field_145850_b, entityPlayer);
            entityPlayer.field_71071_by.func_70299_a(this.myFakePlayer.field_71071_by.field_70461_c, itemStack2.field_77994_a <= 0 ? null : itemStack2);
        }
    }

    public boolean simRightClick2(EntityPlayer entityPlayer, ItemStack itemStack, int n, int n2, int n3, int n4) {
        int n5;
        float f = 0.5f;
        float f2 = 0.5f;
        float f3 = 0.5f;
        int n6 = n5 = this.facing == 1 ? 1 : -1;
        if (this.facing > 1) {
            if (this.angle == 0) {
                --n2;
            }
            if (this.angle == 2) {
                ++n2;
            }
        }
        Block block = ((TileEntity)this).field_145850_b.func_147439_a(n, n2, n3);
        boolean bl = block.isAir((IBlockAccess)((TileEntity)this).field_145850_b, n, n2, n3);
        if (itemStack != null && itemStack.func_77973_b() != null && itemStack.func_77973_b().onItemUseFirst(itemStack, entityPlayer, ((TileEntity)this).field_145850_b, n, n2, n3, n4, f, f2, f3)) {
            return true;
        }
        if ((!entityPlayer.func_70093_af() || entityPlayer.func_70694_bm() == null) && block.func_149727_a(((TileEntity)this).field_145850_b, n, n2, n3, entityPlayer, n4, f, f2, f3)) {
            return true;
        }
        if (itemStack == null) {
            return false;
        }
        if (itemStack.func_77973_b() instanceof ItemBlock ? !itemStack.func_77943_a(entityPlayer, ((TileEntity)this).field_145850_b, n, n2 + n5, n3, this.facing != 1 ? 1 : 0, f, f2, f3) && (bl ? !itemStack.func_77943_a(entityPlayer, ((TileEntity)this).field_145850_b, n, n2, n3, this.facing != 1 ? 1 : 0, f, f2, f3) : !itemStack.func_77943_a(entityPlayer, ((TileEntity)this).field_145850_b, n, n2, n3, 0, f, f2, f3)) : (bl ? !itemStack.func_77943_a(entityPlayer, ((TileEntity)this).field_145850_b, n, n2, n3, this.facing != 1 ? 1 : 0, f, f2, f3) && !itemStack.func_77943_a(entityPlayer, ((TileEntity)this).field_145850_b, n, n2 + n5, n3, this.facing != 1 ? 1 : 0, f, f2, f3) : !itemStack.func_77943_a(entityPlayer, ((TileEntity)this).field_145850_b, n, n2, n3, 0, f, f2, f3) && !itemStack.func_77943_a(entityPlayer, ((TileEntity)this).field_145850_b, n, n2 + n5, n3, this.facing != 1 ? 1 : 0, f, f2, f3))) {
            return false;
        }
        if (itemStack.field_77994_a <= 0) {
            MinecraftForge.EVENT_BUS.post((Event)new PlayerDestroyItemEvent(entityPlayer, itemStack));
            entityPlayer.field_71071_by.func_70299_a(this.myFakePlayer.field_71071_by.field_70461_c, null);
        }
        return true;
    }

    public Object getGuiClient(InventoryPlayer inventoryPlayer) {
        return new GuiActivator(inventoryPlayer, (TileEntity)this);
    }

    public Object getGuiServer(InventoryPlayer inventoryPlayer) {
        return new ContainerActivator(inventoryPlayer, (TileEntity)this);
    }

    @Override
    public void func_145839_a(NBTTagCompound nBTTagCompound) {
        super.func_145839_a(nBTTagCompound);
        this.actsSneaking = nBTTagCompound.func_74767_n("Sneaking");
        this.leftClick = nBTTagCompound.func_74767_n("LeftClick");
        this.tickSlot = nBTTagCompound.func_74771_c("TickSlot");
        this.angle = nBTTagCompound.func_74771_c("Angle");
    }

    @Override
    public void func_145841_b(NBTTagCompound nBTTagCompound) {
        super.func_145841_b(nBTTagCompound);
        nBTTagCompound.func_74757_a("Sneaking", this.actsSneaking);
        nBTTagCompound.func_74757_a("LeftClick", this.leftClick);
        nBTTagCompound.func_74774_a("TickSlot", this.tickSlot);
        nBTTagCompound.func_74774_a("Angle", this.angle);
    }

    @Override
    public PacketCoFHBase getPacket() {
        PacketCoFHBase packetCoFHBase = super.getPacket();
        packetCoFHBase.addBool(this.leftClick);
        packetCoFHBase.addBool(this.actsSneaking);
        packetCoFHBase.addByte(this.tickSlot);
        packetCoFHBase.addByte(this.angle);
        return packetCoFHBase;
    }

    @Override
    public PacketCoFHBase getModePacket() {
        PacketCoFHBase packetCoFHBase = super.getModePacket();
        packetCoFHBase.addBool(this.leftClick);
        packetCoFHBase.addBool(this.actsSneaking);
        packetCoFHBase.addByte(this.tickSlot);
        packetCoFHBase.addByte(this.angle);
        return packetCoFHBase;
    }

    @Override
    protected void handleModePacket(PacketCoFHBase packetCoFHBase) {
        super.handleModePacket(packetCoFHBase);
        this.leftClick = packetCoFHBase.getBool();
        this.actsSneaking = packetCoFHBase.getBool();
        this.tickSlot = packetCoFHBase.getByte();
        this.angle = packetCoFHBase.getByte();
    }

    @Override
    public void handleTilePacket(PacketCoFHBase packetCoFHBase, boolean bl) {
        super.handleTilePacket(packetCoFHBase, bl);
        this.leftClick = packetCoFHBase.getBool();
        this.actsSneaking = packetCoFHBase.getBool();
        this.tickSlot = packetCoFHBase.getByte();
        this.angle = packetCoFHBase.getByte();
    }

    @Override
    public void readPortableData(EntityPlayer entityPlayer, NBTTagCompound nBTTagCompound) {
        if (!this.canPlayerAccess(entityPlayer.func_70005_c_())) {
            return;
        }
        super.readPortableData(entityPlayer, nBTTagCompound);
        this.actsSneaking = nBTTagCompound.func_74767_n("Sneaking");
        this.leftClick = nBTTagCompound.func_74767_n("LeftClick");
        this.tickSlot = nBTTagCompound.func_74771_c("TickSlot");
        this.angle = nBTTagCompound.func_74771_c("Angle");
    }

    @Override
    public void writePortableData(EntityPlayer entityPlayer, NBTTagCompound nBTTagCompound) {
        if (!this.canPlayerAccess(entityPlayer.func_70005_c_())) {
            return;
        }
        super.writePortableData(entityPlayer, nBTTagCompound);
        nBTTagCompound.func_74757_a("Sneaking", this.actsSneaking);
        nBTTagCompound.func_74757_a("LeftClick", this.leftClick);
        nBTTagCompound.func_74774_a("TickSlot", this.tickSlot);
        nBTTagCompound.func_74774_a("Angle", this.angle);
    }

    @Override
    public boolean allowYAxisFacing() {
        return true;
    }

    @Override
    public boolean setFacing(int n) {
        if (n < 0 || n > 5) {
            return false;
        }
        this.facing = (byte)n;
        this.sideCache[this.facing] = 0;
        this.sideCache[this.facing ^ 1] = 2;
        this.func_70296_d();
        this.sendUpdatePacket(Side.CLIENT);
        return true;
    }

    @Override
    public IIcon getTexture(int n, int n2) {
        if (n2 == 0) {
            return n != this.facing ? IconRegistry.getIcon((String)"DeviceSide") : (this.redstoneControlOrDisable() ? IconRegistry.getIcon((String)"DeviceActive", (int)this.getType()) : IconRegistry.getIcon((String)"DeviceFace", (int)this.getType()));
        }
        if (n < 6) {
            return IconRegistry.getIcon((String)TEProps.textureSelection, (int)this.sideConfig.sideTex[this.sideCache[n]]);
        }
        return IconRegistry.getIcon((String)"DeviceSide");
    }
}

