/*
 * Decompiled with CFR 0.152.
 */
package cofh.repack.codechicken.lib.colour;

import cofh.repack.codechicken.lib.math.MathHelper;
import cofh.repack.codechicken.lib.util.Copyable;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

public abstract class Colour
implements Copyable<Colour> {
    public byte r;
    public byte g;
    public byte b;
    public byte a;

    public Colour(int n, int n2, int n3, int n4) {
        this.r = (byte)n;
        this.g = (byte)n2;
        this.b = (byte)n3;
        this.a = (byte)n4;
    }

    public Colour(Colour colour) {
        this.r = colour.r;
        this.g = colour.g;
        this.b = colour.b;
        this.a = colour.a;
    }

    @SideOnly(value=Side.CLIENT)
    public void glColour() {
        GL11.glColor4ub((byte)this.r, (byte)this.g, (byte)this.b, (byte)this.a);
    }

    @SideOnly(value=Side.CLIENT)
    public void glColour(int n) {
        GL11.glColor4ub((byte)this.r, (byte)this.g, (byte)this.b, (byte)((byte)n));
    }

    public abstract int pack();

    public String toString() {
        return this.getClass().getSimpleName() + "[0x" + Integer.toHexString(this.pack()).toUpperCase() + "]";
    }

    public Colour add(Colour colour) {
        this.a = (byte)(this.a + colour.a);
        this.r = (byte)(this.r + colour.r);
        this.g = (byte)(this.g + colour.g);
        this.b = (byte)(this.b + colour.b);
        return this;
    }

    public Colour sub(Colour colour) {
        int n = (this.a & 0xFF) - (colour.a & 0xFF);
        int n2 = (this.r & 0xFF) - (colour.r & 0xFF);
        int n3 = (this.g & 0xFF) - (colour.g & 0xFF);
        int n4 = (this.b & 0xFF) - (colour.b & 0xFF);
        this.a = (byte)(n < 0 ? 0 : n);
        this.r = (byte)(n2 < 0 ? 0 : n2);
        this.g = (byte)(n3 < 0 ? 0 : n3);
        this.b = (byte)(n4 < 0 ? 0 : n4);
        return this;
    }

    public Colour invert() {
        this.a = (byte)(255 - (this.a & 0xFF));
        this.r = (byte)(255 - (this.r & 0xFF));
        this.g = (byte)(255 - (this.g & 0xFF));
        this.b = (byte)(255 - (this.b & 0xFF));
        return this;
    }

    public Colour multiply(Colour colour) {
        this.a = (byte)((double)(this.a & 0xFF) * ((double)(colour.a & 0xFF) / 255.0));
        this.r = (byte)((double)(this.r & 0xFF) * ((double)(colour.r & 0xFF) / 255.0));
        this.g = (byte)((double)(this.g & 0xFF) * ((double)(colour.g & 0xFF) / 255.0));
        this.b = (byte)((double)(this.b & 0xFF) * ((double)(colour.b & 0xFF) / 255.0));
        return this;
    }

    public Colour scale(double d) {
        this.a = (byte)((double)(this.a & 0xFF) * d);
        this.r = (byte)((double)(this.r & 0xFF) * d);
        this.g = (byte)((double)(this.g & 0xFF) * d);
        this.b = (byte)((double)(this.b & 0xFF) * d);
        return this;
    }

    public Colour interpolate(Colour colour, double d) {
        return this.add(colour.copy().sub(this).scale(d));
    }

    public Colour multiplyC(double d) {
        this.r = (byte)MathHelper.clip((double)(this.r & 0xFF) * d, 0.0, 255.0);
        this.g = (byte)MathHelper.clip((double)(this.g & 0xFF) * d, 0.0, 255.0);
        this.b = (byte)MathHelper.clip((double)(this.b & 0xFF) * d, 0.0, 255.0);
        return this;
    }

    @Override
    public abstract Colour copy();

    public int rgb() {
        return (this.r & 0xFF) << 16 | (this.g & 0xFF) << 8 | this.b & 0xFF;
    }

    public int argb() {
        return (this.a & 0xFF) << 24 | (this.r & 0xFF) << 16 | (this.g & 0xFF) << 8 | this.b & 0xFF;
    }

    public int rgba() {
        return (this.r & 0xFF) << 24 | (this.g & 0xFF) << 16 | (this.b & 0xFF) << 8 | this.a & 0xFF;
    }

    public Colour set(Colour colour) {
        this.r = colour.r;
        this.g = colour.g;
        this.b = colour.b;
        this.a = colour.a;
        return this;
    }

    public boolean equals(Colour colour) {
        return colour != null && this.rgba() == colour.rgba();
    }
}

