/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.world;

import cofh.lib.util.WeightedRandomBlock;
import cofh.lib.world.WorldGenMinableCluster;
import java.util.List;
import java.util.Random;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenSpike
extends WorldGenerator {
    private final List<WeightedRandomBlock> cluster;
    private final WeightedRandomBlock[] genBlock;
    public boolean largeSpikes = true;
    public int largeSpikeChance = 60;
    public int minHeight = 7;
    public int heightVariance = 4;
    public int sizeVariance = 2;
    public int positionVariance = 4;
    public int minLargeSpikeHeightGain = 10;
    public int largeSpikeHeightVariance = 30;
    public int largeSpikeFillerSize = 1;

    public WorldGenSpike(List<WeightedRandomBlock> list, List<WeightedRandomBlock> list2) {
        this.cluster = list;
        this.genBlock = list2.toArray(new WeightedRandomBlock[list2.size()]);
    }

    public boolean func_76484_a(World world, Random random, int n, int n2, int n3) {
        int n4;
        while (world.func_147437_c(n, n2, n3) && n2 > 2) {
            --n2;
        }
        if (!WorldGenMinableCluster.canGenerateInBlock(world, n, n2, n3, this.genBlock)) {
            return false;
        }
        int n5 = n4 = random.nextInt(this.heightVariance) + this.minHeight;
        int n6 = n4 / (this.minHeight / 2) + random.nextInt(this.sizeVariance);
        if (n6 > 1) {
            n2 += random.nextInt(this.positionVariance) - 1;
        }
        if (this.largeSpikes && n6 > 1 && (this.largeSpikeChance <= 0 || random.nextInt(this.largeSpikeChance) == 0)) {
            n4 += this.minLargeSpikeHeightGain + random.nextInt(this.largeSpikeHeightVariance);
        }
        int n7 = n4 - n5;
        for (int i = 0; i < n4; ++i) {
            float f = i >= n7 ? (1.0f - (float)(i - n7) / (float)n5) * (float)n6 : (float)this.largeSpikeFillerSize;
            int n8 = MathHelper.func_76123_f((float)f);
            for (int j = -n8; j <= n8; ++j) {
                float f2 = (float)MathHelper.func_76130_a((int)j) - 0.25f;
                for (int k = -n8; k <= n8; ++k) {
                    float f3 = (float)MathHelper.func_76130_a((int)k) - 0.25f;
                    if ((j != 0 || k != 0) && !(f2 * f2 + f3 * f3 <= f * f) || (j == -n8 || j == n8 || k == -n8 || k == n8) && !(random.nextFloat() <= 0.75f)) continue;
                    WorldGenMinableCluster.generateBlock(world, n + j, n2 + i, n3 + k, this.genBlock, this.cluster);
                    if (i == 0 || n8 <= 1) continue;
                    WorldGenMinableCluster.generateBlock(world, n + j, n2 - i + n7, n3 + k, this.genBlock, this.cluster);
                }
            }
        }
        return true;
    }
}

