/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.util.helpers;

import cofh.api.tileentity.ISecurable;
import cofh.lib.util.helpers.StringHelper;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class SecurityHelper {
    private SecurityHelper() {
    }

    public static NBTTagCompound setItemStackTagSecure(NBTTagCompound nBTTagCompound, ISecurable iSecurable) {
        if (iSecurable == null) {
            return null;
        }
        if (nBTTagCompound == null) {
            nBTTagCompound = new NBTTagCompound();
        }
        nBTTagCompound.func_74757_a("Secure", true);
        nBTTagCompound.func_74774_a("Access", (byte)iSecurable.getAccess().ordinal());
        nBTTagCompound.func_74778_a("Owner", iSecurable.getOwnerName());
        return nBTTagCompound;
    }

    public static void addOwnerInformation(ItemStack itemStack, List<String> list) {
        if (SecurityHelper.isSecure(itemStack)) {
            if (!itemStack.field_77990_d.func_74764_b("Owner")) {
                list.add(StringHelper.localize("info.cofh.owner") + ": " + StringHelper.localize("info.cofh.none"));
            } else {
                list.add(StringHelper.localize("info.cofh.owner") + ": " + itemStack.field_77990_d.func_74779_i("Owner"));
            }
        }
    }

    public static void addAccessInformation(ItemStack itemStack, List<String> list) {
        if (SecurityHelper.isSecure(itemStack)) {
            String string = "";
            switch (itemStack.field_77990_d.func_74771_c("Access")) {
                case 0: {
                    string = StringHelper.localize("info.cofh.accessPublic");
                    break;
                }
                case 1: {
                    string = StringHelper.localize("info.cofh.accessRestricted");
                    break;
                }
                case 2: {
                    string = StringHelper.localize("info.cofh.accessPrivate");
                }
            }
            list.add(StringHelper.localize("info.cofh.access") + ": " + string);
        }
    }

    public static boolean isSecure(ItemStack itemStack) {
        return itemStack.field_77990_d == null ? false : itemStack.field_77990_d.func_74764_b("Secure");
    }

    public static ItemStack setSecure(ItemStack itemStack) {
        if (SecurityHelper.isSecure(itemStack)) {
            return itemStack;
        }
        if (itemStack.field_77990_d == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        itemStack.field_77990_d.func_74757_a("Secure", true);
        itemStack.field_77990_d.func_74774_a("Access", (byte)0);
        return itemStack;
    }

    public static boolean setAccess(ItemStack itemStack, ISecurable.AccessMode accessMode) {
        if (!SecurityHelper.isSecure(itemStack)) {
            return false;
        }
        itemStack.field_77990_d.func_74774_a("Access", (byte)accessMode.ordinal());
        return true;
    }

    public static ISecurable.AccessMode getAccess(ItemStack itemStack) {
        return itemStack.field_77990_d == null ? ISecurable.AccessMode.PUBLIC : ISecurable.AccessMode.values()[itemStack.field_77990_d.func_74771_c("Access")];
    }

    public static boolean setOwnerName(ItemStack itemStack, String string) {
        if (!SecurityHelper.isSecure(itemStack)) {
            return false;
        }
        itemStack.field_77990_d.func_74778_a("Owner", string);
        return true;
    }

    public static String getOwnerName(ItemStack itemStack) {
        return itemStack.field_77990_d == null ? "[None]" : itemStack.field_77990_d.func_74779_i("Owner");
    }
}

