/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.util.helpers;

import java.util.AbstractList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public final class BlockHelper {
    public static byte[] rotateType = new byte[4096];
    public static final int[][] SIDE_COORD_MOD = new int[][]{{0, -1, 0}, {0, 1, 0}, {0, 0, -1}, {0, 0, 1}, {-1, 0, 0}, {1, 0, 0}};
    public static float[][] SIDE_COORD_AABB = new float[][]{{1.0f, -2.0f, 1.0f}, {1.0f, 2.0f, 1.0f}, {1.0f, 1.0f, 1.0f}, {1.0f, 1.0f, 2.0f}, {1.0f, 1.0f, 1.0f}, {2.0f, 1.0f, 1.0f}};
    public static final byte[] SIDE_LEFT = new byte[]{4, 5, 5, 4, 2, 3};
    public static final byte[] SIDE_RIGHT = new byte[]{5, 4, 4, 5, 3, 2};
    public static final byte[] SIDE_OPPOSITE = new byte[]{1, 0, 3, 2, 5, 4};
    public static final byte[] SIDE_ABOVE = new byte[]{3, 2, 1, 1, 1, 1};
    public static final byte[] SIDE_BELOW = new byte[]{2, 3, 0, 0, 0, 0};
    public static final byte[] ROTATE_CLOCK_Y = new byte[]{0, 1, 4, 5, 3, 2};
    public static final byte[] ROTATE_CLOCK_Z = new byte[]{5, 4, 2, 3, 0, 1};
    public static final byte[] ROTATE_CLOCK_X = new byte[]{2, 3, 1, 0, 4, 5};
    public static final byte[] ROTATE_COUNTER_Y = new byte[]{0, 1, 5, 4, 2, 3};
    public static final byte[] ROTATE_COUNTER_Z = new byte[]{4, 5, 2, 3, 1, 0};
    public static final byte[] ROTATE_COUNTER_X = new byte[]{3, 2, 0, 1, 4, 5};
    public static final byte[] INVERT_AROUND_Y = new byte[]{0, 1, 3, 2, 5, 4};
    public static final byte[] INVERT_AROUND_Z = new byte[]{1, 0, 2, 3, 5, 4};
    public static final byte[] INVERT_AROUND_X = new byte[]{1, 0, 3, 2, 4, 5};
    public static final byte[][] ICON_ROTATION_MAP = new byte[6][];

    private BlockHelper() {
    }

    public static int getMicroBlockAngle(int n, float f, float f2, float f3) {
        int n2 = n ^ 1;
        float f4 = 0.16f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        switch (n >> 1) {
            case 0: {
                f5 = f;
                f6 = f3;
                break;
            }
            case 1: {
                f5 = f;
                f6 = f2;
                break;
            }
            case 2: {
                f5 = f2;
                f6 = f3;
            }
        }
        f5 -= 0.5f;
        f6 -= 0.5f;
        if (f5 * f5 + f6 * f6 > f4 * f4) {
            int n3 = (int)((Math.atan2(f5, f6) + Math.PI) * 4.0 / Math.PI);
            ++n3;
            switch ((n3 &= 7) >> 1) {
                case 0: 
                case 4: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 4;
                    break;
                }
                case 2: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 5;
                }
            }
        }
        return n2;
    }

    public static ForgeDirection getMicroBlockAngle(ForgeDirection forgeDirection, float f, float f2, float f3) {
        return ForgeDirection.VALID_DIRECTIONS[BlockHelper.getMicroBlockAngle(forgeDirection.ordinal(), f, f2, f3)];
    }

    public static int getHighestY(World world, int n, int n2) {
        return world.func_72938_d(n, n2).func_76625_h() + 16;
    }

    public static int getSurfaceBlockY(World world, int n, int n2) {
        Block block;
        int n3 = world.func_72938_d(n, n2).func_76625_h() + 16;
        while (--n3 >= 0 && ((block = world.func_147439_a(n, n3, n2)).isAir((IBlockAccess)world, n, n3, n2) || block.isReplaceable((IBlockAccess)world, n, n3, n2) || block.isLeaves((IBlockAccess)world, n, n3, n2) || block.isFoliage((IBlockAccess)world, n, n3, n2) || block.canBeReplacedByLeaves((IBlockAccess)world, n, n3, n2))) {
        }
        return n3;
    }

    public static int getTopBlockY(World world, int n, int n2) {
        Block block;
        int n3 = world.func_72938_d(n, n2).func_76625_h() + 16;
        while (--n3 >= 0 && (block = world.func_147439_a(n, n3, n2)).isAir((IBlockAccess)world, n, n3, n2)) {
        }
        return n3;
    }

    public static MovingObjectPosition getCurrentMovingObjectPosition(EntityPlayer entityPlayer, double d) {
        Vec3 vec3 = Vec3.func_72443_a((double)entityPlayer.field_70165_t, (double)entityPlayer.field_70163_u, (double)entityPlayer.field_70161_v);
        Vec3 vec32 = entityPlayer.func_70676_i(1.0f);
        vec3.field_72448_b += (double)entityPlayer.func_70047_e();
        vec32 = vec3.func_72441_c(vec32.field_72450_a * d, vec32.field_72448_b * d, vec32.field_72449_c * d);
        return entityPlayer.field_70170_p.func_72933_a(vec3, vec32);
    }

    public static MovingObjectPosition getCurrentMovingObjectPosition(EntityPlayer entityPlayer) {
        return BlockHelper.getCurrentMovingObjectPosition(entityPlayer, entityPlayer.field_71075_bZ.field_75098_d ? 5.0 : 4.5);
    }

    public static int getCurrentMousedOverSide(EntityPlayer entityPlayer) {
        MovingObjectPosition movingObjectPosition = BlockHelper.getCurrentMovingObjectPosition(entityPlayer);
        return movingObjectPosition == null ? 0 : movingObjectPosition.field_72310_e;
    }

    public static int determineXZPlaceFacing(EntityLivingBase entityLivingBase) {
        int n = MathHelper.func_76128_c((double)((double)(entityLivingBase.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        switch (n) {
            case 0: {
                return 2;
            }
            case 1: {
                return 5;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 4;
            }
        }
        return 3;
    }

    public static boolean isEqual(Block block, Block block2) {
        if (block == block2) {
            return true;
        }
        if (block == null | block2 == null) {
            return false;
        }
        return block.equals(block2) || block.func_149667_c(block2);
    }

    public static TileEntity getAdjacentTileEntity(World world, int n, int n2, int n3, ForgeDirection forgeDirection) {
        return world == null ? null : world.func_147438_o(n + forgeDirection.offsetX, n2 + forgeDirection.offsetY, n3 + forgeDirection.offsetZ);
    }

    public static TileEntity getAdjacentTileEntity(World world, int n, int n2, int n3, int n4) {
        return world == null ? null : BlockHelper.getAdjacentTileEntity(world, n, n2, n3, ForgeDirection.values()[n4]);
    }

    public static TileEntity getAdjacentTileEntity(TileEntity tileEntity, ForgeDirection forgeDirection) {
        return tileEntity == null ? null : BlockHelper.getAdjacentTileEntity(tileEntity.func_145831_w(), tileEntity.field_145851_c, tileEntity.field_145848_d, tileEntity.field_145849_e, forgeDirection);
    }

    public static TileEntity getAdjacentTileEntity(TileEntity tileEntity, int n) {
        return tileEntity == null ? null : BlockHelper.getAdjacentTileEntity(tileEntity.func_145831_w(), tileEntity.field_145851_c, tileEntity.field_145848_d, tileEntity.field_145849_e, ForgeDirection.values()[n]);
    }

    public static int determineAdjacentSide(TileEntity tileEntity, int n, int n2, int n3) {
        return n2 > tileEntity.field_145848_d ? 1 : (n2 < tileEntity.field_145848_d ? 0 : (n3 > tileEntity.field_145849_e ? 3 : (n3 < tileEntity.field_145849_e ? 2 : (n > tileEntity.field_145851_c ? 5 : 4))));
    }

    public static int[] getAdjacentCoordinatesForSide(MovingObjectPosition movingObjectPosition) {
        return BlockHelper.getAdjacentCoordinatesForSide(movingObjectPosition.field_72311_b, movingObjectPosition.field_72312_c, movingObjectPosition.field_72309_d, movingObjectPosition.field_72310_e);
    }

    public static int[] getAdjacentCoordinatesForSide(int n, int n2, int n3, int n4) {
        return new int[]{n + SIDE_COORD_MOD[n4][0], n2 + SIDE_COORD_MOD[n4][1], n3 + SIDE_COORD_MOD[n4][2]};
    }

    public static AxisAlignedBB getAdjacentAABBForSide(MovingObjectPosition movingObjectPosition) {
        return BlockHelper.getAdjacentAABBForSide(movingObjectPosition.field_72311_b, movingObjectPosition.field_72312_c, movingObjectPosition.field_72309_d, movingObjectPosition.field_72310_e);
    }

    public static AxisAlignedBB getAdjacentAABBForSide(int n, int n2, int n3, int n4) {
        return AxisAlignedBB.func_72330_a((double)(n + SIDE_COORD_MOD[n4][0]), (double)(n2 + SIDE_COORD_MOD[n4][1]), (double)(n3 + SIDE_COORD_MOD[n4][2]), (double)((float)n + SIDE_COORD_AABB[n4][0]), (double)((float)n2 + SIDE_COORD_AABB[n4][1]), (double)((float)n3 + SIDE_COORD_AABB[n4][2]));
    }

    public static int getLeftSide(int n) {
        return SIDE_LEFT[n];
    }

    public static int getRightSide(int n) {
        return SIDE_RIGHT[n];
    }

    public static int getOppositeSide(int n) {
        return SIDE_OPPOSITE[n];
    }

    public static int getAboveSide(int n) {
        return SIDE_ABOVE[n];
    }

    public static int getBelowSide(int n) {
        return SIDE_BELOW[n];
    }

    public static boolean canRotate(Block block) {
        return rotateType[Block.func_149682_b((Block)block)] != 0;
    }

    public static int rotateVanillaBlock(World world, Block block, int n, int n2, int n3) {
        int n4 = Block.func_149682_b((Block)block);
        int n5 = world.func_72805_g(n, n2, n3);
        switch (rotateType[n4]) {
            case 1: {
                return SIDE_LEFT[n5];
            }
            case 2: {
                if (n5 < 6) {
                    return ++n5 % 6;
                }
                return n5;
            }
            case 3: {
                if (n5 < 2) {
                    return ++n5 % 2;
                }
                return n5;
            }
            case 4: {
                return ++n5 % 4;
            }
            case 5: {
                return ++n5 % 8;
            }
            case 6: {
                int n6 = n5 & 0xC;
                int n7 = n5 & 3;
                return n6 + ++n7 % 4;
            }
            case 7: {
                return (n5 + 4) % 12;
            }
            case 8: {
                return (n5 + 8) % 16;
            }
            case 9: {
                int[] nArray = new int[3];
                for (int i = 2; i < 6; ++i) {
                    nArray = BlockHelper.getAdjacentCoordinatesForSide(n, n2, n3, i);
                    if (!BlockHelper.isEqual(world.func_147439_a(nArray[0], nArray[1], nArray[2]), block)) continue;
                    world.func_72921_c(nArray[0], nArray[1], nArray[2], (int)SIDE_OPPOSITE[n5], 1);
                    return SIDE_OPPOSITE[n5];
                }
                return SIDE_LEFT[n5];
            }
            case 10: {
                int n8 = 0;
                if (n5 > 7) {
                    n5 -= 8;
                    n8 = 8;
                }
                if (n5 == 5) {
                    return 6 + n8;
                }
                if (n5 == 6) {
                    return 5 + n8;
                }
                if (n5 == 7) {
                    return 0 + n8;
                }
                if (n5 == 0) {
                    return 7 + n8;
                }
                return n5 + n8;
            }
            case 11: {
                return ++n5 % 16;
            }
        }
        return n5;
    }

    public static int rotateVanillaBlockAlt(World world, Block block, int n, int n2, int n3) {
        int n4 = Block.func_149682_b((Block)block);
        int n5 = world.func_72805_g(n, n2, n3);
        switch (rotateType[n4]) {
            case 1: {
                return SIDE_RIGHT[n5];
            }
            case 2: {
                if (n5 < 6) {
                    return (n5 + 5) % 6;
                }
                return n5;
            }
            case 3: {
                if (n5 < 2) {
                    return ++n5 % 2;
                }
                return n5;
            }
            case 4: {
                return (n5 + 3) % 4;
            }
            case 5: {
                return (n5 + 7) % 8;
            }
            case 6: {
                int n6 = n5 & 0xC;
                int n7 = n5 & 3;
                return n6 + (n7 + 3) % 4;
            }
            case 7: {
                return (n5 + 8) % 12;
            }
            case 8: {
                return (n5 + 8) % 16;
            }
            case 9: {
                int[] nArray = new int[3];
                for (int i = 2; i < 6; ++i) {
                    nArray = BlockHelper.getAdjacentCoordinatesForSide(n, n2, n3, i);
                    if (!BlockHelper.isEqual(world.func_147439_a(nArray[0], nArray[1], nArray[2]), block)) continue;
                    world.func_72921_c(nArray[0], nArray[1], nArray[2], (int)SIDE_OPPOSITE[n5], 1);
                    return SIDE_OPPOSITE[n5];
                }
                return SIDE_RIGHT[n5];
            }
            case 10: {
                int n8 = 0;
                if (n5 > 7) {
                    n5 -= 8;
                    n8 = 8;
                }
                if (n5 == 5) {
                    return 6 + n8;
                }
                if (n5 == 6) {
                    return 5 + n8;
                }
                if (n5 == 7) {
                    return 0 + n8;
                }
                if (n5 == 0) {
                    return 7 + n8;
                }
            }
            case 11: {
                return ++n5 % 16;
            }
        }
        return n5;
    }

    public static List<ItemStack> breakBlock(World world, int n, int n2, int n3, Block block, int n4, boolean bl, boolean bl2) {
        if (block.func_149712_f(world, n, n2, n3) == -1.0f) {
            return new LinkedList<ItemStack>();
        }
        int n5 = world.func_72805_g(n, n2, n3);
        AbstractList abstractList = null;
        if (bl2 && block.canSilkHarvest(world, null, n, n2, n3, n5)) {
            abstractList = new LinkedList();
            abstractList.add(BlockHelper.createStackedBlock(block, n5));
        } else {
            abstractList = block.getDrops(world, n, n2, n3, n5, n4);
        }
        if (!bl) {
            return abstractList;
        }
        world.func_72889_a(null, 2001, n, n2, n3, Block.func_149682_b((Block)block) + (n5 << 12));
        world.func_147468_f(n, n2, n3);
        List list = world.func_72872_a(EntityItem.class, AxisAlignedBB.func_72330_a((double)(n - 2), (double)(n2 - 2), (double)(n3 - 2), (double)(n + 3), (double)(n2 + 3), (double)(n3 + 3)));
        for (int i = 0; i < list.size(); ++i) {
            EntityItem entityItem = (EntityItem)list.get(i);
            if (entityItem.field_70128_L || entityItem.func_92059_d().field_77994_a <= 0) continue;
            abstractList.add(entityItem.func_92059_d());
            entityItem.field_70170_p.func_72900_e((Entity)entityItem);
        }
        return abstractList;
    }

    public static ItemStack createStackedBlock(Block block, int n) {
        Item item = Item.func_150898_a((Block)block);
        if (item.func_77614_k()) {
            return new ItemStack(item, 1, n);
        }
        return new ItemStack(item, 1, 0);
    }

    static {
        BlockHelper.ICON_ROTATION_MAP[0] = new byte[]{0, 1, 2, 3, 4, 5};
        BlockHelper.ICON_ROTATION_MAP[1] = new byte[]{1, 0, 2, 3, 4, 5};
        BlockHelper.ICON_ROTATION_MAP[2] = new byte[]{3, 2, 0, 1, 4, 5};
        BlockHelper.ICON_ROTATION_MAP[3] = new byte[]{3, 2, 1, 0, 5, 4};
        BlockHelper.ICON_ROTATION_MAP[4] = new byte[]{3, 2, 5, 4, 0, 1};
        BlockHelper.ICON_ROTATION_MAP[5] = new byte[]{3, 2, 4, 5, 1, 0};
        BlockHelper.rotateType[Block.func_149682_b((Block)Blocks.field_150324_C)] = -1;
        BlockHelper.rotateType[Block.func_149682_b((Block)Blocks.field_150333_U)] = 8;
        BlockHelper.rotateType[Block.func_149682_b((Block)Blocks.field_150376_bx)] = 8;
        BlockHelper.rotateType[Block.func_149682_b((Block)Blocks.field_150448_aq)] = 3;
        BlockHelper.rotateType[Block.func_149682_b((Block)Blocks.field_150318_D)] = 3;
        BlockHelper.rotateType[Block.func_149682_b((Block)Blocks.field_150319_E)] = 3;
        BlockHelper.rotateType[Block.func_149682_b((Block)Blocks.field_150408_cc)] = 3;
        BlockHelper.rotateType[Block.func_149682_b((Block)Blocks.field_150423_aK)] = 4;
        BlockHelper.rotateType[Block.func_149682_b((Block)Blocks.field_150428_aP)] = 4;
        BlockHelper.rotateType[Block.func_149682_b((Block)Blocks.field_150460_al)] = 1;
        BlockHelper.rotateType[Block.func_149682_b((Block)Blocks.field_150470_am)] = 1;
        BlockHelper.rotateType[Block.func_149682_b((Block)Blocks.field_150477_bB)] = 1;
        BlockHelper.rotateType[Block.func_149682_b((Block)Blocks.field_150447_bR)] = 9;
        BlockHelper.rotateType[Block.func_149682_b((Block)Blocks.field_150486_ae)] = 9;
        BlockHelper.rotateType[Block.func_149682_b((Block)Blocks.field_150367_z)] = 2;
        BlockHelper.rotateType[Block.func_149682_b((Block)Blocks.field_150320_F)] = 2;
        BlockHelper.rotateType[Block.func_149682_b((Block)Blocks.field_150331_J)] = 2;
        BlockHelper.rotateType[Block.func_149682_b((Block)Blocks.field_150438_bZ)] = 2;
        BlockHelper.rotateType[Block.func_149682_b((Block)Blocks.field_150409_cd)] = 2;
        BlockHelper.rotateType[Block.func_149682_b((Block)Blocks.field_150413_aR)] = 6;
        BlockHelper.rotateType[Block.func_149682_b((Block)Blocks.field_150441_bU)] = 6;
        BlockHelper.rotateType[Block.func_149682_b((Block)Blocks.field_150416_aS)] = 6;
        BlockHelper.rotateType[Block.func_149682_b((Block)Blocks.field_150455_bV)] = 6;
        BlockHelper.rotateType[Block.func_149682_b((Block)Blocks.field_150442_at)] = 10;
        BlockHelper.rotateType[Block.func_149682_b((Block)Blocks.field_150472_an)] = 11;
        BlockHelper.rotateType[Block.func_149682_b((Block)Blocks.field_150476_ad)] = 5;
        BlockHelper.rotateType[Block.func_149682_b((Block)Blocks.field_150446_ar)] = 5;
        BlockHelper.rotateType[Block.func_149682_b((Block)Blocks.field_150389_bf)] = 5;
        BlockHelper.rotateType[Block.func_149682_b((Block)Blocks.field_150390_bg)] = 5;
        BlockHelper.rotateType[Block.func_149682_b((Block)Blocks.field_150387_bl)] = 5;
        BlockHelper.rotateType[Block.func_149682_b((Block)Blocks.field_150372_bz)] = 5;
        BlockHelper.rotateType[Block.func_149682_b((Block)Blocks.field_150485_bF)] = 5;
        BlockHelper.rotateType[Block.func_149682_b((Block)Blocks.field_150487_bG)] = 5;
        BlockHelper.rotateType[Block.func_149682_b((Block)Blocks.field_150481_bH)] = 5;
        BlockHelper.rotateType[Block.func_149682_b((Block)Blocks.field_150370_cb)] = 5;
    }

    public static final class RotationType {
        public static final int PREVENT = -1;
        public static final int FOUR_WAY = 1;
        public static final int SIX_WAY = 2;
        public static final int RAIL = 3;
        public static final int PUMPKIN = 4;
        public static final int STAIRS = 5;
        public static final int REDSTONE = 6;
        public static final int LOG = 7;
        public static final int SLAB = 8;
        public static final int CHEST = 9;
        public static final int LEVER = 10;
        public static final int SIGN = 11;
    }
}

