/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.world.feature;

import cofh.api.world.IFeatureGenerator;
import cofh.api.world.IFeatureParser;
import cofh.core.world.FeatureParser;
import cofh.lib.util.WeightedRandomBlock;
import cofh.lib.util.helpers.MathHelper;
import cofh.lib.world.feature.FeatureBase;
import cofh.lib.world.feature.FeatureGenUniform;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.world.gen.feature.WorldGenerator;
import org.apache.logging.log4j.Logger;

public class UniformParser
implements IFeatureParser {
    private final List<WeightedRandomBlock> defaultMaterial = this.generateDefaultMaterial();

    protected List<WeightedRandomBlock> generateDefaultMaterial() {
        return Arrays.asList(new WeightedRandomBlock(new ItemStack(Blocks.field_150348_b, 1, -1)));
    }

    @Override
    public IFeatureGenerator parseFeature(String string, JsonObject jsonObject, Logger logger) {
        ArrayList<WeightedRandomBlock> arrayList = new ArrayList<WeightedRandomBlock>();
        if (!FeatureParser.parseResList(jsonObject.get("block"), arrayList)) {
            return null;
        }
        int n = 0;
        if (jsonObject.has("clusterSize")) {
            n = jsonObject.get("clusterSize").getAsInt();
        }
        int n2 = 0;
        if (jsonObject.has("numClusters")) {
            n2 = jsonObject.get("numClusters").getAsInt();
        }
        if (n < 0 || n2 <= 0) {
            logger.error("Invalid cluster size or count specified in \"" + string + "\"");
            return null;
        }
        boolean bl = false;
        if (jsonObject.has("retrogen")) {
            bl = jsonObject.get("retrogen").getAsBoolean();
        }
        FeatureBase.GenRestriction genRestriction = FeatureBase.GenRestriction.NONE;
        if (jsonObject.has("biomeRestriction")) {
            genRestriction = FeatureBase.GenRestriction.get(jsonObject.get("biomeRestriction").getAsString());
        }
        FeatureBase.GenRestriction genRestriction2 = FeatureBase.GenRestriction.NONE;
        if (jsonObject.has("dimensionRestriction")) {
            genRestriction2 = FeatureBase.GenRestriction.get(jsonObject.get("dimensionRestriction").getAsString());
        }
        List<WeightedRandomBlock> list = this.parseMaterial(jsonObject, logger);
        WorldGenerator worldGenerator = FeatureParser.parseGenerator(this.getDefaultTemplate(), jsonObject, arrayList, n, list);
        FeatureBase featureBase = this.getFeature(string, jsonObject, worldGenerator, list, n2, genRestriction, bl, genRestriction2, logger);
        if (jsonObject.has("chunkChance")) {
            int n3 = MathHelper.clampI(jsonObject.get("chunkChance").getAsInt(), 1, 1000000);
            featureBase.setRarity(n3);
        }
        if (featureBase != null) {
            UniformParser.addFeatureRestrictions(featureBase, jsonObject);
        }
        return featureBase;
    }

    protected FeatureBase getFeature(String string, JsonObject jsonObject, WorldGenerator worldGenerator, List<WeightedRandomBlock> list, int n, FeatureBase.GenRestriction genRestriction, boolean bl, FeatureBase.GenRestriction genRestriction2, Logger logger) {
        int n2;
        int n3 = jsonObject.get("minHeight").getAsInt();
        if (n3 >= (n2 = jsonObject.get("maxHeight").getAsInt()) || n3 < 0) {
            logger.error("Invalid height parameters specified in \"" + string + "\"");
            return null;
        }
        return new FeatureGenUniform(string, worldGenerator, n, n3, n2, genRestriction, bl, genRestriction2);
    }

    protected String getDefaultTemplate() {
        return "cluster";
    }

    protected List<WeightedRandomBlock> parseMaterial(JsonObject jsonObject, Logger logger) {
        List<WeightedRandomBlock> list = this.defaultMaterial;
        if (jsonObject.has("material")) {
            list = new ArrayList<WeightedRandomBlock>();
            if (!FeatureParser.parseResList(jsonObject.get("material"), list)) {
                logger.warn("Invalid material list! Using default list.");
                list = this.defaultMaterial;
            }
        }
        return list;
    }

    protected static boolean addFeatureRestrictions(FeatureBase featureBase, JsonObject jsonObject) {
        if (featureBase.biomeRestriction != FeatureBase.GenRestriction.NONE) {
            featureBase.addBiomes(FeatureParser.parseBiomeRestrictions(jsonObject));
        }
        if (featureBase.dimensionRestriction != FeatureBase.GenRestriction.NONE && jsonObject.has("dimensions")) {
            JsonArray jsonArray = jsonObject.getAsJsonArray("dimensions");
            for (int i = 0; i < jsonArray.size(); ++i) {
                featureBase.addDimension(jsonArray.get(i).getAsInt());
            }
        }
        return true;
    }
}

