/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.world.decoration;

import cofh.api.world.IGeneratorParser;
import cofh.core.world.FeatureParser;
import cofh.lib.util.WeightedRandomBlock;
import cofh.lib.world.WorldGenSmallTree;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.gen.feature.WorldGenerator;
import org.apache.logging.log4j.Logger;

public class SmallTreeParser
implements IGeneratorParser {
    @Override
    public WorldGenerator parseGenerator(String string, JsonObject jsonObject, Logger logger, List<WeightedRandomBlock> list, int n, List<WeightedRandomBlock> list2) {
        Object object;
        ArrayList<WeightedRandomBlock> arrayList = new ArrayList<WeightedRandomBlock>();
        if (jsonObject.has("leaves")) {
            arrayList = new ArrayList();
            object = jsonObject.get("leaves");
            if (!object.isJsonNull() && !FeatureParser.parseResList(object, arrayList)) {
                logger.warn("Entry specifies invalid leaves for 'smalltree' generator!");
                arrayList.clear();
            }
        } else {
            logger.info("Entry does not specify leaves for 'smalltree' generator! There are none!");
        }
        object = new WorldGenSmallTree(list, arrayList, list2);
        if (jsonObject.has("minHeight")) {
            object.minHeight = jsonObject.get("minHeight").getAsInt();
        }
        if (jsonObject.has("heightVariance")) {
            object.heightVariance = jsonObject.get("heightVariance").getAsInt();
        }
        if (jsonObject.has("treeChecks")) {
            object.treeChecks = jsonObject.get("treeChecks").getAsBoolean();
        }
        if (jsonObject.has("relaxedGrowth")) {
            object.relaxedGrowth = jsonObject.get("relaxedGrowth").getAsBoolean();
        }
        if (jsonObject.has("waterLoving")) {
            object.waterLoving = jsonObject.get("waterLoving").getAsBoolean();
        }
        if (jsonObject.has("genSurface")) {
            arrayList = new ArrayList();
            JsonElement jsonElement = jsonObject.get("genSurface");
            if (!jsonElement.isJsonNull() && !FeatureParser.parseResList(jsonElement, arrayList)) {
                logger.warn("Entry specifies invalid genSurface for 'smalltree' generator! Using grass!");
                arrayList.clear();
                arrayList.add(new WeightedRandomBlock((Block)Blocks.field_150349_c));
                arrayList.add(new WeightedRandomBlock(Blocks.field_150346_d, -1));
            }
            if (arrayList.size() > 0) {
                object.genSurface = arrayList.toArray(new WeightedRandomBlock[arrayList.size()]);
            }
        } else {
            logger.info("Entry does not specify genSurface for 'smalltree' generator! There are no restrictions!");
        }
        return object;
    }
}

