/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.world;

import cofh.CoFHCore;
import cofh.api.world.IFeatureGenerator;
import cofh.api.world.IFeatureParser;
import cofh.api.world.IGeneratorParser;
import cofh.core.CoFHProps;
import cofh.core.util.CoreUtils;
import cofh.core.world.WorldHandler;
import cofh.core.world.decoration.BoulderParser;
import cofh.core.world.decoration.ClusterParser;
import cofh.core.world.decoration.DungeonParser;
import cofh.core.world.decoration.GeodeParser;
import cofh.core.world.decoration.LakeParser;
import cofh.core.world.decoration.LargeVeinParser;
import cofh.core.world.decoration.SpikeParser;
import cofh.core.world.decoration.StalagmiteParser;
import cofh.core.world.feature.CaveParser;
import cofh.core.world.feature.DecorationParser;
import cofh.core.world.feature.FractalParser;
import cofh.core.world.feature.NormalParser;
import cofh.core.world.feature.SurfaceParser;
import cofh.core.world.feature.UnderfluidParser;
import cofh.core.world.feature.UniformParser;
import cofh.lib.util.WeightedRandomBlock;
import cofh.lib.util.WeightedRandomNBTTag;
import cofh.lib.util.helpers.MathHelper;
import cofh.lib.world.biome.BiomeInfo;
import cofh.lib.world.biome.BiomeInfoRarity;
import cofh.lib.world.biome.BiomeInfoSet;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.stream.JsonWriter;
import cpw.mods.fml.common.registry.GameRegistry;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.DungeonHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FeatureParser {
    private static File worldGenFolder;
    private static File vanillaGen;
    private static final String vanillaGenInternal = "assets/cofh/world/Vanilla.json";
    private static HashMap<String, IFeatureParser> templateHandlers;
    private static HashMap<String, IGeneratorParser> generatorHandlers;
    private static Logger log;
    public static ArrayList<IFeatureGenerator> parsedFeatures;

    private FeatureParser() {
    }

    public static boolean registerTemplate(String string, IFeatureParser iFeatureParser) {
        if (!templateHandlers.containsKey(string)) {
            templateHandlers.put(string, iFeatureParser);
            return true;
        }
        log.error("Attempted to register duplicate template '" + string + "'!");
        return false;
    }

    public static boolean registerGenerator(String string, IGeneratorParser iGeneratorParser) {
        if (!generatorHandlers.containsKey(string)) {
            generatorHandlers.put(string, iGeneratorParser);
            return true;
        }
        log.error("Attempted to register duplicate generator '" + string + "'!");
        return false;
    }

    public static void initialize() {
        worldGenFolder = new File(CoFHProps.configDir, "/cofh/world/");
        if (!worldGenFolder.exists()) {
            try {
                worldGenFolder.mkdir();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        vanillaGen = new File(CoFHProps.configDir, "/cofh/world/Vanilla.json");
        try {
            if (vanillaGen.createNewFile()) {
                CoreUtils.copyFileUsingStream(vanillaGenInternal, vanillaGen);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        log.info("Registering default templates");
        FeatureParser.registerTemplate("normal", new NormalParser());
        FeatureParser.registerTemplate("uniform", new UniformParser());
        FeatureParser.registerTemplate("surface", new SurfaceParser());
        FeatureParser.registerTemplate("fractal", new FractalParser());
        FeatureParser.registerTemplate("decoration", new DecorationParser());
        FeatureParser.registerTemplate("underfluid", new UnderfluidParser());
        FeatureParser.registerTemplate("underwater", new UnderfluidParser());
        FeatureParser.registerTemplate("cave", new CaveParser());
        log.info("Registering default generators");
        FeatureParser.registerGenerator(null, new ClusterParser(false));
        FeatureParser.registerGenerator("", new ClusterParser(false));
        FeatureParser.registerGenerator("cluster", new ClusterParser(false));
        FeatureParser.registerGenerator("sparse-cluster", new ClusterParser(true));
        FeatureParser.registerGenerator("large-vein", new LargeVeinParser());
        FeatureParser.registerGenerator("decoration", new DecorationParser());
        FeatureParser.registerGenerator("lake", new LakeParser());
        FeatureParser.registerGenerator("geode", new GeodeParser());
        FeatureParser.registerGenerator("spike", new SpikeParser());
        FeatureParser.registerGenerator("boulder", new BoulderParser());
        FeatureParser.registerGenerator("dungeon", new DungeonParser());
        FeatureParser.registerGenerator("stalagmite", new StalagmiteParser(false));
        FeatureParser.registerGenerator("statactite", new StalagmiteParser(true));
        log.info("Complete");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void complete() {
        if (!CoFHCore.configCore.isOldConfig()) {
            return;
        }
        log.fatal("Warning: CoFHWorld will now scan and update your worldgen files. This will only occur once.");
        JsonParser jsonParser = new JsonParser();
        Gson gson = new Gson();
        ArrayList<File> arrayList = new ArrayList<File>(5);
        FeatureParser.addFiles(arrayList, worldGenFolder);
        for (int i = 0; i < arrayList.size(); ++i) {
            JsonObject jsonObject;
            File file = arrayList.get(i);
            if (file.isDirectory()) {
                FeatureParser.addFiles(arrayList, file);
                continue;
            }
            try {
                jsonObject = (JsonObject)jsonParser.parse((Reader)new FileReader(file));
            }
            catch (Throwable throwable) {
                log.error("Critical error reading from a world generation file: " + file + " > Please be sure the file is correct!", throwable);
                continue;
            }
            boolean bl = false;
            log.warn("Checking if " + file.getName() + " is from an old version.");
            JsonWriter jsonWriter = jsonObject.entrySet().iterator();
            while (jsonWriter.hasNext()) {
                JsonArray jsonArray;
                Map.Entry entry = (Map.Entry)jsonWriter.next();
                JsonObject jsonObject2 = ((JsonElement)entry.getValue()).getAsJsonObject();
                String string = FeatureParser.parseTemplate(jsonObject2);
                if (!"uniform".equals(string) && !"normal".equals(string) || !jsonObject2.has("metadata")) continue;
                bl = true;
                JsonElement jsonElement = jsonObject2.get("block");
                if (jsonElement.isJsonArray()) {
                    jsonArray = jsonElement.getAsJsonArray();
                    JsonArray jsonArray2 = jsonObject2.getAsJsonArray("metadata");
                    JsonArray jsonArray3 = jsonObject2.getAsJsonArray("weight");
                    int n = jsonArray.size();
                    if (n != jsonArray2.size() || n != jsonArray3.size()) {
                        log.error("The entry '" + (String)entry.getKey() + "' is invalid and will be removed.");
                        jsonWriter.remove();
                        continue;
                    }
                    JsonArray jsonArray4 = new JsonArray();
                    for (int j = 0; j < n; ++j) {
                        JsonObject jsonObject3 = new JsonObject();
                        jsonObject3.add("name", (JsonElement)new JsonPrimitive(jsonArray.get(j).getAsString()));
                        jsonObject3.add("metadata", (JsonElement)new JsonPrimitive((Number)jsonArray2.get(j).getAsInt()));
                        jsonObject3.add("weight", (JsonElement)new JsonPrimitive((Number)jsonArray3.get(j).getAsInt()));
                        jsonArray4.add((JsonElement)jsonObject3);
                    }
                    jsonObject2.remove("metadata");
                    jsonObject2.remove("weight");
                    jsonObject2.add("block", (JsonElement)jsonArray4);
                    continue;
                }
                jsonArray = new JsonObject();
                jsonArray.add("name", (JsonElement)new JsonPrimitive(jsonElement.getAsString()));
                jsonArray.add("metadata", (JsonElement)new JsonPrimitive((Number)jsonObject2.get("metadata").getAsInt()));
                jsonObject2.remove("metadata");
                if (jsonObject2.has("weight")) {
                    jsonObject2.remove("weight");
                }
                jsonObject2.add("block", (JsonElement)jsonArray);
            }
            if (!bl) continue;
            log.warn("File " + file + " is from an old version and will be converted to the new format.");
            jsonWriter = null;
            try {
                jsonWriter = new JsonWriter((Writer)new FileWriter(file));
                jsonWriter.setIndent("    ");
                gson.toJson((JsonElement)jsonObject, jsonWriter);
                continue;
            }
            catch (IOException iOException) {
                log.error("There was an error updating " + file.getName() + "!", (Throwable)iOException);
                continue;
            }
            finally {
                if (jsonWriter != null) {
                    try {
                        jsonWriter.close();
                    }
                    catch (IOException iOException) {
                        log.error("There was an error updating " + file.getName() + "!", (Throwable)iOException);
                    }
                }
            }
        }
    }

    private static void addFiles(ArrayList<File> arrayList, File file) {
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            log.error("There are no World Generation files present in " + file + ".");
            return;
        }
        arrayList.addAll(Arrays.asList(fileArray));
    }

    public static void parseGenerationFile() {
        File file;
        int n;
        JsonParser jsonParser = new JsonParser();
        ArrayList<File> arrayList = new ArrayList<File>(5);
        FeatureParser.addFiles(arrayList, worldGenFolder);
        int n2 = arrayList.size();
        for (n = 0; n < n2; ++n) {
            file = arrayList.get(n);
            if (!file.equals(vanillaGen)) continue;
            if (WorldHandler.genReplaceVanilla) break;
            arrayList.remove(n);
            break;
        }
        for (n = 0; n < arrayList.size(); ++n) {
            File file2 = arrayList.get(n);
            if (file2.isDirectory()) {
                FeatureParser.addFiles(arrayList, file2);
                continue;
            }
            try {
                file = (JsonObject)jsonParser.parse((Reader)new FileReader(file2));
            }
            catch (Throwable throwable) {
                log.error("Critical error reading from a world generation file: " + file2 + " > Please be sure the file is correct!", throwable);
                continue;
            }
            log.info("Reading world generation info from: " + file2 + ":");
            for (Map.Entry entry : file.entrySet()) {
                try {
                    if (FeatureParser.parseGenerationEntry((String)entry.getKey(), (JsonElement)entry.getValue())) {
                        log.debug("Generation entry successfully parsed: \"" + (String)entry.getKey() + "\"");
                        continue;
                    }
                    log.error("Error parsing generation entry: \"" + (String)entry.getKey() + "\" > Please check the parameters. It *may* be a duplicate.");
                }
                catch (Throwable throwable) {
                    log.fatal("There was a severe error parsing '" + (String)entry.getKey() + "'!", throwable);
                }
            }
        }
    }

    private static boolean parseGenerationEntry(String string, JsonElement jsonElement) {
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        if (jsonObject.has("enabled") && !jsonObject.get("enabled").getAsBoolean()) {
            log.info('\"' + string + "\" is disabled.");
            return true;
        }
        String string2 = FeatureParser.parseTemplate(jsonObject);
        IFeatureParser iFeatureParser = templateHandlers.get(string2);
        if (iFeatureParser != null) {
            IFeatureGenerator iFeatureGenerator = iFeatureParser.parseFeature(string, jsonObject, log);
            if (iFeatureGenerator != null) {
                parsedFeatures.add(iFeatureGenerator);
                return WorldHandler.addFeature(iFeatureGenerator);
            }
            log.warn("Template '" + string2 + "' failed to parse its entry!");
        } else {
            log.warn("Unknown template + '" + string2 + "'.");
        }
        return false;
    }

    private static String parseTemplate(JsonObject jsonObject) {
        JsonElement jsonElement = jsonObject.get("template");
        if (jsonElement.isJsonObject()) {
            jsonObject = jsonElement.getAsJsonObject();
            return jsonObject.get("type").getAsString();
        }
        return jsonElement.getAsString();
    }

    public static WorldGenerator parseGenerator(String string, JsonObject jsonObject, List<WeightedRandomBlock> list, int n, List<WeightedRandomBlock> list2) {
        IGeneratorParser iGeneratorParser;
        JsonElement jsonElement = jsonObject.get("template");
        String string2 = string;
        if (jsonElement.isJsonObject() && !generatorHandlers.containsKey(string2 = (jsonObject = jsonElement.getAsJsonObject()).get("generator").getAsString())) {
            log.warn("Unknown generator '%s'! using '%s'", new Object[]{string2, string});
            string2 = string;
        }
        if ((iGeneratorParser = generatorHandlers.get(string2)) == null) {
            throw new IllegalStateException("Generator " + string2 + " is not registered!");
        }
        return iGeneratorParser.parseGenerator(string2, jsonObject, log, list, n, list2);
    }

    /*
     * Unable to fully structure code
     */
    public static BiomeInfoSet parseBiomeRestrictions(JsonObject var0) {
        block13: {
            var1_1 = null;
            if (!var0.has("biomes")) break block13;
            var2_2 = var0.getAsJsonArray("biomes");
            var1_1 = new BiomeInfoSet(var2_2.size());
            var4_4 = var2_2.size();
            for (var3_3 = 0; var3_3 < var4_4; ++var3_3) {
                block15: {
                    block16: {
                        block18: {
                            block17: {
                                block14: {
                                    var5_5 = null;
                                    var6_6 = var2_2.get(var3_3);
                                    if (!var6_6.isJsonNull()) break block14;
                                    FeatureParser.log.info("Null biome entry. Ignoring.");
                                    break block15;
                                }
                                if (!var6_6.isJsonObject()) break block16;
                                var7_7 = var6_6.getAsJsonObject();
                                var8_8 = var7_7.get("type").getAsString();
                                var9_9 = var7_7.has("whitelist") != false ? var7_7.get("whitelist").getAsBoolean() : true;
                                var10_10 = var7_7.get("entry");
                                var11_11 = var10_10.isJsonArray() != false ? var10_10.getAsJsonArray() : null;
                                var12_12 = var11_11 != null ? null : var10_10.getAsString();
                                v0 = var13_13 = var7_7.has("rarity") != false ? var7_7.get("rarity").getAsInt() : -1;
                                if (!var8_8.equalsIgnoreCase("name")) break block17;
                                if (var11_11 != null) {
                                    var14_14 = new ArrayList();
                                    var16_16 = var11_11.size();
                                    for (var15_15 = 0; var15_15 < var16_16; ++var15_15) {
                                        var14_14.add(var11_11.get(var15_15).getAsString());
                                    }
                                    var5_5 = var13_13 > 0 ? new BiomeInfoRarity(var14_14, 4, true, var13_13) : new BiomeInfo(var14_14, 4, true);
                                } else {
                                    var5_5 = var13_13 > 0 ? new BiomeInfoRarity(var12_12, var13_13) : new BiomeInfo(var12_12);
                                }
                                break block15;
                            }
                            var14_14 = null;
                            var15_15 = -1;
                            if (!var8_8.equalsIgnoreCase("temperature")) break block18;
                            if (var11_11 != null) {
                                var16_17 = new ArrayList<BiomeGenBase.TempCategory>();
                                var18_20 = var11_11.size();
                                for (var17_19 = 0; var17_19 < var18_20; ++var17_19) {
                                    var16_17.add(BiomeGenBase.TempCategory.valueOf((String)var11_11.get(var17_19).getAsString()));
                                }
                                var14_14 = EnumSet.copyOf(var16_17);
                                var15_15 = 5;
                            } else {
                                var14_14 = BiomeGenBase.TempCategory.valueOf((String)var12_12);
                                var15_15 = 1;
                            }
                            ** GOTO lbl68
                        }
                        if (!var8_8.equalsIgnoreCase("dictionary")) {
                            FeatureParser.log.warn("Biome entry of unknown type");
                        } else {
                            if (var11_11 != null) {
                                var16_18 = new ArrayList<BiomeDictionary.Type>();
                                var18_20 = var11_11.size();
                                for (var17_19 = 0; var17_19 < var18_20; ++var17_19) {
                                    var19_21 = BiomeDictionary.Type.valueOf((String)var11_11.get(var17_19).getAsString());
                                    if (var19_21 == null) continue;
                                    var16_18.add(var19_21);
                                }
                                var14_14 = var16_18.toArray(new BiomeDictionary.Type[var16_18.size()]);
                                var15_15 = 6;
                            } else {
                                var14_14 = BiomeDictionary.Type.valueOf((String)var12_12);
                                var15_15 = 2;
                            }
lbl68:
                            // 4 sources

                            if (var14_14 != null) {
                                var5_5 = var13_13 > 0 ? new BiomeInfoRarity(var14_14, var15_15, var9_9, var13_13) : new BiomeInfo(var14_14, var15_15, var9_9);
                            }
                        }
                        break block15;
                    }
                    var5_5 = new BiomeInfo(var6_6.getAsString());
                }
                if (var5_5 == null) continue;
                var1_1.add(var5_5);
            }
        }
        return var1_1;
    }

    public static Block parseBlockName(String string) {
        String[] stringArray = string.split(":", 2);
        int n = 0;
        return GameRegistry.findBlock((String)(stringArray.length > 1 ? stringArray[n++] : "minecraft"), (String)stringArray[n]);
    }

    public static WeightedRandomBlock parseBlockEntry(JsonElement jsonElement) {
        if (jsonElement.isJsonNull()) {
            log.warn("Null Block entry!");
            return null;
        }
        if (jsonElement.isJsonObject()) {
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            if (!jsonObject.has("name")) {
                log.error("Block entry needs a name!");
                return null;
            }
            Block block = FeatureParser.parseBlockName(jsonObject.get("name").getAsString());
            if (block == null) {
                log.error("Invalid block entry!");
                return null;
            }
            int n = jsonObject.has("metadata") ? MathHelper.clampI(jsonObject.get("metadata").getAsInt(), 0, 15) : 0;
            int n2 = jsonObject.has("weight") ? MathHelper.clampI(jsonObject.get("weight").getAsInt(), 1, 1000000) : 100;
            return new WeightedRandomBlock(block, n, n2);
        }
        Block block = FeatureParser.parseBlockName(jsonElement.getAsString());
        if (block == null) {
            log.error("Invalid block entry!");
            return null;
        }
        return new WeightedRandomBlock(block, 0);
    }

    public static boolean parseResList(JsonElement jsonElement, List<WeightedRandomBlock> list) {
        if (jsonElement.isJsonArray()) {
            JsonArray jsonArray = jsonElement.getAsJsonArray();
            int n = jsonArray.size();
            for (int i = 0; i < n; ++i) {
                WeightedRandomBlock weightedRandomBlock = FeatureParser.parseBlockEntry(jsonArray.get(i));
                if (weightedRandomBlock == null) {
                    return false;
                }
                list.add(weightedRandomBlock);
            }
        } else {
            WeightedRandomBlock weightedRandomBlock = FeatureParser.parseBlockEntry(jsonElement);
            if (weightedRandomBlock == null) {
                return false;
            }
            list.add(weightedRandomBlock);
        }
        return true;
    }

    public static WeightedRandomNBTTag parseEntityEntry(JsonElement jsonElement) {
        if (jsonElement.isJsonNull()) {
            log.warn("Null entity entry!");
            return null;
        }
        if (jsonElement.isJsonObject()) {
            NBTTagCompound nBTTagCompound;
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            if (jsonObject.has("spawnerTag")) {
                try {
                    nBTTagCompound = (NBTTagCompound)JsonToNBT.func_150315_a((String)jsonObject.get("spawnerTag").toString());
                }
                catch (NBTException nBTException) {
                    log.error("Invalid entity entry!", (Throwable)nBTException);
                    return null;
                }
            } else {
                nBTTagCompound = new NBTTagCompound();
                String string = jsonObject.get("entity").getAsString();
                if (string == null) {
                    log.error("Invalid entity entry!");
                    return null;
                }
                nBTTagCompound.func_74778_a("EntityId", string);
            }
            return new WeightedRandomNBTTag(jsonObject.get("weight").getAsInt(), (NBTBase)nBTTagCompound);
        }
        String string = jsonElement.getAsString();
        if (string == null) {
            log.error("Invalid entity entry!");
            return null;
        }
        NBTTagCompound nBTTagCompound = new NBTTagCompound();
        nBTTagCompound.func_74778_a("EntityId", string);
        return new WeightedRandomNBTTag(100, (NBTBase)nBTTagCompound);
    }

    public static boolean parseEntityList(JsonElement jsonElement, List<WeightedRandomNBTTag> list) {
        if (jsonElement.isJsonArray()) {
            JsonArray jsonArray = jsonElement.getAsJsonArray();
            int n = jsonArray.size();
            for (int i = 0; i < n; ++i) {
                WeightedRandomNBTTag weightedRandomNBTTag = FeatureParser.parseEntityEntry(jsonArray.get(i));
                if (weightedRandomNBTTag == null) {
                    return false;
                }
                list.add(weightedRandomNBTTag);
            }
        } else {
            WeightedRandomNBTTag weightedRandomNBTTag = FeatureParser.parseEntityEntry(jsonElement);
            if (weightedRandomNBTTag == null) {
                return false;
            }
            list.add(weightedRandomNBTTag);
        }
        return true;
    }

    public static DungeonHooks.DungeonMob parseWeightedStringEntry(JsonElement jsonElement) {
        int n = 100;
        String string = null;
        if (jsonElement.isJsonNull()) {
            log.warn("Null string entry!");
            return null;
        }
        if (jsonElement.isJsonObject()) {
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            string = jsonObject.get("name").getAsString();
            if (string == null) {
                log.warn("Invalid string entry!");
                return null;
            }
            if (jsonObject.has("weight")) {
                n = jsonObject.get("weight").getAsInt();
            }
        } else {
            string = jsonElement.getAsString();
            if (string == null) {
                log.warn("Invalid string entry!");
                return null;
            }
        }
        return new DungeonHooks.DungeonMob(n, string);
    }

    public static boolean parseWeightedStringList(JsonElement jsonElement, List<DungeonHooks.DungeonMob> list) {
        if (jsonElement.isJsonArray()) {
            JsonArray jsonArray = jsonElement.getAsJsonArray();
            int n = jsonArray.size();
            for (int i = 0; i < n; ++i) {
                DungeonHooks.DungeonMob dungeonMob = FeatureParser.parseWeightedStringEntry(jsonArray.get(i));
                if (dungeonMob == null) {
                    return false;
                }
                list.add(dungeonMob);
            }
        } else {
            DungeonHooks.DungeonMob dungeonMob = FeatureParser.parseWeightedStringEntry(jsonElement);
            if (dungeonMob == null) {
                return false;
            }
            list.add(dungeonMob);
        }
        return true;
    }

    static {
        templateHandlers = new HashMap();
        generatorHandlers = new HashMap();
        log = LogManager.getLogger((String)"CoFHWorld");
        parsedFeatures = new ArrayList();
    }
}

