/*
 * Decompiled with CFR 0.152.
 */
package cofh.asm;

import cofh.asm.LoadingPlugin;
import cofh.asm.relauncher.Implementable;
import cofh.asm.relauncher.Strippable;
import cofh.mod.updater.ModRange;
import cofh.mod.updater.ModVersion;
import com.google.common.base.Throwables;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModAPIManager;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.asm.transformers.deobf.FMLDeobfuscatingRemapper;
import cpw.mods.fml.common.asm.transformers.deobf.FMLRemappingAdapter;
import cpw.mods.fml.common.discovery.ASMDataTable;
import cpw.mods.fml.common.versioning.ArtifactVersion;
import cpw.mods.fml.common.versioning.InvalidVersionSpecificationException;
import cpw.mods.fml.common.versioning.VersionRange;
import gnu.trove.map.hash.TObjectByteHashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.InnerClassNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

class ASMCore {
    static Logger log = LogManager.getLogger((String)"CoFH ASM");
    static TObjectByteHashMap<String> hashes = new TObjectByteHashMap(20, 1.0f, 0);
    static THashSet<String> parsables;
    static THashSet<String> implementables;
    static THashSet<String> strippables;
    static final String implementableDesc;
    static final String strippableDesc;
    static String side;
    static final ArrayList<String> workingPath;
    private static final String[] emptyList;
    private static Map<String, ModContainer> mods;
    private static Map<String, ModContainer> apis;

    ASMCore() {
    }

    static void init() {
    }

    static byte[] parse(String string, String string2, byte[] byArray) {
        ClassWriter classWriter;
        ClassNode classNode;
        ClassReader classReader;
        workingPath.add(string2);
        if (implementables.contains((Object)string)) {
            log.info("Adding runtime interfaces to " + string2);
            classReader = new ClassReader(byArray);
            classNode = new ClassNode();
            classReader.accept((ClassVisitor)classNode, 0);
            if (ASMCore.implement(classNode)) {
                classWriter = new ClassWriter(1);
                classNode.accept((ClassVisitor)classWriter);
                byArray = classWriter.toByteArray();
            } else {
                log.debug("Nothing implemented on " + string2);
            }
        }
        if (strippables.contains((Object)string)) {
            log.info("Stripping methods and fields from " + string2);
            classReader = new ClassReader(byArray);
            classNode = new ClassNode();
            classReader.accept((ClassVisitor)classNode, 0);
            if (ASMCore.strip(classNode)) {
                classWriter = new ClassWriter(2);
                classNode.accept((ClassVisitor)classWriter);
                byArray = classWriter.toByteArray();
            } else {
                log.debug("Nothing stripped from " + string2);
            }
        }
        workingPath.remove(workingPath.size() - 1);
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static synchronized void HACK(String string, byte[] byArray) {
        ArrayList<String> arrayList = workingPath;
        synchronized (arrayList) {
            workingPath.add(string);
            ClassReader classReader = new ClassReader(byArray);
            ClassNode classNode = new ClassNode();
            classReader.accept((ClassVisitor)classNode, 0);
            if (classNode.innerClasses != null) {
                for (InnerClassNode innerClassNode : classNode.innerClasses) {
                    log.debug("\tInner class: " + innerClassNode.name);
                    if (workingPath.contains(innerClassNode.name)) continue;
                    try {
                        Class.forName(innerClassNode.name, false, ASMCore.class.getClassLoader());
                    }
                    catch (Throwable throwable) {}
                }
            }
            workingPath.remove(workingPath.size() - 1);
        }
    }

    static byte[] transform(int n, String string, String string2, byte[] byArray) {
        ClassReader classReader = new ClassReader(byArray);
        switch (n) {
            case 1: {
                return ASMCore.writeWorldServer(string, string2, byArray, classReader);
            }
            case 2: {
                return ASMCore.writeWorld(string, string2, byArray, classReader);
            }
            case 3: {
                return ASMCore.writeWorldProxy(string, byArray, classReader);
            }
            case 4: {
                return ASMCore.writeWorldServerProxy(string, byArray, classReader);
            }
            case 5: {
                return ASMCore.alterBlockPane(string, string2, byArray, classReader);
            }
            case 6: {
                return ASMCore.alterContainer(string, string2, byArray, classReader);
            }
            case 7: {
                return ASMCore.alterController(string, string2, byArray, classReader);
            }
            case 8: {
                return ASMCore.alterLongHashMap(string, string2, byArray, classReader);
            }
            case 9: {
                return ASMCore.alterChunk(string, string2, byArray, classReader);
            }
            case 10: {
                return ASMCore.alterMinecraft(string, string2, byArray, classReader);
            }
            case 11: {
                return ASMCore.alterRenderBlocks(string, string2, byArray, classReader);
            }
            case 12: {
                return ASMCore.alterTileEntity(string, string2, byArray, classReader);
            }
            case 13: {
                return ASMCore.fixWorldGenLag(string, string2, byArray, classReader);
            }
            case 14: {
                return ASMCore.alterEntity(string, string2, byArray, classReader);
            }
            case 15: {
                return ASMCore.alterEntityItem(string, string2, byArray, classReader);
            }
        }
        return byArray;
    }

    private static byte[] alterEntityItem(String string, String string2, byte[] byArray, ClassReader classReader) {
        String[] stringArray = LoadingPlugin.runtimeDeobfEnabled ? new String[]{"func_85054_d", "", ""} : new String[]{"searchForOtherItemsNearby", "", ""};
        string = string.replace('.', '/');
        ClassNode classNode = new ClassNode(262144);
        classReader.accept((ClassVisitor)classNode, 8);
        FMLDeobfuscatingRemapper fMLDeobfuscatingRemapper = FMLDeobfuscatingRemapper.INSTANCE;
        MethodNode methodNode = null;
        for (MethodNode methodNode2 : classNode.methods) {
            if (!stringArray[0].equals(fMLDeobfuscatingRemapper.mapMethodName(string, methodNode2.name, methodNode2.desc))) continue;
            methodNode = methodNode2;
            break;
        }
        if (methodNode != null) {
            methodNode.localVariables = null;
            methodNode.instructions.clear();
            methodNode.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            methodNode.instructions.add((AbstractInsnNode)new MethodInsnNode(184, "cofh/asm/HooksCore", "stackItems", "(Lnet/minecraft/entity/item/EntityItem;)V", false));
            methodNode.instructions.add((AbstractInsnNode)new InsnNode(177));
            ClassWriter classWriter = new ClassWriter(1);
            classNode.accept((ClassVisitor)classWriter);
            byArray = classWriter.toByteArray();
        }
        return byArray;
    }

    private static byte[] alterEntity(String string, String string2, byte[] byArray, ClassReader classReader) {
        String[] stringArray = LoadingPlugin.runtimeDeobfEnabled ? new String[]{"func_70091_d", "func_72945_a", ""} : new String[]{"moveEntity", "getCollidingBoundingBoxes", ""};
        string = string.replace('.', '/');
        ClassNode classNode = new ClassNode(262144);
        classReader.accept((ClassVisitor)classNode, 8);
        FMLDeobfuscatingRemapper fMLDeobfuscatingRemapper = FMLDeobfuscatingRemapper.INSTANCE;
        String string3 = "net/minecraft/world/World";
        MethodNode methodNode = null;
        for (MethodNode methodNode2 : classNode.methods) {
            if (!stringArray[0].equals(fMLDeobfuscatingRemapper.mapMethodName(string, methodNode2.name, methodNode2.desc))) continue;
            methodNode = methodNode2;
            break;
        }
        if (methodNode != null) {
            int n = methodNode.instructions.size();
            for (int i = 0; i < n; ++i) {
                AbstractInsnNode abstractInsnNode = methodNode.instructions.get(i);
                if (abstractInsnNode.getOpcode() != 182) continue;
                MethodInsnNode methodInsnNode = (MethodInsnNode)abstractInsnNode;
                if (!string3.equals(fMLDeobfuscatingRemapper.map(methodInsnNode.owner)) || !stringArray[1].equals(fMLDeobfuscatingRemapper.mapMethodName(methodInsnNode.owner, methodInsnNode.name, methodInsnNode.desc))) continue;
                methodInsnNode.setOpcode(184);
                methodInsnNode.owner = "cofh/asm/HooksCore";
                methodInsnNode.desc = "(Lnet/minecraft/world/World;Lnet/minecraft/entity/Entity;Lnet/minecraft/util/AxisAlignedBB;)Ljava/util/List;";
                methodInsnNode.name = "getEntityCollisonBoxes";
            }
            ClassWriter classWriter = new ClassWriter(1);
            classNode.accept((ClassVisitor)classWriter);
            byArray = classWriter.toByteArray();
        }
        return byArray;
    }

    private static byte[] alterRenderBlocks(String string, String string2, byte[] byArray, ClassReader classReader) {
        String[] stringArray = LoadingPlugin.runtimeDeobfEnabled ? new String[]{"func_147733_k", "func_150098_a", "func_147439_a"} : new String[]{"renderBlockStainedGlassPane", "canPaneConnectToBlock", "getBlock"};
        string = string.replace('.', '/');
        ClassNode classNode = new ClassNode(262144);
        classReader.accept((ClassVisitor)classNode, 8);
        FMLDeobfuscatingRemapper fMLDeobfuscatingRemapper = FMLDeobfuscatingRemapper.INSTANCE;
        MethodNode methodNode = null;
        for (MethodNode methodNode2 : classNode.methods) {
            if (!stringArray[0].equals(fMLDeobfuscatingRemapper.mapMethodName(string, methodNode2.name, methodNode2.desc)) || !"(Lnet/minecraft/block/Block;III)Z".equals(fMLDeobfuscatingRemapper.mapMethodDesc(methodNode2.desc))) continue;
            methodNode = methodNode2;
            break;
        }
        if (methodNode != null) {
            methodNode.localVariables = null;
            String[] stringArray2 = new String[]{"NORTH", "NORTH", "SOUTH", "SOUTH", "WEST", "WEST", "EAST", "EAST"};
            int n = 0;
            int n2 = methodNode.instructions.size();
            for (int i = 0; i < n2; ++i) {
                AbstractInsnNode abstractInsnNode = methodNode.instructions.get(i);
                if (abstractInsnNode.getType() != 5) continue;
                MethodInsnNode methodInsnNode = (MethodInsnNode)abstractInsnNode;
                if (abstractInsnNode.getOpcode() != 185 || abstractInsnNode.getNext().getOpcode() != 182 || !stringArray[2].equals(fMLDeobfuscatingRemapper.mapMethodName(methodInsnNode.owner, methodInsnNode.name, methodInsnNode.desc)) || !"(III)Lnet/minecraft/block/Block;".equals(fMLDeobfuscatingRemapper.mapMethodDesc(methodInsnNode.desc)) || !"(Lnet/minecraft/block/Block;)Z".equals(fMLDeobfuscatingRemapper.mapMethodDesc(((MethodInsnNode)methodInsnNode.getNext()).desc))) continue;
                methodNode.instructions.insertBefore(abstractInsnNode, (AbstractInsnNode)new FieldInsnNode(178, "net/minecraftforge/common/util/ForgeDirection", stringArray2[n++], "Lnet/minecraftforge/common/util/ForgeDirection;"));
                methodNode.instructions.insertBefore(abstractInsnNode, (AbstractInsnNode)new MethodInsnNode(182, "net/minecraft/block/BlockPane", "canPaneConnectTo", "(Lnet/minecraft/world/IBlockAccess;IIILnet/minecraftforge/common/util/ForgeDirection;)Z", false));
                methodNode.instructions.remove(abstractInsnNode.getNext());
                methodNode.instructions.remove(abstractInsnNode);
            }
            if (n != 0) {
                ClassWriter classWriter = new ClassWriter(1);
                classNode.accept((ClassVisitor)classWriter);
                byArray = classWriter.toByteArray();
            }
        }
        return byArray;
    }

    private static byte[] alterBlockPane(String string, String string2, byte[] byArray, ClassReader classReader) {
        String string3 = "canPaneConnectTo";
        string = string.replace('.', '/');
        ClassNode classNode = new ClassNode(262144);
        classReader.accept((ClassVisitor)classNode, 8);
        FMLDeobfuscatingRemapper fMLDeobfuscatingRemapper = FMLDeobfuscatingRemapper.INSTANCE;
        MethodNode methodNode = null;
        for (MethodNode methodNode2 : classNode.methods) {
            if (!string3.equals(fMLDeobfuscatingRemapper.mapMethodName(string, methodNode2.name, methodNode2.desc)) || !"(Lnet/minecraft/world/IBlockAccess;IIILnet/minecraftforge/common/util/ForgeDirection;)Z".equals(fMLDeobfuscatingRemapper.mapMethodDesc(methodNode2.desc))) continue;
            methodNode = methodNode2;
            break;
        }
        if (methodNode != null) {
            methodNode.instructions.clear();
            methodNode.instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
            methodNode.instructions.add((AbstractInsnNode)new VarInsnNode(21, 2));
            methodNode.instructions.add((AbstractInsnNode)new VarInsnNode(21, 3));
            methodNode.instructions.add((AbstractInsnNode)new VarInsnNode(21, 4));
            methodNode.instructions.add((AbstractInsnNode)new VarInsnNode(25, 5));
            methodNode.instructions.add((AbstractInsnNode)new MethodInsnNode(184, "cofh/asm/HooksCore", "paneConnectsTo", "(Lnet/minecraft/world/IBlockAccess;IIILnet/minecraftforge/common/util/ForgeDirection;)Z", false));
            methodNode.instructions.add((AbstractInsnNode)new InsnNode(172));
            methodNode.localVariables = null;
            ClassWriter classWriter = new ClassWriter(1);
            classNode.accept((ClassVisitor)classWriter);
            byArray = classWriter.toByteArray();
        }
        return byArray;
    }

    private static byte[] alterMinecraft(String string, String string2, byte[] byArray, ClassReader classReader) {
        String[] stringArray = LoadingPlugin.runtimeDeobfEnabled ? new String[]{"func_71407_l", "func_110550_d"} : new String[]{"runTick", "tick"};
        string = string.replace('.', '/');
        ClassNode classNode = new ClassNode(262144);
        classReader.accept((ClassVisitor)classNode, 8);
        FMLDeobfuscatingRemapper fMLDeobfuscatingRemapper = FMLDeobfuscatingRemapper.INSTANCE;
        String string3 = fMLDeobfuscatingRemapper.unmap("net/minecraft/client/renderer/texture/TextureManager");
        boolean bl = false;
        block0: for (MethodNode methodNode : classNode.methods) {
            String string4 = fMLDeobfuscatingRemapper.mapMethodName(string, methodNode.name, methodNode.desc);
            if (!stringArray[0].equals(string4) || !"()V".equals(methodNode.desc)) continue;
            bl = true;
            int n = methodNode.instructions.size();
            for (int i = 0; i < n; ++i) {
                AbstractInsnNode abstractInsnNode = methodNode.instructions.get(i);
                if (abstractInsnNode.getOpcode() != 182) continue;
                MethodInsnNode methodInsnNode = (MethodInsnNode)abstractInsnNode;
                if (!string3.equals(methodInsnNode.owner) || !stringArray[1].equals(fMLDeobfuscatingRemapper.mapMethodName(methodInsnNode.owner, methodInsnNode.name, methodInsnNode.desc)) || !"()V".equals(methodInsnNode.desc)) continue;
                methodNode.instructions.set((AbstractInsnNode)methodInsnNode, (AbstractInsnNode)new MethodInsnNode(184, "cofh/asm/HooksCore", "tickTextures", "(Lnet/minecraft/client/renderer/texture/ITickable;)V", false));
                break block0;
            }
        }
        if (bl) {
            ClassWriter classWriter = new ClassWriter(1);
            classNode.accept((ClassVisitor)classWriter);
            byArray = classWriter.toByteArray();
        }
        return byArray;
    }

    private static byte[] alterChunk(String string, String string2, byte[] byArray, ClassReader classReader) {
        String[] stringArray = LoadingPlugin.runtimeDeobfEnabled ? new String[]{"func_150803_c", "field_76650_s"} : new String[]{"recheckGaps", "isGapLightingUpdated"};
        string = string.replace('.', '/');
        ClassNode classNode = new ClassNode(262144);
        classReader.accept((ClassVisitor)classNode, 8);
        FMLDeobfuscatingRemapper fMLDeobfuscatingRemapper = FMLDeobfuscatingRemapper.INSTANCE;
        boolean bl = false;
        block0: for (MethodNode methodNode : classNode.methods) {
            String string3 = fMLDeobfuscatingRemapper.mapMethodName(string, methodNode.name, methodNode.desc);
            if (!stringArray[0].equals(string3) || !"(Z)V".equals(methodNode.desc)) continue;
            bl = true;
            int n = methodNode.instructions.size();
            for (int i = 0; i < n; ++i) {
                AbstractInsnNode abstractInsnNode = methodNode.instructions.get(i);
                if (abstractInsnNode.getOpcode() != 177) continue;
                methodNode.instructions.insertBefore(abstractInsnNode, (AbstractInsnNode)new VarInsnNode(25, 0));
                methodNode.instructions.insertBefore(abstractInsnNode, (AbstractInsnNode)new InsnNode(3));
                methodNode.instructions.insertBefore(abstractInsnNode, (AbstractInsnNode)new FieldInsnNode(181, string, stringArray[1], "Z"));
                continue block0;
            }
        }
        if (bl) {
            ClassWriter classWriter = new ClassWriter(1);
            classNode.accept((ClassVisitor)classWriter);
            byArray = classWriter.toByteArray();
        }
        return byArray;
    }

    private static byte[] fixWorldGenLag(String string, String string2, byte[] byArray, ClassReader classReader) {
        String string3 = LoadingPlugin.runtimeDeobfEnabled ? "func_73254_a" : "sendChunkUpdate";
        string = string.replace('.', '/');
        ClassNode classNode = new ClassNode(262144);
        classReader.accept((ClassVisitor)classNode, 8);
        String string4 = "()V";
        FMLDeobfuscatingRemapper fMLDeobfuscatingRemapper = FMLDeobfuscatingRemapper.INSTANCE;
        MethodNode methodNode = null;
        for (MethodNode methodNode2 : classNode.methods) {
            if (!string3.equals(fMLDeobfuscatingRemapper.mapMethodName(string, methodNode2.name, methodNode2.desc)) || !string4.equals(methodNode2.desc)) continue;
            methodNode = methodNode2;
            break;
        }
        if (methodNode != null) {
            int n = methodNode.instructions.size();
            block1: for (int i = 0; i < n; ++i) {
                AbstractInsnNode abstractInsnNode = methodNode.instructions.get(i);
                if (abstractInsnNode.getOpcode() != 178 || !"net/minecraftforge/common/ForgeModContainer".equals(((FieldInsnNode)abstractInsnNode).owner)) continue;
                while (abstractInsnNode != null) {
                    if (abstractInsnNode.getOpcode() == 160) {
                        ((JumpInsnNode)abstractInsnNode).setOpcode(161);
                        break block1;
                    }
                    abstractInsnNode = abstractInsnNode.getNext();
                }
            }
            ClassWriter classWriter = new ClassWriter(1);
            classNode.accept((ClassVisitor)classWriter);
            byArray = classWriter.toByteArray();
        }
        return byArray;
    }

    private static byte[] alterLongHashMap(String string, String string2, byte[] byArray, ClassReader classReader) {
        ClassNode classNode;
        Object object;
        String[] stringArray = LoadingPlugin.runtimeDeobfEnabled ? new String[]{"func_76155_g", "func_76160_c", "func_76161_b"} : new String[]{"getHashedKey", "getEntry", "containsItem"};
        string = string.replace('.', '/');
        ClassNode classNode2 = new ClassNode(262144);
        classReader.accept((ClassVisitor)classNode2, 8);
        FMLDeobfuscatingRemapper fMLDeobfuscatingRemapper = FMLDeobfuscatingRemapper.INSTANCE;
        boolean bl = false;
        MethodNode methodNode = null;
        Object object2 = null;
        for (Object object3 : classNode2.methods) {
            object = fMLDeobfuscatingRemapper.mapMethodName(string, ((MethodNode)object3).name, ((MethodNode)object3).desc);
            if (stringArray[0].equals(object) && "(J)I".equals(((MethodNode)object3).desc)) {
                bl = true;
                int n = ((MethodNode)object3).instructions.size();
                for (int i = 0; i < n; ++i) {
                    AbstractInsnNode abstractInsnNode = ((MethodNode)object3).instructions.get(i);
                    if (abstractInsnNode.getOpcode() != 131) continue;
                    ((MethodNode)object3).instructions.insertBefore(abstractInsnNode, (AbstractInsnNode)new LdcInsnNode((Object)new Long(13L)));
                    ((MethodNode)object3).instructions.insertBefore(abstractInsnNode, (AbstractInsnNode)new InsnNode(105));
                    break;
                }
                if (object2 == null) continue;
                break;
            }
            if (!stringArray[2].equals(object) || !"(J)Z".equals(((MethodNode)object3).desc)) continue;
            object2 = object3;
            if (!bl) continue;
            break;
        }
        if (object2 != null) {
            Object object3;
            classNode = new ClassNode(262144);
            classReader.accept((ClassVisitor)classNode, 8);
            object3 = "(J)Lnet/minecraft/util/LongHashMap$Entry;";
            object = classNode.methods.iterator();
            while (object.hasNext()) {
                MethodNode methodNode2 = (MethodNode)object.next();
                String string3 = fMLDeobfuscatingRemapper.mapMethodName(string, methodNode2.name, methodNode2.desc);
                if (!stringArray[1].equals(string3) || !((String)object3).equals(fMLDeobfuscatingRemapper.mapMethodDesc(methodNode2.desc))) continue;
                methodNode = methodNode2;
                break;
            }
            if (methodNode != null) {
                bl = true;
                ((MethodNode)object2).instructions.clear();
                ((MethodNode)object2).instructions.add(methodNode.instructions);
                for (object = ((MethodNode)object2).instructions.get(0); object != null; object = object.getNext()) {
                    if (object.getOpcode() != 176) continue;
                    AbstractInsnNode abstractInsnNode = object.getPrevious();
                    if (abstractInsnNode.getOpcode() == 1) {
                        ((MethodNode)object2).instructions.set(abstractInsnNode, (AbstractInsnNode)new InsnNode(3));
                    } else {
                        ((MethodNode)object2).instructions.set(abstractInsnNode, (AbstractInsnNode)new InsnNode(4));
                    }
                    Object object4 = object;
                    object = new InsnNode(172);
                    ((MethodNode)object2).instructions.set((AbstractInsnNode)object4, (AbstractInsnNode)object);
                }
            }
        }
        if (bl) {
            classNode = new ClassWriter(1);
            classNode2.accept((ClassVisitor)classNode);
            byArray = classNode.toByteArray();
        }
        return byArray;
    }

    private static byte[] alterController(String string, String string2, byte[] byArray, ClassReader classReader) {
        block7: {
            String[] stringArray = LoadingPlugin.runtimeDeobfEnabled ? new String[]{"func_85182_a", "field_85183_f"} : new String[]{"sameToolAndBlock", "currentItemHittingBlock"};
            string = string.replace('.', '/');
            ClassNode classNode = new ClassNode(262144);
            classReader.accept((ClassVisitor)classNode, 8);
            FMLDeobfuscatingRemapper fMLDeobfuscatingRemapper = FMLDeobfuscatingRemapper.INSTANCE;
            String string3 = fMLDeobfuscatingRemapper.unmap("net/minecraft/item/ItemStack");
            MethodNode methodNode = null;
            for (MethodNode methodNode2 : classNode.methods) {
                if (!stringArray[0].equals(fMLDeobfuscatingRemapper.mapMethodName(string, methodNode2.name, methodNode2.desc)) || !"(III)Z".equals(methodNode2.desc)) continue;
                methodNode = methodNode2;
                break;
            }
            if (methodNode != null) {
                int n = methodNode.instructions.size();
                for (int i = 0; i < n; ++i) {
                    AbstractInsnNode abstractInsnNode = methodNode.instructions.get(i);
                    if (abstractInsnNode.getOpcode() != 182) continue;
                    MethodInsnNode methodInsnNode = (MethodInsnNode)abstractInsnNode;
                    if (!string3.equals(methodInsnNode.owner)) continue;
                    LabelNode labelNode = null;
                    LabelNode labelNode2 = null;
                    block2: for (int j = i; j < n; ++j) {
                        int n2;
                        abstractInsnNode = methodNode.instructions.get(j);
                        if (abstractInsnNode.getOpcode() != 4) continue;
                        for (n2 = j; n2 > i; --n2) {
                            abstractInsnNode = methodNode.instructions.get(n2);
                            if (abstractInsnNode.getType() != 8) continue;
                            labelNode = (LabelNode)abstractInsnNode;
                            break;
                        }
                        for (n2 = j; n2 < n; ++n2) {
                            abstractInsnNode = methodNode.instructions.get(n2);
                            if (abstractInsnNode.getType() != 8) continue;
                            labelNode2 = (LabelNode)abstractInsnNode;
                            break block2;
                        }
                    }
                    if (labelNode != null && labelNode2 != null) {
                        methodNode.instructions.insertBefore((AbstractInsnNode)methodInsnNode, (AbstractInsnNode)new VarInsnNode(25, 0));
                        methodNode.instructions.insertBefore((AbstractInsnNode)methodInsnNode, (AbstractInsnNode)new FieldInsnNode(180, string, stringArray[1], 'L' + string3 + ';'));
                        methodNode.instructions.insertBefore((AbstractInsnNode)methodInsnNode, (AbstractInsnNode)new MethodInsnNode(184, "cofh/asm/HooksCore", "areItemsEqualHook", "(Lnet/minecraft/item/ItemStack;Lnet/minecraft/item/ItemStack;)Z", false));
                        methodNode.instructions.insertBefore((AbstractInsnNode)methodInsnNode, (AbstractInsnNode)new JumpInsnNode(153, labelNode2));
                        methodNode.instructions.insertBefore((AbstractInsnNode)methodInsnNode, (AbstractInsnNode)new JumpInsnNode(167, labelNode));
                        break;
                    }
                    break block7;
                }
                ClassWriter classWriter = new ClassWriter(1);
                classNode.accept((ClassVisitor)classWriter);
                byArray = classWriter.toByteArray();
            }
        }
        return byArray;
    }

    private static byte[] alterContainer(String string, String string2, byte[] byArray, ClassReader classReader) {
        String[] stringArray = LoadingPlugin.runtimeDeobfEnabled ? new String[]{"func_75135_a", "field_75151_b"} : new String[]{"mergeItemStack", "inventorySlots"};
        string = string.replace('.', '/');
        ClassNode classNode = new ClassNode(262144);
        classReader.accept((ClassVisitor)classNode, 8);
        FMLDeobfuscatingRemapper fMLDeobfuscatingRemapper = FMLDeobfuscatingRemapper.INSTANCE;
        MethodNode methodNode = null;
        for (MethodNode methodNode2 : classNode.methods) {
            if (!stringArray[0].equals(fMLDeobfuscatingRemapper.mapMethodName(string, methodNode2.name, methodNode2.desc)) || !"(Lnet/minecraft/item/ItemStack;IIZ)Z".equals(fMLDeobfuscatingRemapper.mapMethodDesc(methodNode2.desc))) continue;
            methodNode = methodNode2;
            break;
        }
        if (methodNode != null) {
            methodNode.instructions.clear();
            methodNode.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            methodNode.instructions.add((AbstractInsnNode)new FieldInsnNode(180, string, stringArray[1], "Ljava/util/List;"));
            methodNode.instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
            methodNode.instructions.add((AbstractInsnNode)new VarInsnNode(21, 2));
            methodNode.instructions.add((AbstractInsnNode)new VarInsnNode(21, 3));
            methodNode.instructions.add((AbstractInsnNode)new VarInsnNode(21, 4));
            methodNode.instructions.add((AbstractInsnNode)new InsnNode(3));
            methodNode.instructions.add((AbstractInsnNode)new MethodInsnNode(184, "cofh/lib/util/helpers/InventoryHelper", "mergeItemStack", "(Ljava/util/List;Lnet/minecraft/item/ItemStack;IIZZ)Z", false));
            methodNode.instructions.add((AbstractInsnNode)new InsnNode(172));
            methodNode.localVariables = null;
            ClassWriter classWriter = new ClassWriter(1);
            classNode.accept((ClassVisitor)classWriter);
            byArray = classWriter.toByteArray();
        }
        return byArray;
    }

    private static byte[] alterTileEntity(String string, String string2, byte[] byArray, ClassReader classReader) {
        string = string.replace('.', '/');
        ClassNode classNode = new ClassNode(262144);
        classReader.accept((ClassVisitor)classNode, 0);
        ClassWriter classWriter = new ClassWriter(1);
        classNode.accept((ClassVisitor)classWriter);
        classWriter.newMethod(string, "cofh_validate", "()V", true);
        MethodVisitor methodVisitor = classWriter.visitMethod(1, "cofh_validate", "()V", null, null);
        methodVisitor.visitCode();
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(0, 1);
        methodVisitor.visitEnd();
        classWriter.visitEnd();
        return classWriter.toByteArray();
    }

    private static byte[] writeWorld(String string, String string2, byte[] byArray, ClassReader classReader) {
        LabelNode labelNode;
        AbstractInsnNode abstractInsnNode;
        LabelNode labelNode2;
        MethodNode methodNode6;
        String[] stringArray = LoadingPlugin.runtimeDeobfEnabled ? new String[]{"field_73019_z", "field_72986_A", "field_73011_w", "field_72984_F", "func_147448_a", "func_147455_a", "func_72939_s", "func_145830_o"} : new String[]{"saveHandler", "worldInfo", "provider", "theProfiler", "func_147448_a", "setTileEntity", "updateEntities", "hasWorldObj"};
        string = string.replace('.', '/');
        ClassNode classNode = new ClassNode(262144);
        classReader.accept((ClassVisitor)classNode, 8);
        FMLDeobfuscatingRemapper fMLDeobfuscatingRemapper = FMLDeobfuscatingRemapper.INSTANCE;
        MethodNode methodNode2 = null;
        MethodNode methodNode3 = null;
        MethodNode methodNode4 = null;
        MethodNode methodNode5 = null;
        boolean bl = false;
        for (MethodNode methodNode6 : classNode.methods) {
            if ("<init>".equals(methodNode6.name)) {
                if ("(Lnet/minecraft/world/storage/ISaveHandler;Ljava/lang/String;Lnet/minecraft/world/WorldProvider;Lnet/minecraft/world/WorldSettings;Lnet/minecraft/profiler/Profiler;)V".equals(fMLDeobfuscatingRemapper.mapMethodDesc(methodNode6.desc))) {
                    bl = true;
                }
                labelNode2 = new LabelNode(new Label());
                abstractInsnNode = methodNode6.instructions.getFirst();
                while (abstractInsnNode.getOpcode() != 183 || !((MethodInsnNode)abstractInsnNode).name.equals("<init>")) {
                    abstractInsnNode = abstractInsnNode.getNext();
                }
                AbstractInsnNode abstractInsnNode2 = abstractInsnNode;
                abstractInsnNode = labelNode2;
                methodNode6.instructions.insert(abstractInsnNode2, abstractInsnNode);
                AbstractInsnNode abstractInsnNode3 = abstractInsnNode;
                abstractInsnNode = new LineNumberNode(-15000, labelNode2);
                methodNode6.instructions.insert(abstractInsnNode3, abstractInsnNode);
                AbstractInsnNode abstractInsnNode4 = abstractInsnNode;
                abstractInsnNode = new VarInsnNode(25, 0);
                methodNode6.instructions.insert(abstractInsnNode4, abstractInsnNode);
                AbstractInsnNode abstractInsnNode5 = abstractInsnNode;
                abstractInsnNode = new TypeInsnNode(187, "cofh/lib/util/LinkedHashList");
                methodNode6.instructions.insert(abstractInsnNode5, abstractInsnNode);
                AbstractInsnNode abstractInsnNode6 = abstractInsnNode;
                abstractInsnNode = new InsnNode(89);
                methodNode6.instructions.insert(abstractInsnNode6, abstractInsnNode);
                AbstractInsnNode abstractInsnNode7 = abstractInsnNode;
                abstractInsnNode = new MethodInsnNode(183, "cofh/lib/util/LinkedHashList", "<init>", "()V", false);
                methodNode6.instructions.insert(abstractInsnNode7, abstractInsnNode);
                AbstractInsnNode abstractInsnNode8 = abstractInsnNode;
                abstractInsnNode = new FieldInsnNode(181, "net/minecraft/world/World", "cofh_recentTiles", "Lcofh/lib/util/LinkedHashList;");
                methodNode6.instructions.insert(abstractInsnNode8, abstractInsnNode);
                continue;
            }
            if ("addTileEntity".equals(methodNode6.name) && "(Lnet/minecraft/tileentity/TileEntity;)V".equals(fMLDeobfuscatingRemapper.mapMethodDesc(methodNode6.desc))) {
                methodNode2 = methodNode6;
                continue;
            }
            if (stringArray[4].equals(fMLDeobfuscatingRemapper.mapMethodName(string, methodNode6.name, methodNode6.desc)) && "(Ljava/util/Collection;)V".equals(methodNode6.desc)) {
                methodNode3 = methodNode6;
                continue;
            }
            if (stringArray[5].equals(fMLDeobfuscatingRemapper.mapMethodName(string, methodNode6.name, methodNode6.desc)) && "(IIILnet/minecraft/tileentity/TileEntity;)V".equals(fMLDeobfuscatingRemapper.mapMethodDesc(methodNode6.desc))) {
                methodNode4 = methodNode6;
                continue;
            }
            if (!stringArray[6].equals(fMLDeobfuscatingRemapper.mapMethodName(string, methodNode6.name, methodNode6.desc)) || !"()V".equals(fMLDeobfuscatingRemapper.mapMethodDesc(methodNode6.desc))) continue;
            methodNode5 = methodNode6;
        }
        classNode.fields.add(new FieldNode(2, "cofh_recentTiles", "Lcofh/lib/util/LinkedHashList;", null, null));
        if (methodNode2 != null) {
            labelNode = new LabelNode(new Label());
            methodNode6 = labelNode;
            methodNode2.instructions.insert((AbstractInsnNode)methodNode6);
            MethodNode methodNode7 = methodNode6;
            methodNode6 = new LineNumberNode(-15001, labelNode);
            methodNode2.instructions.insert((AbstractInsnNode)methodNode7, (AbstractInsnNode)methodNode6);
            MethodNode methodNode8 = methodNode6;
            methodNode6 = new VarInsnNode(25, 0);
            methodNode2.instructions.insert((AbstractInsnNode)methodNode8, (AbstractInsnNode)methodNode6);
            MethodNode methodNode9 = methodNode6;
            methodNode6 = new FieldInsnNode(180, "net/minecraft/world/World", "cofh_recentTiles", "Lcofh/lib/util/LinkedHashList;");
            methodNode2.instructions.insert((AbstractInsnNode)methodNode9, (AbstractInsnNode)methodNode6);
            MethodNode methodNode10 = methodNode6;
            methodNode6 = new VarInsnNode(25, 1);
            methodNode2.instructions.insert((AbstractInsnNode)methodNode10, (AbstractInsnNode)methodNode6);
            MethodNode methodNode11 = methodNode6;
            methodNode6 = new MethodInsnNode(182, "cofh/lib/util/LinkedHashList", "push", "(Ljava/lang/Object;)Z", false);
            methodNode2.instructions.insert((AbstractInsnNode)methodNode11, (AbstractInsnNode)methodNode6);
            MethodNode methodNode12 = methodNode6;
            methodNode6 = new InsnNode(87);
            methodNode2.instructions.insert((AbstractInsnNode)methodNode12, (AbstractInsnNode)methodNode6);
        }
        if (methodNode4 != null) {
            labelNode = new LabelNode(new Label());
            methodNode6 = methodNode4.instructions.getLast();
            while (methodNode6.getOpcode() != 177) {
                methodNode6 = methodNode6.getPrevious();
            }
            methodNode6 = methodNode6.getPrevious();
            methodNode6 = labelNode;
            methodNode4.instructions.insert((AbstractInsnNode)methodNode6);
            MethodNode methodNode13 = methodNode6;
            methodNode6 = new LineNumberNode(-15002, labelNode);
            methodNode4.instructions.insert((AbstractInsnNode)methodNode13, (AbstractInsnNode)methodNode6);
            MethodNode methodNode14 = methodNode6;
            methodNode6 = new VarInsnNode(25, 0);
            methodNode4.instructions.insert((AbstractInsnNode)methodNode14, (AbstractInsnNode)methodNode6);
            MethodNode methodNode15 = methodNode6;
            methodNode6 = new FieldInsnNode(180, "net/minecraft/world/World", "cofh_recentTiles", "Lcofh/lib/util/LinkedHashList;");
            methodNode4.instructions.insert((AbstractInsnNode)methodNode15, (AbstractInsnNode)methodNode6);
            MethodNode methodNode16 = methodNode6;
            methodNode6 = new VarInsnNode(25, 4);
            methodNode4.instructions.insert((AbstractInsnNode)methodNode16, (AbstractInsnNode)methodNode6);
            MethodNode methodNode17 = methodNode6;
            methodNode6 = new MethodInsnNode(182, "cofh/lib/util/LinkedHashList", "push", "(Ljava/lang/Object;)Z", false);
            methodNode4.instructions.insert((AbstractInsnNode)methodNode17, (AbstractInsnNode)methodNode6);
            MethodNode methodNode18 = methodNode6;
            methodNode6 = new InsnNode(87);
            methodNode4.instructions.insert((AbstractInsnNode)methodNode18, (AbstractInsnNode)methodNode6);
        }
        if (methodNode3 != null) {
            labelNode = new LabelNode(new Label());
            methodNode6 = methodNode3.instructions.getFirst();
            while (true) {
                if (methodNode6.getOpcode() != 192) {
                    methodNode6 = methodNode6.getNext();
                    continue;
                }
                if (fMLDeobfuscatingRemapper.mapType(((TypeInsnNode)methodNode6).desc).equals("net/minecraft/tileentity/TileEntity")) break;
            }
            MethodNode methodNode19 = methodNode6;
            methodNode6 = labelNode;
            methodNode3.instructions.insert((AbstractInsnNode)methodNode19, (AbstractInsnNode)methodNode6);
            MethodNode methodNode20 = methodNode6;
            methodNode6 = new LineNumberNode(-15003, labelNode);
            methodNode3.instructions.insert((AbstractInsnNode)methodNode20, (AbstractInsnNode)methodNode6);
            MethodNode methodNode21 = methodNode6;
            methodNode6 = new InsnNode(89);
            methodNode3.instructions.insert((AbstractInsnNode)methodNode21, (AbstractInsnNode)methodNode6);
            MethodNode methodNode22 = methodNode6;
            methodNode6 = new VarInsnNode(25, 0);
            methodNode3.instructions.insert((AbstractInsnNode)methodNode22, (AbstractInsnNode)methodNode6);
            MethodNode methodNode23 = methodNode6;
            methodNode6 = new FieldInsnNode(180, "net/minecraft/world/World", "cofh_recentTiles", "Lcofh/lib/util/LinkedHashList;");
            methodNode3.instructions.insert((AbstractInsnNode)methodNode23, (AbstractInsnNode)methodNode6);
            MethodNode methodNode24 = methodNode6;
            methodNode6 = new InsnNode(95);
            methodNode3.instructions.insert((AbstractInsnNode)methodNode24, (AbstractInsnNode)methodNode6);
            MethodNode methodNode25 = methodNode6;
            methodNode6 = new MethodInsnNode(182, "cofh/lib/util/LinkedHashList", "push", "(Ljava/lang/Object;)Z", false);
            methodNode3.instructions.insert((AbstractInsnNode)methodNode25, (AbstractInsnNode)methodNode6);
            MethodNode methodNode26 = methodNode6;
            methodNode6 = new InsnNode(87);
            methodNode3.instructions.insert((AbstractInsnNode)methodNode26, (AbstractInsnNode)methodNode6);
        }
        if (methodNode5 != null) {
            labelNode = methodNode5.instructions.getFirst();
            while (labelNode.getOpcode() != 182 || !"onChunkUnload".equals(((MethodInsnNode)labelNode).name) || !"()V".equals(((MethodInsnNode)labelNode).desc)) {
                labelNode = labelNode.getNext();
            }
            while (labelNode.getOpcode() != 181) {
                labelNode = labelNode.getNext();
            }
            labelNode = labelNode.getPrevious().getPrevious();
            methodNode6 = new LabelNode(new Label());
            labelNode2 = new LabelNode(new Label());
            abstractInsnNode = new LabelNode(new Label());
            LabelNode labelNode3 = new LabelNode(new Label());
            LabelNode labelNode4 = labelNode;
            labelNode = labelNode3;
            methodNode5.instructions.insert((AbstractInsnNode)labelNode4, (AbstractInsnNode)labelNode);
            LabelNode labelNode5 = labelNode;
            labelNode = new LineNumberNode(-15004, labelNode3);
            methodNode5.instructions.insert((AbstractInsnNode)labelNode5, (AbstractInsnNode)labelNode);
            LabelNode labelNode6 = labelNode;
            labelNode = new JumpInsnNode(167, labelNode2);
            methodNode5.instructions.insert((AbstractInsnNode)labelNode6, (AbstractInsnNode)labelNode);
            LabelNode labelNode7 = labelNode;
            labelNode = methodNode6;
            methodNode5.instructions.insert((AbstractInsnNode)labelNode7, (AbstractInsnNode)labelNode);
            LabelNode labelNode8 = labelNode;
            labelNode = new FrameNode(3, 0, null, 0, null);
            methodNode5.instructions.insert((AbstractInsnNode)labelNode8, (AbstractInsnNode)labelNode);
            LabelNode labelNode9 = labelNode;
            labelNode = new VarInsnNode(25, 0);
            methodNode5.instructions.insert((AbstractInsnNode)labelNode9, (AbstractInsnNode)labelNode);
            LabelNode labelNode10 = labelNode;
            labelNode = new FieldInsnNode(180, "net/minecraft/world/World", "cofh_recentTiles", "Lcofh/lib/util/LinkedHashList;");
            methodNode5.instructions.insert((AbstractInsnNode)labelNode10, (AbstractInsnNode)labelNode);
            LabelNode labelNode11 = labelNode;
            labelNode = new MethodInsnNode(182, "cofh/lib/util/LinkedHashList", "shift", "()Ljava/lang/Object;", false);
            methodNode5.instructions.insert((AbstractInsnNode)labelNode11, (AbstractInsnNode)labelNode);
            LabelNode labelNode12 = labelNode;
            labelNode = new TypeInsnNode(192, "net/minecraft/tileentity/TileEntity");
            methodNode5.instructions.insert((AbstractInsnNode)labelNode12, (AbstractInsnNode)labelNode);
            LabelNode labelNode13 = labelNode;
            labelNode = new InsnNode(89);
            methodNode5.instructions.insert((AbstractInsnNode)labelNode13, (AbstractInsnNode)labelNode);
            LabelNode labelNode14 = labelNode;
            labelNode = new JumpInsnNode(198, (LabelNode)abstractInsnNode);
            methodNode5.instructions.insert((AbstractInsnNode)labelNode14, (AbstractInsnNode)labelNode);
            LabelNode labelNode15 = labelNode;
            labelNode = new InsnNode(89);
            methodNode5.instructions.insert((AbstractInsnNode)labelNode15, (AbstractInsnNode)labelNode);
            LabelNode labelNode16 = labelNode;
            labelNode = new MethodInsnNode(182, "net/minecraft/tileentity/TileEntity", stringArray[7], "()Z", false);
            methodNode5.instructions.insert((AbstractInsnNode)labelNode16, (AbstractInsnNode)labelNode);
            LabelNode labelNode17 = labelNode;
            labelNode = new JumpInsnNode(154, (LabelNode)abstractInsnNode);
            methodNode5.instructions.insert((AbstractInsnNode)labelNode17, (AbstractInsnNode)labelNode);
            LabelNode labelNode18 = labelNode;
            labelNode = new MethodInsnNode(182, "net/minecraft/tileentity/TileEntity", "cofh_validate", "()V", false);
            methodNode5.instructions.insert((AbstractInsnNode)labelNode18, (AbstractInsnNode)labelNode);
            LabelNode labelNode19 = labelNode;
            labelNode = new InsnNode(1);
            methodNode5.instructions.insert((AbstractInsnNode)labelNode19, (AbstractInsnNode)labelNode);
            LabelNode labelNode20 = labelNode;
            labelNode = abstractInsnNode;
            methodNode5.instructions.insert((AbstractInsnNode)labelNode20, (AbstractInsnNode)labelNode);
            LabelNode labelNode21 = labelNode;
            labelNode = new InsnNode(87);
            methodNode5.instructions.insert((AbstractInsnNode)labelNode21, (AbstractInsnNode)labelNode);
            LabelNode labelNode22 = labelNode;
            labelNode = labelNode2;
            methodNode5.instructions.insert((AbstractInsnNode)labelNode22, (AbstractInsnNode)labelNode);
            LabelNode labelNode23 = labelNode;
            labelNode = new FrameNode(3, 0, null, 0, null);
            methodNode5.instructions.insert((AbstractInsnNode)labelNode23, (AbstractInsnNode)labelNode);
            LabelNode labelNode24 = labelNode;
            labelNode = new VarInsnNode(25, 0);
            methodNode5.instructions.insert((AbstractInsnNode)labelNode24, (AbstractInsnNode)labelNode);
            LabelNode labelNode25 = labelNode;
            labelNode = new FieldInsnNode(180, "net/minecraft/world/World", "cofh_recentTiles", "Lcofh/lib/util/LinkedHashList;");
            methodNode5.instructions.insert((AbstractInsnNode)labelNode25, (AbstractInsnNode)labelNode);
            LabelNode labelNode26 = labelNode;
            labelNode = new MethodInsnNode(182, "cofh/lib/util/LinkedHashList", "size", "()I", false);
            methodNode5.instructions.insert((AbstractInsnNode)labelNode26, (AbstractInsnNode)labelNode);
            LabelNode labelNode27 = labelNode;
            labelNode = new JumpInsnNode(154, (LabelNode)methodNode6);
            methodNode5.instructions.insert((AbstractInsnNode)labelNode27, (AbstractInsnNode)labelNode);
        }
        labelNode = new ClassWriter(2);
        classNode.accept((ClassVisitor)labelNode);
        if (!bl) {
            labelNode.newMethod(string, "<init>", "(Lnet/minecraft/world/storage/ISaveHandler;Ljava/lang/String;Lnet/minecraft/world/WorldProvider;Lnet/minecraft/world/WorldSettings;Lnet/minecraft/profiler/Profiler;)V", true);
            methodNode6 = labelNode.visitMethod(1, "<init>", "(Lnet/minecraft/world/storage/ISaveHandler;Ljava/lang/String;Lnet/minecraft/world/WorldProvider;Lnet/minecraft/world/WorldSettings;Lnet/minecraft/profiler/Profiler;)V", null, null);
            methodNode6.visitCode();
            methodNode6.visitVarInsn(25, 0);
            methodNode6.visitInsn(89);
            methodNode6.visitInsn(89);
            methodNode6.visitInsn(89);
            methodNode6.visitInsn(89);
            methodNode6.visitInsn(89);
            methodNode6.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
            methodNode6.visitVarInsn(25, 1);
            methodNode6.visitFieldInsn(181, string, stringArray[0], "Lnet/minecraft/world/storage/ISaveHandler;");
            methodNode6.visitTypeInsn(187, "net/minecraft/world/storage/WorldInfo");
            methodNode6.visitInsn(89);
            methodNode6.visitVarInsn(25, 4);
            methodNode6.visitVarInsn(25, 2);
            methodNode6.visitMethodInsn(183, "net/minecraft/world/storage/WorldInfo", "<init>", "(Lnet/minecraft/world/WorldSettings;Ljava/lang/String;)V", false);
            methodNode6.visitFieldInsn(181, string, stringArray[1], "Lnet/minecraft/world/storage/WorldInfo;");
            methodNode6.visitVarInsn(25, 3);
            methodNode6.visitFieldInsn(181, string, stringArray[2], "Lnet/minecraft/world/WorldProvider;");
            methodNode6.visitVarInsn(25, 5);
            methodNode6.visitFieldInsn(181, string, stringArray[3], "Lnet/minecraft/profiler/Profiler;");
            methodNode6.visitInsn(177);
            methodNode6.visitMaxs(11, 10);
            methodNode6.visitEnd();
            labelNode.visitEnd();
        }
        byArray = labelNode.toByteArray();
        return byArray;
    }

    private static byte[] writeWorldServer(String string, String string2, byte[] byArray, ClassReader classReader) {
        block1: {
            MethodNode methodNode2;
            String[] stringArray = LoadingPlugin.runtimeDeobfEnabled ? new String[]{"field_73061_a", "field_73062_L", "field_73063_M", "field_85177_Q"} : new String[]{"mcServer", "theEntityTracker", "thePlayerManager", "worldTeleporter"};
            string = string.replace('.', '/');
            ClassNode classNode = new ClassNode(262144);
            classReader.accept((ClassVisitor)classNode, 8);
            FMLDeobfuscatingRemapper fMLDeobfuscatingRemapper = FMLDeobfuscatingRemapper.INSTANCE;
            for (MethodNode methodNode2 : classNode.methods) {
                if (!"<init>".equals(methodNode2.name) || !"(Lnet/minecraft/server/MinecraftServer;Lnet/minecraft/world/storage/ISaveHandler;Ljava/lang/String;Lnet/minecraft/world/WorldProvider;Lnet/minecraft/world/WorldSettings;Lnet/minecraft/profiler/Profiler;)V".equals(fMLDeobfuscatingRemapper.mapMethodDesc(methodNode2.desc))) continue;
                break block1;
            }
            ClassWriter classWriter = new ClassWriter(2);
            classNode.accept((ClassVisitor)classWriter);
            classWriter.newMethod(string, "<init>", "(Lnet/minecraft/server/MinecraftServer;Lnet/minecraft/world/storage/ISaveHandler;Ljava/lang/String;Lnet/minecraft/world/WorldProvider;Lnet/minecraft/world/WorldSettings;Lnet/minecraft/profiler/Profiler;)V", true);
            methodNode2 = classWriter.visitMethod(1, "<init>", "(Lnet/minecraft/server/MinecraftServer;Lnet/minecraft/world/storage/ISaveHandler;Ljava/lang/String;Lnet/minecraft/world/WorldProvider;Lnet/minecraft/world/WorldSettings;Lnet/minecraft/profiler/Profiler;)V", null, null);
            methodNode2.visitCode();
            methodNode2.visitVarInsn(25, 0);
            methodNode2.visitInsn(89);
            methodNode2.visitInsn(89);
            methodNode2.visitInsn(89);
            methodNode2.visitInsn(89);
            methodNode2.visitVarInsn(25, 2);
            methodNode2.visitVarInsn(25, 3);
            methodNode2.visitVarInsn(25, 4);
            methodNode2.visitVarInsn(25, 5);
            methodNode2.visitVarInsn(25, 6);
            methodNode2.visitMethodInsn(183, "net/minecraft/world/World", "<init>", "(Lnet/minecraft/world/storage/ISaveHandler;Ljava/lang/String;Lnet/minecraft/world/WorldProvider;Lnet/minecraft/world/WorldSettings;Lnet/minecraft/profiler/Profiler;)V", false);
            methodNode2.visitVarInsn(25, 1);
            methodNode2.visitFieldInsn(181, string, stringArray[0], "Lnet/minecraft/server/MinecraftServer;");
            methodNode2.visitInsn(1);
            methodNode2.visitFieldInsn(181, string, stringArray[1], "Lnet/minecraft/entity/EntityTracker;");
            methodNode2.visitInsn(1);
            methodNode2.visitFieldInsn(181, string, stringArray[2], "Lnet/minecraft/server/management/PlayerManager;");
            methodNode2.visitInsn(1);
            methodNode2.visitFieldInsn(181, string, stringArray[3], "Lnet/minecraft/world/Teleporter;");
            methodNode2.visitInsn(177);
            methodNode2.visitMaxs(11, 10);
            methodNode2.visitEnd();
            classWriter.visitEnd();
            byArray = classWriter.toByteArray();
        }
        return byArray;
    }

    private static byte[] writeWorldProxy(String string, byte[] byArray, ClassReader classReader) {
        Object object;
        ClassNode classNode = new ClassNode(262144);
        FMLDeobfuscatingRemapper fMLDeobfuscatingRemapper = FMLDeobfuscatingRemapper.INSTANCE;
        try {
            object = new ClassReader(LoadingPlugin.loader.getClassBytes(fMLDeobfuscatingRemapper.unmap("net/minecraft/world/World").replace('/', '.')));
            object.accept((ClassVisitor)new FMLRemappingAdapter((ClassVisitor)classNode), 1);
        }
        catch (Throwable throwable) {
            Throwables.propagate((Throwable)throwable);
        }
        fMLDeobfuscatingRemapper = new ClassNode(262144);
        classReader.accept((ClassVisitor)fMLDeobfuscatingRemapper, 4);
        for (MethodNode methodNode : classNode.methods) {
            Type[] typeArray;
            if (methodNode.name.indexOf(60) == 0 || (methodNode.access & 8) != 0) continue;
            MethodVisitor methodVisitor = fMLDeobfuscatingRemapper.methods.iterator();
            while (methodVisitor.hasNext()) {
                typeArray = (Type[])methodVisitor.next();
                if (!typeArray.name.equals(methodNode.name) || !typeArray.desc.equals(methodNode.desc)) continue;
                methodVisitor.remove();
            }
            methodVisitor = fMLDeobfuscatingRemapper.visitMethod(ASMCore.getAccess(methodNode), methodNode.name, methodNode.desc, methodNode.signature, methodNode.exceptions.toArray(new String[0]));
            methodVisitor.visitCode();
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitFieldInsn(180, "skyboy/core/world/WorldProxy", "proxiedWorld", "Lnet/minecraft/world/World;");
            typeArray = Type.getArgumentTypes((String)methodNode.desc);
            int n = 1;
            int n2 = typeArray.length;
            for (int i = 0; i < n2; ++i) {
                methodVisitor.visitVarInsn(typeArray[i].getOpcode(21), n);
                n += typeArray[i].getSize();
            }
            methodVisitor.visitMethodInsn(182, "net/minecraft/world/World", methodNode.name, methodNode.desc, false);
            methodVisitor.visitInsn(Type.getReturnType((String)methodNode.desc).getOpcode(172));
            methodVisitor.visitMaxs(1, 1);
            methodVisitor.visitEnd();
        }
        object = new ClassWriter(2);
        fMLDeobfuscatingRemapper.accept((ClassVisitor)object);
        return object.toByteArray();
    }

    private static byte[] writeWorldServerProxy(String string, byte[] byArray, ClassReader classReader) {
        int n;
        Object object;
        Object object2;
        ClassReader classReader2;
        ClassNode classNode = new ClassNode(262144);
        FMLDeobfuscatingRemapper fMLDeobfuscatingRemapper = FMLDeobfuscatingRemapper.INSTANCE;
        try {
            classReader2 = new ClassReader(LoadingPlugin.loader.getClassBytes(fMLDeobfuscatingRemapper.unmap("net/minecraft/world/WorldServer").replace('/', '.')));
            classReader2.accept((ClassVisitor)new FMLRemappingAdapter((ClassVisitor)classNode), 1);
        }
        catch (Throwable throwable) {
            Throwables.propagate((Throwable)throwable);
        }
        fMLDeobfuscatingRemapper = new ClassNode(262144);
        classReader2 = FMLDeobfuscatingRemapper.INSTANCE;
        try {
            object2 = new ClassReader(LoadingPlugin.loader.getClassBytes(classReader2.unmap("net/minecraft/world/World").replace('/', '.')));
            object2.accept((ClassVisitor)new FMLRemappingAdapter((ClassVisitor)fMLDeobfuscatingRemapper), 1);
        }
        catch (Throwable throwable) {
            Throwables.propagate((Throwable)throwable);
        }
        classReader2 = new ClassNode(262144);
        classReader.accept((ClassVisitor)classReader2, 4);
        classReader2.superName = "net/minecraft/world/WorldServer";
        block4: for (MethodNode methodNode : classReader2.methods) {
            if (!"<init>".equals(methodNode.name)) continue;
            object = methodNode.instructions;
            n = object.size();
            for (int i = 0; i < n; ++i) {
                MethodInsnNode methodInsnNode;
                AbstractInsnNode abstractInsnNode = object.get(i);
                if (!(abstractInsnNode instanceof MethodInsnNode) || (methodInsnNode = (MethodInsnNode)abstractInsnNode).getOpcode() != 183) continue;
                methodInsnNode.owner = classReader2.superName;
                continue block4;
            }
        }
        for (MethodNode methodNode : fMLDeobfuscatingRemapper.methods) {
            Type[] typeArray;
            if (methodNode.name.indexOf(60) == 0 || (methodNode.access & 8) != 0) continue;
            object = classReader2.methods.iterator();
            while (object.hasNext()) {
                typeArray = (Type[])object.next();
                if (!typeArray.name.equals(methodNode.name) || !typeArray.desc.equals(methodNode.desc)) continue;
                object.remove();
            }
            object = classReader2.visitMethod(ASMCore.getAccess(methodNode), methodNode.name, methodNode.desc, methodNode.signature, methodNode.exceptions.toArray(new String[0]));
            object.visitCode();
            object.visitVarInsn(25, 0);
            object.visitFieldInsn(180, "skyboy/core/world/WorldServerProxy", "proxiedWorld", "Lnet/minecraft/world/WorldServer;");
            typeArray = Type.getArgumentTypes((String)methodNode.desc);
            int n2 = 1;
            int n3 = typeArray.length;
            for (n = 0; n < n3; ++n) {
                object.visitVarInsn(typeArray[n].getOpcode(21), n2);
                n2 += typeArray[n].getSize();
            }
            object.visitMethodInsn(182, "net/minecraft/world/World", methodNode.name, methodNode.desc, false);
            object.visitInsn(Type.getReturnType((String)methodNode.desc).getOpcode(172));
            object.visitMaxs(1, 1);
            object.visitEnd();
        }
        for (MethodNode methodNode : classNode.methods) {
            Type[] typeArray;
            if (methodNode.name.indexOf(60) == 0 || (methodNode.access & 8) != 0) continue;
            object = classReader2.methods.iterator();
            while (object.hasNext()) {
                typeArray = (Type[])object.next();
                if (!typeArray.name.equals(methodNode.name) || !typeArray.desc.equals(methodNode.desc)) continue;
                object.remove();
            }
            object = classReader2.visitMethod(ASMCore.getAccess(methodNode), methodNode.name, methodNode.desc, methodNode.signature, methodNode.exceptions.toArray(new String[0]));
            object.visitCode();
            object.visitVarInsn(25, 0);
            object.visitFieldInsn(180, "skyboy/core/world/WorldServerProxy", "proxiedWorld", "Lnet/minecraft/world/WorldServer;");
            typeArray = Type.getArgumentTypes((String)methodNode.desc);
            int n4 = 1;
            int n5 = typeArray.length;
            for (n = 0; n < n5; ++n) {
                object.visitVarInsn(typeArray[n].getOpcode(21), n4);
                n4 += typeArray[n].getSize();
            }
            object.visitMethodInsn(182, "net/minecraft/world/WorldServer", methodNode.name, methodNode.desc, false);
            object.visitInsn(Type.getReturnType((String)methodNode.desc).getOpcode(172));
            object.visitMaxs(1, 1);
            object.visitEnd();
        }
        object2 = new ClassWriter(2);
        classReader2.accept((ClassVisitor)object2);
        byArray = object2.toByteArray();
        return byArray;
    }

    private static int getAccess(MethodNode methodNode) {
        int n = methodNode.access;
        n &= 0xFFFFFBA8;
        return n |= 0x1001;
    }

    static boolean implement(ClassNode classNode) {
        if (classNode.visibleAnnotations == null) {
            return false;
        }
        boolean bl = false;
        for (AnnotationNode annotationNode : classNode.visibleAnnotations) {
            AnnotationInfo annotationInfo = ASMCore.parseAnnotation(annotationNode, implementableDesc);
            if (annotationInfo == null || side != annotationInfo.side) continue;
            String[] stringArray = annotationInfo.values;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String string = stringArray[i].trim();
                String string2 = string.replace('.', '/');
                if (classNode.interfaces.contains(string2)) continue;
                try {
                    if (!workingPath.contains(string)) {
                        Class.forName(string, false, ASMCore.class.getClassLoader());
                    }
                    classNode.interfaces.add(string2);
                    bl = true;
                    continue;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        return bl;
    }

    static boolean strip(ClassNode classNode) {
        Iterator iterator;
        AnnotationNode annotationNode2;
        boolean bl = false;
        if (classNode.visibleAnnotations != null) {
            for (AnnotationNode annotationNode2 : classNode.visibleAnnotations) {
                AnnotationInfo annotationInfo = ASMCore.parseAnnotation(annotationNode2, strippableDesc);
                if (annotationInfo == null) continue;
                AnnotationNode annotationNode3 = annotationInfo.values;
                boolean bl2 = side == annotationInfo.side;
                for (AnnotationNode annotationNode4 : annotationNode3) {
                    String string = annotationNode4.replace('.', '/');
                    if (!classNode.interfaces.contains(string)) continue;
                    boolean bl3 = true;
                    try {
                        if (!bl2 && !workingPath.contains(annotationNode4)) {
                            Class.forName((String)annotationNode4, false, ASMCore.class.getClassLoader());
                            bl3 = false;
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (!bl3) continue;
                    classNode.interfaces.remove(string);
                    bl = true;
                }
            }
        }
        if (classNode.methods != null) {
            iterator = classNode.methods.iterator();
            block4: while (iterator.hasNext()) {
                annotationNode2 = (MethodNode)iterator.next();
                if (annotationNode2.visibleAnnotations == null) continue;
                for (AnnotationNode annotationNode3 : annotationNode2.visibleAnnotations) {
                    if (!ASMCore.checkRemove(ASMCore.parseAnnotation(annotationNode3, strippableDesc), iterator)) continue;
                    bl = true;
                    continue block4;
                }
            }
        }
        if (classNode.fields != null) {
            iterator = classNode.fields.iterator();
            block6: while (iterator.hasNext()) {
                annotationNode2 = (FieldNode)iterator.next();
                if (annotationNode2.visibleAnnotations == null) continue;
                for (AnnotationNode annotationNode3 : annotationNode2.visibleAnnotations) {
                    if (!ASMCore.checkRemove(ASMCore.parseAnnotation(annotationNode3, strippableDesc), iterator)) continue;
                    bl = true;
                    continue block6;
                }
            }
        }
        return bl;
    }

    static boolean checkRemove(AnnotationInfo annotationInfo, Iterator<? extends Object> iterator) {
        if (annotationInfo != null) {
            boolean bl;
            boolean bl2 = bl = annotationInfo.side == side;
            if (!bl) {
                for (String string : annotationInfo.values) {
                    block20: {
                        ModContainer modContainer;
                        String string2 = string.substring(4);
                        if (string.startsWith("mod:")) {
                            int n = string2.indexOf(64);
                            if (n > 0) {
                                string = string2.substring(n + 1);
                                string2 = string2.substring(0, n);
                            }
                            boolean bl3 = bl = !Loader.isModLoaded((String)string2);
                            if (!bl && n > 0) {
                                modContainer = ASMCore.getLoadedMods().get(string2);
                                try {
                                    if (Boolean.parseBoolean((String)modContainer.getCustomModProperties().get("cofhversion"))) {
                                        bl = !ModRange.createFromVersionSpec(string2, string).containsVersion((ArtifactVersion)new ModVersion(string2, modContainer.getVersion()));
                                        break block20;
                                    }
                                    bl = !VersionRange.createFromVersionSpec((String)string).containsVersion(modContainer.getProcessedVersion());
                                }
                                catch (InvalidVersionSpecificationException invalidVersionSpecificationException) {
                                    bl = true;
                                }
                            }
                        } else if (string.startsWith("api:")) {
                            int n = string2.indexOf(64);
                            if (n > 0) {
                                string = string2.substring(n + 1);
                                string2 = string2.substring(0, n);
                            }
                            boolean bl4 = bl = !ModAPIManager.INSTANCE.hasAPI(string2);
                            if (!bl && n > 0) {
                                modContainer = ASMCore.getLoadedAPIs().get(string2);
                                try {
                                    bl = !VersionRange.createFromVersionSpec((String)string).containsVersion(modContainer.getProcessedVersion());
                                }
                                catch (InvalidVersionSpecificationException invalidVersionSpecificationException) {
                                    bl = true;
                                }
                            }
                        } else {
                            try {
                                if (!workingPath.contains(string)) {
                                    Class.forName(string, false, ASMCore.class.getClassLoader());
                                }
                            }
                            catch (Throwable throwable) {
                                bl = true;
                            }
                        }
                    }
                    if (bl) break;
                }
            }
            if (bl) {
                iterator.remove();
                return true;
            }
        }
        return false;
    }

    static Map<String, ModContainer> getLoadedMods() {
        if (mods == null) {
            mods = new HashMap<String, ModContainer>();
            for (ModContainer modContainer : Loader.instance().getModList()) {
                mods.put(modContainer.getModId(), modContainer);
            }
        }
        return mods;
    }

    static Map<String, ModContainer> getLoadedAPIs() {
        if (apis == null) {
            apis = new HashMap<String, ModContainer>();
            for (ModContainer modContainer : ModAPIManager.INSTANCE.getAPIList()) {
                apis.put(modContainer.getModId(), modContainer);
            }
        }
        return apis;
    }

    static AnnotationInfo parseAnnotation(AnnotationNode annotationNode, String string) {
        AnnotationInfo annotationInfo = null;
        if (annotationNode.desc.equals(string)) {
            annotationInfo = new AnnotationInfo();
            if (annotationNode.values != null) {
                List list = annotationNode.values;
                int n = 0;
                int n2 = list.size();
                while (n < n2) {
                    String string2;
                    Object e = list.get(n++);
                    Object e2 = list.get(n++);
                    if ("value".equals(e)) {
                        if (!(e2 instanceof List) || ((List)e2).size() <= 0 || !(((List)e2).get(0) instanceof String)) continue;
                        annotationInfo.values = ((List)e2).toArray(emptyList);
                        continue;
                    }
                    if (!"side".equals(e) || !(e2 instanceof String[]) || (string2 = ((String[])e2)[1]) == null) continue;
                    annotationInfo.side = string2.toUpperCase().intern();
                }
            }
        }
        return annotationInfo;
    }

    static void scrapeData(ASMDataTable aSMDataTable) {
        String string;
        log.debug("Scraping data");
        side = FMLCommonHandler.instance().getSide().toString().toUpperCase().intern();
        for (ASMDataTable.ASMData aSMData : aSMDataTable.getAll(Implementable.class.getName())) {
            string = aSMData.getClassName();
            parsables.add((Object)string);
            parsables.add((Object)(string + "$class"));
            implementables.add((Object)string);
            implementables.add((Object)(string + "$class"));
        }
        for (ASMDataTable.ASMData aSMData : aSMDataTable.getAll(Strippable.class.getName())) {
            string = aSMData.getClassName();
            parsables.add((Object)string);
            parsables.add((Object)(string + "$class"));
            strippables.add((Object)string);
            strippables.add((Object)(string + "$class"));
        }
        log.debug("Found " + implementables.size() + " @Implementable and " + strippables.size() + " @Strippable");
    }

    static /* synthetic */ String[] access$000() {
        return emptyList;
    }

    static {
        implementableDesc = Type.getDescriptor(Implementable.class);
        strippableDesc = Type.getDescriptor(Strippable.class);
        parsables = new THashSet(10);
        implementables = new THashSet(10);
        strippables = new THashSet(10);
        hashes.put((Object)"net.minecraft.world.WorldServer", (byte)1);
        hashes.put((Object)"net.minecraft.world.World", (byte)2);
        hashes.put((Object)"skyboy.core.world.WorldProxy", (byte)3);
        hashes.put((Object)"skyboy.core.world.WorldServerProxy", (byte)4);
        hashes.put((Object)"net.minecraft.block.BlockPane", (byte)5);
        hashes.put((Object)"net.minecraft.inventory.Container", (byte)6);
        hashes.put((Object)"net.minecraft.client.multiplayer.PlayerControllerMP", (byte)7);
        hashes.put((Object)"net.minecraft.util.LongHashMap", (byte)8);
        if (Boolean.parseBoolean(System.getProperty("cofh.lightedit", "true"))) {
            hashes.put((Object)"net.minecraft.world.chunk.Chunk", (byte)9);
        }
        hashes.put((Object)"net.minecraft.client.Minecraft", (byte)10);
        hashes.put((Object)"net.minecraft.client.renderer.RenderBlocks", (byte)11);
        hashes.put((Object)"net.minecraft.tileentity.TileEntity", (byte)12);
        hashes.put((Object)"net.minecraft.server.management.PlayerManager$PlayerInstance", (byte)13);
        hashes.put((Object)"net.minecraft.entity.Entity", (byte)14);
        hashes.put((Object)"net.minecraft.entity.item.EntityItem", (byte)15);
        workingPath = new ArrayList();
        emptyList = new String[0];
    }

    static class AnnotationInfo {
        public String side;
        public String[] values = ASMCore.access$000();

        AnnotationInfo() {
        }
    }
}

