/*
 * Decompiled with CFR 0.152.
 */
package cofh.api.transport;

import cofh.api.transport.IEnderAttuned;
import cofh.api.transport.IEnderEnergyHandler;
import cofh.api.transport.IEnderFluidHandler;
import cofh.api.transport.IEnderItemHandler;
import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraftforge.common.config.Configuration;

public final class RegistryEnderAttuned {
    public static Map<String, Map<Integer, List<IEnderItemHandler>>> inputItem = new THashMap();
    public static Map<String, Map<Integer, List<IEnderFluidHandler>>> inputFluid = new THashMap();
    public static Map<String, Map<Integer, List<IEnderEnergyHandler>>> inputEnergy = new THashMap();
    public static Map<String, Map<Integer, List<IEnderItemHandler>>> outputItem = new THashMap();
    public static Map<String, Map<Integer, List<IEnderFluidHandler>>> outputFluid = new THashMap();
    public static Map<String, Map<Integer, List<IEnderEnergyHandler>>> outputEnergy = new THashMap();
    public static Configuration linkConf;
    public static Map<String, String> clientFrequencyNames;
    public static Map<String, String> clientFrequencyNamesReversed;

    public static void clear() {
        inputItem.clear();
        inputFluid.clear();
        inputEnergy.clear();
        outputItem.clear();
        outputFluid.clear();
        outputEnergy.clear();
    }

    public static List<IEnderItemHandler> getLinkedItemInputs(IEnderItemHandler iEnderItemHandler) {
        if (inputItem.get(iEnderItemHandler.getChannelString()) == null) {
            return null;
        }
        return inputItem.get(iEnderItemHandler.getChannelString()).get(iEnderItemHandler.getFrequency());
    }

    public static List<IEnderItemHandler> getLinkedItemOutputs(IEnderItemHandler iEnderItemHandler) {
        if (outputItem.get(iEnderItemHandler.getChannelString()) == null) {
            return null;
        }
        return outputItem.get(iEnderItemHandler.getChannelString()).get(iEnderItemHandler.getFrequency());
    }

    public static List<IEnderFluidHandler> getLinkedFluidInputs(IEnderFluidHandler iEnderFluidHandler) {
        if (inputFluid.get(iEnderFluidHandler.getChannelString()) == null) {
            return null;
        }
        return inputFluid.get(iEnderFluidHandler.getChannelString()).get(iEnderFluidHandler.getFrequency());
    }

    public static List<IEnderFluidHandler> getLinkedFluidOutputs(IEnderFluidHandler iEnderFluidHandler) {
        if (outputFluid.get(iEnderFluidHandler.getChannelString()) == null) {
            return null;
        }
        return outputFluid.get(iEnderFluidHandler.getChannelString()).get(iEnderFluidHandler.getFrequency());
    }

    public static List<IEnderEnergyHandler> getLinkedEnergyInputs(IEnderEnergyHandler iEnderEnergyHandler) {
        if (inputEnergy.get(iEnderEnergyHandler.getChannelString()) == null) {
            return null;
        }
        return inputEnergy.get(iEnderEnergyHandler.getChannelString()).get(iEnderEnergyHandler.getFrequency());
    }

    public static List<IEnderEnergyHandler> getLinkedEnergyOutputs(IEnderEnergyHandler iEnderEnergyHandler) {
        if (outputEnergy.get(iEnderEnergyHandler.getChannelString()) == null) {
            return null;
        }
        return outputEnergy.get(iEnderEnergyHandler.getChannelString()).get(iEnderEnergyHandler.getFrequency());
    }

    public static void addItemHandler(IEnderItemHandler iEnderItemHandler) {
        if (iEnderItemHandler.canSendItems()) {
            if (inputItem.get(iEnderItemHandler.getChannelString()) == null) {
                inputItem.put(iEnderItemHandler.getChannelString(), new HashMap());
            }
            if (inputItem.get(iEnderItemHandler.getChannelString()).get(iEnderItemHandler.getFrequency()) == null) {
                inputItem.get(iEnderItemHandler.getChannelString()).put(iEnderItemHandler.getFrequency(), new ArrayList());
            }
            if (!inputItem.get(iEnderItemHandler.getChannelString()).get(iEnderItemHandler.getFrequency()).contains(iEnderItemHandler)) {
                inputItem.get(iEnderItemHandler.getChannelString()).get(iEnderItemHandler.getFrequency()).add(iEnderItemHandler);
            }
        }
        if (iEnderItemHandler.canReceiveItems()) {
            if (outputItem.get(iEnderItemHandler.getChannelString()) == null) {
                outputItem.put(iEnderItemHandler.getChannelString(), new HashMap());
            }
            if (outputItem.get(iEnderItemHandler.getChannelString()).get(iEnderItemHandler.getFrequency()) == null) {
                outputItem.get(iEnderItemHandler.getChannelString()).put(iEnderItemHandler.getFrequency(), new ArrayList());
            }
            if (!outputItem.get(iEnderItemHandler.getChannelString()).get(iEnderItemHandler.getFrequency()).contains(iEnderItemHandler)) {
                outputItem.get(iEnderItemHandler.getChannelString()).get(iEnderItemHandler.getFrequency()).add(iEnderItemHandler);
            }
        }
    }

    public static void addFluidHandler(IEnderFluidHandler iEnderFluidHandler) {
        if (iEnderFluidHandler.canSendFluid()) {
            if (inputFluid.get(iEnderFluidHandler.getChannelString()) == null) {
                inputFluid.put(iEnderFluidHandler.getChannelString(), new HashMap());
            }
            if (inputFluid.get(iEnderFluidHandler.getChannelString()).get(iEnderFluidHandler.getFrequency()) == null) {
                inputFluid.get(iEnderFluidHandler.getChannelString()).put(iEnderFluidHandler.getFrequency(), new ArrayList());
            }
            if (!inputFluid.get(iEnderFluidHandler.getChannelString()).get(iEnderFluidHandler.getFrequency()).contains(iEnderFluidHandler)) {
                inputFluid.get(iEnderFluidHandler.getChannelString()).get(iEnderFluidHandler.getFrequency()).add(iEnderFluidHandler);
            }
        }
        if (iEnderFluidHandler.canReceiveFluid()) {
            if (outputFluid.get(iEnderFluidHandler.getChannelString()) == null) {
                outputFluid.put(iEnderFluidHandler.getChannelString(), new HashMap());
            }
            if (outputFluid.get(iEnderFluidHandler.getChannelString()).get(iEnderFluidHandler.getFrequency()) == null) {
                outputFluid.get(iEnderFluidHandler.getChannelString()).put(iEnderFluidHandler.getFrequency(), new ArrayList());
            }
            if (!outputFluid.get(iEnderFluidHandler.getChannelString()).get(iEnderFluidHandler.getFrequency()).contains(iEnderFluidHandler)) {
                outputFluid.get(iEnderFluidHandler.getChannelString()).get(iEnderFluidHandler.getFrequency()).add(iEnderFluidHandler);
            }
        }
    }

    public static void addEnergyHandler(IEnderEnergyHandler iEnderEnergyHandler) {
        if (iEnderEnergyHandler.canSendEnergy()) {
            if (inputEnergy.get(iEnderEnergyHandler.getChannelString()) == null) {
                inputEnergy.put(iEnderEnergyHandler.getChannelString(), new HashMap());
            }
            if (inputEnergy.get(iEnderEnergyHandler.getChannelString()).get(iEnderEnergyHandler.getFrequency()) == null) {
                inputEnergy.get(iEnderEnergyHandler.getChannelString()).put(iEnderEnergyHandler.getFrequency(), new ArrayList());
            }
            if (!inputEnergy.get(iEnderEnergyHandler.getChannelString()).get(iEnderEnergyHandler.getFrequency()).contains(iEnderEnergyHandler)) {
                inputEnergy.get(iEnderEnergyHandler.getChannelString()).get(iEnderEnergyHandler.getFrequency()).add(iEnderEnergyHandler);
            }
        }
        if (iEnderEnergyHandler.canReceiveEnergy()) {
            if (outputEnergy.get(iEnderEnergyHandler.getChannelString()) == null) {
                outputEnergy.put(iEnderEnergyHandler.getChannelString(), new HashMap());
            }
            if (outputEnergy.get(iEnderEnergyHandler.getChannelString()).get(iEnderEnergyHandler.getFrequency()) == null) {
                outputEnergy.get(iEnderEnergyHandler.getChannelString()).put(iEnderEnergyHandler.getFrequency(), new ArrayList());
            }
            if (!outputEnergy.get(iEnderEnergyHandler.getChannelString()).get(iEnderEnergyHandler.getFrequency()).contains(iEnderEnergyHandler)) {
                outputEnergy.get(iEnderEnergyHandler.getChannelString()).get(iEnderEnergyHandler.getFrequency()).add(iEnderEnergyHandler);
            }
        }
    }

    public static void removeItemHandler(IEnderItemHandler iEnderItemHandler) {
        if (inputItem.get(iEnderItemHandler.getChannelString()) != null && inputItem.get(iEnderItemHandler.getChannelString()).get(iEnderItemHandler.getFrequency()) != null) {
            inputItem.get(iEnderItemHandler.getChannelString()).get(iEnderItemHandler.getFrequency()).remove(iEnderItemHandler);
            if (inputItem.get(iEnderItemHandler.getChannelString()).get(iEnderItemHandler.getFrequency()).size() == 0) {
                inputItem.get(iEnderItemHandler.getChannelString()).remove(iEnderItemHandler.getFrequency());
            }
        }
        if (outputItem.get(iEnderItemHandler.getChannelString()) != null && outputItem.get(iEnderItemHandler.getChannelString()).get(iEnderItemHandler.getFrequency()) != null) {
            outputItem.get(iEnderItemHandler.getChannelString()).get(iEnderItemHandler.getFrequency()).remove(iEnderItemHandler);
            if (outputItem.get(iEnderItemHandler.getChannelString()).get(iEnderItemHandler.getFrequency()).size() == 0) {
                outputItem.get(iEnderItemHandler.getChannelString()).remove(iEnderItemHandler.getFrequency());
            }
        }
    }

    public static void removeFluidHandler(IEnderFluidHandler iEnderFluidHandler) {
        if (inputFluid.get(iEnderFluidHandler.getChannelString()) != null && inputFluid.get(iEnderFluidHandler.getChannelString()).get(iEnderFluidHandler.getFrequency()) != null) {
            inputFluid.get(iEnderFluidHandler.getChannelString()).get(iEnderFluidHandler.getFrequency()).remove(iEnderFluidHandler);
            if (inputFluid.get(iEnderFluidHandler.getChannelString()).get(iEnderFluidHandler.getFrequency()).size() == 0) {
                inputFluid.get(iEnderFluidHandler.getChannelString()).remove(iEnderFluidHandler.getFrequency());
            }
        }
        if (outputFluid.get(iEnderFluidHandler.getChannelString()) != null && outputFluid.get(iEnderFluidHandler.getChannelString()).get(iEnderFluidHandler.getFrequency()) != null) {
            outputFluid.get(iEnderFluidHandler.getChannelString()).get(iEnderFluidHandler.getFrequency()).remove(iEnderFluidHandler);
            if (outputFluid.get(iEnderFluidHandler.getChannelString()).get(iEnderFluidHandler.getFrequency()).size() == 0) {
                outputFluid.get(iEnderFluidHandler.getChannelString()).remove(iEnderFluidHandler.getFrequency());
            }
        }
    }

    public static void removeEnergyHandler(IEnderEnergyHandler iEnderEnergyHandler) {
        if (inputEnergy.get(iEnderEnergyHandler.getChannelString()) != null && inputEnergy.get(iEnderEnergyHandler.getChannelString()).get(iEnderEnergyHandler.getFrequency()) != null) {
            inputEnergy.get(iEnderEnergyHandler.getChannelString()).get(iEnderEnergyHandler.getFrequency()).remove(iEnderEnergyHandler);
            if (inputEnergy.get(iEnderEnergyHandler.getChannelString()).get(iEnderEnergyHandler.getFrequency()).size() == 0) {
                inputEnergy.get(iEnderEnergyHandler.getChannelString()).remove(iEnderEnergyHandler.getFrequency());
            }
        }
        if (outputEnergy.get(iEnderEnergyHandler.getChannelString()) != null && outputEnergy.get(iEnderEnergyHandler.getChannelString()).get(iEnderEnergyHandler.getFrequency()) != null) {
            outputEnergy.get(iEnderEnergyHandler.getChannelString()).get(iEnderEnergyHandler.getFrequency()).remove(iEnderEnergyHandler);
            if (outputEnergy.get(iEnderEnergyHandler.getChannelString()).get(iEnderEnergyHandler.getFrequency()).size() == 0) {
                outputEnergy.get(iEnderEnergyHandler.getChannelString()).remove(iEnderEnergyHandler.getFrequency());
            }
        }
    }

    public static void add(IEnderAttuned iEnderAttuned) {
        if (iEnderAttuned instanceof IEnderItemHandler) {
            RegistryEnderAttuned.addItemHandler((IEnderItemHandler)iEnderAttuned);
        }
        if (iEnderAttuned instanceof IEnderFluidHandler) {
            RegistryEnderAttuned.addFluidHandler((IEnderFluidHandler)iEnderAttuned);
        }
        if (iEnderAttuned instanceof IEnderEnergyHandler) {
            RegistryEnderAttuned.addEnergyHandler((IEnderEnergyHandler)iEnderAttuned);
        }
    }

    public static void remove(IEnderAttuned iEnderAttuned) {
        if (iEnderAttuned instanceof IEnderItemHandler) {
            RegistryEnderAttuned.removeItemHandler((IEnderItemHandler)iEnderAttuned);
        }
        if (iEnderAttuned instanceof IEnderFluidHandler) {
            RegistryEnderAttuned.removeFluidHandler((IEnderFluidHandler)iEnderAttuned);
        }
        if (iEnderAttuned instanceof IEnderEnergyHandler) {
            RegistryEnderAttuned.removeEnergyHandler((IEnderEnergyHandler)iEnderAttuned);
        }
    }

    public static void sortClientNames() {
        ArrayList<Map.Entry<String, String>> arrayList = new ArrayList<Map.Entry<String, String>>(clientFrequencyNames.entrySet());
        Collections.sort(arrayList, new Comparator<Map.Entry<String, String>>(){

            @Override
            public int compare(Map.Entry<String, String> entry, Map.Entry<String, String> entry2) {
                int n;
                int n2 = Integer.valueOf(clientFrequencyNamesReversed.get(entry.getValue()));
                return n2 > (n = Integer.valueOf(clientFrequencyNamesReversed.get(entry2.getValue())).intValue()) ? 1 : (n2 == n ? 0 : -1);
            }
        });
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        for (Map.Entry entry : arrayList) {
            linkedHashMap.put((String)entry.getKey(), (String)entry.getValue());
        }
        clientFrequencyNames = linkedHashMap;
    }

    public static void clearClientNames() {
        clientFrequencyNames.clear();
        clientFrequencyNamesReversed.clear();
    }

    public static void addClientNames(String string, String string2) {
        if (!string.isEmpty()) {
            clientFrequencyNames.put(string, string2);
            clientFrequencyNamesReversed.put(string2, string);
        }
    }

    static {
        clientFrequencyNames = new LinkedHashMap<String, String>();
        clientFrequencyNamesReversed = new LinkedHashMap<String, String>();
    }
}

