/*
 * Decompiled with CFR 0.152.
 */
package iguanaman.iguanatweakstconstruct.tweaks;

import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import iguanaman.iguanatweakstconstruct.reference.Config;
import iguanaman.iguanatweakstconstruct.tweaks.PartCraftingRecipe;
import iguanaman.iguanatweakstconstruct.tweaks.RepairCraftingRecipe;
import iguanaman.iguanatweakstconstruct.tweaks.ToolCraftingRecipe;
import iguanaman.iguanatweakstconstruct.tweaks.handlers.CastHandler;
import iguanaman.iguanatweakstconstruct.tweaks.handlers.FlintHandler;
import iguanaman.iguanatweakstconstruct.tweaks.handlers.StoneToolHandler;
import iguanaman.iguanatweakstconstruct.tweaks.handlers.StringBindingHandler;
import iguanaman.iguanatweakstconstruct.tweaks.handlers.VanillaBowNerfHandler;
import iguanaman.iguanatweakstconstruct.tweaks.handlers.VanillaHoeNerfHandler;
import iguanaman.iguanatweakstconstruct.tweaks.handlers.VanillaSwordNerfHandler;
import iguanaman.iguanatweakstconstruct.tweaks.handlers.VanillaToolNerfHandler;
import iguanaman.iguanatweakstconstruct.tweaks.modifiers.ModFluxExpensive;
import iguanaman.iguanatweakstconstruct.tweaks.modifiers.ModLimitedToolRepair;
import iguanaman.iguanatweakstconstruct.util.Log;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import mantle.pulsar.pulse.Handler;
import mantle.pulsar.pulse.Pulse;
import mantle.utils.RecipeRemover;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.oredict.ShapedOreRecipe;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.client.TConstructClientRegistry;
import tconstruct.library.crafting.ModifyBuilder;
import tconstruct.library.crafting.PatternBuilder;
import tconstruct.library.crafting.StencilBuilder;
import tconstruct.library.crafting.ToolBuilder;
import tconstruct.library.modifier.ItemModifier;
import tconstruct.library.util.IPattern;
import tconstruct.modifiers.tools.ModExtraModifier;
import tconstruct.modifiers.tools.ModFlux;
import tconstruct.modifiers.tools.ModToolRepair;
import tconstruct.tools.TinkerTools;
import tconstruct.world.TinkerWorld;

@Pulse(id="Tweaks", description="Various Tweaks for vanilla Minecraft and Tinker's Construct. See Config.")
public class IguanaTweaks {
    public static Set<Item> toolWhitelist = new HashSet<Item>();

    @Handler
    public void postInit(FMLPostInitializationEvent event) {
        this.flintTweaks();
        if (Config.allowStringBinding) {
            Log.info("Register String binding");
            TConstructRegistry.addToolMaterial((int)40, (String)"String", (int)0, (int)33, (int)1, (int)0, (float)0.01f, (int)0, (float)0.0f, (String)EnumChatFormatting.WHITE.toString(), (int)0xFFFFFF);
            TConstructClientRegistry.addMaterialRenderMapping((int)40, (String)"tinker", (String)"paper", (boolean)true);
            MinecraftForge.EVENT_BUS.register((Object)new StringBindingHandler());
        }
        if (Config.allowStencilReuse) {
            Log.info("Make stencils reusable");
            for (ItemStack stack : StencilBuilder.getStencils()) {
                StencilBuilder.registerBlankStencil((ItemStack)stack);
            }
        }
        if (Config.castsBurnMaterial) {
            Log.info("Burn casting materials to a crisp");
            MinecraftForge.EVENT_BUS.register((Object)new CastHandler());
        }
        if (Config.allowPartReuse) {
            this.reusableToolParts();
        }
        if (Config.disableStoneTools) {
            Log.info("Disabling tinkers stone tools");
            MinecraftForge.EVENT_BUS.register((Object)new StoneToolHandler());
            ChestGenHooks.removeItem((String)"bonusChest", (ItemStack)new ItemStack(Items.field_151049_t));
            ChestGenHooks.removeItem((String)"bonusChest", (ItemStack)new ItemStack(Items.field_151050_s));
        }
        if (Config.nerfVanillaTools) {
            IguanaTweaks.findToolsFromConfig();
            Log.info("Sticks and stones may break my bones, but your pickaxes and axes will break no blocks.");
            MinecraftForge.EVENT_BUS.register((Object)new VanillaToolNerfHandler());
            ChestGenHooks.removeItem((String)"bonusChest", (ItemStack)new ItemStack(Items.field_151039_o));
            ChestGenHooks.removeItem((String)"bonusChest", (ItemStack)new ItemStack(Items.field_151053_p));
            ItemStack starterPick = ToolBuilder.instance.buildTool(new ItemStack(TinkerTools.pickaxeHead, 1, 0), new ItemStack(TinkerTools.toolRod, 1, 0), new ItemStack(TinkerTools.binding, 1, 0), "Starter Pickaxe");
            ItemStack starterAxe = ToolBuilder.instance.buildTool(new ItemStack(TinkerTools.hatchetHead, 1, 0), new ItemStack(TinkerTools.toolRod, 1, 0), null, "Starter Hatchet");
            if (starterPick != null) {
                ChestGenHooks.addItem((String)"bonusChest", (WeightedRandomChestContent)new WeightedRandomChestContent(starterPick, 1, 1, 5));
            }
            if (starterAxe != null) {
                ChestGenHooks.addItem((String)"bonusChest", (WeightedRandomChestContent)new WeightedRandomChestContent(starterAxe, 1, 1, 5));
            }
            if (!Config.disableStoneTools) {
                ChestGenHooks.removeItem((String)"bonusChest", (ItemStack)new ItemStack(Items.field_151049_t));
                ChestGenHooks.removeItem((String)"bonusChest", (ItemStack)new ItemStack(Items.field_151050_s));
                ItemStack stonePick = ToolBuilder.instance.buildTool(new ItemStack(TinkerTools.pickaxeHead, 1, 1), new ItemStack(TinkerTools.toolRod, 1, 0), new ItemStack(TinkerTools.binding, 1, 0), "");
                ItemStack stoneAxe = ToolBuilder.instance.buildTool(new ItemStack(TinkerTools.hatchetHead, 1, 1), new ItemStack(TinkerTools.toolRod, 1, 0), null, "");
                if (stonePick != null) {
                    ChestGenHooks.addItem((String)"bonusChest", (WeightedRandomChestContent)new WeightedRandomChestContent(stonePick, 1, 1, 5));
                }
                if (stoneAxe != null) {
                    ChestGenHooks.addItem((String)"bonusChest", (WeightedRandomChestContent)new WeightedRandomChestContent(stoneAxe, 1, 1, 5));
                }
            }
        }
        if (Config.nerfVanillaHoes) {
            Log.info("Vanilla hoe? More like vanilla go!");
            MinecraftForge.EVENT_BUS.register((Object)new VanillaHoeNerfHandler());
        }
        if (Config.nerfVanillaSwords) {
            Log.info("Replacing swords with pasta");
            MinecraftForge.EVENT_BUS.register((Object)new VanillaSwordNerfHandler());
        }
        if (Config.nerfVanillaBows) {
            Log.info("Sabotaging bows");
            MinecraftForge.EVENT_BUS.register((Object)new VanillaBowNerfHandler());
        }
        if (Config.removeStoneTorchRecipe) {
            Log.info("Removing stone torch recipe");
            RecipeRemover.removeAnyRecipe((ItemStack)new ItemStack(TinkerWorld.stoneTorch, 4));
        }
        if (Config.moreExpensiveSilkyCloth) {
            Log.info("Making Silky Cloth more expensive");
            RecipeRemover.removeAnyRecipe((ItemStack)new ItemStack(TinkerTools.materials, 1, 25));
            String[] patSurround = new String[]{"###", "#m#", "###"};
            GameRegistry.addRecipe((ItemStack)new ItemStack(TinkerTools.materials, 1, 25), (Object[])new Object[]{patSurround, Character.valueOf('m'), new ItemStack(TinkerTools.materials, 1, 14), Character.valueOf('#'), new ItemStack(Items.field_151007_F)});
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(TinkerTools.materials, 1, 25), new Object[]{patSurround, Character.valueOf('m'), "ingotGold", Character.valueOf('#'), new ItemStack(Items.field_151007_F)}));
        }
        if (Config.moreExpensiveSilkyJewel) {
            Log.info("Making Silky Jewel more expensive");
            RecipeRemover.removeAnyRecipe((ItemStack)new ItemStack(TinkerTools.materials, 1, 26));
            GameRegistry.addRecipe((ItemStack)new ItemStack(TinkerTools.materials, 1, 26), (Object[])new Object[]{" c ", "cec", " c ", Character.valueOf('c'), new ItemStack(TinkerTools.materials, 1, 25), Character.valueOf('e'), new ItemStack(Item.func_150898_a((Block)Blocks.field_150475_bE))});
        }
        if (Config.moreModifiersForFlux) {
            this.exchangeFluxModifier();
        }
        if (Config.disableBonusMods) {
            this.removeBonusModifierModifiers();
        }
        if (Config.maxToolRepairs > -1) {
            this.limitToolRepair();
        }
        if (Config.easyToolRepair) {
            GameRegistry.addRecipe((IRecipe)new RepairCraftingRecipe());
        }
        if (Config.easyPartCrafting) {
            GameRegistry.addRecipe((IRecipe)new PartCraftingRecipe());
        }
        if (Config.easyToolBuilding) {
            GameRegistry.addRecipe((IRecipe)new ToolCraftingRecipe());
        }
    }

    private void flintTweaks() {
        if (Config.removeFlintDrop) {
            Log.info("Removing Flint drops from Gravel");
            MinecraftForge.EVENT_BUS.register((Object)new FlintHandler());
        }
        if (Config.addFlintRecipe) {
            Log.info("Adding shapeless Flint recipe from " + Config.recipeGravelPerFlint + " Gravel");
            Object[] recipe = new ItemStack[Config.recipeGravelPerFlint];
            for (int i = 0; i < Config.recipeGravelPerFlint; ++i) {
                recipe[i] = new ItemStack(Blocks.field_150351_n);
            }
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(Items.field_151145_ak), (Object[])recipe);
        }
    }

    private void reusableToolParts() {
        Log.info("Registering reusable tool parts");
        for (Map.Entry entry : TConstructRegistry.patternPartMapping.entrySet()) {
            Item pattern = (Item)((List)entry.getKey()).get(0);
            Integer meta = (Integer)((List)entry.getKey()).get(1);
            Integer matID = (Integer)((List)entry.getKey()).get(2);
            ItemStack toolPart = (ItemStack)entry.getValue();
            int cost = ((IPattern)pattern).getPatternCost(new ItemStack(pattern, 1, meta.intValue()));
            if (cost <= 0) continue;
            PatternBuilder.instance.registerMaterial(toolPart, cost, TConstructRegistry.getMaterial((int)matID.intValue()).materialName);
        }
    }

    private void exchangeFluxModifier() {
        List mods = ModifyBuilder.instance.itemModifiers;
        ListIterator<ModFluxExpensive> iter = mods.listIterator();
        while (iter.hasNext()) {
            ItemModifier mod = (ItemModifier)iter.next();
            if (!(mod instanceof ModFlux)) continue;
            iter.set(new ModFluxExpensive(((ModFlux)mod).batteries));
            Log.trace("Replaced Flux Modifier to make it more expensive");
        }
    }

    private void removeBonusModifierModifiers() {
        Log.info("Removing bonus modifier modifiers");
        List mods = ModifyBuilder.instance.itemModifiers;
        ListIterator iter = mods.listIterator();
        while (iter.hasNext()) {
            ItemModifier mod = (ItemModifier)iter.next();
            if (!(mod instanceof ModExtraModifier)) continue;
            iter.remove();
        }
    }

    private void limitToolRepair() {
        List mods = ModifyBuilder.instance.itemModifiers;
        ListIterator<ModLimitedToolRepair> iter = mods.listIterator();
        while (iter.hasNext()) {
            ItemModifier mod = (ItemModifier)iter.next();
            if (!(mod instanceof ModToolRepair)) continue;
            iter.set(new ModLimitedToolRepair());
            Log.trace("Replaced Tool Repair Modifier to limit the maximum amount of repairs");
        }
    }

    private static void findToolsFromConfig() {
        Log.info("Setting up whitelist/blacklist for allowed tools");
        for (Object identifier : Item.field_150901_e.func_148742_b()) {
            Object item = Item.field_150901_e.func_82594_a(identifier);
            if (!(item instanceof ItemTool) && !(item instanceof ItemHoe) && !(item instanceof ItemSword) && !(item instanceof ItemBow)) continue;
            String mod = identifier.toString().split(":")[0];
            if (Config.excludedToolsIsWhitelist) {
                if (!Config.excludedModTools.contains(mod) && !Config.excludedTools.contains(identifier)) continue;
                toolWhitelist.add((Item)item);
                continue;
            }
            if (Config.excludedModTools.contains(mod) || Config.excludedTools.contains(identifier)) continue;
            toolWhitelist.add((Item)item);
        }
    }
}

