/*
 * Decompiled with CFR 0.152.
 */
package iguanaman.iguanatweakstconstruct.replacing;

import iguanaman.iguanatweakstconstruct.leveling.LevelingLogic;
import iguanaman.iguanatweakstconstruct.leveling.modifiers.ModXpAwareRedstone;
import iguanaman.iguanatweakstconstruct.reference.Config;
import iguanaman.iguanatweakstconstruct.util.Log;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.crafting.ModifyBuilder;
import tconstruct.library.crafting.ToolBuilder;
import tconstruct.library.crafting.ToolRecipe;
import tconstruct.library.modifier.ItemModifier;
import tconstruct.library.tools.ToolCore;
import tconstruct.library.tools.ToolMaterial;
import tconstruct.modifiers.tools.ModAttack;
import tconstruct.modifiers.tools.ModRedstone;

public final class ReplacementLogic {
    private ReplacementLogic() {
    }

    public static void exchangeToolPart(ToolCore tool, NBTTagCompound tags, PartTypes type, ItemStack partStack, ItemStack toolStack) {
        float xp;
        ItemStack originalTool;
        ItemStack headStack = null;
        ItemStack handleStack = null;
        ItemStack accessoryStack = null;
        ItemStack extraStack = null;
        if (ReplacementLogic.getPart(tool, PartTypes.HEAD) != null) {
            headStack = new ItemStack(ReplacementLogic.getPart(tool, PartTypes.HEAD), 1, ReplacementLogic.getToolPartMaterial(tags, PartTypes.HEAD));
        }
        if (ReplacementLogic.getPart(tool, PartTypes.HANDLE) != null) {
            handleStack = new ItemStack(ReplacementLogic.getPart(tool, PartTypes.HANDLE), 1, ReplacementLogic.getToolPartMaterial(tags, PartTypes.HANDLE));
        }
        if (ReplacementLogic.getPart(tool, PartTypes.ACCESSORY) != null) {
            accessoryStack = new ItemStack(ReplacementLogic.getPart(tool, PartTypes.ACCESSORY), 1, ReplacementLogic.getToolPartMaterial(tags, PartTypes.ACCESSORY));
        }
        if (ReplacementLogic.getPart(tool, PartTypes.EXTRA) != null) {
            extraStack = new ItemStack(ReplacementLogic.getPart(tool, PartTypes.EXTRA), 1, ReplacementLogic.getToolPartMaterial(tags, PartTypes.EXTRA));
        }
        if ((originalTool = ToolBuilder.instance.buildTool(headStack, handleStack, accessoryStack, extraStack, "Original Tool")) == null) {
            Log.error("Tool to modify is impossible?");
            return;
        }
        if (type == PartTypes.HEAD && headStack != null) {
            headStack = partStack;
        }
        if (type == PartTypes.HANDLE && handleStack != null) {
            handleStack = partStack;
        }
        if (type == PartTypes.ACCESSORY && accessoryStack != null) {
            accessoryStack = partStack;
        }
        if (type == PartTypes.EXTRA && extraStack != null) {
            extraStack = partStack;
        }
        ItemStack newTool = ToolBuilder.instance.buildTool(headStack, handleStack, accessoryStack, extraStack, "Modified Tool");
        NBTTagCompound newTags = newTool.func_77978_p().func_74775_l("InfiTool");
        int partMaterialId = ReplacementLogic.getToolPartMaterial(newTags, type);
        int oldMaterialId = ReplacementLogic.getToolPartMaterial(tags, type);
        long oldRequiredXp = LevelingLogic.getRequiredXp(toolStack, tags);
        long oldRequiredBoostXp = LevelingLogic.getRequiredBoostXp(toolStack);
        ReplacementLogic.updateTag(newTags, tags, "Head");
        ReplacementLogic.updateTag(newTags, tags, "RenderHead");
        ReplacementLogic.updateTag(newTags, tags, "Handle");
        ReplacementLogic.updateTag(newTags, tags, "RenderHandle");
        ReplacementLogic.updateTag(newTags, tags, "Accessory");
        ReplacementLogic.updateTag(newTags, tags, "RenderAccessory");
        ReplacementLogic.updateTag(newTags, tags, "Extra");
        ReplacementLogic.updateTag(newTags, tags, "RenderExtra");
        int base = newTags.func_74762_e("BaseDurability");
        int bonus = tags.func_74762_e("BonusDurability");
        float modDur = tags.func_74760_g("ModDurability");
        int total = Math.max((int)((float)(base + bonus) * (modDur + 1.0f)), 1);
        tags.func_74768_a("BaseDurability", base);
        tags.func_74768_a("TotalDurability", total);
        ReplacementLogic.updateTag(newTags, tags, "Attack");
        ReplacementLogic.updateTag(newTags, tags, "MiningSpeed");
        ReplacementLogic.updateTag(newTags, tags, "MiningSpeed2");
        ReplacementLogic.updateTag(newTags, tags, "MiningSpeedHandle");
        ReplacementLogic.updateTag(newTags, tags, "MiningSpeedExtra");
        ReplacementLogic.updateTag(newTags, tags, "HarvestLevel");
        ReplacementLogic.updateTag(newTags, tags, "HarvestLevel2");
        ReplacementLogic.updateTag(newTags, tags, "HarvestLevelHandle");
        ReplacementLogic.updateTag(newTags, tags, "HarvestLevelExtra");
        ReplacementLogic.updateTag(newTags, tags, "DrawSpeed");
        ReplacementLogic.updateTag(newTags, tags, "BaseDrawSpeed");
        ReplacementLogic.updateTag(newTags, tags, "Shoddy");
        int currentReinforced = tags.func_74762_e("Unbreaking");
        int oldReinforced = originalTool.func_77978_p().func_74775_l("InfiTool").func_74762_e("Unbreaking");
        int newReinforced = newTags.func_74762_e("Unbreaking");
        tags.func_74768_a("Unbreaking", newReinforced += currentReinforced - oldReinforced);
        ReplacementLogic.handleMaterialTraits(tags, oldMaterialId, partMaterialId);
        ReplacementLogic.reapplyRedstone(tags, toolStack);
        ReplacementLogic.reapplyAttack(tags, toolStack);
        if (Config.removeMobHeadOnPartReplacement && type == PartTypes.HEAD) {
            ReplacementLogic.removeMobHeadModifier(tags);
        }
        if (tags.func_74764_b("GemBoost")) {
            tags.func_82580_o("GemBoost");
        }
        if (LevelingLogic.hasXp(tags)) {
            float newRequiredXp = LevelingLogic.getRequiredXp(toolStack, tags);
            xp = LevelingLogic.getXp(tags);
            xp *= newRequiredXp / (float)oldRequiredXp;
            if (Config.partReplacementXpPenality > 0) {
                xp *= (100.0f - (float)Config.partReplacementXpPenality) / 100.0f;
            }
            tags.func_74768_a("ToolEXP", Math.round(xp));
        }
        if (LevelingLogic.hasBoostXp(tags)) {
            float newRequiredBoostXp = LevelingLogic.getRequiredBoostXp(toolStack);
            xp = LevelingLogic.getBoostXp(tags);
            float percentage = xp / (float)oldRequiredBoostXp;
            xp *= newRequiredBoostXp / (float)oldRequiredBoostXp;
            if (Config.partReplacementBoostXpPenality > 0 && type == PartTypes.HEAD) {
                if (LevelingLogic.isBoosted(tags)) {
                    tags.func_74757_a("HarvestLevelModified", false);
                    xp = newRequiredBoostXp;
                }
                xp *= (100.0f - (float)Config.partReplacementBoostXpPenality) / 100.0f;
            }
            tags.func_74768_a("HeadEXP", Math.round(xp));
            if (LevelingLogic.isBoosted(tags)) {
                tags.func_74768_a("HarvestLevel", tags.func_74762_e("HarvestLevel") + 1);
            }
        } else {
            LevelingLogic.addBoostTags(tags, tool);
        }
        if (type == PartTypes.HEAD) {
            String defaultName = ToolBuilder.defaultToolName((ToolMaterial)TConstructRegistry.getMaterial((int)oldMaterialId), (ToolCore)tool);
            if (toolStack.func_82833_r().endsWith(defaultName)) {
                defaultName = ToolBuilder.defaultToolName((ToolMaterial)TConstructRegistry.getMaterial((int)partMaterialId), (ToolCore)tool);
                toolStack.func_151001_c("\u00a7r" + defaultName);
            }
        }
    }

    private static void updateTag(NBTTagCompound from, NBTTagCompound to, String tag) {
        if (to.func_74764_b(tag)) {
            to.func_74782_a(tag, from.func_74781_a(tag));
        }
    }

    private static void handleMaterialTraits(NBTTagCompound tags, int oldMaterialId, int newMaterialId) {
        if (oldMaterialId == newMaterialId) {
            return;
        }
        ToolMaterial oldMat = TConstructRegistry.getMaterial((int)oldMaterialId);
        ToolMaterial newMat = TConstructRegistry.getMaterial((int)newMaterialId);
        String ability = newMat.ability();
        if (ability.equals(StatCollector.func_74838_a((String)"materialtraits.writable")) || ability.equals(StatCollector.func_74838_a((String)"materialtraits.thaumic"))) {
            tags.func_74768_a("Modifiers", tags.func_74762_e("Modifiers") + 1);
        }
        if ((ability = oldMat.ability()).equals(StatCollector.func_74838_a((String)"materialtraits.writable")) || ability.equals(StatCollector.func_74838_a((String)"materialtraits.thaumic"))) {
            int newMods = tags.func_74762_e("Modifiers") - 1;
            if (newMods < 0) {
                newMods = 0;
            }
            tags.func_74768_a("Modifiers", newMods);
        }
    }

    private static void reapplyRedstone(NBTTagCompound tags, ItemStack itemStack) {
        if (!tags.func_74764_b("Redstone")) {
            return;
        }
        int modifiers = tags.func_74762_e("Modifiers");
        for (ItemModifier mod : ModifyBuilder.instance.itemModifiers) {
            if (!(mod instanceof ModRedstone)) continue;
            ModRedstone modRedstone = (ModRedstone)mod;
            if (modRedstone instanceof ModXpAwareRedstone) {
                modRedstone = ((ModXpAwareRedstone)modRedstone).originalModifier;
            }
            int[] keyPair = tags.func_74759_k("Redstone");
            int rLvl = keyPair[0];
            tags.func_82580_o("Redstone");
            int tipIndex = keyPair[2];
            tags.func_82580_o("Tooltip" + tipIndex);
            tags.func_82580_o("ModifierTip" + tipIndex);
            while (rLvl-- > 0) {
                modRedstone.modify(new ItemStack[]{new ItemStack(Items.field_151137_ax)}, itemStack);
            }
        }
        tags.func_74768_a("Modifiers", modifiers);
    }

    private static void reapplyAttack(NBTTagCompound tags, ItemStack itemStack) {
        if (!tags.func_74764_b("ModAttack")) {
            return;
        }
        int modifiers = tags.func_74762_e("Modifiers");
        for (ItemModifier mod : ModifyBuilder.instance.itemModifiers) {
            if (!mod.key.equals("ModAttack")) continue;
            ModAttack modAttack = (ModAttack)mod;
            int[] keyPair = tags.func_74759_k("ModAttack");
            int qLvl = keyPair[0];
            tags.func_82580_o("ModAttack");
            int tipIndex = keyPair[2];
            tags.func_82580_o("Tooltip" + tipIndex);
            tags.func_82580_o("ModifierTip" + tipIndex);
            while (qLvl-- > 0) {
                modAttack.modify(new ItemStack[]{new ItemStack(Items.field_151128_bU)}, itemStack);
            }
        }
        tags.func_74768_a("Modifiers", modifiers);
    }

    private static void removeMobHeadModifier(NBTTagCompound tags) {
        if (!tags.func_74764_b("Mining Level Boost")) {
            return;
        }
        tags.func_82580_o("Mining Level Boost");
        int i = 1;
        boolean removed = false;
        while (true) {
            String effect = "Effect" + i;
            ++i;
            if (!tags.func_74764_b(effect)) break;
            if (removed) {
                tags.func_74768_a("Effect" + (i - 2), tags.func_74762_e(effect));
                tags.func_82580_o(effect);
                continue;
            }
            int effectId = tags.func_74762_e(effect);
            if (effectId < 20 || effectId > 26) continue;
            tags.func_82580_o(effect);
            removed = true;
        }
        i = 1;
        removed = false;
        while (true) {
            String modTip = "ModifierTip" + i;
            String toolTip = "Tooltip" + i;
            ++i;
            if (!tags.func_74764_b(modTip)) break;
            if (removed) {
                tags.func_74778_a("ModifierTip" + (i - 2), tags.func_74779_i(modTip));
                tags.func_74778_a("Tooltip" + (i - 2), tags.func_74779_i(toolTip));
                continue;
            }
            if (!tags.func_74779_i(modTip).endsWith("Mining Level Boost")) continue;
            tags.func_82580_o(modTip);
            tags.func_82580_o(toolTip);
            removed = true;
        }
        if (Config.mobHeadRequiresModifier) {
            tags.func_74768_a("Modifiers", tags.func_74762_e("Modifiers") + 1);
        }
    }

    public static boolean hasExtraModifier(int materialId) {
        return materialId == 9 || materialId == 31;
    }

    public static Item getPart(ToolCore tool, PartTypes type) {
        switch (type) {
            case HEAD: {
                return tool.getHeadItem();
            }
            case HANDLE: {
                return tool.getHandleItem();
            }
            case ACCESSORY: {
                return tool.getAccessoryItem();
            }
            case EXTRA: {
                return tool.getExtraItem();
            }
        }
        return null;
    }

    public static int getToolPartMaterial(NBTTagCompound tags, PartTypes type) {
        int mat = -1;
        switch (type) {
            case HEAD: {
                mat = tags.func_74762_e("Head");
                break;
            }
            case HANDLE: {
                mat = tags.func_74762_e("Handle");
                break;
            }
            case ACCESSORY: {
                mat = tags.func_74762_e("Accessory");
                break;
            }
            case EXTRA: {
                mat = tags.func_74762_e("Extra");
            }
        }
        return mat;
    }

    public static PartTypes detectAdditionalPartType(ToolRecipe recipe, Item part, PartTypes currentType) {
        PartTypes tmpType = currentType;
        if (tmpType == null) {
            if (recipe.validHead(part)) {
                return PartTypes.HEAD;
            }
            tmpType = PartTypes.HEAD;
        }
        if (tmpType == PartTypes.HEAD) {
            if (recipe.validHandle(part)) {
                return PartTypes.HANDLE;
            }
            tmpType = PartTypes.HANDLE;
        }
        if (tmpType == PartTypes.HANDLE) {
            if (recipe.validAccessory(part)) {
                return PartTypes.ACCESSORY;
            }
            tmpType = PartTypes.ACCESSORY;
        }
        if (tmpType == PartTypes.ACCESSORY && recipe.validExtra(part)) {
            return PartTypes.EXTRA;
        }
        return currentType;
    }

    public static enum PartTypes {
        HEAD,
        HANDLE,
        ACCESSORY,
        EXTRA;

    }
}

