/*
 * Decompiled with CFR 0.152.
 */
package iguanaman.iguanatweakstconstruct.override;

import iguanaman.iguanatweakstconstruct.override.IOverride;
import iguanaman.iguanatweakstconstruct.reference.Config;
import iguanaman.iguanatweakstconstruct.util.HarvestLevels;
import iguanaman.iguanatweakstconstruct.util.Log;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.tools.ToolMaterial;

public class MaterialOverride
implements IOverride {
    @Override
    public void createDefault(Configuration config) {
        Log.info("Creating Material Default File");
        HashMap newMaterials = new HashMap();
        for (Map.Entry entry : TConstructRegistry.toolMaterials.entrySet()) {
            ToolMaterial mat = (ToolMaterial)entry.getValue();
            String category = "materials." + mat.materialName;
            category = category.toLowerCase();
            this.processMaterial(category, mat, config);
        }
    }

    @Override
    public void processConfig(Configuration config) {
        Log.info("Loading Material Overrides");
        StringBuilder comment = new StringBuilder();
        comment.append("Copy the desired materials you want to change from the defaults file into this file and adapt the stats.\n\n");
        comment.append("Mining Levels:\n");
        for (int i = 0; i <= HarvestLevels.max; ++i) {
            comment.append(String.format("\t%d - %s\n", i, HarvestLevels.getHarvestLevelName(i)));
        }
        comment.append("\n");
        comment.append("Stonebound and Jagged are both in the 'shoddy' property. A positive number is stonebound, a negative number jagged.\n");
        comment.append("\n");
        comment.append("Possible Colors:\n");
        for (EnumChatFormatting format : EnumChatFormatting.values()) {
            comment.append(String.format("\t%s\n", format.func_96297_d()));
        }
        config.setCategoryComment(" Info", comment.toString());
        config.setCategoryComment(" Info", comment.toString());
        Property prop = config.get(" Info", "fillWithDefault", false, "Fills this file with the default values, not altering changed values.");
        boolean fillWithDefault = prop.getBoolean();
        prop.set(false);
        prop = config.get(" Info", "removeDefaultValues", false, "Removes all entries that correspond to the default values. Will likely fail with some materials because floats are derp.");
        boolean cleanup = prop.getBoolean();
        prop.set(false);
        config.setCategoryComment("materials", "Insert materials to change here");
        HashMap newMaterials = new HashMap();
        for (Map.Entry entry : TConstructRegistry.toolMaterials.entrySet()) {
            ToolMaterial mat = (ToolMaterial)entry.getValue();
            String category = "materials." + mat.materialName;
            if (!config.hasCategory(category = category.toLowerCase()) && !fillWithDefault) {
                newMaterials.put(entry.getKey(), mat);
                continue;
            }
            ToolMaterial newMat = this.processMaterial(category, mat, config);
            newMaterials.put(entry.getKey(), newMat);
            if (Config.logOverrideChanges) {
                Log.info(String.format("Material Override: Changed Material %s", mat.materialName));
            }
            if (!cleanup || !this.isEqual(mat, newMat)) continue;
            config.removeCategory(config.getCategory(category));
        }
        TConstructRegistry.toolMaterials = newMaterials;
    }

    private ToolMaterial processMaterial(String category, ToolMaterial mat, Configuration config) {
        int harvestLevel = config.get(category, "harvestLevel", mat.harvestLevel()).getInt();
        int durability = config.get(category, "durability", mat.durability()).getInt();
        int miningspeed = config.get(category, "miningSpeed", mat.toolSpeed()).getInt();
        int attack = config.get(category, "attack", mat.attack()).getInt();
        float handleModifier = (float)config.get(category, "handleModifier", (double)mat.handleDurability()).getDouble();
        int reinforced = config.get(category, "reinforced", mat.reinforced()).getInt();
        float stonebound = (float)config.get(category, "shoddy", (double)mat.shoddy()).getDouble();
        String oldStyle = this.stringToEnum(mat.style()).func_96297_d();
        String tipStyle = config.get(category, "color", oldStyle).getString();
        EnumChatFormatting newStyle = EnumChatFormatting.func_96300_b((String)tipStyle);
        tipStyle = newStyle != null ? newStyle.toString() : mat.style();
        return new ToolMaterial(mat.materialName, harvestLevel, durability, miningspeed, attack, handleModifier, reinforced, stonebound, tipStyle, mat.primaryColor());
    }

    private EnumChatFormatting stringToEnum(String s) {
        for (EnumChatFormatting color : EnumChatFormatting.values()) {
            if (!color.toString().equals(s)) continue;
            return color;
        }
        return EnumChatFormatting.GRAY;
    }

    private boolean isEqual(ToolMaterial mat1, ToolMaterial mat2) {
        return mat1.harvestLevel() == mat2.harvestLevel() && mat1.style().equals(mat2.style()) && mat1.ability().equals(mat2.ability()) && mat1.attack() == mat2.attack() && mat1.durability() == mat2.durability() && mat1.toolSpeed() == mat2.toolSpeed() && Float.compare(mat1.handleDurability(), mat2.handleDurability()) == 0 && mat1.reinforced() == mat2.reinforced() && Float.compare(mat1.shoddy(), mat2.shoddy()) == 0;
    }
}

