/*
 * Decompiled with CFR 0.152.
 */
package iguanaman.iguanatweakstconstruct.override;

import iguanaman.iguanatweakstconstruct.override.IOverride;
import iguanaman.iguanatweakstconstruct.reference.Config;
import iguanaman.iguanatweakstconstruct.util.HarvestLevels;
import iguanaman.iguanatweakstconstruct.util.Log;
import java.util.HashMap;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.tools.ToolMaterial;

public class HarvestLevelNameOverride
implements IOverride {
    @Override
    public void createDefault(Configuration config) {
        Log.info("Creating Harvest Level Name Default File");
        config.get("HarvestLevelNames", "Level0", "Stone");
        config.get("HarvestLevelNames", "Level1", "Copper");
        config.get("HarvestLevelNames", "Level2", "Iron");
        config.get("HarvestLevelNames", "Level3", "Bronze");
        config.get("HarvestLevelNames", "Level4", "Steel");
        config.get("HarvestLevelNames", "Level5", "Obsidian");
        config.get("HarvestLevelNames", "Level6", "Ardite");
        config.get("HarvestLevelNames", "Level7", "Cobalt");
        config.get("HarvestLevelNames", "Level8", "Manyullyn");
    }

    @Override
    public void processConfig(Configuration config) {
        Log.info("Loading Harvest Level Name Overrides");
        ConfigCategory cat = config.getCategory("HarvestLevelNames");
        cat.setComment("Use materialnames to set the name of a harvest level. Check the MaterialDefaults file for the material names.\nFor Example: 'Level0=wood' would change the first harvest level to wood from stone.");
        HashMap<Integer, ToolMaterial> mats = new HashMap<Integer, ToolMaterial>();
        block2: for (Property prop : cat.values()) {
            Integer lvl;
            if (!prop.getName().startsWith("Level")) {
                Log.error("Invalid entry: " + prop.getName());
                continue;
            }
            try {
                lvl = Integer.valueOf(prop.getName().substring(5));
            }
            catch (NumberFormatException e) {
                Log.error("Invalid entry: " + prop.getName());
                continue;
            }
            String matName = prop.getString().toLowerCase();
            for (ToolMaterial mat : TConstructRegistry.toolMaterials.values()) {
                if (!matName.equals(mat.name().toLowerCase())) continue;
                mats.put(lvl, mat);
                if (!Config.logOverrideChanges) continue block2;
                Log.info(String.format("Harvest Level Name Override: Changed Level %s to %s", lvl, mat.materialName));
                continue block2;
            }
        }
        HarvestLevels.setCustomHarvestLevelNames(mats);
    }
}

