/*
 * Decompiled with CFR 0.152.
 */
package iguanaman.iguanatweakstconstruct.modcompat.fmp;

import codechicken.lib.config.ConfigFile;
import codechicken.microblock.BlockMicroMaterial;
import codechicken.microblock.ItemSaw;
import codechicken.microblock.Saw;
import codechicken.microblock.handler.MicroblockProxy;
import codechicken.multipart.handler.MultipartProxy;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import iguanaman.iguanatweakstconstruct.IguanaTweaksTConstruct;
import iguanaman.iguanatweakstconstruct.harvestlevels.HarvestLevelTweaks;
import iguanaman.iguanatweakstconstruct.modcompat.fmp.CommonFMPProxy;
import iguanaman.iguanatweakstconstruct.modcompat.fmp.SawStrengthHandler;
import iguanaman.iguanatweakstconstruct.reference.Config;
import iguanaman.iguanatweakstconstruct.reference.Reference;
import iguanaman.iguanatweakstconstruct.util.Log;
import java.lang.reflect.Field;
import mantle.pulsar.pulse.Handler;
import mantle.pulsar.pulse.Pulse;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.oredict.ShapedOreRecipe;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.tools.ToolMaterial;
import tconstruct.smeltery.TinkerSmeltery;
import tconstruct.tools.TinkerTools;
import tconstruct.world.TinkerWorld;

@Pulse(id="MultipartCompat", description="Makes Saw cut stuff again", pulsesRequired="HarvestLevelTweaks", modsRequired="ForgeMultipart")
public class IguanaFMPCompat {
    @SidedProxy(clientSide="iguanaman.iguanatweakstconstruct.modcompat.fmp.ClientFMPProxy", serverSide="iguanaman.iguanatweakstconstruct.modcompat.fmp.CommonFMPProxy")
    public static CommonFMPProxy proxy;
    public static Item arditeSaw;
    public static Item cobaltSaw;
    public static Item manyullynSaw;

    private Item createSaw(ToolMaterial mat) {
        String name = String.format("saw%s", mat.name());
        MultipartProxy.config().getTag(name).useBraces().getTag("durability").getIntValue(mat.durability() * 5);
        Item saw = MicroblockProxy.createSaw((ConfigFile)MultipartProxy.config(), (String)name, (int)mat.harvestLevel());
        saw.func_77655_b(Reference.prefix(name));
        return saw;
    }

    @Handler
    public void init(FMLInitializationEvent event) {
        int i;
        Log.info("Making TConstruct blocks multipart compatible");
        if (TinkerWorld.metalBlock != null) {
            for (i = 0; i < 11; ++i) {
                BlockMicroMaterial.createAndRegister((Block)TinkerWorld.metalBlock, (int)i);
            }
        }
        if (TinkerSmeltery.smeltery != null) {
            for (i = 2; i < 12; ++i) {
                if (i == 3) continue;
                BlockMicroMaterial.createAndRegister((Block)TinkerSmeltery.smeltery, (int)i);
                BlockMicroMaterial.createAndRegister((Block)TinkerSmeltery.smelteryNether, (int)i);
            }
            for (i = 0; i < 7; ++i) {
                BlockMicroMaterial.createAndRegister((Block)TinkerSmeltery.speedBlock, (int)i);
            }
        }
        if (TinkerTools.multiBrick != null) {
            for (i = 0; i < 14; ++i) {
                BlockMicroMaterial.createAndRegister((Block)TinkerTools.multiBrick, (int)i);
            }
            for (i = 0; i < 16; ++i) {
                BlockMicroMaterial.createAndRegister((Block)TinkerTools.multiBrickFancy, (int)i);
            }
        }
    }

    @Handler
    public void postInit(FMLPostInitializationEvent event) {
        if (IguanaTweaksTConstruct.pulsar.isPulseLoaded("Debug")) {
            MinecraftForge.EVENT_BUS.register((Object)new SawStrengthHandler());
        }
        Log.info("Adapting and adding FMP saws");
        for (Object o : Item.field_150901_e) {
            if (!(o instanceof Saw) || o == arditeSaw || o == cobaltSaw || o == manyullynSaw) continue;
            Item item = (Item)o;
            if (!(o instanceof ItemSaw)) continue;
            try {
                Field hlvlField = ItemSaw.class.getDeclaredField("harvestLevel");
                hlvlField.setAccessible(true);
                Integer old = (Integer)hlvlField.get(o);
                Integer hlvl = HarvestLevelTweaks.getUpdatedHarvestLevel(old);
                hlvlField.set(o, hlvl);
                if (!Config.logMiningLevelChanges) continue;
                Log.info(String.format("Changed Cutting Strength for %s from %d to %d", item.func_77658_a(), old, hlvl));
            }
            catch (Exception e) {
                Log.error(String.format("Couldn't update FMP saw %s", item.func_77658_a()));
            }
        }
        arditeSaw = this.createSaw(TConstructRegistry.getMaterial((String)"Ardite"));
        cobaltSaw = this.createSaw(TConstructRegistry.getMaterial((String)"Cobalt"));
        manyullynSaw = this.createSaw(TConstructRegistry.getMaterial((String)"Manyullyn"));
        String[] recipe = new String[]{"srr", "sbr"};
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(arditeSaw), new Object[]{recipe, Character.valueOf('s'), Items.field_151055_y, Character.valueOf('r'), "rodStone", Character.valueOf('b'), new ItemStack(TinkerTools.toolRod, 1, 11)}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(cobaltSaw), new Object[]{recipe, Character.valueOf('s'), Items.field_151055_y, Character.valueOf('r'), "rodStone", Character.valueOf('b'), new ItemStack(TinkerTools.toolRod, 1, 10)}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(manyullynSaw), new Object[]{recipe, Character.valueOf('s'), Items.field_151055_y, Character.valueOf('r'), "rodStone", Character.valueOf('b'), new ItemStack(TinkerTools.toolRod, 1, 12)}));
        proxy.updateSawRenderers();
    }
}

