/*
 * Decompiled with CFR 0.152.
 */
package iguanaman.iguanatweakstconstruct.leveling.handlers;

import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import iguanaman.iguanatweakstconstruct.OldToolConversionHandler;
import iguanaman.iguanatweakstconstruct.leveling.LevelingLogic;
import iguanaman.iguanatweakstconstruct.leveling.LevelingTooltips;
import iguanaman.iguanatweakstconstruct.reference.Config;
import iguanaman.iguanatweakstconstruct.util.ModSupportHelper;
import iguanaman.iguanatweakstconstruct.util.TooltipHelper;
import java.util.List;
import java.util.ListIterator;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import tconstruct.items.tools.Hammer;
import tconstruct.items.tools.Pickaxe;
import tconstruct.library.tools.ToolCore;

public class LevelingToolTipHandler {
    public static String plusPrefix = "\u00a79+";

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onItemToolTip(ItemTooltipEvent event) {
        String empty;
        int level;
        boolean hasMiningLevel;
        if (event.entityPlayer == null) {
            return;
        }
        if (!(event.itemStack.func_77973_b() instanceof ToolCore)) {
            return;
        }
        if (TooltipHelper.ctrlHeld()) {
            return;
        }
        ItemStack stack = event.itemStack;
        if (OldToolConversionHandler.toolNeedsUpdating(stack)) {
            event.toolTip.add(1, EnumChatFormatting.DARK_RED + StatCollector.func_74838_a((String)"tooltip.oldToolWarning1"));
            event.toolTip.add(2, EnumChatFormatting.DARK_RED + StatCollector.func_74838_a((String)"tooltip.oldToolWarning2"));
        }
        ToolCore tool = (ToolCore)event.itemStack.func_77973_b();
        NBTTagCompound tags = stack.func_77978_p().func_74775_l(tool.getBaseTagName());
        if (!LevelingLogic.hasLevel(tags)) {
            return;
        }
        ListIterator<String> inserter = this.findInsertSpot(event.toolTip);
        boolean advanced = TooltipHelper.shiftHeld();
        advanced &= Config.showTooltipXP;
        boolean bl = hasMiningLevel = tool.getHarvestLevel(event.itemStack, "pickaxe") >= 0 || tool instanceof Pickaxe || tool instanceof Hammer;
        if (hasMiningLevel) {
            int hLevel = tags.func_74762_e("HarvestLevel");
            String mLvl = LevelingTooltips.getMiningLevelTooltip(hLevel);
            if (Config.showMinimalTooltipXP && !advanced && Config.levelingPickaxeBoost && LevelingLogic.hasBoostXp(tags) && LevelingLogic.canBoostMiningLevel(tags)) {
                mLvl = mLvl + " (" + LevelingTooltips.getBoostXpString(stack, tags, false) + ")";
            }
            inserter.add(mLvl);
            if (Config.showTooltipXP && advanced && LevelingLogic.hasBoostXp(tags) && Config.pickaxeBoostRequired) {
                if (LevelingLogic.canBoostMiningLevel(tags)) {
                    inserter.add(LevelingTooltips.getBoostXpToolTip(stack, tags));
                } else if (LevelingLogic.isBoosted(tags)) {
                    inserter.add(LevelingTooltips.getBoostedTooltip());
                }
            }
        }
        if ((level = LevelingLogic.getLevel(tags)) > 0 && Config.toolLeveling) {
            String lvl = LevelingTooltips.getLevelTooltip(level);
            if (!advanced && Config.showMinimalTooltipXP && !LevelingLogic.isMaxLevel(tags)) {
                lvl = lvl + " (" + LevelingTooltips.getXpString(stack, tags, false) + ")";
            }
            inserter.add(lvl);
            if (advanced && Config.showTooltipXP && !LevelingLogic.isMaxLevel(tags)) {
                inserter.add(LevelingTooltips.getXpToolTip(stack, tags));
            }
        }
        inserter.add("");
        if (!advanced && Config.showTooltipXP && !ModSupportHelper.tiCTooltips && Config.toolLeveling) {
            inserter.add(StatCollector.func_74837_a((String)"tooltip.level.advanced", (Object[])new Object[]{EnumChatFormatting.YELLOW.toString() + EnumChatFormatting.ITALIC + "Shift" + EnumChatFormatting.RESET + EnumChatFormatting.GRAY}));
        }
        if ((empty = inserter.next()).isEmpty()) {
            inserter.remove();
        }
    }

    private ListIterator<String> findInsertSpot(List<String> tooltip) {
        ListIterator<String> iterator = tooltip.listIterator();
        while (iterator.hasNext()) {
            String str = iterator.next();
            if (!str.isEmpty() && !str.startsWith(plusPrefix)) continue;
            iterator.previous();
            break;
        }
        return iterator;
    }
}

