/*
 * Decompiled with CFR 0.152.
 */
package iguanaman.iguanatweakstconstruct.leveling.handlers;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import iguanaman.iguanatweakstconstruct.leveling.LevelingLogic;
import iguanaman.iguanatweakstconstruct.leveling.LevelingTooltips;
import iguanaman.iguanatweakstconstruct.leveling.RandomBonuses;
import iguanaman.iguanatweakstconstruct.reference.Config;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.UseHoeEvent;
import tconstruct.items.tools.Arrow;
import tconstruct.items.tools.Battleaxe;
import tconstruct.items.tools.Chisel;
import tconstruct.items.tools.Hammer;
import tconstruct.items.tools.Pickaxe;
import tconstruct.items.tools.Shortbow;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.event.ToolCraftEvent;
import tconstruct.library.tools.ToolCore;
import tconstruct.library.tools.Weapon;

public class LevelingEventHandler {
    @SubscribeEvent
    public void onHurt(LivingHurtEvent event) {
        if (!event.source.field_76373_n.equals("player") && !event.source.field_76373_n.equals("arrow")) {
            return;
        }
        if (!(event.source.func_76346_g() instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.source.func_76346_g();
        if (player instanceof FakePlayer) {
            return;
        }
        ItemStack stack = player.func_71045_bC();
        if (stack == null || !stack.func_77942_o()) {
            return;
        }
        if (stack.func_77973_b() == null || !(stack.func_77973_b() instanceof ToolCore)) {
            return;
        }
        int xp = 0;
        xp = stack.func_77973_b() instanceof Weapon || stack.func_77973_b() instanceof Battleaxe || stack.func_77973_b() instanceof Shortbow && event.source.field_76373_n.equals("arrow") ? Math.round(event.ammount) : Math.round((event.ammount - 0.1f) / 2.0f);
        if (event.entityLiving instanceof EntityAnimal) {
            xp = Math.max(1, xp / 2);
        }
        if (xp > 0) {
            LevelingLogic.addXP(stack, player, xp);
            NBTTagCompound tags = stack.func_77978_p().func_74775_l("InfiTool");
            if (event.entityLiving instanceof EntityAnimal) {
                RandomBonuses.addModifierExtraWeight(RandomBonuses.Modifier.LAPIS, xp + 5, tags);
            } else {
                RandomBonuses.addModifierExtraWeight(RandomBonuses.Modifier.ATTACK, xp, tags);
            }
            if (event.entityLiving instanceof EntitySpider) {
                RandomBonuses.addModifierExtraWeight(RandomBonuses.Modifier.BANE, Math.max(1, xp / 2), tags);
            } else if (event.entityLiving instanceof EntityBlaze) {
                RandomBonuses.addModifierExtraWeight(RandomBonuses.Modifier.BLAZE, Math.max(1, xp / 2), tags);
            } else if (event.entityLiving instanceof EntityPigZombie) {
                RandomBonuses.addModifierExtraWeight(RandomBonuses.Modifier.LIFESTEAL, Math.max(1, xp / 2), tags);
            } else if (event.entityLiving instanceof EntityZombie) {
                RandomBonuses.addModifierExtraWeight(RandomBonuses.Modifier.SMITE, Math.max(1, xp / 2), tags);
            } else if (event.entityLiving instanceof EntitySkeleton) {
                if (((EntitySkeleton)event.entityLiving).func_82202_m() != 0) {
                    RandomBonuses.addModifierExtraWeight(RandomBonuses.Modifier.LIFESTEAL, Math.max(1, xp / 2) + 2, tags);
                }
            } else if (event.entityLiving instanceof EntityEnderman) {
                RandomBonuses.addModifierExtraWeight(RandomBonuses.Modifier.BEHEADING, Math.max(1, xp / 2) + 3, tags);
            }
            if (player.func_70051_ag()) {
                RandomBonuses.addModifierExtraWeight(RandomBonuses.Modifier.KNOCKBACK, xp + 2, tags);
            }
        }
    }

    @SubscribeEvent
    public void onUseHoe(UseHoeEvent event) {
        EntityPlayer player = event.entityPlayer;
        if (player instanceof FakePlayer) {
            return;
        }
        ItemStack stack = event.current;
        if (stack != null && stack.func_77942_o() && stack.func_77973_b() instanceof ToolCore) {
            LevelingLogic.addXP(stack, player, 1L);
        }
    }

    @SubscribeEvent
    public void onCrafting(PlayerEvent.ItemCraftedEvent event) {
        if (event.crafting == null) {
            return;
        }
        ItemStack chisel = null;
        for (int i = 0; i < event.craftMatrix.func_70302_i_(); ++i) {
            if (event.craftMatrix.func_70301_a(i) == null || !(event.craftMatrix.func_70301_a(i).func_77973_b() instanceof Chisel)) continue;
            chisel = event.craftMatrix.func_70301_a(i);
        }
        if (chisel == null) {
            return;
        }
        LevelingLogic.addXP(chisel, event.player, 1L);
    }

    @SubscribeEvent
    public void onCraftTool(ToolCraftEvent.NormalTool event) {
        if (event.tool instanceof Arrow) {
            return;
        }
        NBTTagCompound toolTag = event.toolTag.func_74775_l("InfiTool");
        LevelingLogic.addLevelingTags(toolTag, event.tool);
        toolTag.func_74768_a("Modifiers", Math.max(toolTag.func_74762_e("Modifiers") - (3 - Config.toolLevelingExtraModifiers), 0));
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onRenderGameOverlay(RenderGameOverlayEvent.Text event) {
        if (Config.toolLeveling && Config.showDebugXP) {
            ItemStack equipped;
            Minecraft mc = Minecraft.func_71410_x();
            EntityClientPlayerMP player = mc.field_71439_g;
            if (!player.field_70128_L && mc.field_71474_y.field_74330_P && (equipped = player.func_71045_bC()) != null && equipped.func_77973_b() != null && equipped.func_77973_b() instanceof ToolCore) {
                int hLevel;
                NBTTagCompound tags = equipped.func_77978_p().func_74775_l("InfiTool");
                int level = tags.func_74762_e("ToolLevel");
                hLevel = tags.func_74764_b("HarvestLevel") ? (hLevel = tags.func_74762_e("HarvestLevel")) : -1;
                event.left.add("");
                if (Config.showTooltipXP) {
                    if (level <= 5) {
                        event.left.add(LevelingTooltips.getXpToolTip(equipped, null));
                    }
                    if (Config.levelingPickaxeBoost && hLevel >= TConstructRegistry.getMaterial((String)"Copper").harvestLevel() && hLevel < TConstructRegistry.getMaterial((String)"Manyullyn").harvestLevel() && !tags.func_74764_b("HarvestLevelModified") && (equipped.func_77973_b() instanceof Pickaxe || equipped.func_77973_b() instanceof Hammer)) {
                        event.left.add(LevelingTooltips.getBoostXpToolTip(equipped, null));
                    }
                }
            }
        }
    }
}

