/*
 * Decompiled with CFR 0.152.
 */
package iguanaman.iguanatweakstconstruct;

import cpw.mods.fml.common.gameevent.PlayerEvent;
import iguanaman.iguanatweakstconstruct.leveling.LevelingLogic;
import iguanaman.iguanatweakstconstruct.reference.Config;
import iguanaman.iguanatweakstconstruct.replacing.ReplacementLogic;
import iguanaman.iguanatweakstconstruct.util.HarvestLevels;
import iguanaman.iguanatweakstconstruct.util.Log;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import tconstruct.items.tools.Arrow;
import tconstruct.items.tools.Hammer;
import tconstruct.items.tools.Pickaxe;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.tools.ToolCore;

public class OldToolConversionHandler {
    public void onLogin(PlayerEvent.PlayerLoggedInEvent event) {
        InventoryPlayer inventory = event.player.field_71071_by;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            if (inventory.func_70301_a(i) == null || !OldToolConversionHandler.toolNeedsUpdating(inventory.func_70301_a(i))) continue;
            OldToolConversionHandler.updateItem(inventory.func_70301_a(i));
        }
    }

    public static boolean toolNeedsUpdating(ItemStack itemStack) {
        if (itemStack.func_77973_b() == null) {
            return false;
        }
        if (!(itemStack.func_77973_b() instanceof ToolCore) || itemStack.func_77973_b() instanceof Arrow) {
            return false;
        }
        if (itemStack.func_77978_p() == null) {
            return false;
        }
        NBTTagCompound tags = itemStack.func_77978_p().func_74775_l("InfiTool");
        if (!LevelingLogic.hasLevel(tags) && Config.toolLeveling) {
            return true;
        }
        int hlvl = tags.func_74762_e("HarvestLevel");
        if (hlvl > 0 && (itemStack.func_77973_b() instanceof Pickaxe || itemStack.func_77973_b() instanceof Hammer) && !LevelingLogic.hasBoostXp(tags) && Config.pickaxeBoostRequired) {
            return true;
        }
        int realHlvl = TConstructRegistry.getMaterial((int)tags.func_74762_e("Head")).harvestLevel();
        if (Config.pickaxeBoostRequired && !LevelingLogic.isBoosted(tags) && (itemStack.func_77973_b() instanceof Pickaxe || itemStack.func_77973_b() instanceof Hammer)) {
            return hlvl != Math.max(realHlvl - 1, 0);
        }
        if (tags.func_74764_b("GemBoost") && realHlvl == HarvestLevels._4_bronze) {
            return hlvl != HarvestLevels._5_diamond;
        }
        return hlvl != realHlvl;
    }

    public static void updateItem(ItemStack itemStack) {
        ToolCore tool = (ToolCore)itemStack.func_77973_b();
        NBTTagCompound tags = itemStack.func_77978_p().func_74775_l("InfiTool");
        if (!LevelingLogic.hasLevel(tags) && Config.toolLeveling) {
            LevelingLogic.addLevelingTags(tags, tool);
        } else if (!LevelingLogic.hasBoostXp(tags) && Config.pickaxeBoostRequired) {
            LevelingLogic.addBoostTags(tags, tool);
        }
        ItemStack newHead = new ItemStack(tool.getHeadItem(), 1, tags.func_74762_e("Head"));
        int oldXpPenality = Config.partReplacementXpPenality;
        int oldBoostXpPenality = Config.partReplacementBoostXpPenality;
        Config.partReplacementXpPenality = 0;
        Config.partReplacementBoostXpPenality = 0;
        ReplacementLogic.exchangeToolPart(tool, tags, ReplacementLogic.PartTypes.HEAD, newHead, itemStack);
        Config.partReplacementXpPenality = oldXpPenality;
        Config.partReplacementBoostXpPenality = oldBoostXpPenality;
        Log.info("Updated Tool " + itemStack.func_82833_r());
    }
}

