/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.util.potions;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import xreliquary.util.potions.PotionIngredient;

public class PotionEssence {
    public static int MAX_DURATION = 4500000;
    public List<PotionEffect> potionEffects = new ArrayList<PotionEffect>();

    public PotionEssence(NBTTagCompound tag) {
        if (tag == null) {
            return;
        }
        for (Object object : tag.func_150296_c()) {
            if (!(object instanceof NBTTagCompound)) continue;
            NBTTagCompound effect = (NBTTagCompound)object;
            this.potionEffects.add(new PotionEffect(effect.func_74762_e("id"), effect.func_74762_e("duration"), effect.func_74762_e("potency")));
        }
    }

    public PotionEssence(PotionEffect ... effects) {
        for (PotionEffect effect : effects) {
            this.potionEffects.add(effect);
        }
    }

    public PotionEssence(PotionIngredient ... ingredients) {
    }

    public NBTTagCompound writeToNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        int count = 0;
        for (PotionEffect object : this.potionEffects) {
            NBTTagCompound effect = new NBTTagCompound();
            effect.func_74768_a("id", object.func_76456_a());
            effect.func_74768_a("duration", object.func_76459_b());
            effect.func_74768_a("potency", object.func_76458_c());
            tag.func_74782_a("effect" + count, (NBTBase)effect);
            ++count;
        }
        return tag;
    }

    public void combine(PotionEssence essence) {
        for (PotionEffect effect : essence.potionEffects) {
            boolean found = false;
            for (PotionEffect effect1 : this.potionEffects) {
                if (effect1.func_76456_a() != effect.func_76456_a()) continue;
                found = true;
                int minPotency = Math.min(effect.func_76458_c(), effect1.func_76458_c());
                int maxPotency = Math.max(effect.func_76458_c(), effect1.func_76458_c());
                PotionEffect lessPotentPotion = effect.func_76458_c() == minPotency ? effect : effect1;
                PotionEffect morePotentPotion = effect.func_76458_c() == minPotency ? effect : effect1;
                PotionEffect newEffect = new PotionEffect(effect1.func_76456_a(), morePotentPotion.func_76459_b() + lessPotentPotion.func_76459_b() / (maxPotency - minPotency + 1), minPotency + 1 + (maxPotency + 1) - 1);
                this.potionEffects.remove(effect1);
                this.potionEffects.add(newEffect);
            }
            if (found) continue;
            this.potionEffects.add(effect);
        }
    }

    public void apply(EntityPlayer player) {
        for (PotionEffect effect : this.potionEffects) {
            player.func_70690_d(effect);
        }
    }
}

