/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.addons.sensors;

import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleCommandResult;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.api.turtle.TurtleUpgradeType;
import dan200.computercraft.api.turtle.TurtleVerb;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import openperipheral.addons.Config;
import openperipheral.addons.OpenPeripheralAddons;
import openperipheral.addons.sensors.ISensorEnvironment;
import openperipheral.addons.utils.CCUtils;
import openperipheral.api.ApiAccess;
import openperipheral.api.IAdapterFactory;

public class TurtleUpgradeSensor
implements ITurtleUpgrade {
    public int getUpgradeID() {
        return 180;
    }

    public String getUnlocalisedAdjective() {
        return "openperipheral.turtle.sensor.adjective";
    }

    public TurtleUpgradeType getType() {
        return TurtleUpgradeType.Peripheral;
    }

    public ItemStack getCraftingItem() {
        return new ItemStack((Block)OpenPeripheralAddons.Blocks.sensor);
    }

    public IPeripheral createPeripheral(ITurtleAccess turtle, TurtleSide side) {
        return ((IAdapterFactory)ApiAccess.getApi(IAdapterFactory.class)).createPeripheral((Object)new TurtleSensorEnvironment(turtle));
    }

    public TurtleCommandResult useTool(ITurtleAccess turtle, TurtleSide side, TurtleVerb verb, int direction) {
        return null;
    }

    public IIcon getIcon(ITurtleAccess turtle, TurtleSide side) {
        return OpenPeripheralAddons.Icons.sensorTurtle;
    }

    public void update(ITurtleAccess turtle, TurtleSide side) {
    }

    private static class TurtleSensorEnvironment
    implements ISensorEnvironment {
        private ITurtleAccess turtle;

        public TurtleSensorEnvironment(ITurtleAccess turtle) {
            this.turtle = turtle;
        }

        @Override
        public boolean isTurtle() {
            return true;
        }

        @Override
        public Vec3 getLocation() {
            return this.turtle.getVisualPosition(0.0f);
        }

        public World getWorld() {
            return this.turtle.getWorld();
        }

        @Override
        public int getSensorRange() {
            World world = this.getWorld();
            return world.func_72896_J() && world.func_72911_I() ? Config.sensorRangeInStorm : Config.sensorRange;
        }

        public boolean isValid() {
            return CCUtils.isTurtleValid(this.turtle);
        }
    }
}

