/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.addons.glasses;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import openperipheral.addons.glasses.Drawable;
import openperipheral.addons.glasses.SurfaceClient;
import openperipheral.addons.glasses.TerminalEvent;
import openperipheral.addons.glasses.TerminalUtils;

public class TerminalManagerClient {
    private final Table<Long, String, SurfaceClient> surfaces = HashBasedTable.create();

    private void tryDrawSurface(long guid, String player, float partialTicks) {
        SurfaceClient surface = (SurfaceClient)this.surfaces.get((Object)guid, (Object)player);
        if (surface != null) {
            for (Drawable drawable : surface) {
                drawable.draw(partialTicks);
            }
        }
    }

    @SubscribeEvent
    public void onRenderGameOverlay(RenderGameOverlayEvent evt) {
        EntityClientPlayerMP player;
        Long guid;
        if (evt.type == RenderGameOverlayEvent.ElementType.HELMET && evt instanceof RenderGameOverlayEvent.Post && (guid = TerminalUtils.tryGetTerminalGuid((EntityPlayer)(player = Minecraft.func_71410_x().field_71439_g))) != null) {
            this.tryDrawSurface(guid, "GLOBAL", evt.partialTicks);
            this.tryDrawSurface(guid, "PRIVATE", evt.partialTicks);
        }
    }

    private static String getSurfaceName(TerminalEvent evt) {
        return evt.isPrivate ? "PRIVATE" : "GLOBAL";
    }

    @SubscribeEvent
    public void onTerminalData(TerminalEvent.TerminalDataEvent evt) {
        String surfaceName = TerminalManagerClient.getSurfaceName(evt);
        SurfaceClient surface = (SurfaceClient)this.surfaces.get((Object)evt.terminalId, (Object)surfaceName);
        if (surface == null) {
            surface = new SurfaceClient(evt.terminalId, evt.isPrivate);
            this.surfaces.put((Object)evt.terminalId, (Object)surfaceName, (Object)surface);
        }
        surface.interpretCommandList((List)evt.commands);
    }

    @SubscribeEvent
    public void onTerminalClear(TerminalEvent.TerminalClearEvent evt) {
        String surfaceName = TerminalManagerClient.getSurfaceName(evt);
        this.surfaces.remove((Object)evt.terminalId, (Object)surfaceName);
    }
}

