/*
 * Decompiled with CFR 0.152.
 */
package tonius.simplyjetpacks.util;

import java.text.DecimalFormat;
import net.minecraft.util.StatCollector;
import org.lwjgl.input.Keyboard;
import tonius.simplyjetpacks.config.Config;
import tonius.simplyjetpacks.item.jetpack.JetpackParticleType;

public abstract class StringUtils {
    private static DecimalFormat formatter = new DecimalFormat("###,###");
    public static final String BLACK = "\u00a70";
    public static final String BLUE = "\u00a71";
    public static final String GREEN = "\u00a72";
    public static final String TEAL = "\u00a73";
    public static final String RED = "\u00a74";
    public static final String PURPLE = "\u00a75";
    public static final String ORANGE = "\u00a76";
    public static final String LIGHT_GRAY = "\u00a77";
    public static final String GRAY = "\u00a78";
    public static final String LIGHT_BLUE = "\u00a79";
    public static final String BRIGHT_GREEN = "\u00a7a";
    public static final String BRIGHT_BLUE = "\u00a7b";
    public static final String LIGHT_RED = "\u00a7c";
    public static final String PINK = "\u00a7d";
    public static final String YELLOW = "\u00a7e";
    public static final String WHITE = "\u00a7f";
    public static final String OBFUSCATED = "\u00a7k";
    public static final String BOLD = "\u00a7l";
    public static final String STRIKETHROUGH = "\u00a7m";
    public static final String UNDERLINE = "\u00a7n";
    public static final String ITALIC = "\u00a7o";
    public static final String END = "\u00a7r";

    public static boolean isAltKeyDown() {
        return Keyboard.isKeyDown((int)56) || Keyboard.isKeyDown((int)184);
    }

    public static boolean isControlKeyDown() {
        return Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157);
    }

    public static boolean isShiftKeyDown() {
        return Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
    }

    public static String getScaledNumber(int number) {
        return StringUtils.getScaledNumber(number, 2);
    }

    public static String getScaledNumber(int number, int minDigits) {
        String numString = "";
        int numMod = 10 * minDigits;
        numString = number > 100000 * numMod ? numString + number / 1000000 + "M" : (number > 100 * numMod ? numString + number / 1000 + "k" : numString + number);
        return numString;
    }

    public static String getFormattedNumber(int number) {
        return formatter.format(number);
    }

    public static String getTierText(int tier) {
        return String.format(StringUtils.translate("tooltip.tier"), tier);
    }

    public static String getChargeText(boolean infinite, int charge, int total) {
        if (infinite) {
            return LIGHT_GRAY + StringUtils.translate("tooltip.charge.infinite");
        }
        return LIGHT_GRAY + StringUtils.getFormattedNumber(charge) + " / " + StringUtils.getFormattedNumber(total) + " RF";
    }

    public static String getStateText(boolean state) {
        String onOrOff = state ? BRIGHT_GREEN + StringUtils.translate("tooltip.on") : LIGHT_RED + StringUtils.translate("tooltip.off");
        return ORANGE + StringUtils.translate("tooltip.state") + ": " + onOrOff;
    }

    public static String getHoverModeText(boolean state) {
        String enabledOrDisabled = state ? BRIGHT_GREEN + StringUtils.translate("tooltip.enabled") : LIGHT_RED + StringUtils.translate("tooltip.disabled");
        return ORANGE + StringUtils.translate("tooltip.hoverMode") + ": " + enabledOrDisabled;
    }

    public static String getChargerStateText(boolean state) {
        String onOrOff = state ? BRIGHT_GREEN + StringUtils.translate("tooltip.enabled") : LIGHT_RED + StringUtils.translate("tooltip.disabled");
        return ORANGE + StringUtils.translate("tooltip.chargerState") + ": " + onOrOff;
    }

    public static String getEnergyUsageText(int usage) {
        String usageText = usage > 0 ? StringUtils.getFormattedNumber(usage) + " RF/t" : StringUtils.translate("tooltip.energy.none");
        return ORANGE + StringUtils.translate("tooltip.energyUsage") + ": " + LIGHT_GRAY + usageText;
    }

    public static String getChargerRateText(int rate) {
        String rateText = rate > 0 ? StringUtils.getFormattedNumber(rate) + " RF/t" : StringUtils.translate("tooltip.energy.none");
        return ORANGE + StringUtils.translate("tooltip.chargerRate") + ": " + LIGHT_GRAY + rateText;
    }

    public static String getEnergySendText(int send) {
        return ORANGE + StringUtils.translate("tooltip.energySend") + ": " + LIGHT_GRAY + StringUtils.getFormattedNumber(send) + " RF/t";
    }

    public static String getEnergyReceiveText(int receive) {
        String usageText = receive < Integer.MAX_VALUE ? StringUtils.getFormattedNumber(receive) + " RF/t" : StringUtils.translate("tooltip.energy.none");
        return ORANGE + StringUtils.translate("tooltip.energyReceive") + ": " + LIGHT_GRAY + usageText;
    }

    public static String getArmoredText(boolean armored) {
        String yesOrNo = armored ? BRIGHT_GREEN + StringUtils.translate("tooltip.yes") : LIGHT_RED + StringUtils.translate("tooltip.no");
        return ORANGE + StringUtils.translate("tooltip.armored") + ": " + yesOrNo;
    }

    public static String getParticlesText(JetpackParticleType particle) {
        return ORANGE + StringUtils.translate("tooltip.particles") + ": " + LIGHT_GRAY + StringUtils.translate("tooltip.particles." + particle.ordinal());
    }

    public static String getHUDEnergyText(String prefix, int percent, int energy) {
        String text = "";
        if (!Config.minimalEnergyHUD) {
            text = text + StringUtils.translate("gui.hud." + prefix + ".energy") + ": ";
        }
        text = percent > 0 ? text + StringUtils.getColoredPercent(percent) + "%" : text + RED + StringUtils.translate("gui.hud.energy.depleted");
        if (Config.showExactEnergyInHUD) {
            text = text + " (" + StringUtils.getFormattedNumber(energy) + " RF)";
        }
        return text;
    }

    public static String getHUDStateText(Boolean engine, Boolean hover, Boolean charger) {
        String text = "";
        if (engine != null) {
            text = text + (engine != false ? BRIGHT_GREEN : RED) + StringUtils.translate("gui.hud.state.engine") + END;
        }
        if (hover != null) {
            if (engine != null) {
                text = text + "\u00a77 - ";
            }
            text = text + (hover != false ? BRIGHT_GREEN : RED) + StringUtils.translate("gui.hud.state.hover") + END;
        }
        if (charger != null) {
            if (hover != null || engine != null) {
                text = text + "\u00a77 - ";
            }
            text = text + (charger != false ? BRIGHT_GREEN : RED) + StringUtils.translate("gui.hud.state.charger");
        }
        return text;
    }

    public static String getColoredPercent(int percent) {
        if (percent > 70) {
            return BRIGHT_GREEN + percent;
        }
        if (percent > 40 && percent <= 70) {
            return YELLOW + percent;
        }
        if (percent > 10 && percent <= 40) {
            return ORANGE + percent;
        }
        return LIGHT_RED + percent;
    }

    public static String getShiftText() {
        return LIGHT_GRAY + String.format(StringUtils.translate("tooltip.holdShift"), "\u00a7e\u00a7o" + StringUtils.translate("tooltip.holdShift.shift") + END + LIGHT_GRAY);
    }

    public static boolean canShowDetails() {
        return Config.holdShiftForDetails ? StringUtils.isShiftKeyDown() : true;
    }

    public static String translate(String unlocalized) {
        return StringUtils.translate(unlocalized, true);
    }

    public static String translate(String unlocalized, boolean prefix) {
        if (prefix) {
            return StatCollector.func_74838_a((String)("simplyjetpacks." + unlocalized));
        }
        return StatCollector.func_74838_a((String)unlocalized);
    }
}

