/*
 * Decompiled with CFR 0.152.
 */
package tonius.simplyjetpacks.util;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class FireworkUtils {
    public static ItemStack getRandomFirework() {
        Random rand = new Random();
        Firework firework = new Firework();
        int v = rand.nextInt(4);
        switch (v) {
            case 0: 
            case 2: {
                firework.setFlicker();
                if (v == 0) break;
            }
            case 1: {
                firework.setTrail();
            }
        }
        int type = rand.nextInt(5);
        firework.setType(type);
        for (int i = 0; i <= rand.nextInt(6); ++i) {
            Color randomColor = new Color(Color.HSBtoRGB(rand.nextFloat() * 360.0f, rand.nextFloat() * 0.15f + 0.8f, 0.85f));
            firework.addColor(randomColor.getRed(), randomColor.getGreen(), randomColor.getBlue());
        }
        return firework.getStack();
    }

    public static class Firework {
        private int flightDuration = 0;
        private boolean flicker = false;
        private boolean trail = false;
        private ArrayList<Integer> colors = new ArrayList();
        private FireworkType type = FireworkType.BALL;

        public Firework setFlightDuration(int duration) {
            if (duration >= 0 && duration <= 3) {
                this.flightDuration = duration;
            }
            return this;
        }

        public Firework setFlicker() {
            this.flicker = true;
            return this;
        }

        public Firework setTrail() {
            this.trail = true;
            return this;
        }

        public Firework setType(FireworkType type) {
            this.type = type;
            return this;
        }

        public Firework setType(int type) {
            if (type >= 0 && type <= 4) {
                this.setType(FireworkType.values()[type]);
            }
            return this;
        }

        public Firework addColor(int red, int green, int blue) {
            this.colors.add((red << 16) + (green << 8) + blue);
            return this;
        }

        public ItemStack getStack() {
            NBTTagCompound tags = new NBTTagCompound();
            NBTTagCompound fireworksTag = new NBTTagCompound();
            NBTTagList explosionsList = new NBTTagList();
            explosionsList.func_74742_a((NBTBase)this.getNBT());
            fireworksTag.func_74774_a("Flight", (byte)this.flightDuration);
            fireworksTag.func_74782_a("Explosions", (NBTBase)explosionsList);
            tags.func_74782_a("Fireworks", (NBTBase)fireworksTag);
            ItemStack stack = new ItemStack(Items.field_151152_bP);
            stack.func_77982_d(tags);
            return stack;
        }

        private NBTTagCompound getNBT() {
            NBTTagCompound explosionTag = new NBTTagCompound();
            explosionTag.func_74757_a("Flicker", this.flicker);
            explosionTag.func_74757_a("Trail", this.trail);
            explosionTag.func_74774_a("Type", (byte)this.type.ordinal());
            int[] intArray = new int[this.colors.size()];
            for (int i = 0; i < this.colors.size(); ++i) {
                intArray[i] = this.colors.get(i);
            }
            explosionTag.func_74783_a("Colors", intArray);
            return explosionTag;
        }
    }

    public static enum FireworkType {
        BALL,
        LARGE_BALL,
        STAR,
        CREEPER,
        BURST;

    }
}

