/*
 * Decompiled with CFR 0.152.
 */
package tonius.simplyjetpacks.item.jetpack;

import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityFireworkRocket;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import tonius.simplyjetpacks.SyncTracker;
import tonius.simplyjetpacks.item.ItemJetpack;
import tonius.simplyjetpacks.item.jetpack.Jetpack;
import tonius.simplyjetpacks.item.jetpack.JetpackParticleType;
import tonius.simplyjetpacks.util.FireworkUtils;
import tonius.simplyjetpacks.util.StackUtils;
import tonius.simplyjetpacks.util.StringUtils;

public class JetpackPotato
extends Jetpack {
    public JetpackPotato(int tier, int energyCapacity, int energyPerTick, double speedVertical, double accelVertical) {
        super(tier, EnumRarity.common, false, energyCapacity, energyPerTick, speedVertical, accelVertical, 0.0, 0.0, 0.0f, 0.0f, 0.0f, false, 0, false);
    }

    @Override
    public String getBaseName() {
        return "jetpack.potato";
    }

    @Override
    public boolean hasEmptyItem() {
        return false;
    }

    @Override
    public void addShiftInformation(ItemStack itemStack, EntityPlayer player, List list) {
        list.add(StringUtils.getEnergyUsageText(this.energyPerTick));
        list.add(StringUtils.getParticlesText(this.getParticleType(itemStack)));
        list.add("\u00a7a" + StringUtils.translate("tooltip.jetpack.description.1"));
        list.add("\u00a7a" + StringUtils.translate("tooltip.jetpack.description.2"));
        list.add("\u00a7c\u00a7o" + StringUtils.translate("tooltip.jetpackPotato.warning"));
    }

    @Override
    public void useJetpack(EntityLivingBase user, ItemStack jetpack, ItemJetpack item, boolean force) {
        if (this.isFired(jetpack)) {
            super.useJetpack(user, jetpack, item, true);
            user.field_70759_as += 37.5f;
            if (item.getEnergyStored(jetpack) == 0) {
                user.func_70062_b(3, null);
                if (!user.field_70170_p.field_72995_K) {
                    Random rand = new Random();
                    user.field_70170_p.func_72876_a((Entity)user, user.field_70165_t, user.field_70163_u, user.field_70161_v, 4.0f, false);
                    for (int i = 0; i <= rand.nextInt(3) + 4; ++i) {
                        ItemStack firework = FireworkUtils.getRandomFirework();
                        user.field_70170_p.func_72838_d((Entity)new EntityFireworkRocket(user.field_70170_p, user.field_70165_t + rand.nextDouble() * 6.0 - 3.0, user.field_70163_u, user.field_70161_v + rand.nextDouble() * 6.0 - 3.0, firework));
                    }
                    user.func_70097_a((DamageSource)new EntityDamageSource("jetpackpotato", (Entity)user), 100.0f);
                    if (user instanceof EntityPlayer) {
                        user.func_145779_a(Items.field_151168_bH, 1);
                    }
                }
            }
        } else if (force || SyncTracker.isFlyKeyDown(user)) {
            if (this.isTimerSet(jetpack)) {
                this.decrementTimer(jetpack, user);
            } else {
                this.setTimer(jetpack, 50);
            }
        }
    }

    @Override
    public void toggle(ItemStack itemStack, EntityPlayer player, boolean sneakChangesToggleBehavior, boolean showInChat) {
    }

    @Override
    public void switchHoverMode(ItemStack itemStack, EntityPlayer player, boolean showInChat) {
    }

    @Override
    public boolean switchEmergencyHoverMode(ItemStack itemStack, EntityPlayer player) {
        return false;
    }

    @Override
    public JetpackParticleType particleToShow(ItemStack itemStack, ItemJetpack item, EntityLivingBase user) {
        if (!this.isFired(itemStack) && SyncTracker.isFlyKeyDown(user)) {
            return user.func_70681_au().nextInt(5) == 0 ? JetpackParticleType.SMOKE : null;
        }
        if (this.isFired(itemStack)) {
            return this.getParticleType(itemStack);
        }
        return null;
    }

    @Override
    public boolean isOn(ItemStack itemStack) {
        return true;
    }

    @Override
    public boolean isHoverModeOn(ItemStack itemStack) {
        return false;
    }

    public boolean isFired(ItemStack itemStack) {
        return StackUtils.getNBT(itemStack).func_74767_n("Fired");
    }

    public void setFired(ItemStack itemStack) {
        StackUtils.getNBT(itemStack).func_74757_a("Fired", true);
    }

    public void setTimer(ItemStack itemStack, int timer) {
        StackUtils.getNBT(itemStack);
        itemStack.field_77990_d.func_74768_a("RocketTimer", timer);
        itemStack.field_77990_d.func_74757_a("TimerSet", true);
    }

    public boolean isTimerSet(ItemStack itemStack) {
        return StackUtils.getNBT(itemStack).func_74767_n("TimerSet");
    }

    public void decrementTimer(ItemStack itemStack, EntityLivingBase user) {
        StackUtils.getNBT(itemStack);
        int timer = itemStack.field_77990_d.func_74762_e("RocketTimer");
        timer = timer > 0 ? timer - 1 : 0;
        itemStack.field_77990_d.func_74768_a("RocketTimer", timer);
        if (timer == 0) {
            this.setFired(itemStack);
            user.field_70170_p.func_72956_a((Entity)user, "simplyjetpacks:rocket", 1.0f, 1.0f);
        }
    }
}

