/*
 * Decompiled with CFR 0.152.
 */
package tonius.simplyjetpacks.item.jetpack;

import cofh.api.energy.IEnergyContainerItem;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.common.ISpecialArmor;
import tonius.simplyjetpacks.config.Config;
import tonius.simplyjetpacks.item.ItemJetpack;
import tonius.simplyjetpacks.item.jetpack.JetpackArmored;
import tonius.simplyjetpacks.util.StackUtils;
import tonius.simplyjetpacks.util.StringUtils;

public class JetpackJetPlate
extends JetpackArmored {
    public final int energyPerTickOut;
    public final boolean allowCharger;

    public JetpackJetPlate(int tier, EnumRarity rarity, boolean hasModel, int energyCapacity, int energyPerTick, double speedVertical, double accelVertical, double speedVerticalHover, double speedVerticalHoverSlow, float speedSideways, float sprintSpeedModifier, float sprintEnergyModifier, boolean enchantable, int enchantability, boolean emergencyHoverMode, int armorReduction, int energyPerHit, int energyPerTickOut) {
        super(tier, rarity, hasModel, energyCapacity, energyPerTick, speedVertical, accelVertical, speedVerticalHover, speedVerticalHoverSlow, speedSideways, sprintSpeedModifier, sprintEnergyModifier, enchantable, enchantability, emergencyHoverMode, armorReduction, energyPerHit);
        this.allowCharger = energyPerTickOut > 0;
        this.energyPerTickOut = energyPerTickOut;
    }

    public boolean isChargerOn(ItemStack itemStack) {
        return this.allowCharger && StackUtils.getNBTBoolean(itemStack, "FluxPackOn", true);
    }

    public void toggleCharger(ItemStack itemStack, EntityPlayer player, boolean showInChat) {
        String msg = "";
        if (this.isChargerOn(itemStack)) {
            msg = StringUtils.translate("chat.fluxpack.charger") + " " + "\u00a7c" + StringUtils.translate("chat.disabled");
            itemStack.field_77990_d.func_74757_a("FluxPackOn", false);
        } else {
            msg = StringUtils.translate("chat.fluxpack.charger") + " " + "\u00a7a" + StringUtils.translate("chat.enabled");
            itemStack.field_77990_d.func_74757_a("FluxPackOn", true);
        }
        if (player != null && showInChat) {
            player.func_145747_a((IChatComponent)new ChatComponentText(msg));
        }
    }

    @Override
    public String getBaseName() {
        return "jetpack." + this.tier;
    }

    @Override
    public void toggle(ItemStack itemStack, EntityPlayer player, boolean sneakChangesToggleBehavior, boolean showInChat) {
        if (this.allowCharger && sneakChangesToggleBehavior && player.func_70093_af()) {
            this.toggleCharger(itemStack, player, showInChat);
        } else {
            super.toggle(itemStack, player, sneakChangesToggleBehavior, showInChat);
        }
    }

    @Override
    public void useJetpack(EntityLivingBase user, ItemStack armor, ItemJetpack item, boolean force) {
        super.useJetpack(user, armor, item, force);
        if (this.isChargerOn(armor)) {
            for (int i = 0; i <= 4; ++i) {
                ItemStack currentStack = user.func_71124_b(i);
                if (currentStack == null || currentStack == armor || !(currentStack.func_77973_b() instanceof IEnergyContainerItem)) continue;
                IEnergyContainerItem heldEnergyItem = (IEnergyContainerItem)currentStack.func_77973_b();
                if (this.consumesEnergy()) {
                    int energyToAdd = Math.min(item.extractEnergy(armor, this.energyPerTickOut, true), heldEnergyItem.receiveEnergy(currentStack, this.energyPerTickOut, true));
                    item.extractEnergy(armor, energyToAdd, false);
                    heldEnergyItem.receiveEnergy(currentStack, energyToAdd, false);
                    continue;
                }
                heldEnergyItem.receiveEnergy(currentStack, this.energyPerTickOut, false);
            }
        }
    }

    @Override
    public void addShiftInformation(ItemStack itemStack, EntityPlayer player, List list) {
        list.add(StringUtils.getStateText(this.isOn(itemStack)));
        list.add(StringUtils.getHoverModeText(this.isHoverModeOn(itemStack)));
        list.add(StringUtils.getChargerStateText(this.isChargerOn(itemStack)));
        list.add(StringUtils.getEnergyUsageText(this.energyPerTick));
        list.add(StringUtils.getChargerRateText(this.energyPerTickOut));
        list.add(StringUtils.getParticlesText(this.getParticleType(itemStack)));
        list.add("\u00a7a" + StringUtils.translate("tooltip.jetpack.description.1"));
        list.add("\u00a7a" + StringUtils.translate("tooltip.fluxpack.description.1"));
        list.add("\u00a7a" + StringUtils.translate("tooltip.jetpack.description.2"));
        list.add("\u00a7b\u00a7o" + StringUtils.translate("tooltip.jetpackFluxPlate.controls" + (Config.sneakChangesToggleBehavior ? "" : ".command")));
    }

    @Override
    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemJetpack item, ItemStack armor, DamageSource source, double damage, int slot) {
        if (source.field_76373_n.equals("flux")) {
            return new ISpecialArmor.ArmorProperties(0, 0.5, Integer.MAX_VALUE);
        }
        return super.getProperties(player, item, armor, source, damage, slot);
    }

    @Override
    public void damageArmor(EntityLivingBase entity, ItemJetpack item, ItemStack armor, DamageSource source, int damage, int slot) {
        if (source.field_76373_n.equals("flux")) {
            item.receiveEnergy(armor, damage * (source.func_76346_g() == null ? this.armorEnergyPerHit / 2 : this.getEnergyPerDamage(armor)), false);
        } else {
            super.damageArmor(entity, item, armor, source, damage, slot);
        }
    }
}

