/*
 * Decompiled with CFR 0.152.
 */
package tonius.simplyjetpacks.item.jetpack;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.common.ISpecialArmor;
import tonius.simplyjetpacks.SyncTracker;
import tonius.simplyjetpacks.config.Config;
import tonius.simplyjetpacks.config.JetpackConfig;
import tonius.simplyjetpacks.item.ItemIndex;
import tonius.simplyjetpacks.item.ItemJetpack;
import tonius.simplyjetpacks.item.jetpack.JetpackArmored;
import tonius.simplyjetpacks.item.jetpack.JetpackCreative;
import tonius.simplyjetpacks.item.jetpack.JetpackJetPlate;
import tonius.simplyjetpacks.item.jetpack.JetpackParticleType;
import tonius.simplyjetpacks.item.jetpack.JetpackPotato;
import tonius.simplyjetpacks.setup.JetpackIcon;
import tonius.simplyjetpacks.util.StackUtils;
import tonius.simplyjetpacks.util.StringUtils;

public class Jetpack {
    public static final int ARMORED_META_OFFSET = 100;
    private static Map<Integer, Jetpack> jetpacksCommon = new HashMap<Integer, Jetpack>();
    private static int highestMetaCommon;
    private static Map<Integer, Jetpack> jetpacksPerMod;
    private static int highestMetaPerMod;
    public final int tier;
    public final EnumRarity rarity;
    public final boolean useModel;
    public final int energyCapacity;
    public final int energyPerTick;
    public final double speedVertical;
    public final double accelVertical;
    public final double speedVerticalHover;
    public final double speedVerticalHoverSlow;
    public final float speedSideways;
    public final float sprintSpeedModifier;
    public final float sprintEnergyModifier;
    public final boolean enchantable;
    public final int enchantability;
    public final boolean emergencyHoverMode;

    public Jetpack(int tier, EnumRarity rarity, boolean useModel, int energyCapacity, int energyPerTick, double speedVertical, double accelVertical, double speedVerticalHover, double speedVerticalHoverSlow, float speedSideways, float sprintSpeedModifier, float sprintEnergyModifier, boolean enchantable, int enchantability, boolean emergencyHoverMode) {
        this.tier = tier;
        this.rarity = rarity;
        this.useModel = useModel;
        this.energyCapacity = energyCapacity;
        this.energyPerTick = energyPerTick;
        this.speedVertical = speedVertical;
        this.accelVertical = accelVertical;
        this.speedVerticalHover = speedVerticalHover;
        this.speedVerticalHoverSlow = speedVerticalHoverSlow;
        this.speedSideways = speedSideways;
        this.sprintSpeedModifier = sprintSpeedModifier;
        this.sprintEnergyModifier = sprintEnergyModifier;
        this.enchantable = enchantable;
        this.enchantability = enchantability;
        this.emergencyHoverMode = emergencyHoverMode;
    }

    public static Jetpack getJetpack(ItemIndex index, int meta) {
        switch (index) {
            case COMMON: {
                return jetpacksCommon.get(meta);
            }
            case PER_MOD: {
                return jetpacksPerMod.get(meta);
            }
        }
        return null;
    }

    public static int getHighestMeta(ItemIndex index) {
        switch (index) {
            case COMMON: {
                return highestMetaCommon;
            }
            case PER_MOD: {
                return highestMetaPerMod;
            }
        }
        return 0;
    }

    public static void addJetpack(ItemIndex index, int meta, Jetpack jetpack) {
        switch (index) {
            case COMMON: {
                jetpacksCommon.put(meta, jetpack);
                if (highestMetaCommon >= meta) break;
                highestMetaCommon = meta;
                break;
            }
            case PER_MOD: {
                jetpacksPerMod.put(meta, jetpack);
                if (highestMetaPerMod >= meta) break;
                highestMetaPerMod = meta;
            }
        }
    }

    public static void reconstructJetpacks() {
        Jetpack.newJetpack(ItemIndex.COMMON, 0, null, false, false);
        Jetpack.addJetpack(ItemIndex.COMMON, 1, new JetpackIcon());
        Jetpack.newJetpack(ItemIndex.COMMON, 9001, null, true, false);
        Jetpack.newJetpack(ItemIndex.PER_MOD, 1, EnumRarity.common, true, true);
        Jetpack.newJetpack(ItemIndex.PER_MOD, 2, EnumRarity.common, true, true);
        Jetpack.newJetpack(ItemIndex.PER_MOD, 3, EnumRarity.uncommon, true, true);
        Jetpack.newJetpack(ItemIndex.PER_MOD, 4, EnumRarity.rare, true, true);
        Jetpack.newJetpack(ItemIndex.PER_MOD, 5, EnumRarity.epic, true, false);
    }

    public static void newJetpack(ItemIndex index, int tier, EnumRarity rarity, boolean hasModel, boolean canBeArmored) {
        JetpackConfig config = Config.jetpackConfigs.get(tier);
        if (config != null) {
            Jetpack jetpack;
            switch (tier) {
                case 0: {
                    jetpack = new JetpackPotato(tier, config.energyCapacity, config.energyPerTick, config.speedVertical, config.accelVertical);
                    break;
                }
                case 5: {
                    jetpack = new JetpackJetPlate(tier, rarity, hasModel, config.energyCapacity, config.energyPerTick, config.speedVertical, config.accelVertical, config.speedVerticalHover, config.speedVerticalHoverSlow, config.speedSideways.floatValue(), config.sprintSpeedModifier.floatValue(), config.sprintEnergyModifier.floatValue(), config.enchantable, config.enchantability, config.emergencyHoverMode, config.armorReduction, config.armorEnergyPerHit, config.chargerRate);
                    break;
                }
                case 9001: {
                    jetpack = new JetpackCreative(config.speedVertical, config.accelVertical, config.speedVerticalHover, config.speedVerticalHoverSlow, config.speedSideways.floatValue(), config.sprintSpeedModifier.floatValue(), config.sprintEnergyModifier.floatValue(), config.enchantable, config.enchantability, config.emergencyHoverMode, config.armorReduction, config.chargerRate);
                    break;
                }
                default: {
                    jetpack = new Jetpack(tier, rarity, hasModel, config.energyCapacity, config.energyPerTick, config.speedVertical, config.accelVertical, config.speedVerticalHover, config.speedVerticalHoverSlow, config.speedSideways.floatValue(), config.sprintSpeedModifier.floatValue(), config.sprintEnergyModifier.floatValue(), config.enchantable, config.enchantability, config.emergencyHoverMode);
                    if (!canBeArmored) break;
                    JetpackArmored jetpackArmored = new JetpackArmored(tier, rarity, hasModel, config.energyCapacity, config.energyPerTick, config.speedVertical, config.accelVertical, config.speedVerticalHover, config.speedVerticalHoverSlow, config.speedSideways.floatValue(), config.sprintSpeedModifier.floatValue(), config.sprintEnergyModifier.floatValue(), config.enchantable, config.enchantability, config.emergencyHoverMode, config.armorReduction, config.armorEnergyPerHit);
                    Jetpack.addJetpack(index, tier + 100, jetpackArmored);
                }
            }
            Jetpack.addJetpack(index, tier, jetpack);
        }
    }

    public String getBaseName() {
        return "jetpack." + this.tier;
    }

    public boolean isArmored() {
        return false;
    }

    public boolean hasArmoredVersion() {
        return true;
    }

    public boolean isVisible() {
        return true;
    }

    public boolean hasEmptyItem() {
        return true;
    }

    public boolean hasDamageBar() {
        return true;
    }

    public boolean consumesEnergy() {
        return true;
    }

    public void useJetpack(EntityLivingBase user, ItemStack armor, ItemJetpack item, boolean force) {
        if (this.isOn(armor)) {
            double currentAccel;
            boolean hoverMode = this.isHoverModeOn(armor);
            double hoverSpeed = this.getHoverSpeed(armor, user);
            boolean flyKeyDown = force || SyncTracker.isFlyKeyDown(user);
            boolean descendKeyDown = SyncTracker.isDescendKeyDown(user);
            double d = currentAccel = user.field_70181_x < 0.3 ? this.accelVertical * 2.5 : this.accelVertical;
            if (flyKeyDown || hoverMode && !user.field_70122_E) {
                item.extractEnergy(armor, user.func_70051_ag() ? Math.round((float)this.energyPerTick * this.sprintEnergyModifier) : this.energyPerTick, false);
                if (item.getEnergyStored(armor) > 0) {
                    float speedForward;
                    user.field_70181_x = flyKeyDown ? (!hoverMode ? Math.min(user.field_70181_x + currentAccel, this.speedVertical) : (descendKeyDown ? Math.min(user.field_70181_x + currentAccel, -this.speedVerticalHoverSlow) : Math.min(user.field_70181_x + currentAccel, this.speedVerticalHover))) : Math.min(user.field_70181_x + currentAccel, -hoverSpeed);
                    float speedSideways = user.func_70093_af() ? this.speedSideways * 0.5f : this.speedSideways;
                    float f = speedForward = user.func_70051_ag() ? speedSideways * this.sprintSpeedModifier : speedSideways;
                    if (SyncTracker.isForwardKeyDown(user)) {
                        user.func_70060_a(0.0f, speedForward, speedForward);
                    }
                    if (SyncTracker.isBackwardKeyDown(user)) {
                        user.func_70060_a(0.0f, -speedSideways, speedSideways * 0.8f);
                    }
                    if (SyncTracker.isLeftKeyDown(user)) {
                        user.func_70060_a(speedSideways, 0.0f, speedSideways);
                    }
                    if (SyncTracker.isRightKeyDown(user)) {
                        user.func_70060_a(-speedSideways, 0.0f, speedSideways);
                    }
                    if (!user.field_70170_p.field_72995_K) {
                        user.field_70143_R = 0.0f;
                        if (user instanceof EntityPlayerMP) {
                            ((EntityPlayerMP)user).field_71135_a.field_147365_f = 0;
                        }
                    }
                }
            }
        }
        if (!(user.field_70170_p.field_72995_K || !this.emergencyHoverMode || !this.isEmergencyHoverModeOn(armor) || item.getEnergyStored(armor) <= 0 || this.isHoverModeOn(armor) && this.isOn(armor))) {
            if (user.field_70163_u < -5.0) {
                this.doEmergencyHoverMode(armor, user);
            } else if (user instanceof EntityPlayer && !((EntityPlayer)user).field_71075_bZ.field_75098_d && user.field_70143_R - 1.2f >= user.func_110143_aJ()) {
                for (int i = 0; i <= 16; ++i) {
                    if (user.field_70170_p.func_147437_c(Math.round((float)user.field_70165_t - 0.5f), Math.round((float)user.field_70163_u) - i, Math.round((float)user.field_70161_v - 0.5f))) continue;
                    this.doEmergencyHoverMode(armor, user);
                    break;
                }
            }
        }
    }

    public void doEmergencyHoverMode(ItemStack armor, EntityLivingBase user) {
        StackUtils.getNBT(armor).func_74757_a("JetpackOn", true);
        StackUtils.getNBT(armor).func_74757_a("JetpackHoverModeOn", true);
        if (user instanceof EntityPlayer) {
            ((EntityPlayer)user).func_145747_a((IChatComponent)new ChatComponentText("\u00a7c" + StringUtils.translate("chat.jetpack.emergencyHoverMode")));
        }
    }

    public boolean isOn(ItemStack itemStack) {
        return StackUtils.getNBTBoolean(itemStack, "JetpackOn", true);
    }

    public JetpackParticleType particleToShow(ItemStack itemStack, ItemJetpack item, EntityLivingBase user) {
        boolean flyKeyDown = SyncTracker.isFlyKeyDown(user);
        if (this.isOn(itemStack) && item.getEnergyStored(itemStack) > 0 && (flyKeyDown || this.isHoverModeOn(itemStack) && !user.field_70122_E && user.field_70181_x < 0.0)) {
            return this.getParticleType(itemStack);
        }
        return null;
    }

    public void toggle(ItemStack itemStack, EntityPlayer player, boolean sneakChangesToggleBehavior, boolean showInChat) {
        String msg = "";
        if (this.isOn(itemStack)) {
            msg = StringUtils.translate("chat.jetpack.engine") + " " + "\u00a7c" + StringUtils.translate("chat.disabled");
            itemStack.field_77990_d.func_74757_a("JetpackOn", false);
        } else {
            msg = StringUtils.translate("chat.jetpack.engine") + " " + "\u00a7a" + StringUtils.translate("chat.enabled");
            itemStack.field_77990_d.func_74757_a("JetpackOn", true);
        }
        if (player != null && showInChat) {
            player.func_145747_a((IChatComponent)new ChatComponentText(msg));
        }
    }

    public boolean isHoverModeOn(ItemStack itemStack) {
        return StackUtils.getNBTBoolean(itemStack, "JetpackHoverModeOn", false);
    }

    public void switchHoverMode(ItemStack itemStack, EntityPlayer player, boolean showInChat) {
        String msg = "";
        if (this.isHoverModeOn(itemStack)) {
            msg = StringUtils.translate("chat.jetpack.hoverMode") + " " + "\u00a7c" + StringUtils.translate("chat.disabled");
            itemStack.field_77990_d.func_74757_a("JetpackHoverModeOn", false);
        } else {
            msg = StringUtils.translate("chat.jetpack.hoverMode") + " " + "\u00a7a" + StringUtils.translate("chat.enabled");
            itemStack.field_77990_d.func_74757_a("JetpackHoverModeOn", true);
        }
        if (player != null && showInChat) {
            player.func_145747_a((IChatComponent)new ChatComponentText(msg));
        }
    }

    public boolean isEmergencyHoverModeOn(ItemStack itemStack) {
        return StackUtils.getNBTBoolean(itemStack, "JetpackEmergencyHoverModeOn", true);
    }

    public boolean switchEmergencyHoverMode(ItemStack itemStack, EntityPlayer player) {
        if (this.emergencyHoverMode) {
            String msg = "";
            if (this.isEmergencyHoverModeOn(itemStack)) {
                msg = StringUtils.translate("chat.jetpack.hoverMode.emergency") + " " + "\u00a7c" + StringUtils.translate("chat.disabled");
                itemStack.field_77990_d.func_74757_a("JetpackEmergencyHoverModeOn", false);
            } else {
                msg = StringUtils.translate("chat.jetpack.hoverMode.emergency") + " " + "\u00a7a" + StringUtils.translate("chat.enabled");
                itemStack.field_77990_d.func_74757_a("JetpackEmergencyHoverModeOn", true);
            }
            if (player != null) {
                player.func_145747_a((IChatComponent)new ChatComponentText(msg));
            }
            return true;
        }
        return false;
    }

    public void setMobMode(ItemStack itemStack) {
        if (!this.isOn(itemStack)) {
            itemStack.field_77990_d.func_74757_a("JetpackOn", true);
        }
        if (this.isHoverModeOn(itemStack)) {
            itemStack.field_77990_d.func_74757_a("JetpackHoverModeOn", false);
        }
    }

    public double getHoverSpeed(ItemStack jetpack, EntityLivingBase user) {
        if (Config.invertHoverSneakingBehavior) {
            return SyncTracker.isDescendKeyDown(user) ? this.speedVerticalHoverSlow : this.speedVerticalHover;
        }
        return SyncTracker.isDescendKeyDown(user) ? this.speedVerticalHover : this.speedVerticalHoverSlow;
    }

    public void addInformation(ItemStack itemStack, EntityPlayer player, List list, int energyStored) {
        list.add(StringUtils.getTierText(this.tier));
        list.add(StringUtils.getChargeText(this.tier == 9001, energyStored, this.energyCapacity));
    }

    public void addShiftInformation(ItemStack itemStack, EntityPlayer player, List list) {
        list.add(StringUtils.getStateText(this.isOn(itemStack)));
        list.add(StringUtils.getHoverModeText(this.isHoverModeOn(itemStack)));
        list.add(StringUtils.getEnergyUsageText(this.energyPerTick));
        list.add(StringUtils.getArmoredText(this.isArmored()));
        list.add(StringUtils.getParticlesText(this.getParticleType(itemStack)));
        list.add("\u00a7a" + StringUtils.translate("tooltip.jetpack.description.1"));
        list.add("\u00a7a" + StringUtils.translate("tooltip.jetpack.description.2"));
    }

    public JetpackParticleType getParticleType(ItemStack jetpack) {
        int particle = StackUtils.getNBT(jetpack).func_74762_e("JetpackParticleType");
        JetpackParticleType particleType = JetpackParticleType.values()[particle];
        if (particleType != null) {
            return particleType;
        }
        return JetpackParticleType.DEFAULT;
    }

    public void setParticleType(ItemStack jetpack, JetpackParticleType particle) {
        StackUtils.getNBT(jetpack).func_74768_a("JetpackParticleType", particle.ordinal());
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemJetpack item, ItemStack armor, DamageSource source, double damage, int slot) {
        return new ISpecialArmor.ArmorProperties(0, 1.0, 0);
    }

    public int getArmorDisplay(EntityPlayer player, ItemJetpack item, ItemStack armor, int slot) {
        return 0;
    }

    public void damageArmor(EntityLivingBase entity, ItemJetpack item, ItemStack armor, DamageSource source, int damage, int slot) {
    }

    static {
        jetpacksPerMod = new HashMap<Integer, Jetpack>();
    }
}

