/*
 * Decompiled with CFR 0.152.
 */
package tonius.simplyjetpacks.item.fluxpack;

import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.ISpecialArmor;
import tonius.simplyjetpacks.item.ItemFluxPack;
import tonius.simplyjetpacks.item.fluxpack.FluxPack;

public class FluxPackArmored
extends FluxPack {
    public int armorReduction;
    public int armorEnergyPerHit;

    public FluxPackArmored(int tier, EnumRarity rarity, int energyCapacity, int energyPerTickIn, int energyPerTickOut, boolean enchantable, int enchantability, int armorReduction, int armorEnergyPerHit) {
        super(tier, rarity, energyCapacity, energyPerTickIn, energyPerTickOut, enchantable, enchantability);
        this.armorReduction = armorReduction;
        this.armorEnergyPerHit = armorEnergyPerHit;
    }

    @Override
    public String getBaseName() {
        return "fluxpack." + this.tier + ".armored";
    }

    @Override
    public boolean isArmored() {
        return true;
    }

    protected int getEnergyPerDamage(ItemStack stack) {
        int unbreakingLevel = MathHelper.func_76125_a((int)EnchantmentHelper.func_77506_a((int)Enchantment.field_77347_r.field_77352_x, (ItemStack)stack), (int)0, (int)4);
        return (int)Math.round((double)(this.armorEnergyPerHit * (5 - unbreakingLevel)) / 5.0);
    }

    @Override
    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemFluxPack item, ItemStack armor, DamageSource source, double damage, int slot) {
        if (source.func_76363_c()) {
            return super.getProperties(player, item, armor, source, damage, slot);
        }
        int maxAbsorbed = this.getEnergyPerDamage(armor) > 0 ? 25 * (item.getEnergyStored(armor) / this.getEnergyPerDamage(armor)) : 0;
        return new ISpecialArmor.ArmorProperties(0, 0.75 * ((double)this.armorReduction / 20.0), maxAbsorbed);
    }

    @Override
    public int getArmorDisplay(EntityPlayer player, ItemFluxPack item, ItemStack armor, int slot) {
        if (item.getEnergyStored(armor) >= this.armorEnergyPerHit) {
            return this.armorReduction;
        }
        return 0;
    }

    @Override
    public void damageArmor(EntityLivingBase entity, ItemFluxPack item, ItemStack armor, DamageSource source, int damage, int slot) {
        item.extractEnergy(armor, damage * this.getEnergyPerDamage(armor), false);
    }
}

