/*
 * Decompiled with CFR 0.152.
 */
package tonius.simplyjetpacks.item.fluxpack;

import cofh.api.energy.IEnergyContainerItem;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.common.ISpecialArmor;
import tonius.simplyjetpacks.config.Config;
import tonius.simplyjetpacks.config.FluxPackConfig;
import tonius.simplyjetpacks.item.ItemFluxPack;
import tonius.simplyjetpacks.item.ItemIndex;
import tonius.simplyjetpacks.item.fluxpack.FluxPackArmored;
import tonius.simplyjetpacks.item.fluxpack.FluxPackCreative;
import tonius.simplyjetpacks.util.StackUtils;
import tonius.simplyjetpacks.util.StringUtils;

public class FluxPack {
    public static final int ARMORED_META_OFFSET = 100;
    private static Map<Integer, FluxPack> fluxPacksCommon = new HashMap<Integer, FluxPack>();
    private static int highestMetaCommon;
    private static Map<Integer, FluxPack> fluxPacksPerMod;
    private static int highestMetaPerMod;
    public int tier;
    public EnumRarity rarity;
    public int energyCapacity;
    public int energyPerTickIn;
    public int energyPerTickOut;
    public boolean enchantable;
    public int enchantability;

    public FluxPack(int tier, EnumRarity rarity, int energyCapacity, int energyPerTickIn, int energyPerTickOut, boolean enchantable, int enchantability) {
        this.tier = tier;
        this.rarity = rarity;
        this.energyCapacity = energyCapacity;
        this.energyPerTickIn = energyPerTickIn;
        this.energyPerTickOut = energyPerTickOut;
        this.enchantable = enchantable;
        this.enchantability = enchantability;
    }

    public static FluxPack getFluxPack(ItemIndex index, int meta) {
        switch (index) {
            case COMMON: {
                return fluxPacksCommon.get(meta);
            }
            case PER_MOD: {
                return fluxPacksPerMod.get(meta);
            }
        }
        return null;
    }

    public static int getHighestMeta(ItemIndex index) {
        switch (index) {
            case COMMON: {
                return highestMetaCommon;
            }
            case PER_MOD: {
                return highestMetaPerMod;
            }
        }
        return 0;
    }

    public static void addFluxPack(ItemIndex index, int meta, FluxPack fluxPack) {
        switch (index) {
            case COMMON: {
                fluxPacksCommon.put(meta, fluxPack);
                if (highestMetaCommon >= meta) break;
                highestMetaCommon = meta;
                break;
            }
            case PER_MOD: {
                fluxPacksPerMod.put(meta, fluxPack);
                if (highestMetaPerMod >= meta) break;
                highestMetaPerMod = meta;
            }
        }
    }

    public static void reconstructFluxPacks() {
        FluxPack.newFluxPack(ItemIndex.COMMON, 9001, null, false);
        FluxPack.newFluxPack(ItemIndex.PER_MOD, 1, EnumRarity.common, false);
        FluxPack.newFluxPack(ItemIndex.PER_MOD, 2, EnumRarity.common, true);
        FluxPack.newFluxPack(ItemIndex.PER_MOD, 3, EnumRarity.uncommon, true);
        FluxPack.newFluxPack(ItemIndex.PER_MOD, 4, EnumRarity.rare, true);
    }

    public static void newFluxPack(ItemIndex index, int tier, EnumRarity rarity, boolean canBeArmored) {
        FluxPackConfig config = Config.fluxPackConfigs.get(tier);
        if (config != null) {
            FluxPack fluxPack;
            switch (tier) {
                case 9001: {
                    fluxPack = new FluxPackCreative(config.energyOutRate, config.enchantable, config.enchantability, config.armorReduction);
                    break;
                }
                default: {
                    fluxPack = new FluxPack(tier, rarity, config.energyCapacity, config.energyInRate, config.energyOutRate, config.enchantable, config.enchantability);
                    if (!canBeArmored) break;
                    FluxPackArmored fluxPackArmored = new FluxPackArmored(tier, rarity, config.energyCapacity, config.energyInRate, config.energyOutRate, config.enchantable, config.enchantability, config.armorReduction, config.armorEnergyPerHit);
                    FluxPack.addFluxPack(index, tier + 100, fluxPackArmored);
                }
            }
            FluxPack.addFluxPack(index, tier, fluxPack);
        }
    }

    public String getBaseName() {
        return "fluxpack." + this.tier;
    }

    public boolean isArmored() {
        return false;
    }

    public boolean isVisible() {
        return true;
    }

    public boolean hasEmptyItem() {
        return true;
    }

    public boolean hasDamageBar() {
        return true;
    }

    public boolean consumesEnergy() {
        return true;
    }

    public void useFluxPack(EntityLivingBase user, ItemStack armor, ItemFluxPack item) {
        if (this.isOn(armor)) {
            for (int i = 0; i <= 4; ++i) {
                ItemStack currentStack = user.func_71124_b(i);
                if (currentStack == null || currentStack == armor || !(currentStack.func_77973_b() instanceof IEnergyContainerItem)) continue;
                IEnergyContainerItem heldEnergyItem = (IEnergyContainerItem)currentStack.func_77973_b();
                if (this.consumesEnergy()) {
                    int energyToAdd = Math.min(item.extractEnergy(armor, this.energyPerTickOut, true), heldEnergyItem.receiveEnergy(currentStack, this.energyPerTickOut, true));
                    item.extractEnergy(armor, energyToAdd, false);
                    heldEnergyItem.receiveEnergy(currentStack, energyToAdd, false);
                    continue;
                }
                heldEnergyItem.receiveEnergy(currentStack, this.energyPerTickOut, false);
            }
        }
    }

    public boolean isOn(ItemStack itemStack) {
        return StackUtils.getNBTBoolean(itemStack, "FluxPackOn", true);
    }

    public void toggle(ItemStack itemStack, EntityPlayer player, boolean showInChat) {
        String msg = "";
        if (this.isOn(itemStack)) {
            msg = StringUtils.translate("chat.fluxpack.charger") + " " + "\u00a7c" + StringUtils.translate("chat.disabled");
            itemStack.field_77990_d.func_74757_a("FluxPackOn", false);
        } else {
            msg = StringUtils.translate("chat.fluxpack.charger") + " " + "\u00a7a" + StringUtils.translate("chat.enabled");
            itemStack.field_77990_d.func_74757_a("FluxPackOn", true);
        }
        if (player != null && showInChat) {
            player.func_145747_a((IChatComponent)new ChatComponentText(msg));
        }
    }

    public void addInformation(ItemStack itemStack, EntityPlayer player, List list, int energyStored) {
        list.add(StringUtils.getTierText(this.tier));
        list.add(StringUtils.getChargeText(this.tier == 9001, energyStored, this.energyCapacity));
        if (StringUtils.canShowDetails()) {
            list.add(StringUtils.getStateText(this.isOn(itemStack)));
            list.add(StringUtils.getEnergySendText(this.energyPerTickOut));
            list.add(StringUtils.getEnergyReceiveText(this.energyPerTickIn));
            list.add(StringUtils.getArmoredText(this.isArmored()));
            list.add("\u00a7a" + StringUtils.translate("tooltip.fluxpack.description.1"));
            list.add("\u00a7a" + StringUtils.translate("tooltip.fluxpack.description.2"));
        } else {
            list.add(StringUtils.getShiftText());
        }
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemFluxPack item, ItemStack armor, DamageSource source, double damage, int slot) {
        return new ISpecialArmor.ArmorProperties(0, 1.0, 0);
    }

    public int getArmorDisplay(EntityPlayer player, ItemFluxPack item, ItemStack armor, int slot) {
        return 0;
    }

    public void damageArmor(EntityLivingBase entity, ItemFluxPack item, ItemStack armor, DamageSource source, int damage, int slot) {
    }

    static {
        fluxPacksPerMod = new HashMap<Integer, FluxPack>();
    }
}

