/*
 * Decompiled with CFR 0.152.
 */
package tonius.simplyjetpacks.item;

import cofh.api.energy.IEnergyContainerItem;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;
import tonius.simplyjetpacks.client.model.ModelFluxPack;
import tonius.simplyjetpacks.client.util.RenderUtils;
import tonius.simplyjetpacks.item.IEnergyHUDInfoProvider;
import tonius.simplyjetpacks.item.IToggleable;
import tonius.simplyjetpacks.item.ItemIndex;
import tonius.simplyjetpacks.item.fluxpack.FluxPack;
import tonius.simplyjetpacks.setup.ModCreativeTab;
import tonius.simplyjetpacks.setup.ModItems;
import tonius.simplyjetpacks.util.StackUtils;
import tonius.simplyjetpacks.util.StringUtils;

public class ItemFluxPack
extends ItemArmor
implements ISpecialArmor,
IEnergyContainerItem,
IToggleable,
IEnergyHUDInfoProvider {
    public final ItemIndex index;
    public final ModItems.ModType modType;
    private IIcon[] icons = null;

    public ItemFluxPack(ItemIndex index, ModItems.ModType modType) {
        super(ItemArmor.ArmorMaterial.IRON, 2, 1);
        this.func_77655_b("simplyjetpacks.fluxpack" + modType.suffix);
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.setNoRepair();
        this.func_77637_a(ModCreativeTab.tab);
        this.index = index;
        this.modType = modType;
        this.icons = new IIcon[FluxPack.getHighestMeta(index) + 1];
    }

    public FluxPack getFluxPack(ItemStack itemStack) {
        return FluxPack.getFluxPack(this.index, itemStack.func_77960_j());
    }

    public ItemStack getChargedItem(ItemFluxPack item, int meta) {
        ItemStack full = new ItemStack((Item)item, 1, meta);
        while (item.getEnergyStored(full) < item.getMaxEnergyStored(full)) {
            item.receiveEnergy(full, item.getMaxEnergyStored(full), false);
        }
        return full;
    }

    @Override
    public void toggle(ItemStack itemStack, EntityPlayer player, boolean sneakChangesToggleBehavior, boolean showInChat) {
        FluxPack fluxpack = this.getFluxPack(itemStack);
        if (fluxpack != null) {
            fluxpack.toggle(itemStack, player, showInChat);
        }
    }

    public String func_77667_c(ItemStack itemStack) {
        FluxPack fluxpack = this.getFluxPack(itemStack);
        if (fluxpack != null) {
            return "item.simplyjetpacks." + fluxpack.getBaseName() + this.modType.suffix;
        }
        return super.func_77658_a();
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, int armorSlot) {
        return RenderUtils.getChestplateModel(entityLiving, ModelFluxPack.INSTANCE);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List list, boolean par4) {
        FluxPack fluxpack = this.getFluxPack(itemStack);
        if (fluxpack != null) {
            fluxpack.addInformation(itemStack, player, list, this.getEnergyStored(itemStack));
        }
    }

    public EnumRarity func_77613_e(ItemStack itemStack) {
        FluxPack fluxpack = this.getFluxPack(itemStack);
        if (fluxpack != null) {
            return fluxpack.rarity;
        }
        return super.func_77613_e(itemStack);
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        FluxPack fluxpack = this.getFluxPack(itemStack);
        if (fluxpack != null) {
            fluxpack.useFluxPack((EntityLivingBase)player, itemStack, this);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        for (int i = 0; i <= FluxPack.getHighestMeta(this.index); ++i) {
            FluxPack fluxpack = FluxPack.getFluxPack(this.index, i);
            if (fluxpack == null || !fluxpack.isVisible()) continue;
            if (fluxpack.hasEmptyItem()) {
                list.add(new ItemStack((Item)this, 1, i));
            }
            list.add(this.getChargedItem(this, i));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister register) {
        for (int i = 0; i <= FluxPack.getHighestMeta(this.index); ++i) {
            FluxPack fluxpack = FluxPack.getFluxPack(this.index, i);
            if (fluxpack == null) continue;
            this.icons[i] = register.func_94245_a("simplyjetpacks:" + fluxpack.getBaseName() + this.modType.suffix);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int damage) {
        return damage < this.icons.length ? this.icons[damage] : null;
    }

    @SideOnly(value=Side.CLIENT)
    public String getArmorTexture(ItemStack itemStack, Entity entity, int slot, String type) {
        FluxPack fluxpack = this.getFluxPack(itemStack);
        if (fluxpack != null) {
            return "simplyjetpacks:textures/armor/" + fluxpack.getBaseName() + this.modType.suffix + ".png";
        }
        return null;
    }

    public boolean showDurabilityBar(ItemStack itemStack) {
        FluxPack fluxpack = this.getFluxPack(itemStack);
        if (fluxpack != null) {
            return fluxpack.hasDamageBar();
        }
        return true;
    }

    public double getDurabilityForDisplay(ItemStack itemStack) {
        double stored = this.getMaxEnergyStored(itemStack) - this.getEnergyStored(itemStack) + 1;
        double max = this.getMaxEnergyStored(itemStack) + 1;
        return stored / max;
    }

    public boolean func_77616_k(ItemStack itemStack) {
        FluxPack fluxpack = this.getFluxPack(itemStack);
        return this.func_77619_b() > 0 ? (fluxpack != null ? fluxpack.enchantable : false) : false;
    }

    public int getItemEnchantability(ItemStack itemStack) {
        FluxPack fluxpack = this.getFluxPack(itemStack);
        if (fluxpack != null) {
            return fluxpack.enchantability;
        }
        return super.getItemEnchantability(itemStack);
    }

    public boolean isBookEnchantable(ItemStack itemStack, ItemStack book) {
        return this.func_77616_k(itemStack);
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        FluxPack fluxpack = this.getFluxPack(armor);
        if (fluxpack != null) {
            return fluxpack.getProperties(player, this, armor, source, damage, slot);
        }
        return null;
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        FluxPack fluxpack = this.getFluxPack(armor);
        if (fluxpack != null) {
            return fluxpack.getArmorDisplay(player, this, armor, slot);
        }
        return 0;
    }

    public void damageArmor(EntityLivingBase entity, ItemStack armor, DamageSource source, int damage, int slot) {
        FluxPack fluxpack = this.getFluxPack(armor);
        if (fluxpack != null) {
            fluxpack.damageArmor(entity, this, armor, source, damage, slot);
        }
    }

    @Override
    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        int energy = this.getEnergyStored(container);
        FluxPack fluxpack = this.getFluxPack(container);
        int maxInput = fluxpack != null ? fluxpack.energyPerTickIn : 0;
        int energyReceived = Math.min(this.getMaxEnergyStored(container) - energy, Math.min(maxReceive, maxInput));
        if (!simulate) {
            StackUtils.getNBT(container).func_74768_a("Energy", energy += energyReceived);
        }
        return energyReceived;
    }

    @Override
    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        int energy = this.getEnergyStored(container);
        FluxPack fluxpack = this.getFluxPack(container);
        int maxOutput = fluxpack != null ? fluxpack.energyPerTickOut : 0;
        int energyExtracted = Math.min(energy, Math.min(maxExtract, maxOutput));
        if (!simulate) {
            StackUtils.getNBT(container).func_74768_a("Energy", energy -= energyExtracted);
        }
        return energyExtracted;
    }

    @Override
    public int getEnergyStored(ItemStack container) {
        return StackUtils.getNBT(container).func_74762_e("Energy");
    }

    @Override
    public int getMaxEnergyStored(ItemStack container) {
        FluxPack fluxpack = this.getFluxPack(container);
        return fluxpack != null ? fluxpack.energyCapacity : 0;
    }

    @Override
    public String getEnergyInfo(ItemStack stack) {
        FluxPack fluxpack = this.getFluxPack(stack);
        if (fluxpack != null && fluxpack.hasDamageBar()) {
            int energy = this.getEnergyStored(stack);
            int maxEnergy = this.getMaxEnergyStored(stack);
            int percent = (int)Math.ceil((double)energy / (double)maxEnergy * 100.0);
            return StringUtils.getHUDEnergyText("fluxpack", percent, energy);
        }
        return null;
    }

    @Override
    public String getStatesInfo(ItemStack stack) {
        FluxPack fluxpack = this.getFluxPack(stack);
        if (fluxpack != null) {
            Boolean charger = fluxpack.isOn(stack);
            return StringUtils.getHUDStateText(null, null, charger);
        }
        return null;
    }
}

