/*
 * Decompiled with CFR 0.152.
 */
package tonius.simplyjetpacks.config;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.config.Configuration;
import tonius.simplyjetpacks.config.JetpackDefaults;
import tonius.simplyjetpacks.config.Section;

public class JetpackConfig {
    public final Section section;
    public final JetpackDefaults defaults;
    public Integer energyCapacity;
    public Integer energyPerTick;
    public Double speedVertical;
    public Double accelVertical;
    public Double speedVerticalHover;
    public Double speedVerticalHoverSlow;
    public Double speedSideways;
    public Double sprintSpeedModifier;
    public Double sprintEnergyModifier;
    public Integer armorReduction;
    public Integer armorEnergyPerHit;
    public Boolean enchantable;
    public Integer enchantability;
    public Boolean emergencyHoverMode;
    public Integer chargerRate;

    public JetpackConfig(Section section, JetpackDefaults defaults) {
        this.section = section;
        this.defaults = defaults;
        this.setDefaults();
    }

    public void setDefaults() {
        this.energyCapacity = this.defaults.energyCapacity;
        this.energyPerTick = this.defaults.energyPerTick;
        this.speedVertical = this.defaults.speedVertical;
        this.accelVertical = this.defaults.accelVertical;
        this.speedVerticalHover = this.defaults.speedVerticalHover;
        this.speedVerticalHoverSlow = this.defaults.speedVerticalHoverSlow;
        this.speedSideways = this.defaults.speedSideways;
        this.sprintSpeedModifier = this.defaults.sprintSpeedModifier;
        this.sprintEnergyModifier = this.defaults.sprintEnergyModifier;
        this.armorReduction = this.defaults.armorReduction;
        this.armorEnergyPerHit = this.defaults.armorEnergyPerHit;
        this.enchantable = this.defaults.enchantable;
        this.enchantability = this.defaults.enchantability;
        this.emergencyHoverMode = this.defaults.emergencyHoverMode;
        this.chargerRate = this.defaults.chargerRate;
    }

    public void processConfig(Configuration config) {
        if (this.energyCapacity != null) {
            this.energyCapacity = config.get(this.section.name, "Energy Capacity", this.defaults.energyCapacity.intValue(), "The maximum amount of energy that the jetpack can hold.").getInt(this.defaults.energyCapacity.intValue());
        }
        if (this.energyPerTick != null) {
            this.energyPerTick = config.get(this.section.name, "Energy Usage per Tick", this.defaults.energyPerTick.intValue(), "The amount of energy that the jetpack uses every tick when flying.").getInt(this.defaults.energyPerTick.intValue());
        }
        this.speedVertical = config.get(this.section.name, "Vertical Speed", this.defaults.speedVertical.doubleValue(), "The maximum vertical speed of the jetpack when flying.").getDouble(this.defaults.speedVertical.doubleValue());
        this.accelVertical = config.get(this.section.name, "Vertical Acceleration", this.defaults.accelVertical.doubleValue(), "The vertical acceleration of the jetpack when flying; every tick, this amount of vertical speed will be added until the jetpack reaches the maximum speed.").getDouble(this.defaults.accelVertical.doubleValue());
        if (this.speedVerticalHover != null) {
            this.speedVerticalHover = config.get(this.section.name, "Vertical Speed (Hover Mode)", this.defaults.speedVerticalHover.doubleValue(), "The maximum vertical speed of the jetpack when flying in hover mode.").getDouble(this.defaults.speedVerticalHover.doubleValue());
        }
        if (this.speedVerticalHoverSlow != null) {
            this.speedVerticalHoverSlow = config.get(this.section.name, "Vertical Speed (Hover Mode / Slow Descent)", this.defaults.speedVerticalHoverSlow.doubleValue(), "The maximum vertical speed of the jetpack when slowly descending in hover mode.").getDouble(this.defaults.speedVerticalHoverSlow.doubleValue());
        }
        if (this.speedSideways != null) {
            this.speedSideways = config.get(this.section.name, "Sideways Speed", this.defaults.speedSideways.doubleValue(), "The speed of the jetpack when flying sideways. This is mostly noticeable in hover mode.").getDouble(this.defaults.speedSideways.doubleValue());
        }
        this.sprintSpeedModifier = config.get(this.section.name, "Sprint Speed Modifier", this.defaults.sprintSpeedModifier.doubleValue(), "How much faster the jetpack will fly forward when sprinting. Setting this to 1.0 will make sprinting have no effect apart from the added speed from vanilla.").getDouble(this.defaults.sprintSpeedModifier.doubleValue());
        this.sprintEnergyModifier = config.get(this.section.name, "Sprint Energy Modifier", this.defaults.sprintEnergyModifier.doubleValue(), "How much more energy the jetpack will use when sprinting. Setting this to 1.0 will make sprinting have no effect on energy usage.").getDouble(this.defaults.sprintEnergyModifier.doubleValue());
        if (this.armorReduction != null) {
            this.armorReduction = config.get(this.section.name, "Armor Reduction", this.defaults.armorReduction.intValue(), "How well the ARMORED version of the jetpack can protect the user from damage. The higher the value, the stronger the jetpack's armor will be.").setMinValue(0).setMaxValue(20).getInt(this.defaults.armorReduction.intValue());
        }
        if (this.armorEnergyPerHit != null) {
            int armorEnergyPerHit_temp = config.get(this.section.name, "Armor Energy Per Hit", this.defaults.armorEnergyPerHit.intValue(), "The amount of energy that is consumed from the ARMORED version of the jetpack when getting hit. This value will be multiplied by the amount of damage done.").getInt(this.defaults.armorEnergyPerHit.intValue());
            this.armorEnergyPerHit = armorEnergyPerHit_temp > 0 ? armorEnergyPerHit_temp : 1;
        }
        if (this.enchantable != null) {
            this.enchantable = config.get(this.section.name, "Enchantable", this.defaults.enchantable.booleanValue(), "When enabled, this jetpack will be enchantable using enchantment tables or anvils.").getBoolean(this.defaults.enchantable.booleanValue());
        }
        if (this.enchantability != null) {
            this.enchantability = config.get(this.section.name, "Enchantability", this.defaults.enchantability.intValue(), "The enchantability of the jetpack. Note that the jetpack may be set not to be enchantable.").setMinValue(0).getInt(this.defaults.enchantability.intValue());
        }
        if (this.emergencyHoverMode != null) {
            this.emergencyHoverMode = config.get(this.section.name, "Emergency Hover Mode", this.defaults.emergencyHoverMode.booleanValue(), "When enabled, this jetpack will activate hover mode automatically when the wearer is about to die from a fall.").getBoolean(this.defaults.emergencyHoverMode.booleanValue());
        }
        if (this.chargerRate != null) {
            this.chargerRate = config.get(this.section.name, "Charger Energy Rate", this.defaults.chargerRate.intValue(), "The rate, in RF per tick, at which this jetpack can charge other items. Set to 0 to disable this jetpack charging items.").getInt(this.defaults.chargerRate.intValue());
        }
    }

    public void writeToNBT(NBTTagCompound tag) {
        if (this.energyCapacity != null) {
            tag.func_74768_a("EnergyCapacity", this.energyCapacity.intValue());
        }
        if (this.energyPerTick != null) {
            tag.func_74768_a("EnergyPerTick", this.energyPerTick.intValue());
        }
        tag.func_74780_a("SpeedVertical", this.speedVertical.doubleValue());
        tag.func_74780_a("AccelVertical", this.accelVertical.doubleValue());
        if (this.speedVerticalHover != null) {
            tag.func_74780_a("SpeedVerticalHover", this.speedVerticalHover.doubleValue());
        }
        if (this.speedVerticalHoverSlow != null) {
            tag.func_74780_a("SpeedVerticalHoverSlow", this.speedVerticalHoverSlow.doubleValue());
        }
        if (this.speedSideways != null) {
            tag.func_74780_a("SpeedSideways", this.speedSideways.doubleValue());
        }
        tag.func_74780_a("SprintSpeedModifier", this.sprintSpeedModifier.doubleValue());
        tag.func_74780_a("SprintEnergyModifier", this.sprintEnergyModifier.doubleValue());
        if (this.armorReduction != null) {
            tag.func_74768_a("ArmorReduction", this.armorReduction.intValue());
        }
        if (this.chargerRate != null) {
            tag.func_74768_a("ChargerRate", this.chargerRate.intValue());
        }
    }

    public void readFromNBT(NBTTagCompound tag) {
        if (this.energyCapacity != null) {
            this.energyCapacity = tag.func_74762_e("EnergyCapacity");
        }
        if (this.energyPerTick != null) {
            this.energyPerTick = tag.func_74762_e("EnergyPerTick");
        }
        this.speedVertical = tag.func_74769_h("SpeedVertical");
        this.accelVertical = tag.func_74769_h("AccelVertical");
        if (this.speedVerticalHover != null) {
            this.speedVerticalHover = tag.func_74769_h("SpeedVerticalHover");
        }
        if (this.speedVerticalHoverSlow != null) {
            this.speedVerticalHoverSlow = tag.func_74769_h("SpeedVerticalHoverSlow");
        }
        if (this.speedSideways != null) {
            this.speedSideways = tag.func_74769_h("SpeedSideways");
        }
        this.sprintSpeedModifier = tag.func_74769_h("SprintSpeedModifier");
        this.sprintEnergyModifier = tag.func_74769_h("SprintEnergyModifier");
        if (this.armorReduction != null) {
            this.armorReduction = tag.func_74762_e("ArmorReduction");
        }
        if (this.chargerRate != null) {
            this.chargerRate = tag.func_74762_e("ChargerRate");
        }
    }
}

