/*
 * Decompiled with CFR 0.152.
 */
package tonius.simplyjetpacks.config;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.config.Configuration;
import tonius.simplyjetpacks.config.FluxPackDefaults;
import tonius.simplyjetpacks.config.Section;

public class FluxPackConfig {
    public final Section section;
    public final FluxPackDefaults defaults;
    public Integer energyCapacity;
    public Integer energyInRate;
    public Integer energyOutRate;
    public Integer armorReduction;
    public Integer armorEnergyPerHit;
    public Boolean enchantable;
    public Integer enchantability;

    public FluxPackConfig(Section section, FluxPackDefaults defaults) {
        this.section = section;
        this.defaults = defaults;
        this.setDefaults();
    }

    public void setDefaults() {
        this.energyCapacity = this.defaults.energyCapacity;
        this.energyInRate = this.defaults.energyInRate;
        this.energyOutRate = this.defaults.energyOutRate;
        this.armorReduction = this.defaults.armorReduction;
        this.armorEnergyPerHit = this.defaults.armorEnergyPerHit;
        this.enchantable = this.defaults.enchantable;
        this.enchantability = this.defaults.enchantability;
    }

    public void processConfig(Configuration config) {
        if (this.energyCapacity != null) {
            this.energyCapacity = config.get(this.section.name, "Energy Capacity", this.defaults.energyCapacity.intValue(), "The maximum amount of energy that the flux pack can hold.").getInt(this.defaults.energyCapacity.intValue());
        }
        if (this.energyInRate != null) {
            this.energyInRate = config.get(this.section.name, "Energy Usage per Tick", this.defaults.energyInRate.intValue(), "The rate in RF/t at which the flux pack can be charged.").getInt(this.defaults.energyInRate.intValue());
        }
        if (this.energyOutRate != null) {
            this.energyOutRate = config.get(this.section.name, "Energy Usage per Tick", this.defaults.energyOutRate.intValue(), "The rate in RF/t at which the flux pack can charge other items.").getInt(this.defaults.energyOutRate.intValue());
        }
        if (this.armorReduction != null) {
            this.armorReduction = config.get(this.section.name, "Armor Reduction", this.defaults.armorReduction.intValue(), "How well the ARMORED version of the flux pack can protect the user from damage. The higher the value, the stronger the flux pack's armor will be.").setMinValue(0).setMaxValue(20).getInt(this.defaults.armorReduction.intValue());
        }
        if (this.armorEnergyPerHit != null) {
            int armorEnergyPerHit_temp = config.get(this.section.name, "Armor Energy Per Hit", this.defaults.armorEnergyPerHit.intValue(), "The amount of energy that is consumed from the ARMORED version of the flux pack when getting hit. This value will be multiplied by the amount of damage done.").getInt(this.defaults.armorEnergyPerHit.intValue());
            this.armorEnergyPerHit = armorEnergyPerHit_temp > 0 ? armorEnergyPerHit_temp : 1;
        }
        if (this.enchantable != null) {
            this.enchantable = config.get(this.section.name, "Enchantable", this.defaults.enchantable.booleanValue(), "When enabled, this flux pack will be enchantable using enchantment tables or anvils.").getBoolean(this.defaults.enchantable.booleanValue());
        }
        if (this.enchantability != null) {
            this.enchantability = config.get(this.section.name, "Enchantability", this.defaults.enchantability.intValue(), "The enchantability of the flux pack. Note that the flux pack may be set not to be enchantable.").setMinValue(0).getInt(this.defaults.enchantability.intValue());
        }
    }

    public void writeToNBT(NBTTagCompound tag) {
        if (this.energyCapacity != null) {
            tag.func_74768_a("EnergyCapacity", this.energyCapacity.intValue());
        }
        if (this.energyInRate != null) {
            tag.func_74768_a("EnergyInRate", this.energyInRate.intValue());
        }
        if (this.energyOutRate != null) {
            tag.func_74768_a("EnergyOutRate", this.energyOutRate.intValue());
        }
        if (this.armorReduction != null) {
            tag.func_74768_a("ArmorReduction", this.armorReduction.intValue());
        }
    }

    public void readFromNBT(NBTTagCompound tag) {
        if (this.energyCapacity != null) {
            this.energyCapacity = tag.func_74762_e("EnergyCapacity");
        }
        if (this.energyInRate != null) {
            this.energyInRate = tag.func_74762_e("EnergyInRate");
        }
        if (this.energyOutRate != null) {
            this.energyOutRate = tag.func_74762_e("EnergyOutRate");
        }
        if (this.armorReduction != null) {
            this.armorReduction = tag.func_74762_e("ArmorReduction");
        }
    }
}

