/*
 * Decompiled with CFR 0.152.
 */
package tonius.simplyjetpacks.config;

import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraftforge.common.config.Configuration;
import tonius.simplyjetpacks.SimplyJetpacks;
import tonius.simplyjetpacks.client.util.RenderUtils;
import tonius.simplyjetpacks.config.Defaults;
import tonius.simplyjetpacks.config.FluxPackConfig;
import tonius.simplyjetpacks.config.FluxPackDefaults;
import tonius.simplyjetpacks.config.JetpackConfig;
import tonius.simplyjetpacks.config.JetpackDefaults;
import tonius.simplyjetpacks.config.Section;
import tonius.simplyjetpacks.item.fluxpack.FluxPack;
import tonius.simplyjetpacks.item.jetpack.Jetpack;

public class Config {
    public static Configuration config;
    public static Configuration configClient;
    public static List<Section> configSections;
    public static Map<Integer, JetpackDefaults> jetpackDefaults;
    public static Map<Integer, JetpackConfig> jetpackConfigs;
    public static Map<Integer, FluxPackDefaults> fluxPackDefaults;
    public static Map<Integer, FluxPackConfig> fluxPackConfigs;
    public static final Section sectionIntegration;
    public static final Section sectionControls;
    public static final Section sectionAesthetics;
    public static final Section sectionGui;
    public static final Section sectionCrafting;
    public static boolean enableIntegrationTE;
    public static boolean enableIntegrationEIO;
    public static boolean customControls;
    public static String flyKey;
    public static String descendKey;
    public static boolean invertHoverSneakingBehavior;
    public static boolean sneakChangesToggleBehavior;
    public static boolean enableJetpackModel;
    public static boolean enableStateChatMessages;
    public static boolean enableEnergyHUD;
    public static boolean enableStateHUD;
    public static int energyHUDOffsetX;
    public static int energyHUDOffsetY;
    public static int energyHUDPosition;
    public static double energyHUDScale;
    public static boolean holdShiftForDetails;
    public static boolean minimalEnergyHUD;
    public static boolean showEnergyHUDWhileChatting;
    public static boolean showExactEnergyInHUD;
    public static boolean enableCraftingArmorPlating;
    public static boolean enableCraftingPotatoJetpack;
    public static boolean enableCraftingJetPlate;

    private static void initJetpackConfigs() {
        jetpackDefaults.put(0, new JetpackDefaults(1200, 45, 0.9, 0.5, null, null, null, null, null, null, null, null, null, null, null));
        jetpackDefaults.put(1, new JetpackDefaults(25000, 10, 0.22, 0.1, 0.18, 0.14, 0.0, null, null, 5, 80, false, 8, false, null));
        jetpackDefaults.put(2, new JetpackDefaults(400000, 50, 0.3, 0.12, 0.18, 0.1, 0.08, null, null, 6, 80, false, 11, false, null));
        jetpackDefaults.put(3, new JetpackDefaults(2000000, 100, 0.48, 0.13, 0.34, 0.03, 0.14, 1.3, 3.0, 7, 120, true, 14, true, null));
        jetpackDefaults.put(4, new JetpackDefaults(10000000, 200, 0.8, 0.14, 0.4, 0.005, 0.19, 1.8, 5.0, 8, 160, true, 17, true, null));
        jetpackDefaults.put(5, new JetpackDefaults(50000000, 400, 0.9, 0.15, 0.45, 0.0, 0.21, 2.4, 8.0, 12, 240, true, 20, true, 20000));
        for (int i : jetpackDefaults.keySet()) {
            jetpackConfigs.put(i, new JetpackConfig(new Section(false, "Tuning - Jetpack tier " + i, "tuningJetpack" + i), jetpackDefaults.get(i)));
        }
        jetpackDefaults.put(9001, new JetpackDefaults(null, null, 0.9, 0.15, 0.45, 0.0, 0.21, 2.5, null, 12, null, true, 20, true, 20000));
        jetpackConfigs.put(9001, new JetpackConfig(new Section(false, "Tuning - Creative Jetpack", "tuningJetpackCreative"), jetpackDefaults.get(9001)));
    }

    private static void initFluxPackConfigs() {
        fluxPackDefaults.put(1, new FluxPackDefaults(400000, 80, 80, null, null, false, 4));
        fluxPackDefaults.put(2, new FluxPackDefaults(2000000, 400, 400, 5, 80, false, 6));
        fluxPackDefaults.put(3, new FluxPackDefaults(10000000, 2000, 2000, 6, 120, true, 8));
        fluxPackDefaults.put(4, new FluxPackDefaults(50000000, 10000, 10000, 7, 160, true, 10));
        for (int i : fluxPackDefaults.keySet()) {
            fluxPackConfigs.put(i, new FluxPackConfig(new Section(false, "Tuning - Flux Pack tier " + i, "tuningFluxPack" + i), fluxPackDefaults.get(i)));
        }
        fluxPackDefaults.put(9001, new FluxPackDefaults(null, null, 20000, 8, null, true, 10));
        fluxPackConfigs.put(9001, new FluxPackConfig(new Section(false, "Tuning - Creative Flux Pack", "tuningFluxPackCreative"), fluxPackDefaults.get(9001)));
    }

    public static void preInit(FMLPreInitializationEvent evt) {
        FMLCommonHandler.instance().bus().register((Object)new Config());
        config = new Configuration(new File(evt.getModConfigurationDirectory(), "simplyjetpacks.cfg"));
        configClient = new Configuration(new File(evt.getModConfigurationDirectory(), "simplyjetpacks-client.cfg"));
        Config.initJetpackConfigs();
        Config.initFluxPackConfigs();
        Config.syncConfig();
        SimplyJetpacks.proxy.updateCustomKeybinds();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void syncConfig() {
        SimplyJetpacks.logger.info("Loading configuration files");
        try {
            Config.processConfig();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            config.save();
            configClient.save();
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent evt) {
        Config.onConfigChanged(evt.modID);
    }

    public static void onConfigChanged(String modid) {
        if (modid.equals("simplyjetpacks")) {
            Config.syncConfig();
            Jetpack.reconstructJetpacks();
            FluxPack.reconstructFluxPacks();
            SimplyJetpacks.proxy.updateCustomKeybinds();
        }
    }

    public static void processConfig() {
        enableIntegrationTE = config.get(Config.sectionIntegration.name, "Thermal Expansion integration", true, "When enabled, Simply Jetpacks will register its Thermal Expansion-based jetpacks and flux packs.").setRequiresMcRestart(true).getBoolean(true);
        enableIntegrationEIO = config.get(Config.sectionIntegration.name, "Ender IO integration", true, "When enabled, Simply Jetpacks will register its Ender IO-based jetpacks and flux packs.").setRequiresMcRestart(true).getBoolean(true);
        customControls = configClient.get(Config.sectionControls.name, "Custom controls", false, "When enabled, the key codes specified here will be used for the fly and descend keys. Otherwise, the vanilla jump and sneak keys will be used.").getBoolean(false);
        flyKey = configClient.get(Config.sectionControls.name, "Custom Fly key", "SPACE", "The name of the Fly key when custom controls are enabled.").getString();
        descendKey = configClient.get(Config.sectionControls.name, "Custom Descend key", "LSHIFT", "The name of the Descend key when custom controls are enabled.").getString();
        invertHoverSneakingBehavior = configClient.get(Config.sectionControls.name, "Invert Hover Mode sneaking behavior", false, "Invert Hover Mode sneaking behavior").getBoolean(false);
        sneakChangesToggleBehavior = configClient.get(Config.sectionControls.name, "Sneak Changes Toggle Behavior", true, "If enabled, when sneaking, the Turn on/off and Switch mode keys will respectively toggle JetPlate chargers and emergency hover mode. If not, use /simplyjetpacks_switch or /sjs to toggle these features.").getBoolean(true);
        enableJetpackModel = configClient.get(Config.sectionAesthetics.name, "Enable Jetpack 3D Model", true, "When enabled, worn jetpacks will have a 3D armor model. Otherwise, flat textures will be used.").getBoolean(true);
        enableStateChatMessages = configClient.get(Config.sectionGui.name, "Enable State Chat Messages", false, "When enabled, switching jetpacks on or off will display chat messages.").getBoolean(false);
        enableEnergyHUD = configClient.get(Config.sectionGui.name, "Enable Energy HUD", true, "When enabled, a HUD that displays your current jetpack's energy level will show.").getBoolean(true);
        enableStateHUD = configClient.get(Config.sectionGui.name, "Enable State HUD", true, "When enabled, a HUD that displays your current jetpack's engine and hover mode state will show.").getBoolean(true);
        energyHUDOffsetX = configClient.get(Config.sectionGui.name, "Energy HUD Offset - X", 0, "The energy HUD display will be shifted horizontally by this value. This value may be negative.").getInt(0);
        energyHUDOffsetY = configClient.get(Config.sectionGui.name, "Energy HUD Offset - Y", 0, "The energy HUD display will be shifted vertically by this value. This value may be negative.").getInt(0);
        energyHUDPosition = configClient.get(Config.sectionGui.name, "Energy HUD Base Position", Defaults.energyHUDPosition, "The base position of the energy HUD on the screen. 0 = top left, 1 = top center, 2 = top right, 3 = left, 4 = right, 5 = bottom left, 6 = bottom right").setMinValue(0).setMaxValue(RenderUtils.HUDPosition.values().length - 1).getInt(Defaults.energyHUDPosition);
        energyHUDScale = Math.abs(configClient.get(Config.sectionGui.name, "Energy HUD Scale", 1.0, "How large the energy HUD will be rendered. Default is 1.0, can be bigger or smaller").setMinValue(0.001).getDouble(1.0));
        holdShiftForDetails = configClient.get(Config.sectionGui.name, "Hold Shift for Details", true, "When enabled, item details are only shown in the tooltip when holding Shift.").getBoolean(true);
        minimalEnergyHUD = configClient.get(Config.sectionGui.name, "Minimal Energy HUD", false, "When enabled, only the actual power amounts will be rendered on the energy HUD.").getBoolean(false);
        showEnergyHUDWhileChatting = configClient.get(Config.sectionGui.name, "Show Energy HUD while chatting", true, "When enabled, the energy HUD will display even when the chat window is opened.").getBoolean(true);
        showExactEnergyInHUD = configClient.get(Config.sectionGui.name, "Exact energy amounts in Energy HUD", false, "When enabled, the energy HUD will display the exact amount of RF other than just a percentage.").getBoolean(false);
        enableCraftingArmorPlating = config.get(Config.sectionCrafting.name, "Armor Plating craftable", true, "When enabled, Armor Plating items will be craftable, and thus armored jetpacks are available.").setRequiresMcRestart(true).getBoolean(true);
        enableCraftingPotatoJetpack = config.get(Config.sectionCrafting.name, "Potato Jetpack craftable", true, "When enabled, the Potato Jetpack will be craftable.").setRequiresMcRestart(true).getBoolean(true);
        enableCraftingJetPlate = config.get(Config.sectionCrafting.name, "JetPlates craftable", true, "When enabled, JetPlates will be craftable.").setRequiresMcRestart(true).getBoolean(true);
        for (JetpackConfig jc : jetpackConfigs.values()) {
            jc.processConfig(config);
        }
        for (FluxPackConfig fc : fluxPackConfigs.values()) {
            fc.processConfig(config);
        }
    }

    static {
        configSections = new ArrayList<Section>();
        jetpackDefaults = new HashMap<Integer, JetpackDefaults>();
        jetpackConfigs = new HashMap<Integer, JetpackConfig>();
        fluxPackDefaults = new HashMap<Integer, FluxPackDefaults>();
        fluxPackConfigs = new HashMap<Integer, FluxPackConfig>();
        sectionIntegration = new Section(false, "Integration Settings", "integration");
        sectionControls = new Section(true, "Controls Settings", "controls");
        sectionAesthetics = new Section(true, "Aesthetics Settings", "aesthetics");
        sectionGui = new Section(true, "GUI Settings", "gui");
        sectionCrafting = new Section(false, "Crafting Settings", "crafting");
        enableIntegrationTE = true;
        enableIntegrationEIO = true;
        customControls = false;
        flyKey = "SPACE";
        descendKey = "LSHIFT";
        invertHoverSneakingBehavior = false;
        sneakChangesToggleBehavior = true;
        enableJetpackModel = true;
        enableStateChatMessages = false;
        enableEnergyHUD = true;
        enableStateHUD = true;
        energyHUDOffsetX = 0;
        energyHUDOffsetY = 0;
        energyHUDPosition = Defaults.energyHUDPosition;
        energyHUDScale = 1.0;
        holdShiftForDetails = true;
        minimalEnergyHUD = false;
        showEnergyHUDWhileChatting = true;
        showExactEnergyInHUD = false;
        enableCraftingArmorPlating = true;
        enableCraftingPotatoJetpack = true;
        enableCraftingJetPlate = true;
    }
}

