/*
 * Decompiled with CFR 0.152.
 */
package tonius.simplyjetpacks.client.handler;

import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.InputEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.Iterator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;
import tonius.simplyjetpacks.SimplyJetpacks;
import tonius.simplyjetpacks.SyncTracker;
import tonius.simplyjetpacks.config.Config;
import tonius.simplyjetpacks.item.IModeSwitchable;
import tonius.simplyjetpacks.item.IToggleable;
import tonius.simplyjetpacks.item.ItemJetpack;
import tonius.simplyjetpacks.item.jetpack.Jetpack;
import tonius.simplyjetpacks.item.jetpack.JetpackParticleType;
import tonius.simplyjetpacks.network.PacketHandler;
import tonius.simplyjetpacks.network.message.MessageKeyboardSync;
import tonius.simplyjetpacks.network.message.MessageModKey;
import tonius.simplyjetpacks.setup.ModControls;

public class ClientTickHandler {
    private static Minecraft mc = Minecraft.func_71410_x();
    private static int flyKey;
    private static int descendKey;
    private static boolean lastFlyState;
    private static boolean lastDescendState;
    private static boolean lastForwardState;
    private static boolean lastBackwardState;
    private static boolean lastLeftState;
    private static boolean lastRightState;
    private static JetpackParticleType lastJetpackState;
    private static KeyBinding keyToggle;
    private static KeyBinding keyMode;

    public ClientTickHandler() {
        ClientRegistry.registerKeyBinding((KeyBinding)keyToggle);
        ClientRegistry.registerKeyBinding((KeyBinding)keyMode);
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent evt) {
        if (evt.phase == TickEvent.Phase.START) {
            ClientTickHandler.tickStart();
        } else {
            ClientTickHandler.tickEnd();
        }
    }

    public static void updateCustomKeybinds() {
        flyKey = Keyboard.getKeyIndex((String)Config.flyKey);
        descendKey = Keyboard.getKeyIndex((String)Config.descendKey);
    }

    private static void tickStart() {
        if (ClientTickHandler.mc.field_71439_g != null) {
            Jetpack jetpack;
            boolean descendState;
            boolean flyState;
            if (Config.customControls) {
                flyState = ClientTickHandler.mc.field_71415_G && Keyboard.isKeyDown((int)flyKey);
                descendState = ClientTickHandler.mc.field_71415_G && Keyboard.isKeyDown((int)descendKey);
            } else {
                flyState = ClientTickHandler.mc.field_71474_y.field_74314_A.func_151470_d();
                descendState = ClientTickHandler.mc.field_71474_y.field_74311_E.func_151470_d();
            }
            boolean forwardState = ClientTickHandler.mc.field_71474_y.field_74351_w.func_151470_d();
            boolean backwardState = ClientTickHandler.mc.field_71474_y.field_74368_y.func_151470_d();
            boolean leftState = ClientTickHandler.mc.field_71474_y.field_74370_x.func_151470_d();
            boolean rightState = ClientTickHandler.mc.field_71474_y.field_74366_z.func_151470_d();
            if (flyState != lastFlyState || descendState != lastDescendState || forwardState != lastForwardState || backwardState != lastBackwardState || leftState != lastLeftState || rightState != lastRightState) {
                lastFlyState = flyState;
                lastDescendState = descendState;
                lastForwardState = forwardState;
                lastBackwardState = backwardState;
                lastLeftState = leftState;
                lastRightState = rightState;
                PacketHandler.instance.sendToServer((IMessage)new MessageKeyboardSync(flyState, descendState, forwardState, backwardState, leftState, rightState));
                SyncTracker.processKeyUpdate((EntityPlayer)ClientTickHandler.mc.field_71439_g, flyState, descendState, forwardState, backwardState, leftState, rightState);
            }
            JetpackParticleType jetpackState = null;
            ItemStack armor = ClientTickHandler.mc.field_71439_g.func_71124_b(3);
            if (armor != null && armor.func_77973_b() instanceof ItemJetpack && (jetpack = ((ItemJetpack)armor.func_77973_b()).getJetpack(armor)) != null) {
                jetpackState = jetpack.particleToShow(armor, (ItemJetpack)armor.func_77973_b(), (EntityLivingBase)ClientTickHandler.mc.field_71439_g);
            }
            if (jetpackState != lastJetpackState) {
                lastJetpackState = jetpackState;
                SyncTracker.processJetpackUpdate(ClientTickHandler.mc.field_71439_g.func_145782_y(), jetpackState);
            }
        }
    }

    private static void tickEnd() {
        if (ClientTickHandler.mc.field_71439_g != null && ClientTickHandler.mc.field_71441_e != null && !mc.func_147113_T()) {
            Iterator<Integer> itr = SyncTracker.getJetpackStates().keySet().iterator();
            while (itr.hasNext()) {
                int currentEntity = itr.next();
                Entity entity = ClientTickHandler.mc.field_71441_e.func_73045_a(currentEntity);
                if (entity == null || !(entity instanceof EntityLivingBase) || entity.field_71093_bK != ClientTickHandler.mc.field_71439_g.field_71093_bK) {
                    itr.remove();
                    continue;
                }
                JetpackParticleType particle = SyncTracker.getJetpackStates().get(currentEntity);
                if (particle != null) {
                    SimplyJetpacks.proxy.showJetpackParticles((World)ClientTickHandler.mc.field_71441_e, (EntityLivingBase)entity, particle);
                    continue;
                }
                itr.remove();
            }
        }
    }

    @SubscribeEvent
    public void onKey(InputEvent evt) {
        ItemStack itemStack;
        boolean toggle = keyToggle.func_151468_f();
        boolean mode = keyMode.func_151468_f();
        if ((toggle || mode) && ClientTickHandler.mc.field_71415_G && (itemStack = ClientTickHandler.mc.field_71439_g.func_71124_b(3)) != null) {
            if (toggle && itemStack.func_77973_b() instanceof IToggleable) {
                PacketHandler.instance.sendToServer((IMessage)new MessageModKey(ModControls.TOGGLE, Config.sneakChangesToggleBehavior, Config.enableStateChatMessages));
            } else if (mode && itemStack.func_77973_b() instanceof IModeSwitchable) {
                PacketHandler.instance.sendToServer((IMessage)new MessageModKey(ModControls.MODE, Config.sneakChangesToggleBehavior, Config.enableStateChatMessages));
            }
        }
    }

    static {
        lastFlyState = false;
        lastDescendState = false;
        lastForwardState = false;
        lastBackwardState = false;
        lastLeftState = false;
        lastRightState = false;
        lastJetpackState = null;
        keyToggle = new KeyBinding("Turn on/off", 33, "Simply Jetpacks");
        keyMode = new KeyBinding("Switch mode", 46, "Simply Jetpacks");
    }
}

