/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.minecraft.dragon.server.cmd;

import info.ata4.minecraft.dragon.server.entity.EntityTameableDragon;
import info.ata4.minecraft.dragon.server.entity.breeds.DragonBreed;
import info.ata4.minecraft.dragon.server.entity.helper.DragonBreedRegistry;
import info.ata4.minecraft.dragon.server.entity.helper.DragonLifeStage;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.SyntaxErrorException;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.WorldServer;
import org.apache.commons.lang3.StringUtils;

public class CommandDragon
extends CommandBase {
    public String func_71517_b() {
        return "dragon";
    }

    public String func_71518_a(ICommandSender sender) {
        String stages = StringUtils.join((Object[])DragonLifeStage.values(), (char)'|').toLowerCase();
        String breeds = StringUtils.join(DragonBreedRegistry.getInstance().getBreeds(), (char)'|');
        return String.format("/dragon <stage <%s>|breed <%s> [global]", stages, breeds);
    }

    public int func_82362_a() {
        return 3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void func_71515_b(ICommandSender sender, String[] params) {
        if (params.length < 1 || params[0].isEmpty()) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        boolean global = params[params.length - 1].equalsIgnoreCase("global");
        String command = params[0];
        if (command.equals("stage")) {
            if (params.length < 2) {
                throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
            }
            DragonLifeStage lifeStage = null;
            String parameter = params[1].toUpperCase();
            if (!parameter.equals("ITEM")) {
                try {
                    lifeStage = DragonLifeStage.valueOf(parameter);
                }
                catch (IllegalArgumentException ex) {
                    throw new SyntaxErrorException();
                }
            }
            LifeStageModifier modifier = new LifeStageModifier(lifeStage);
            this.appyModifier(sender, modifier, global);
            return;
        }
        if (command.equals("breed")) {
            if (params.length < 2) {
                throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
            }
            String breedName = params[1].toLowerCase();
            DragonBreed breed = DragonBreedRegistry.getInstance().getBreedByName(breedName);
            if (breed == null) {
                throw new SyntaxErrorException();
            }
            this.appyModifier(sender, new BreedModifier(breed), global);
            return;
        } else {
            if (!command.equals("tame")) throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
            if (!(sender instanceof EntityPlayerMP)) throw new CommandException("commands.dragon.canttame", new Object[0]);
            EntityPlayerMP player = (EntityPlayerMP)sender;
            this.appyModifier(sender, new TameModifier(player), global);
        }
    }

    private void appyModifier(ICommandSender sender, EntityModifier modifier, boolean global) {
        if (!global && sender instanceof EntityPlayerMP) {
            EntityPlayerMP player = CommandDragon.func_71521_c((ICommandSender)sender);
            double range = 64.0;
            AxisAlignedBB aabb = AxisAlignedBB.func_72330_a((double)(player.field_70165_t - 1.0), (double)(player.field_70163_u - 1.0), (double)(player.field_70161_v - 1.0), (double)(player.field_70165_t + 1.0), (double)(player.field_70163_u + 1.0), (double)(player.field_70161_v + 1.0));
            aabb = aabb.func_72314_b(range, range, range);
            List entities = player.field_70170_p.func_72872_a(EntityTameableDragon.class, aabb);
            Entity closestEntity = null;
            float minPlayerDist = Float.MAX_VALUE;
            for (int i = 0; i < entities.size(); ++i) {
                Entity entity = (Entity)entities.get(i);
                float playerDist = entity.func_70032_d((Entity)player);
                if (!(entity.func_70032_d((Entity)player) < minPlayerDist)) continue;
                closestEntity = entity;
                minPlayerDist = playerDist;
            }
            if (closestEntity == null) {
                throw new CommandException("commands.dragon.nodragons", new Object[0]);
            }
            modifier.modify((EntityTameableDragon)closestEntity);
        } else {
            MinecraftServer server = MinecraftServer.func_71276_C();
            for (WorldServer worldServer : server.field_71305_c) {
                List entities = worldServer.field_72996_f;
                for (int i = 0; i < entities.size(); ++i) {
                    Entity entity = (Entity)entities.get(i);
                    if (!(entity instanceof EntityTameableDragon)) continue;
                    modifier.modify((EntityTameableDragon)entity);
                }
            }
        }
    }

    private class TameModifier
    implements EntityModifier {
        private EntityPlayerMP player;

        TameModifier(EntityPlayerMP player) {
            this.player = player;
        }

        @Override
        public void modify(EntityTameableDragon dragon) {
            dragon.tamedFor((EntityPlayer)this.player, true);
        }
    }

    private class BreedModifier
    implements EntityModifier {
        private DragonBreed breed;

        BreedModifier(DragonBreed breed) {
            this.breed = breed;
        }

        @Override
        public void modify(EntityTameableDragon dragon) {
            dragon.setBreed(this.breed);
        }
    }

    private class LifeStageModifier
    implements EntityModifier {
        private DragonLifeStage lifeStage;

        LifeStageModifier(DragonLifeStage lifeStage) {
            this.lifeStage = lifeStage;
        }

        @Override
        public void modify(EntityTameableDragon dragon) {
            if (this.lifeStage == null) {
                dragon.getLifeStageHelper().transformToEgg();
            } else {
                dragon.getLifeStageHelper().setLifeStage(this.lifeStage);
            }
        }
    }

    private static interface EntityModifier {
        public void modify(EntityTameableDragon var1);
    }
}

