/*
 * Decompiled with CFR 0.152.
 */
package redstonearsenal.item.armor;

import cofh.api.energy.IEnergyContainerItem;
import cofh.core.item.ItemArmorAdv;
import cofh.lib.util.helpers.EnergyHelper;
import cofh.lib.util.helpers.MathHelper;
import cofh.lib.util.helpers.StringHelper;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraftforge.common.ISpecialArmor;

public class ItemArmorRF
extends ItemArmorAdv
implements ISpecialArmor,
IEnergyContainerItem {
    public static final ISpecialArmor.ArmorProperties UNBLOCKABLE = new ISpecialArmor.ArmorProperties(0, 0.0, 0);
    public static final ISpecialArmor.ArmorProperties FLUX = new ISpecialArmor.ArmorProperties(0, 0.125, Integer.MAX_VALUE);
    public int maxEnergy = 400000;
    public int maxTransfer = 2000;
    public double absorbRatio = 0.8;
    public int energyPerDamage = 160;
    public String[] textures = new String[2];

    public ItemArmorRF(ItemArmor.ArmorMaterial armorMaterial, int n) {
        super(armorMaterial, n);
    }

    public boolean func_82789_a(ItemStack itemStack, ItemStack itemStack2) {
        return false;
    }

    public EnumRarity func_77613_e(ItemStack itemStack) {
        return EnumRarity.uncommon;
    }

    public void func_77624_a(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean bl) {
        if (StringHelper.displayShiftForDetail && !StringHelper.isShiftKeyDown()) {
            list.add(StringHelper.shiftForDetails());
        }
        if (!StringHelper.isShiftKeyDown()) {
            return;
        }
        if (itemStack.field_77990_d == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)itemStack, (int)0);
        }
        list.add(StringHelper.localize((String)"info.cofh.charge") + ": " + itemStack.field_77990_d.func_74762_e("Energy") + " / " + this.maxEnergy + " RF");
    }

    public int getDisplayDamage(ItemStack itemStack) {
        if (itemStack.field_77990_d == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)itemStack, (int)0);
        }
        return this.maxEnergy - itemStack.field_77990_d.func_74762_e("Energy");
    }

    public int getMaxDamage(ItemStack itemStack) {
        return this.maxEnergy;
    }

    public boolean isDamaged(ItemStack itemStack) {
        return true;
    }

    public void func_150895_a(Item item, CreativeTabs creativeTabs, List list) {
        list.add(EnergyHelper.setDefaultEnergyTag((ItemStack)new ItemStack(item, 1, 0), (int)0));
        list.add(EnergyHelper.setDefaultEnergyTag((ItemStack)new ItemStack(item, 1, 0), (int)this.maxEnergy));
    }

    protected int getBaseAbsorption() {
        return 20;
    }

    protected int getAbsorptionRatio() {
        switch (((ItemArmor)this).field_77881_a) {
            case 0: {
                return 15;
            }
            case 1: {
                return 40;
            }
            case 2: {
                return 30;
            }
            case 3: {
                return 15;
            }
        }
        return 0;
    }

    protected int getEnergyPerDamage(ItemStack itemStack) {
        int n = MathHelper.clampI((int)EnchantmentHelper.func_77506_a((int)Enchantment.field_77347_r.field_77352_x, (ItemStack)itemStack), (int)0, (int)4);
        return this.energyPerDamage * (5 - n) / 5;
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase entityLivingBase, ItemStack itemStack, DamageSource damageSource, double d, int n) {
        if (damageSource.field_76373_n.equals("flux")) {
            return FLUX;
        }
        if (damageSource.func_76363_c()) {
            return UNBLOCKABLE;
        }
        int n2 = this.getEnergyPerDamage(itemStack) > 0 ? 25 * this.getEnergyStored(itemStack) / this.getEnergyPerDamage(itemStack) : 0;
        return new ISpecialArmor.ArmorProperties(0, this.absorbRatio * (double)this.func_82812_d().func_78044_b(((ItemArmor)this).field_77881_a) * 0.05, n2);
    }

    public int getArmorDisplay(EntityPlayer entityPlayer, ItemStack itemStack, int n) {
        if (this.getEnergyStored(itemStack) >= this.getEnergyPerDamage(itemStack)) {
            return Math.min(this.getBaseAbsorption(), 20) * this.getAbsorptionRatio() / 100;
        }
        return 0;
    }

    public void damageArmor(EntityLivingBase entityLivingBase, ItemStack itemStack, DamageSource damageSource, int n, int n2) {
        if (damageSource.field_76373_n.equals("flux")) {
            boolean bl = damageSource.func_76346_g() == null;
            this.receiveEnergy(itemStack, n * (bl ? this.energyPerDamage / 2 : this.getEnergyPerDamage(itemStack)), false);
        } else {
            this.extractEnergy(itemStack, n * this.getEnergyPerDamage(itemStack), false);
        }
    }

    public int receiveEnergy(ItemStack itemStack, int n, boolean bl) {
        if (itemStack.field_77990_d == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)itemStack, (int)0);
        }
        int n2 = itemStack.field_77990_d.func_74762_e("Energy");
        int n3 = Math.min(n, Math.min(this.maxEnergy - n2, this.maxTransfer));
        if (!bl) {
            itemStack.field_77990_d.func_74768_a("Energy", n2 += n3);
        }
        return n3;
    }

    public int extractEnergy(ItemStack itemStack, int n, boolean bl) {
        if (itemStack.field_77990_d == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)itemStack, (int)0);
        }
        int n2 = itemStack.field_77990_d.func_74762_e("Energy");
        int n3 = Math.min(n, n2);
        if (!bl) {
            itemStack.field_77990_d.func_74768_a("Energy", n2 -= n3);
        }
        return n3;
    }

    public int getEnergyStored(ItemStack itemStack) {
        if (itemStack.field_77990_d == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)itemStack, (int)0);
        }
        return itemStack.field_77990_d.func_74762_e("Energy");
    }

    public int getMaxEnergyStored(ItemStack itemStack) {
        return this.maxEnergy;
    }
}

