/*
 * Decompiled with CFR 0.152.
 */
package redstonearsenal.block;

import cofh.api.core.IInitializer;
import cofh.lib.util.helpers.DamageHelper;
import cofh.lib.util.helpers.EnergyHelper;
import cofh.lib.util.helpers.ItemHelper;
import cofh.lib.util.helpers.MathHelper;
import cofh.lib.util.helpers.ServerHelper;
import cofh.lib.util.helpers.StringHelper;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import redstonearsenal.RedstoneArsenal;
import redstonearsenal.block.ItemBlockStorage;

public class BlockStorage
extends Block
implements IInitializer {
    public static final String[] NAMES = new String[]{"electrumFlux", "crystalFlux"};
    public static final IIcon[] TEXTURES = new IIcon[NAMES.length];
    public static boolean[] enableDamage = new boolean[2];
    public static boolean[] enableDamageCharge = new boolean[2];
    public static double[] damage = new double[2];
    public static int chargeRate = 50;
    public static ItemStack blockElectrumFlux;
    public static ItemStack blockCrystalFlux;

    public BlockStorage() {
        super(Material.field_151573_f);
        this.func_149711_c(25.0f);
        this.func_149752_b(120.0f);
        this.func_149672_a(Block.field_149777_j);
        this.func_149647_a(RedstoneArsenal.tab);
        this.func_149663_c("redstonearsenal.storage");
    }

    public void func_149666_a(Item item, CreativeTabs creativeTabs, List list) {
        for (int i = 0; i < NAMES.length; ++i) {
            list.add(new ItemStack(item, 1, i));
        }
    }

    public int func_149692_a(int n) {
        return n;
    }

    public boolean canCreatureSpawn(EnumCreatureType enumCreatureType, IBlockAccess iBlockAccess, int n, int n2, int n3) {
        return false;
    }

    public boolean isBeaconBase(IBlockAccess iBlockAccess, int n, int n2, int n3, int n4, int n5, int n6) {
        return true;
    }

    public AxisAlignedBB func_149668_a(World world, int n, int n2, int n3) {
        return AxisAlignedBB.func_72330_a((double)((float)n + 0.0625f), (double)n2, (double)((float)n3 + 0.0625f), (double)((float)(n + 1) - 0.0625f), (double)((float)(n2 + 1) - 0.0625f), (double)((float)(n3 + 1) - 0.0625f));
    }

    public int getLightValue(IBlockAccess iBlockAccess, int n, int n2, int n3) {
        return 7;
    }

    public void func_149670_a(World world, int n, int n2, int n3, Entity entity) {
        if (ServerHelper.isClientWorld((World)world) || entity instanceof EntityItem) {
            return;
        }
        double d = 0.0;
        switch (world.func_72805_g(n, n2, n3)) {
            case 0: {
                if (!enableDamage[0]) break;
                d = damage[0];
                break;
            }
            case 1: {
                if (!enableDamage[1]) break;
                d = damage[1];
            }
        }
        if (d > 0.0) {
            EntityPlayerMP entityPlayerMP;
            entity.func_70097_a((DamageSource)DamageHelper.flux, (float)d);
            if (entity instanceof EntityPlayerMP && EnergyHelper.isPlayerHoldingEnergyContainerItem((EntityPlayer)(entityPlayerMP = (EntityPlayerMP)entity))) {
                EnergyHelper.insertEnergyIntoHeldContainer((EntityPlayer)entityPlayerMP, (int)((int)((double)chargeRate * d)), (boolean)false);
            }
        }
    }

    public IIcon func_149691_a(int n, int n2) {
        return TEXTURES[n2];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iIconRegister) {
        for (int i = 0; i < NAMES.length; ++i) {
            BlockStorage.TEXTURES[i] = iIconRegister.func_94245_a("redstonearsenal:storage/Block_" + StringHelper.titleCase((String)NAMES[i]));
        }
    }

    public boolean preInit() {
        GameRegistry.registerBlock((Block)this, ItemBlockStorage.class, (String)"Storage");
        String string = "block.feature";
        BlockStorage.enableDamage[0] = RedstoneArsenal.config.get(string, "Storage.Electrum.Damage.Enable", true);
        BlockStorage.enableDamage[1] = RedstoneArsenal.config.get(string, "Storage.Crystal.Damage.Enable", true);
        BlockStorage.enableDamageCharge[0] = RedstoneArsenal.config.get(string, "Storage.Electrum.Damage.Charge", true);
        BlockStorage.enableDamageCharge[1] = RedstoneArsenal.config.get(string, "Storage.Crystal.Damage.Charge", true);
        BlockStorage.damage[0] = RedstoneArsenal.config.get(string, "Storage.Electrum.Damage.Amount", 0.5);
        BlockStorage.damage[1] = RedstoneArsenal.config.get(string, "Storage.Crystal.Damage.Amount", 1);
        String string2 = "Amount of Redstone Flux charged per tick while touching a block; multiplied by damage dealt by the block. Max: 1000; Default: 50";
        chargeRate = RedstoneArsenal.config.get(string, "Storage.FluxPerTickPerDamage", chargeRate, string2);
        chargeRate = MathHelper.clampI((int)chargeRate, (int)0, (int)1000);
        blockElectrumFlux = new ItemStack((Block)this, 1, 0);
        blockCrystalFlux = new ItemStack((Block)this, 1, 1);
        ItemHelper.registerWithHandlers((String)"blockElectrumFlux", (ItemStack)blockElectrumFlux);
        ItemHelper.registerWithHandlers((String)"blockCrystalFlux", (ItemStack)blockCrystalFlux);
        return true;
    }

    public boolean initialize() {
        return true;
    }

    public boolean postInit() {
        ItemHelper.addStorageRecipe((ItemStack)blockElectrumFlux, (String)"ingotElectrumFlux");
        ItemHelper.addStorageRecipe((ItemStack)blockCrystalFlux, (String)"gemCrystalFlux");
        return true;
    }
}

