/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.core.handler;

import com.github.lunatrius.core.reference.Names;
import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class ConfigurationHandler {
    public static Configuration configuration;
    public static final boolean CHECKFORUPDATES_DEFAULT = true;
    public static final boolean SILENCEKNOWNUPDATES_DEFAULT = false;
    public static boolean checkForUpdates;
    public static boolean silenceKnownUpdates;
    private static Property propCheckForUpdates;
    private static Property propSilenceKnownUpdates;
    private static Property propKnownUpdates;

    public static void init(File configFile) {
        if (configuration == null) {
            configuration = new Configuration(configFile);
            ConfigurationHandler.loadConfiguration();
        }
    }

    private static void loadConfiguration() {
        propCheckForUpdates = configuration.get("versioncheck", "checkForUpdates", true, "Should the mod check for updates?");
        propCheckForUpdates.setLanguageKey(Names.Config.LANG_PREFIX + "." + "checkForUpdates");
        propCheckForUpdates.setRequiresMcRestart(true);
        checkForUpdates = propCheckForUpdates.getBoolean(true);
        propSilenceKnownUpdates = configuration.get("versioncheck", "silenceKnownUpdates", false, "Should the mod remind you only for new updates (once per version)?");
        propSilenceKnownUpdates.setLanguageKey(Names.Config.LANG_PREFIX + "." + "silenceKnownUpdates");
        propSilenceKnownUpdates.setRequiresMcRestart(true);
        silenceKnownUpdates = propSilenceKnownUpdates.getBoolean(false);
        propKnownUpdates = configuration.get("versioncheck", "knownVersions", new String[0], "A list of known updates. Deleting versions from the list will remind you about them again.");
        propKnownUpdates.setShowInGui(false);
        if (configuration.hasChanged()) {
            configuration.save();
        }
    }

    public static void addUpdate(String modid, String version) {
        ArrayList<String> knownUpdatesList = new ArrayList<String>(Arrays.asList(propKnownUpdates.getStringList()));
        String update = String.format("%s %s", modid, version);
        if (!knownUpdatesList.contains(update)) {
            knownUpdatesList.add(update);
        }
        Collections.sort(knownUpdatesList);
        String[] knownUpdates = new String[knownUpdatesList.size()];
        knownUpdates = knownUpdatesList.toArray(knownUpdates);
        propKnownUpdates.set(knownUpdates);
        if (configuration.hasChanged()) {
            configuration.save();
        }
    }

    public static boolean canNotifyOfUpdate(String modid, String version) {
        return !Arrays.asList(propKnownUpdates.getStringList()).contains(String.format("%s %s", modid, version)) || !silenceKnownUpdates;
    }

    @SubscribeEvent
    public void onConfigurationChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.modID.equalsIgnoreCase("LunatriusCore")) {
            ConfigurationHandler.loadConfiguration();
        }
    }

    static {
        checkForUpdates = true;
        silenceKnownUpdates = false;
        propCheckForUpdates = null;
        propSilenceKnownUpdates = null;
        propKnownUpdates = null;
    }
}

