/*
 * Decompiled with CFR 0.152.
 */
package toast.utilityMobs.colossal;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S12PacketEntityVelocity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import toast.utilityMobs._UtilityMobs;
import toast.utilityMobs.ai.EntityAIGolemTarget;
import toast.utilityMobs.golem.EntityUtilityGolem;

public class EntityColossalGolem
extends EntityUtilityGolem {
    public static final int ANIM_R_ARM_SWING = 1;
    public static final int ANIM_L_ARM_SWING = 2;
    private int lastAnimId;
    private int animTick;

    public EntityColossalGolem(World world) {
        super(world);
        this.func_70105_a(1.8f, 3.2f);
        this.field_70138_W = 1.0f;
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, 1.0, false));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIGolemTarget(this));
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(30, (Object)0);
    }

    public int getAnimId() {
        return this.field_70180_af.func_75683_a(30);
    }

    public void setAnimId(int id) {
        this.field_70180_af.func_75692_b(30, (Object)((byte)id));
    }

    public int getAnimTick() {
        return this.animTick;
    }

    public AxisAlignedBB func_70046_E() {
        return _UtilityMobs.proxy.solidEntities() ? this.field_70121_D : super.func_70046_E();
    }

    @Override
    public boolean func_70072_I() {
        return false;
    }

    @Override
    public boolean func_70058_J() {
        return false;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(100.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.15);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        int animId = this.getAnimId();
        if (this.lastAnimId != animId) {
            this.lastAnimId = animId;
            this.animTick = 0;
        }
        if (animId != 0) {
            ++this.animTick;
            if (!this.field_70170_p.field_72995_K && this.animTick > 16) {
                this.setAnimId(0);
            }
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.getAnimTick() == 2) {
            Vec3 lookVec = this.func_70040_Z();
            List list = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72325_c(lookVec.field_72450_a * (double)this.field_70130_N, 0.0, lookVec.field_72449_c * (double)this.field_70130_N).func_72314_b(0.5, 2.0, 0.5));
            double reach = this.field_70130_N * this.field_70130_N * 4.0f + this.field_70130_N;
            for (Object entity : list) {
                if (entity == this.field_70153_n || !(entity instanceof EntityLivingBase) || !this.canDamage((Entity)entity) || !(this.func_70092_e(((Entity)entity).field_70165_t, ((Entity)entity).field_70121_D.field_72338_b, ((Entity)entity).field_70161_v) <= reach)) continue;
                this.attackEntityAsMobFinish((Entity)entity);
            }
        }
        this.func_70031_b(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y > 2.5E-7);
    }

    private boolean canDamage(Entity entity) {
        if (this.field_70153_n == null || entity instanceof IEntityOwnable || entity instanceof EntityPlayer) {
            return this.targetHelper.isValidTarget(entity);
        }
        return true;
    }

    @Override
    public boolean func_70652_k(Entity entity) {
        if (!(this.field_70170_p.field_72995_K || this.getAnimId() != 0 || this.field_70153_n instanceof EntityPlayer && entity != null)) {
            this.setAnimId(this.field_70146_Z.nextBoolean() ? 2 : 1);
        }
        return true;
    }

    public boolean attackEntityAsMobFinish(Entity entity) {
        this.field_70170_p.func_72960_a((Entity)this, (byte)4);
        this.field_70170_p.func_72956_a((Entity)this, "mob.irongolem.throw", 1.0f, 1.0f);
        double dX = entity.field_70165_t - this.field_70165_t;
        double dZ = entity.field_70161_v - this.field_70161_v;
        double dH = Math.sqrt(dX * dX + dZ * dZ);
        entity.field_70159_w = dX / dH * 0.5 + this.field_70159_w * 1.2;
        entity.field_70181_x = 0.8;
        entity.field_70179_y = dZ / dH * 0.5 + this.field_70179_y * 1.2;
        if (entity instanceof EntityPlayerMP) {
            try {
                ((EntityPlayerMP)entity).field_71135_a.func_147359_a((Packet)new S12PacketEntityVelocity(entity));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return super.func_70652_k(entity);
    }

    public void func_70103_a(byte b) {
        if (b == 4) {
            this.field_70170_p.func_72956_a((Entity)this, "mob.irongolem.throw", 1.0f, 1.0f);
        } else {
            super.func_70103_a(b);
        }
    }

    @Override
    protected String func_70621_aR() {
        return "mob.irongolem.hit";
    }

    @Override
    protected String func_70673_aS() {
        return "mob.irongolem.death";
    }

    protected void func_145780_a(int x, int y, int z, Block block) {
        this.field_70170_p.func_72956_a((Entity)this, "mob.irongolem.walk", 1.0f, 1.0f);
    }

    @Override
    public boolean func_70085_c(EntityPlayer player) {
        if (this.canInteract(player) && !player.func_70093_af() && !player.field_70122_E) {
            if (this.field_70153_n == null) {
                player.func_70078_a((Entity)this);
            } else if (!(this.field_70153_n instanceof EntityPlayer)) {
                Entity rider = this.field_70153_n;
                this.field_70153_n.func_70078_a(null);
                rider.func_70107_b(player.field_70165_t, player.field_70163_u, player.field_70161_v);
            }
            return true;
        }
        return super.func_70085_c(player);
    }

    public double func_70042_X() {
        return this.field_70131_O;
    }

    public void func_70612_e(float strafe, float forward) {
        if (this.field_70153_n instanceof EntityPlayer && !this.targetHelper.isValidTarget(this.field_70153_n)) {
            this.field_70126_B = this.field_70177_z = this.field_70153_n.field_70177_z;
            this.field_70125_A = this.field_70153_n.field_70125_A * 0.5f;
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
            this.field_70759_as = this.field_70761_aq = this.field_70177_z;
            strafe = ((EntityLivingBase)this.field_70153_n).field_70702_br * 0.15f;
            forward = ((EntityLivingBase)this.field_70153_n).field_70701_bs * 0.3f;
            if (forward <= 0.0f) {
                forward *= 0.25f;
            }
            if (!this.field_70170_p.field_72995_K) {
                this.func_70659_e((float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
                super.func_70612_e(strafe, forward);
            }
            this.field_70722_aY = this.field_70721_aZ;
            double vX = this.field_70165_t - this.field_70169_q;
            double vZ = this.field_70161_v - this.field_70166_s;
            float vH = MathHelper.func_76133_a((double)(vX * vX + vZ * vZ)) * 4.0f;
            if (vH > 1.0f) {
                vH = 1.0f;
            }
            this.field_70721_aZ += (vH - this.field_70721_aZ) * 0.4f;
            this.field_70754_ba += this.field_70721_aZ;
        } else {
            super.func_70612_e(strafe, forward);
        }
    }

    @Override
    protected void dropFewItems(boolean recentlyHit, int looting, float dropChance) {
        if (recentlyHit && this.field_70146_Z.nextFloat() < dropChance / 4.0f) {
            this.func_70099_a(new ItemStack(Items.field_151144_bL, 1, 4), 0.0f);
        }
    }
}

